/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.ArithmeticUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractGeneralizedAffineTerm<AVAR>
extends Term
implements IPolynomialTerm {
    protected final Map<AVAR, Rational> mAbstractVariable2Coefficient;
    protected final Rational mConstant;
    protected final Sort mSort;

    public AbstractGeneralizedAffineTerm() {
        super(0);
        this.mAbstractVariable2Coefficient = null;
        this.mConstant = null;
        this.mSort = null;
    }

    protected AbstractGeneralizedAffineTerm(Sort s, Rational constant, Map<AVAR, Rational> variables2coeffcient) {
        super(0);
        Objects.requireNonNull(s);
        Objects.requireNonNull(constant);
        Objects.requireNonNull(variables2coeffcient);
        this.mSort = s;
        this.mConstant = constant;
        assert (!SmtSortUtils.isBitvecSort(s) || !constant.isNegative()) : "Negative constant in bitvector term";
        assert (!SmtSortUtils.isBitvecSort(s) || AbstractGeneralizedAffineTerm.allCoefficientsAreNonNegative(variables2coeffcient)) : "Negative coefficients in bitvector term " + variables2coeffcient;
        this.mAbstractVariable2Coefficient = variables2coeffcient;
    }

    private static boolean allCoefficientsAreNonNegative(Map<?, Rational> variables2coeffcient) {
        return variables2coeffcient.entrySet().stream().allMatch(x -> !((Rational)x.getValue()).isNegative());
    }

    protected abstract IPolynomialTerm constructNew(Sort var1, Rational var2, Map<AVAR, Rational> var3);

    protected abstract AVAR constructAbstractVar(Term var1);

    protected abstract Collection<Term> getFreeVars(AVAR var1);

    @Override
    public boolean isErrorTerm() {
        if (this.mAbstractVariable2Coefficient == null) {
            assert (this.mConstant == null);
            assert (this.mSort == null);
            return true;
        }
        assert (this.mConstant != null);
        assert (this.mSort != null);
        return false;
    }

    public abstract boolean isVariable(Term var1);

    @Override
    public boolean isConstant() {
        return this.mAbstractVariable2Coefficient.isEmpty();
    }

    @Override
    public boolean isZero() {
        return this.mConstant.equals((Object)Rational.ZERO) && this.mAbstractVariable2Coefficient.isEmpty();
    }

    @Override
    public boolean isIntegral() {
        if (!this.getConstant().isIntegral()) {
            return false;
        }
        for (Rational coefficient : this.getAbstractVariable2Coefficient().values()) {
            if (coefficient.isIntegral()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Rational getConstant() {
        return this.mConstant;
    }

    public void checkIfTermIsLegalVariable(Term term) {
        if (!(term instanceof TermVariable) && !(term instanceof ApplicationTerm)) {
            throw new IllegalArgumentException("Variable of AffineTerm has to be TermVariable or ApplicationTerm");
        }
    }

    Monomial getExclusiveMonomialOfSubject(Term subject) {
        Monomial result = null;
        block5: for (AVAR abstractVar : this.getAbstractVariable2Coefficient().keySet()) {
            if (abstractVar instanceof Monomial) {
                Monomial monomial = (Monomial)abstractVar;
                switch (monomial.isExclusiveVariable(subject)) {
                    case AS_EXCLUSIVE_VARIABlE: {
                        if (result != null) {
                            return null;
                        }
                        result = monomial;
                        continue block5;
                    }
                    case NON_EXCLUSIVE_OR_SUBTERM: {
                        return null;
                    }
                    case NOT: {
                        continue block5;
                    }
                    default: {
                        throw new AssertionError((Object)"illegal value");
                    }
                }
            }
            if (subject.equals(abstractVar)) {
                if (result != null) {
                    return null;
                }
                result = new Monomial(subject, Rational.ONE);
                continue;
            }
            boolean subjectOccursAsSubterm = new SubtermPropertyChecker(x -> x == subject).isSatisfiedBySomeSubterm((Term)abstractVar);
            if (!subjectOccursAsSubterm) continue;
            return null;
        }
        return result;
    }

    public String toString() {
        String result;
        if (this.isErrorTerm()) {
            return "auxilliaryErrorTerm";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<AVAR, Rational> entry : this.mAbstractVariable2Coefficient.entrySet()) {
            sb.append(entry.getValue().isNegative() ? " - " : " + ");
            sb.append(entry.getValue().abs() + "*" + entry.getKey());
        }
        if (!this.mConstant.equals((Object)Rational.ZERO) || sb.length() == 0) {
            if (this.mConstant.isNegative() || sb.length() > 0) {
                sb.append(this.mConstant.isNegative() ? " - " : " + ");
            }
            sb.append(this.mConstant.abs());
        }
        if ((result = sb.toString()).charAt(0) == ' ') {
            result = result.substring(1);
        }
        return result;
    }

    protected abstract Term abstractVariableToTerm(Script var1, AVAR var2);

    protected abstract Term abstractVariableTimesCoeffToTerm(Script var1, AVAR var2, Rational var3);

    @Override
    public Term toTerm(Script script) {
        Term[] summands = this.mConstant.equals((Object)Rational.ZERO) ? new Term[this.mAbstractVariable2Coefficient.size()] : new Term[this.mAbstractVariable2Coefficient.size() + 1];
        int i = 0;
        for (Map.Entry<AVAR, Rational> entry : this.mAbstractVariable2Coefficient.entrySet()) {
            assert (!entry.getValue().equals((Object)Rational.ZERO)) : "zero is no legal coefficient in AffineTerm";
            summands[i] = entry.getValue().equals((Object)Rational.ONE) ? this.abstractVariableToTerm(script, entry.getKey()) : this.abstractVariableTimesCoeffToTerm(script, entry.getKey(), entry.getValue());
            ++i;
        }
        if (!this.mConstant.equals((Object)Rational.ZERO)) {
            assert (this.mConstant.isIntegral() || SmtSortUtils.isRealSort(this.mSort));
            summands[i] = SmtUtils.rational2Term(script, this.mConstant, this.mSort);
        }
        Term result = SmtUtils.sum(script, this.mSort, summands);
        return result;
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    Map<AVAR, Rational> getAbstractVariable2Coefficient() {
        return Collections.unmodifiableMap(this.mAbstractVariable2Coefficient);
    }

    public Map<Term, Rational> getAbstractVariableAsTerm2Coefficient(Script script) {
        HashMap<Term, Rational> result = new HashMap<Term, Rational>();
        for (Map.Entry<AVAR, Rational> entry : this.mAbstractVariable2Coefficient.entrySet()) {
            result.put(this.abstractVariableToTerm(script, entry.getKey()), entry.getValue());
        }
        return result;
    }

    public void toStringHelper(ArrayDeque<Object> mTodo) {
        throw new UnsupportedOperationException("This is an auxilliary Term and not supported by the solver");
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.mConstant == null ? 0 : this.mConstant.hashCode());
        result = 31 * result + (this.mSort == null ? 0 : this.mSort.hashCode());
        result = 31 * result + (this.mAbstractVariable2Coefficient == null ? 0 : this.mAbstractVariable2Coefficient.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGeneralizedAffineTerm other = (AbstractGeneralizedAffineTerm)obj;
        if (this.mConstant == null ? other.mConstant != null : !this.mConstant.equals((Object)other.mConstant)) {
            return false;
        }
        if (this.mSort == null ? other.mSort != null : !this.mSort.equals(other.mSort)) {
            return false;
        }
        return !(this.mAbstractVariable2Coefficient == null ? other.mAbstractVariable2Coefficient != null : !this.mAbstractVariable2Coefficient.equals(other.mAbstractVariable2Coefficient));
    }

    protected abstract Pair<Rational, Rational> computeMinMax();

    protected Rational checkForModTerm(Term term) {
        ApplicationTerm appTerm = SmtUtils.getFunctionApplication(term, "mod");
        if (appTerm == null) {
            return null;
        }
        Term divisorAsTerm = appTerm.getParameters()[1];
        Rational divisorAsRational = SmtUtils.tryToConvertToLiteral(divisorAsTerm);
        if (divisorAsRational == null) {
            return null;
        }
        return divisorAsRational.abs();
    }

    public abstract AbstractGeneralizedAffineTerm<?> removeAndNegate(Monomial var1);

    public IPolynomialTerm div(Script script, BigInteger divisor, Set<TermVariable> bannedForDivCapture) {
        Rational constant;
        if (!SmtSortUtils.isIntSort(this.getSort())) {
            throw new AssertionError((Object)"only for int");
        }
        HashMap<AVAR, Rational> variables2coeffcient = new HashMap<AVAR, Rational>();
        ArrayList<Term> summandsOfDiv = new ArrayList<Term>();
        for (Map.Entry<AVAR, Rational> entry : this.getAbstractVariable2Coefficient().entrySet()) {
            Rational divisorAsRational = AbstractGeneralizedAffineTerm.toRational(divisor);
            Rational quotient = entry.getValue().div(divisorAsRational);
            if (quotient.isIntegral()) {
                Rational euclideanQuotient = this.euclideanDivision(entry.getValue(), divisor);
                variables2coeffcient.put(entry.getKey(), euclideanQuotient);
                continue;
            }
            if (this.getFreeVars(entry.getKey()).stream().anyMatch(bannedForDivCapture::contains)) {
                return null;
            }
            summandsOfDiv.add(SmtUtils.mul(script, entry.getValue(), this.abstractVariableToTerm(script, entry.getKey())));
        }
        if (summandsOfDiv.isEmpty()) {
            constant = this.euclideanDivision(this.getConstant(), divisor);
        } else {
            constant = Rational.ZERO;
            if (!this.getConstant().equals((Object)Rational.ZERO)) {
                summandsOfDiv.add(this.getConstant().toTerm(this.getSort()));
            }
            Term sum = SmtUtils.sum(script, this.getSort(), summandsOfDiv.toArray(new Term[summandsOfDiv.size()]));
            Term div = SmtUtils.div(script, sum, SmtUtils.constructIntegerValue(script, this.getSort(), divisor));
            AVAR avar = this.constructAbstractVar(div);
            variables2coeffcient.put(avar, Rational.ONE);
        }
        return this.constructNew(this.getSort(), constant, variables2coeffcient);
    }

    protected Rational euclideanDivision(Rational divident, BigInteger divisor) {
        if (!divident.isIntegral()) {
            throw new AssertionError();
        }
        return AbstractGeneralizedAffineTerm.toRational(ArithmeticUtils.euclideanDiv((BigInteger)divident.numerator(), (BigInteger)divisor));
    }

    private static Rational toRational(BigInteger bi) {
        return Rational.valueOf((BigInteger)bi, (BigInteger)BigInteger.ONE);
    }

    @Override
    public IPolynomialTerm add(Rational offset) {
        Rational newConstant;
        if (SmtSortUtils.isRealSort(this.getSort())) {
            newConstant = this.getConstant().add(offset);
        } else if (SmtSortUtils.isIntSort(this.getSort())) {
            newConstant = this.getConstant().add(offset);
        } else if (SmtSortUtils.isBitvecSort(this.getSort())) {
            newConstant = PolynomialTermUtils.bringBitvectorValueInRange(this.getConstant().add(offset), this.getSort());
        } else {
            throw new AssertionError((Object)("unsupported Sort " + this.getSort()));
        }
        return this.constructNew(this.getSort(), newConstant, this.getAbstractVariable2Coefficient());
    }

    @Override
    public Equivalence compare(IPolynomialTerm otherTerm) {
        Equivalence result;
        if (otherTerm instanceof AbstractGeneralizedAffineTerm) {
            AbstractGeneralizedAffineTerm otherPoly = (AbstractGeneralizedAffineTerm)otherTerm;
            result = this.getAbstractVariable2Coefficient().equals(otherPoly.getAbstractVariable2Coefficient()) ? (this.getConstant().equals((Object)otherPoly.getConstant()) ? Equivalence.EQUALS : Equivalence.DISTINCT) : Equivalence.INCOMPARABLE;
        } else {
            result = Equivalence.INCOMPARABLE;
        }
        return result;
    }

    public static ComparisonResult compareRepresentation(PolynomialRelation lhs, PolynomialRelation rhs) {
        AbstractGeneralizedAffineTerm<Term> lhsTerm = lhs.getPolynomialTerm();
        AbstractGeneralizedAffineTerm<Term> rhsTerm = rhs.getPolynomialTerm();
        if (!lhsTerm.getAbstractVariable2Coefficient().equals(rhsTerm.getAbstractVariable2Coefficient())) {
            throw new AssertionError((Object)"incomparable");
        }
        RelationSymbol lhsRelationSymbol = lhs.getRelationSymbol();
        RelationSymbol rhsRelationSymbol = rhs.getRelationSymbol();
        Rational lhsConstant = lhs.getPolynomialTerm().getConstant();
        Rational rhsConstant = rhs.getPolynomialTerm().getConstant();
        ComparisonResult result = AbstractGeneralizedAffineTerm.compare(lhsRelationSymbol, rhsRelationSymbol, lhsConstant, rhsConstant);
        assert (AbstractGeneralizedAffineTerm.doubleCheck(lhsRelationSymbol, rhsRelationSymbol, lhsConstant, rhsConstant, result)) : "double check failed";
        return result;
    }

    private static boolean doubleCheck(RelationSymbol lhsRelationSymbol, RelationSymbol rhsRelationSymbol, Rational lhsConstant, Rational rhsConstant, ComparisonResult result) {
        ComparisonResult otherDirection = AbstractGeneralizedAffineTerm.compare(rhsRelationSymbol, lhsRelationSymbol, rhsConstant, lhsConstant);
        if (result == null) {
            return otherDirection == null;
        }
        return result.switchDiection().equals((Object)otherDirection);
    }

    private static ComparisonResult compare(RelationSymbol lhsRelationSymbol, RelationSymbol rhsRelationSymbol, Rational lhsConstant, Rational rhsConstant) throws AssertionError {
        ComparisonResult result;
        switch (lhsRelationSymbol) {
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"not in PolynomialRelation");
            }
            case DISTINCT: {
                result = AbstractGeneralizedAffineTerm.compareDistinct(lhsConstant, rhsRelationSymbol, rhsConstant);
                break;
            }
            case EQ: {
                result = AbstractGeneralizedAffineTerm.compareEq(lhsConstant, rhsRelationSymbol, rhsConstant);
                break;
            }
            case GEQ: {
                result = AbstractGeneralizedAffineTerm.compareGeq(lhsConstant, rhsRelationSymbol, rhsConstant);
                break;
            }
            case GREATER: {
                result = AbstractGeneralizedAffineTerm.compareGreater(lhsConstant, rhsRelationSymbol, rhsConstant);
                break;
            }
            case LEQ: {
                result = AbstractGeneralizedAffineTerm.compareLeq(lhsConstant, rhsRelationSymbol, rhsConstant);
                break;
            }
            case LESS: {
                result = AbstractGeneralizedAffineTerm.compareLess(lhsConstant, rhsRelationSymbol, rhsConstant);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + (Object)((Object)lhsRelationSymbol)));
            }
        }
        return result;
    }

    public static ComparisonResult compareDistinct(Rational lhsConstant, RelationSymbol relationSymbol, Rational rhsConstant) {
        ComparisonResult result;
        switch (relationSymbol) {
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"not in PolynomialRelation");
            }
            case DISTINCT: {
                if (lhsConstant.equals((Object)rhsConstant)) {
                    result = ComparisonResult.EQUIVALENT;
                    break;
                }
                result = null;
                break;
            }
            case EQ: {
                if (lhsConstant.equals((Object)rhsConstant)) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.EXPLIES;
                break;
            }
            case GEQ: {
                if (lhsConstant.compareTo(rhsConstant) > 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                result = null;
                break;
            }
            case GREATER: {
                if (lhsConstant.compareTo(rhsConstant) >= 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                result = null;
                break;
            }
            case LEQ: {
                if (lhsConstant.compareTo(rhsConstant) < 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                result = null;
                break;
            }
            case LESS: {
                if (lhsConstant.compareTo(rhsConstant) <= 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                result = null;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + (Object)((Object)relationSymbol)));
            }
        }
        return result;
    }

    public static ComparisonResult compareEq(Rational lc, RelationSymbol rRel, Rational rc) {
        ComparisonResult result;
        switch (rRel) {
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"not in PolynomialRelation");
            }
            case DISTINCT: {
                if (lc.equals((Object)rc)) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case EQ: {
                if (lc.equals((Object)rc)) {
                    result = ComparisonResult.EQUIVALENT;
                    break;
                }
                result = ComparisonResult.INCONSISTENT;
                break;
            }
            case GEQ: {
                if (lc.compareTo(rc) > 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case GREATER: {
                if (lc.compareTo(rc) >= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case LEQ: {
                if (lc.compareTo(rc) < 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case LESS: {
                if (lc.compareTo(rc) <= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + (Object)((Object)rRel)));
            }
        }
        return result;
    }

    public static ComparisonResult compareGeq(Rational lc, RelationSymbol rRel, Rational rc) {
        ComparisonResult result;
        switch (rRel) {
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"not in PolynomialRelation");
            }
            case DISTINCT: {
                if (lc.compareTo(rc) < 0) {
                    result = ComparisonResult.IMPLIES;
                    break;
                }
                result = null;
                break;
            }
            case EQ: {
                if (lc.compareTo(rc) < 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.EXPLIES;
                break;
            }
            case GEQ: {
                if (lc.compareTo(rc) > 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                if (lc.equals((Object)rc)) {
                    result = ComparisonResult.EQUIVALENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case GREATER: {
                if (lc.compareTo(rc) >= 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case LEQ: {
                if (lc.compareTo(rc) < 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = null;
                break;
            }
            case LESS: {
                if (lc.compareTo(rc) <= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = null;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + (Object)((Object)rRel)));
            }
        }
        return result;
    }

    public static ComparisonResult compareGreater(Rational lc, RelationSymbol rRel, Rational rc) {
        ComparisonResult result;
        switch (rRel) {
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"not in PolynomialRelation");
            }
            case DISTINCT: {
                if (lc.compareTo(rc) <= 0) {
                    result = ComparisonResult.IMPLIES;
                    break;
                }
                result = null;
                break;
            }
            case EQ: {
                if (lc.compareTo(rc) <= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.EXPLIES;
                break;
            }
            case GEQ: {
                if (lc.compareTo(rc) > 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case GREATER: {
                if (lc.compareTo(rc) > 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                if (lc.equals((Object)rc)) {
                    result = ComparisonResult.EQUIVALENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case LEQ: {
                if (lc.compareTo(rc) <= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = null;
                break;
            }
            case LESS: {
                if (lc.compareTo(rc) <= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = null;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + (Object)((Object)rRel)));
            }
        }
        return result;
    }

    public static ComparisonResult compareLeq(Rational lc, RelationSymbol rRel, Rational rc) {
        ComparisonResult result;
        switch (rRel) {
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"not in PolynomialRelation");
            }
            case DISTINCT: {
                if (lc.compareTo(rc) > 0) {
                    result = ComparisonResult.IMPLIES;
                    break;
                }
                result = null;
                break;
            }
            case EQ: {
                if (lc.compareTo(rc) > 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.EXPLIES;
                break;
            }
            case GEQ: {
                if (lc.compareTo(rc) > 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = null;
                break;
            }
            case GREATER: {
                if (lc.compareTo(rc) >= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = null;
                break;
            }
            case LEQ: {
                if (lc.compareTo(rc) < 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                if (lc.equals((Object)rc)) {
                    result = ComparisonResult.EQUIVALENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case LESS: {
                if (lc.compareTo(rc) <= 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + (Object)((Object)rRel)));
            }
        }
        return result;
    }

    public static ComparisonResult compareLess(Rational lc, RelationSymbol rRel, Rational rc) {
        ComparisonResult result;
        switch (rRel) {
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)"not in PolynomialRelation");
            }
            case DISTINCT: {
                if (lc.compareTo(rc) >= 0) {
                    result = ComparisonResult.IMPLIES;
                    break;
                }
                result = null;
                break;
            }
            case EQ: {
                if (lc.compareTo(rc) >= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = ComparisonResult.EXPLIES;
                break;
            }
            case GEQ: {
                if (lc.compareTo(rc) >= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = null;
                break;
            }
            case GREATER: {
                if (lc.compareTo(rc) >= 0) {
                    result = ComparisonResult.INCONSISTENT;
                    break;
                }
                result = null;
                break;
            }
            case LEQ: {
                if (lc.compareTo(rc) < 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            case LESS: {
                if (lc.compareTo(rc) < 0) {
                    result = ComparisonResult.EXPLIES;
                    break;
                }
                if (lc.equals((Object)rc)) {
                    result = ComparisonResult.EQUIVALENT;
                    break;
                }
                result = ComparisonResult.IMPLIES;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + (Object)((Object)rRel)));
            }
        }
        return result;
    }

    @Override
    public Rational computeGcdOfCoefficients() {
        Rational gcd = Rational.ZERO;
        for (Map.Entry<AVAR, Rational> entry : this.mAbstractVariable2Coefficient.entrySet()) {
            gcd = gcd.gcd(entry.getValue());
        }
        return gcd;
    }

    public TermVariable[] getFreeVars() {
        throw new UnsupportedOperationException("AbstractGeneralizedAffineTerm is not a proper Term of our SMT library");
    }

    public Theory getTheory() {
        throw new UnsupportedOperationException("AbstractGeneralizedAffineTerm is not a proper Term of our SMT library");
    }

    public String toStringDirect() {
        throw new UnsupportedOperationException("AbstractGeneralizedAffineTerm is not a proper Term of our SMT library");
    }

    public static enum ComparisonResult {
        INCONSISTENT,
        IMPLIES,
        EXPLIES,
        EQUIVALENT;


        public ComparisonResult switchDiection() {
            ComparisonResult result;
            switch (this) {
                case EQUIVALENT: {
                    result = this;
                    break;
                }
                case EXPLIES: {
                    result = IMPLIES;
                    break;
                }
                case IMPLIES: {
                    result = EXPLIES;
                    break;
                }
                case INCONSISTENT: {
                    result = this;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)this)));
                }
            }
            return result;
        }
    }

    public static enum Equivalence {
        EQUALS,
        DISTINCT,
        INCOMPARABLE;

    }
}

