/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AffineTerm
extends AbstractGeneralizedAffineTerm<Term> {
    public AffineTerm() {
    }

    public AffineTerm(Sort s, Rational constant, Map<Term, Rational> variables2coeffcient) {
        super(s, constant, variables2coeffcient);
    }

    @Override
    protected IPolynomialTerm constructNew(Sort sort, Rational constant, Map<Term, Rational> variables2coeffcient) {
        return new AffineTerm(sort, constant, variables2coeffcient);
    }

    @Override
    protected Term constructAbstractVar(Term term) {
        return term;
    }

    public static AffineTerm constructConstant(Sort s, Rational constant) {
        return new AffineTerm(s, constant, Collections.emptyMap());
    }

    public static AffineTerm constructVariable(Term t) {
        return new AffineTerm(t.getSort(), Rational.ZERO, Collections.singletonMap(t, Rational.ONE));
    }

    static AffineTerm sum(IPolynomialTerm ... summands) {
        PolynomialTermUtils.GeneralizedConstructor constructor = AffineTerm::new;
        return PolynomialTermUtils.constructSum(x -> ((AffineTerm)x).getVariable2Coefficient(), constructor, summands);
    }

    public static AffineTerm mul(IPolynomialTerm affineTerm, Rational multiplier) {
        PolynomialTermUtils.GeneralizedConstructor constructor = AffineTerm::new;
        return PolynomialTermUtils.constructMul(x -> ((AffineTerm)x).getVariable2Coefficient(), constructor, affineTerm, multiplier);
    }

    public static AffineTerm mulAffineTerms(IPolynomialTerm poly1, IPolynomialTerm poly2) {
        if (poly1.isConstant()) {
            return AffineTerm.mul(poly2, poly1.getConstant());
        }
        if (poly2.isConstant()) {
            return AffineTerm.mul(poly1, poly2.getConstant());
        }
        throw new UnsupportedOperationException("The outcome of this product is not affine!");
    }

    public static IPolynomialTerm divide(IPolynomialTerm[] affineArgs, Script script) {
        return AffineTerm.constructDivision(affineArgs, "/", script);
    }

    private static IPolynomialTerm constructDivision(IPolynomialTerm[] affineArgs, String funcName, Script script) {
        Rational multiplier;
        IPolynomialTerm affineTerm;
        if (affineArgs[0].isConstant()) {
            affineTerm = null;
            multiplier = affineArgs[0].getConstant();
        } else {
            affineTerm = affineArgs[0];
            multiplier = Rational.ONE;
        }
        int i = 1;
        while (i < affineArgs.length) {
            if (!affineArgs[i].isConstant() || affineArgs[i].isZero()) {
                if (funcName == "div") {
                    return PolynomialTermUtils.simplifyImpossibleDivision("div", affineArgs, script);
                }
                if (funcName == "/") {
                    return PolynomialTermUtils.simplifyImpossibleDivision("/", affineArgs, script);
                }
                throw new UnsupportedOperationException("FuncName does not match any known division.");
            }
            multiplier = multiplier.mul(affineArgs[i].getConstant().inverse());
            ++i;
        }
        AffineTerm result = affineTerm == null ? AffineTerm.constructConstant(affineArgs[0].getSort(), multiplier) : AffineTerm.mul(affineTerm, multiplier);
        return result;
    }

    public static IPolynomialTerm div(IPolynomialTerm[] affineArgs, Script script) {
        IPolynomialTerm result = AffineTerm.constructDivision(affineArgs, "div", script);
        if (result.isIntegral()) {
            return result;
        }
        return PolynomialTermUtils.simplifyImpossibleDivision("div", affineArgs, script);
    }

    public Map<Term, Rational> getVariable2Coefficient() {
        return Collections.unmodifiableMap(this.mAbstractVariable2Coefficient);
    }

    public static AffineTerm applyModuloToAllCoefficients(Script script, AffineTerm affineTerm, BigInteger divident) {
        PolynomialTermUtils.GeneralizedConstructor constructor = AffineTerm::new;
        return PolynomialTermUtils.applyModuloToAllCoefficients(affineTerm, divident, constructor);
    }

    @Override
    public Map<Monomial, Rational> getMonomial2Coefficient() {
        return this.mAbstractVariable2Coefficient.entrySet().stream().collect(Collectors.toMap(x -> new Monomial((Term)x.getKey(), Rational.ONE), Map.Entry::getValue));
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public boolean isVariable(Term var) {
        return this.mAbstractVariable2Coefficient.containsKey(var);
    }

    @Override
    protected Term abstractVariableToTerm(Script script, Term abstractVariable) {
        return abstractVariable;
    }

    @Override
    protected Collection<Term> getFreeVars(Term var) {
        return Arrays.asList(var.getFreeVars());
    }

    @Override
    protected Term abstractVariableTimesCoeffToTerm(Script script, Term abstractVariable, Rational coeff) {
        Term[] factors = new Term[]{abstractVariable, SmtUtils.rational2Term(script, coeff, this.mSort)};
        return SmtUtils.mul(script, this.mSort, factors);
    }

    @Override
    protected Pair<Rational, Rational> computeMinMax() {
        Rational minimalValue = Rational.ZERO;
        Rational maximalValue = Rational.ZERO;
        for (Map.Entry entry : this.mAbstractVariable2Coefficient.entrySet()) {
            Rational absOfDivisor = this.checkForModTerm((Term)entry.getKey());
            if (absOfDivisor == null) {
                return null;
            }
            if (((Rational)entry.getValue()).isNegative()) {
                maximalValue = maximalValue.add(((Rational)entry.getValue()).mul(absOfDivisor.add(Rational.MONE)));
                continue;
            }
            minimalValue = minimalValue.add(((Rational)entry.getValue()).mul(absOfDivisor.add(Rational.MONE)));
        }
        minimalValue = minimalValue.add(this.getConstant());
        maximalValue = maximalValue.add(this.getConstant());
        return new Pair((Object)maximalValue, (Object)minimalValue);
    }

    @Override
    public AbstractGeneralizedAffineTerm<Term> removeAndNegate(Monomial monomialOfSubject) {
        HashMap<Term, Rational> newAbstractVariable2Coefficient = new HashMap<Term, Rational>();
        for (Map.Entry entry : this.mAbstractVariable2Coefficient.entrySet()) {
            if (((Term)entry.getKey()).equals(monomialOfSubject.getSingleVariable())) continue;
            Rational newCoefficient = PolynomialTermUtils.bringValueInRange(((Rational)entry.getValue()).negate(), this.getSort());
            newAbstractVariable2Coefficient.put((Term)entry.getKey(), newCoefficient);
        }
        Rational newConstant = PolynomialTermUtils.bringValueInRange(this.getConstant().negate(), this.getSort());
        return new AffineTerm(this.getSort(), newConstant, (Map<Term, Rational>)newAbstractVariable2Coefficient);
    }

    @Override
    public AffineTerm divInvertible(Rational divisor) {
        HashMap<Term, Rational> newAbstractVariable2Coefficient = new HashMap<Term, Rational>();
        for (Map.Entry entry : this.mAbstractVariable2Coefficient.entrySet()) {
            Rational newCoefficient = PolynomialTermUtils.divInvertible(this.getSort(), (Rational)entry.getValue(), divisor);
            if (newCoefficient == null) {
                return null;
            }
            newAbstractVariable2Coefficient.put((Term)entry.getKey(), newCoefficient);
        }
        Rational newConstant = PolynomialTermUtils.divInvertible(this.getSort(), this.getConstant(), divisor);
        if (newConstant == null) {
            return null;
        }
        return new AffineTerm(this.getSort(), newConstant, (Map<Term, Rational>)newAbstractVariable2Coefficient);
    }
}

