/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.function.Predicate;

public class AffineTermTransformer
extends TermTransformer {
    private final Script mScript;
    private final Predicate<Term> mIsAffineVariable = x -> x instanceof TermVariable || x instanceof ApplicationTerm;

    public AffineTermTransformer(Script script) {
        this.mScript = script;
    }

    protected void convert(Term term) {
        if (!AffineTermTransformer.hasSupportedSort(term)) {
            this.inputIsNotAffine();
            return;
        }
        Rational valueOfLiteral = SmtUtils.tryToConvertToLiteral(term);
        if (valueOfLiteral != null) {
            AffineTerm result = AffineTerm.constructConstant(term.getSort(), valueOfLiteral);
            this.setResult(result);
            return;
        }
        if (AffineTermTransformer.isAffineFunction(term)) {
            super.convert(term);
            return;
        }
        if (this.mIsAffineVariable.test(term)) {
            AffineTerm result = AffineTerm.constructVariable(term);
            this.setResult(result);
            return;
        }
        this.inputIsNotAffine();
    }

    private void inputIsNotAffine() {
        this.setResult(new AffineTerm());
    }

    private static boolean hasSupportedSort(Term term) {
        return SmtSortUtils.isNumericSort(term.getSort()) || SmtSortUtils.isBitvecSort(term.getSort());
    }

    private static boolean isAffineFunction(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            return AffineTermTransformer.isAffineFunctionSymbol(appTerm.getFunction().getName());
        }
        return false;
    }

    private static boolean isAffineFunctionSymbol(String funName) {
        return funName.equals("+") || funName.equals("-") || funName.equals("*") || funName.equals("/") || funName.equals("bvadd") || funName.equals("bvsub") || funName.equals("bvmul");
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        assert (AffineTermTransformer.isAffineFunctionSymbol(appTerm.getFunction().getName())) : "We only descended for affine functions";
        AffineTerm[] affineArgs = AffineTermTransformer.castAndCheckForNonAffineArguments(newArgs);
        if (affineArgs == null) {
            throw new AssertionError();
        }
        String funName = appTerm.getFunction().getName();
        if (funName.equals("*") || funName.equals("bvmul")) {
            Sort sort = appTerm.getSort();
            AffineTerm result = AffineTermTransformer.tryToMultiply(sort, affineArgs);
            if (result == null) {
                this.setResult(AffineTerm.constructVariable((Term)appTerm));
                return;
            }
            this.setResult(result);
            return;
        }
        if (funName.equals("+") || funName.equals("bvadd")) {
            AffineTerm result = AffineTermTransformer.add(affineArgs);
            this.setResult(result);
            return;
        }
        if (funName.equals("-") || funName.equals("bvsub")) {
            AffineTerm result = affineArgs.length == 1 ? AffineTermTransformer.negate(affineArgs[0]) : AffineTermTransformer.subtract(affineArgs);
            this.setResult(result);
            return;
        }
        if (funName.equals("/")) {
            Sort sort = appTerm.getSort();
            AffineTerm result = AffineTermTransformer.divide(sort, affineArgs);
            if (result == null) {
                this.setResult(AffineTerm.constructVariable((Term)appTerm));
                return;
            }
            this.setResult(result);
            return;
        }
        throw new UnsupportedOperationException("unsupported symbol " + funName);
    }

    private static AffineTerm[] castAndCheckForNonAffineArguments(Term[] terms) {
        AffineTerm[] affineTerms = new AffineTerm[terms.length];
        int i = 0;
        while (i < affineTerms.length) {
            if (terms[i] instanceof AffineTerm) {
                affineTerms[i] = (AffineTerm)terms[i];
                if (affineTerms[i].isErrorTerm()) {
                    return null;
                }
            } else {
                throw new AssertionError();
            }
            ++i;
        }
        return affineTerms;
    }

    private static AffineTerm add(AffineTerm[] affineArgs) {
        AffineTerm result = AffineTerm.sum(affineArgs);
        return result;
    }

    private static AffineTerm negate(AffineTerm affineTerm) {
        return AffineTerm.mul(affineTerm, Rational.MONE);
    }

    private static AffineTerm subtract(AffineTerm[] input) {
        assert (input.length > 1);
        AffineTerm[] argumentsForSum = new AffineTerm[input.length];
        argumentsForSum[0] = input[0];
        int i = 1;
        while (i < argumentsForSum.length) {
            argumentsForSum[i] = AffineTerm.mul(input[i], Rational.MONE);
            ++i;
        }
        return AffineTermTransformer.add(argumentsForSum);
    }

    private static AffineTerm tryToMultiply(Sort sort, AffineTerm[] affineTerms) {
        AffineTerm nonLiteralArgument = null;
        Rational multiplier = Rational.ONE;
        AffineTerm[] affineTermArray = affineTerms;
        int n = affineTerms.length;
        int n2 = 0;
        while (n2 < n) {
            AffineTerm affineTerm = affineTermArray[n2];
            if (affineTerm.isConstant()) {
                multiplier = multiplier.mul(affineTerm.getConstant());
            } else if (nonLiteralArgument == null) {
                nonLiteralArgument = affineTerm;
            } else {
                return null;
            }
            ++n2;
        }
        AffineTerm result = nonLiteralArgument == null ? AffineTerm.constructConstant(sort, multiplier) : AffineTerm.mul(nonLiteralArgument, multiplier);
        return result;
    }

    private static AffineTerm divide(Sort sort, AffineTerm[] affineArgs) {
        Rational multiplier;
        AffineTerm affineTerm;
        assert (SmtSortUtils.isRealSort(sort));
        if (affineArgs[0].isConstant()) {
            affineTerm = null;
            multiplier = affineArgs[0].getConstant();
        } else {
            affineTerm = affineArgs[0];
            multiplier = Rational.ONE;
        }
        int i = 1;
        while (i < affineArgs.length) {
            if (!affineArgs[i].isConstant() || affineArgs[i].isZero()) {
                return null;
            }
            multiplier = multiplier.mul(affineArgs[i].getConstant().inverse());
            ++i;
        }
        AffineTerm result = affineTerm == null ? AffineTerm.constructConstant(sort, multiplier) : AffineTerm.mul(affineTerm, multiplier);
        return result;
    }

    private static AffineTerm convertConstantNumericTerm(ConstantTerm constTerm) {
        Rational rational = SmtUtils.toRational(constTerm);
        AffineTerm result = AffineTerm.constructConstant(constTerm.getSort(), rational);
        return result;
    }

    private static AffineTerm convertToReal(ApplicationTerm term) {
        AffineTerm result;
        if (!term.getFunction().getName().equals("to_real")) {
            throw new IllegalArgumentException("no to_real term");
        }
        Term[] params = term.getParameters();
        if (params.length > 1) {
            throw new UnsupportedOperationException();
        }
        Term param = params[0];
        if (param instanceof ConstantTerm) {
            AffineTerm realTerm;
            ConstantTerm constant = (ConstantTerm)param;
            if (!SmtSortUtils.isIntSort(constant.getSort())) {
                throw new UnsupportedOperationException();
            }
            AffineTerm intTerm = AffineTermTransformer.convertConstantNumericTerm(constant);
            result = realTerm = AffineTerm.constructConstant(term.getSort(), intTerm.getConstant());
        } else {
            result = AffineTerm.constructVariable((Term)term);
        }
        return result;
    }
}

