/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.DivisibleByAssumption;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IAssumption;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.VariableNotZeroAssumption;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SparseMapBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AssumptionMapBuilder {
    private Map<SolvedBinaryRelation.AssumptionForSolvability, IAssumption> mAssumptionMap = Collections.emptyMap();
    private final Script mScript;

    public AssumptionMapBuilder(Script script) {
        this.mScript = script;
    }

    public void putDivisorNotZero(Term divisor) {
        if (SmtSortUtils.isRealSort(divisor.getSort())) {
            this.put(SolvedBinaryRelation.AssumptionForSolvability.REAL_DIVISOR_NOT_ZERO, new VariableNotZeroAssumption(this.mScript, divisor), AssumptionMapBuilder::castAndCreateVarNotZeroAssu);
        } else if (SmtSortUtils.isIntSort(divisor.getSort())) {
            this.put(SolvedBinaryRelation.AssumptionForSolvability.INTEGER_DIVISOR_NOT_ZERO, new VariableNotZeroAssumption(this.mScript, divisor), AssumptionMapBuilder::castAndCreateVarNotZeroAssu);
        } else {
            throw new UnsupportedOperationException("There is no such assumption of this sort.");
        }
    }

    public void putDivisibleByConstant(Term dividend, Term divisor) {
        if (!SmtSortUtils.isIntSort(dividend.getSort())) {
            throw new UnsupportedOperationException("There is no such assumption of this sort.");
        }
        this.put(SolvedBinaryRelation.AssumptionForSolvability.INTEGER_DIVISIBLE_BY_CONSTANT, new DivisibleByAssumption(this.mScript, dividend, divisor), AssumptionMapBuilder::castAndCreateDivByAssu);
    }

    public void putDivisibleByVariable(Term dividend, Term divisor) {
        if (!SmtSortUtils.isIntSort(dividend.getSort())) {
            throw new UnsupportedOperationException("There is no such assumption of this sort.");
        }
        this.put(SolvedBinaryRelation.AssumptionForSolvability.INTEGER_DIVISIBLE_BY_VARIABLE, new DivisibleByAssumption(this.mScript, dividend, divisor), AssumptionMapBuilder::castAndCreateDivByAssu);
    }

    private void put(SolvedBinaryRelation.AssumptionForSolvability assuType, IAssumption assu, BiAssumptionConstructor<? extends IAssumption> assuConst) {
        if (this.mAssumptionMap.isEmpty()) {
            this.mAssumptionMap = Collections.singletonMap(assuType, assu);
        } else if (this.mAssumptionMap.size() == 1) {
            if (this.mAssumptionMap.containsKey((Object)assuType)) {
                this.mAssumptionMap = Collections.singletonMap(assuType, assuConst.apply(this.mScript, this.mAssumptionMap.get((Object)assuType), assu));
            } else {
                Map.Entry<SolvedBinaryRelation.AssumptionForSolvability, IAssumption> entry = this.mAssumptionMap.entrySet().iterator().next();
                this.mAssumptionMap = new HashMap<SolvedBinaryRelation.AssumptionForSolvability, IAssumption>();
                this.mAssumptionMap.put(entry.getKey(), entry.getValue());
                this.mAssumptionMap.put(assuType, assu);
            }
        } else if (this.mAssumptionMap.containsKey((Object)assuType)) {
            this.mAssumptionMap.put(assuType, assuConst.apply(this.mScript, this.mAssumptionMap.get((Object)assuType), assu));
        } else {
            this.mAssumptionMap.put(assuType, assu);
        }
    }

    private static DivisibleByAssumption castAndCreateDivByAssu(Script script, IAssumption assu1, IAssumption assu2) {
        if (assu1 instanceof DivisibleByAssumption && assu2 instanceof DivisibleByAssumption) {
            DivisibleByAssumption[] assus = new DivisibleByAssumption[]{(DivisibleByAssumption)assu1, (DivisibleByAssumption)assu2};
            return new DivisibleByAssumption(script, assu1.getSort(), assus);
        }
        throw new IllegalArgumentException("Someone has put an assumption at the wrong place");
    }

    private static VariableNotZeroAssumption castAndCreateVarNotZeroAssu(Script script, IAssumption assu1, IAssumption assu2) {
        if (assu1 instanceof VariableNotZeroAssumption && assu2 instanceof VariableNotZeroAssumption) {
            VariableNotZeroAssumption[] assus = new VariableNotZeroAssumption[]{(VariableNotZeroAssumption)assu1, (VariableNotZeroAssumption)assu2};
            return new VariableNotZeroAssumption(script, assu1.getSort(), assus);
        }
        throw new IllegalArgumentException("Someone has put an assumption at the wrong place");
    }

    public boolean hasContractedForm(SolvedBinaryRelation.AssumptionForSolvability assu) {
        return this.mAssumptionMap.get((Object)assu).hasContractedForm();
    }

    public Term getExplicitForm(SolvedBinaryRelation.AssumptionForSolvability assu) {
        if (this.mAssumptionMap.containsKey((Object)assu)) {
            return this.mAssumptionMap.get((Object)assu).toExplicitTerm();
        }
        return this.mScript.term("true", new Term[0]);
    }

    public Term getContractedFormIfPossible(SolvedBinaryRelation.AssumptionForSolvability assu) {
        if (this.mAssumptionMap.containsKey((Object)assu)) {
            return this.mAssumptionMap.get((Object)assu).toContractedTermIfPossible();
        }
        return this.mScript.term("true", new Term[0]);
    }

    public boolean isEmpty() {
        return this.mAssumptionMap.isEmpty();
    }

    public void clear() {
        this.mAssumptionMap = Collections.emptyMap();
    }

    public Map<SolvedBinaryRelation.AssumptionForSolvability, Term> getExplicitAssumptionMap() {
        SparseMapBuilder mapBuilder = new SparseMapBuilder();
        for (SolvedBinaryRelation.AssumptionForSolvability assu : this.mAssumptionMap.keySet()) {
            mapBuilder.put((Object)assu, (Object)this.getExplicitForm(assu));
        }
        return mapBuilder.getBuiltMap();
    }

    public Map<SolvedBinaryRelation.AssumptionForSolvability, Term> getContractedAssumptionMapWherePossible() {
        SparseMapBuilder mapBuilder = new SparseMapBuilder();
        for (SolvedBinaryRelation.AssumptionForSolvability assu : this.mAssumptionMap.keySet()) {
            if (this.hasContractedForm(assu)) {
                mapBuilder.put((Object)assu, (Object)this.getContractedFormIfPossible(assu));
                continue;
            }
            mapBuilder.put((Object)assu, (Object)this.getExplicitForm(assu));
        }
        return mapBuilder.getBuiltMap();
    }

    @FunctionalInterface
    public static interface BiAssumptionConstructor<S> {
        public S apply(Script var1, IAssumption var2, IAssumption var3);
    }
}

