/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProviderOnDemand;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Case
implements ITermProviderOnDemand {
    protected final SolvedBinaryRelation mSolvedBinaryRelation;
    protected final Set<SupportingTerm> mSupportingTerms;
    protected final MultiCaseSolvedBinaryRelation.Xnf mXnf;

    public Case(SolvedBinaryRelation solvedBinaryRelation, Set<SupportingTerm> supportingTerms, MultiCaseSolvedBinaryRelation.Xnf xnf) {
        this.mSolvedBinaryRelation = solvedBinaryRelation;
        this.mSupportingTerms = supportingTerms;
        this.mXnf = xnf;
    }

    public SolvedBinaryRelation getSolvedBinaryRelation() {
        return this.mSolvedBinaryRelation;
    }

    public Set<SupportingTerm> getSupportingTerms() {
        return Collections.unmodifiableSet(this.mSupportingTerms);
    }

    public Set<TermVariable> getAuxiliaryVariables() {
        return this.mSupportingTerms.stream().flatMap(x -> x.getNewAuxiliaryVariables().stream()).collect(Collectors.toSet());
    }

    public Stream<MultiCaseSolvedBinaryRelation.IntricateOperation> streamOfIntricateOperations() {
        if (this.mSolvedBinaryRelation != null && this.mSolvedBinaryRelation.getIntricateOperation() != null) {
            return Stream.concat(this.mSolvedBinaryRelation.getIntricateOperation().stream(), this.getSupportingTerms().stream().map(x -> x.getIntricateOperation()));
        }
        return this.getSupportingTerms().stream().map(x -> x.getIntricateOperation());
    }

    @Override
    public Term asTerm(Script script) {
        Term result;
        Collection params = this.mSupportingTerms.stream().map(x -> x.asTerm()).collect(Collectors.toList());
        if (this.mSolvedBinaryRelation != null) {
            params.add(this.mSolvedBinaryRelation.asTerm(script));
        }
        switch (this.mXnf) {
            case CNF: {
                result = SmtUtils.or(script, params);
                break;
            }
            case DNF: {
                result = SmtUtils.and(script, params);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown case " + (Object)((Object)this.mXnf)));
            }
        }
        return result;
    }

    public String toString() {
        String junctor;
        switch (this.mXnf) {
            case CNF: {
                junctor = " \\/ ";
                break;
            }
            case DNF: {
                junctor = " /\\ ";
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown case " + (Object)((Object)this.mXnf)));
            }
        }
        String result = this.mSolvedBinaryRelation == null ? "{" : "{" + this.mSolvedBinaryRelation.toString();
        for (SupportingTerm supp : this.mSupportingTerms) {
            result = result == "{" ? String.valueOf(result) + supp.toString() : String.valueOf(result) + junctor + supp.toString();
        }
        result = String.valueOf(result) + "}";
        return result;
    }
}

