/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractAssumption;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedList;

public class DivisibleByAssumption
extends AbstractAssumption {
    private final LinkedList<Term> mModTerms;

    public DivisibleByAssumption(Script script, Term dividend, Term divisor) {
        super(script, dividend.getSort(), DivisibleByAssumption::equalZero);
        this.mModTerms = new LinkedList();
        this.mModTerms.add(SmtUtils.mod(script, dividend, divisor));
    }

    public DivisibleByAssumption(Script script, Sort sort, DivisibleByAssumption ... assumptions) {
        super(script, sort, DivisibleByAssumption::equalZero);
        assert (assumptions.length > 1) : "This constructor only makes sense for 2 or more assumptions";
        this.mModTerms = assumptions[0].getModTerms();
        int i = 1;
        while (i < assumptions.length) {
            this.mModTerms.addAll(assumptions[i].getModTerms());
            ++i;
        }
    }

    private static Term equalZero(Script script, Sort sort, Term term) {
        if (SmtSortUtils.isIntSort(sort)) {
            return DivisibleByAssumption.equalZeroInt(script, sort, term);
        }
        throw new UnsupportedOperationException("This method is not implemented for this sort.");
    }

    private static Term equalZeroInt(Script script, Sort sort, Term term) {
        return SmtUtils.binaryEquality(script, term, SmtUtils.constructIntValue(script, BigInteger.ZERO));
    }

    @Override
    public boolean hasContractedForm() {
        return false;
    }

    @Override
    protected Term[] getConjunctsForExplicitForm() {
        Term[] conjuncts = new Term[this.mModTerms.size()];
        int i = 0;
        for (Term term : this.mModTerms) {
            conjuncts[i] = (Term)this.mRhsAppender.apply(this.mScript, this.mSort, term);
            ++i;
        }
        return conjuncts;
    }

    @Override
    protected Term constructContractedLhs() {
        return this.toExplicitTerm();
    }

    private LinkedList<Term> getModTerms() {
        return this.mModTerms;
    }
}

