/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProviderOnDemand;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.IBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolutionBuilder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermOperations;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.INonSolverScript;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ExplicitLhsPolynomialRelation
implements IBinaryRelation,
ITermProviderOnDemand {
    private static final boolean THROW_EXCEPTION_IF_NOT_SOLVABLE = false;
    protected final RelationSymbol mRelationSymbol;
    protected final Rational mLhsCoefficient;
    protected final Monomial mLhsMonomial;
    protected final IPolynomialTerm mRhs;

    public ExplicitLhsPolynomialRelation(RelationSymbol relationSymbol, Rational lhsCoefficient, Monomial lhsMonomial, IPolynomialTerm rhs) {
        this.mRelationSymbol = relationSymbol;
        this.mLhsCoefficient = lhsCoefficient;
        this.mLhsMonomial = lhsMonomial;
        this.mRhs = rhs;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public Rational getLhsCoefficient() {
        return this.mLhsCoefficient;
    }

    public Monomial getLhsMonomial() {
        return this.mLhsMonomial;
    }

    public IPolynomialTerm getRhs() {
        return this.mRhs;
    }

    public ExplicitLhsPolynomialRelation changeRelationSymbol(RelationSymbol relationSymbol) {
        return new ExplicitLhsPolynomialRelation(relationSymbol, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs);
    }

    public static ExplicitLhsPolynomialRelation moveMonomialToLhs(Script script, Term subject, PolynomialRelation polyRel) {
        Rational coeffOfSubject;
        Monomial monomialOfSubject = polyRel.getPolynomialTerm().getExclusiveMonomialOfSubject(subject);
        if (monomialOfSubject == null) {
            return null;
        }
        if (monomialOfSubject.getVariable2Exponent().get(subject) != Rational.ONE) {
            return null;
        }
        if (polyRel.getPolynomialTerm().isAffine()) {
            Term singleVariable = monomialOfSubject.getSingleVariable();
            assert (subject.equals(singleVariable));
            coeffOfSubject = polyRel.getPolynomialTerm().getAbstractVariable2Coefficient().get(singleVariable);
        } else {
            coeffOfSubject = polyRel.getPolynomialTerm().getAbstractVariable2Coefficient().get(monomialOfSubject);
        }
        if (coeffOfSubject.equals((Object)Rational.ZERO)) {
            throw new AssertionError((Object)"no abstract variable must have coefficient zero");
        }
        return new ExplicitLhsPolynomialRelation(polyRel.getRelationSymbol(), coeffOfSubject, monomialOfSubject, polyRel.getPolynomialTerm().removeAndNegate(monomialOfSubject));
    }

    @Deprecated
    public ExplicitLhsPolynomialRelation mul(Rational factor, Script script, boolean tight) {
        IPolynomialTerm newRhs;
        Rational offsetAbs;
        if (factor.equals((Object)Rational.ZERO)) {
            throw new AssertionError((Object)"mul by zero not supported");
        }
        Rational newLhsCoefficient = this.mLhsCoefficient.mul(factor);
        RelationSymbol resultRelationSymbol = this.determineResultRelationSymbol(this.mLhsMonomial.getSort(), this.mRelationSymbol, factor);
        if (tight && (resultRelationSymbol.equals((Object)RelationSymbol.LESS) || resultRelationSymbol.equals((Object)RelationSymbol.GREATER))) {
            if (resultRelationSymbol.equals((Object)RelationSymbol.LESS)) {
                offsetAbs = factor.abs().add(Rational.MONE).negate();
            } else {
                assert (resultRelationSymbol.equals((Object)RelationSymbol.GREATER));
                offsetAbs = factor.abs().add(Rational.MONE);
            }
            newRhs = PolynomialTermOperations.sum(PolynomialTermOperations.mul(this.mRhs, factor), new AffineTerm(this.mLhsMonomial.getSort(), offsetAbs, Collections.emptyMap()));
        } else if (!tight && (resultRelationSymbol.equals((Object)RelationSymbol.LEQ) || resultRelationSymbol.equals((Object)RelationSymbol.GEQ))) {
            if (resultRelationSymbol.equals((Object)RelationSymbol.GEQ)) {
                offsetAbs = factor.abs().add(Rational.MONE).negate();
            } else {
                assert (resultRelationSymbol.equals((Object)RelationSymbol.LEQ));
                offsetAbs = factor.abs().add(Rational.MONE);
            }
            newRhs = PolynomialTermOperations.sum(PolynomialTermOperations.mul(this.mRhs, factor), new AffineTerm(this.mLhsMonomial.getSort(), offsetAbs, Collections.emptyMap()));
        } else {
            newRhs = PolynomialTermOperations.mul(this.mRhs, factor);
        }
        ExplicitLhsPolynomialRelation result = new ExplicitLhsPolynomialRelation(resultRelationSymbol, newLhsCoefficient, this.mLhsMonomial, newRhs);
        assert (script instanceof INonSolverScript || SmtUtils.checkEquivalence(this.asTerm(script), result.asTerm(script), script) != Script.LBool.SAT) : "mul unsound";
        return result;
    }

    public ExplicitLhsPolynomialRelation divInvertible(Rational divisor) {
        IPolynomialTerm newRhs;
        if (divisor.equals((Object)Rational.ZERO)) {
            throw new AssertionError((Object)"div by zero");
        }
        RelationSymbol resultRelationSymbol = this.determineResultRelationSymbol(this.mLhsMonomial.getSort(), this.mRelationSymbol, divisor);
        if (resultRelationSymbol.isConvexInequality() && SmtSortUtils.isIntSort(this.mRhs.getSort())) {
            Rational newConst;
            IPolynomialTerm rhsWithoutConst = this.mRhs.add(this.mRhs.getConstant().negate());
            assert (rhsWithoutConst.getConstant().equals((Object)Rational.ZERO));
            IPolynomialTerm newRhsWithoutConst = rhsWithoutConst.divInvertible(divisor);
            if (newRhsWithoutConst == null) {
                return null;
            }
            Rational constWithRightSign = divisor.isNegative() ? this.mRhs.getConstant().negate() : this.mRhs.getConstant();
            if (resultRelationSymbol.equals((Object)RelationSymbol.LEQ) || resultRelationSymbol.equals((Object)RelationSymbol.GREATER)) {
                newConst = constWithRightSign.div(divisor.abs()).floor();
            } else if (resultRelationSymbol.equals((Object)RelationSymbol.LESS) || resultRelationSymbol.equals((Object)RelationSymbol.GEQ)) {
                newConst = constWithRightSign.add(Rational.MONE).div(divisor.abs()).floor().add(Rational.ONE);
            } else {
                throw new AssertionError((Object)("Unexpected relation symbol: " + (Object)((Object)resultRelationSymbol)));
            }
            newRhs = newRhsWithoutConst.add(newConst);
        } else {
            newRhs = this.mRhs.divInvertible(divisor);
        }
        if (newRhs == null) {
            return null;
        }
        Rational newLhsCoefficient = PolynomialTermUtils.divInvertible(this.mLhsMonomial.getSort(), this.mLhsCoefficient, divisor);
        if (newLhsCoefficient == null) {
            return null;
        }
        return new ExplicitLhsPolynomialRelation(resultRelationSymbol, newLhsCoefficient, this.mLhsMonomial, newRhs);
    }

    private RelationSymbol determineResultRelationSymbol(Sort sort, RelationSymbol relationSymbol, Rational divisor) {
        RelationSymbol resultRelationSymbol = ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(divisor, sort) ? relationSymbol.swapParameters() : relationSymbol;
        return resultRelationSymbol;
    }

    public static boolean swapOfRelationSymbolRequired(Rational divisor, Sort sort) {
        return divisor.isNegative() || SmtSortUtils.isBitvecSort(sort) && SmtUtils.isBvMinusOneButNotOne(divisor, sort);
    }

    public Pair<ExplicitLhsPolynomialRelation, Term> divideByIntegerCoefficient(Script script, Set<TermVariable> bannedForDivCapture) {
        Term divisibilityConstraint;
        if (this.mLhsCoefficient.equals((Object)Rational.ZERO)) {
            throw new AssertionError((Object)"div by zero");
        }
        if (!SmtSortUtils.isIntSort(this.mLhsMonomial.getSort())) {
            throw new AssertionError((Object)("no int: " + this.mLhsMonomial.getSort()));
        }
        Term divisor = this.mLhsCoefficient.toTerm(this.mLhsMonomial.getSort());
        IPolynomialTerm resultRhs = SolveForSubjectUtils.constructRhsIntegerQuotient(script, this.mRelationSymbol, this.mRhs, !this.mLhsCoefficient.isNegative(), divisor, bannedForDivCapture);
        Term rhsAsTerm = this.mRhs.toTerm(script);
        if (resultRhs == null) {
            assert (Arrays.stream(rhsAsTerm.getFreeVars()).anyMatch(bannedForDivCapture::contains)) : "no ban problem detected";
            return null;
        }
        switch (this.mRelationSymbol) {
            case DISTINCT: {
                divisibilityConstraint = ExplicitLhsPolynomialRelation.constructDivisibilityConstraint(script, true, rhsAsTerm, divisor);
                break;
            }
            case EQ: {
                divisibilityConstraint = ExplicitLhsPolynomialRelation.constructDivisibilityConstraint(script, false, rhsAsTerm, divisor);
                break;
            }
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                divisibilityConstraint = null;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + (Object)((Object)this.mRelationSymbol)));
            }
        }
        RelationSymbol resultRelationSymbol = this.determineResultRelationSymbol(this.mLhsMonomial.getSort(), this.mRelationSymbol, this.mLhsCoefficient);
        ExplicitLhsPolynomialRelation resultElpr = new ExplicitLhsPolynomialRelation(resultRelationSymbol, Rational.ONE, this.getLhsMonomial(), resultRhs);
        return new Pair((Object)resultElpr, (Object)divisibilityConstraint);
    }

    @Deprecated
    public SolvedBinaryRelation divideByIntegerCoefficientForInequalities(Script script, Set<TermVariable> bannedForDivCapture) {
        switch (this.mRelationSymbol) {
            case EQ: 
            case DISTINCT: {
                throw new AssertionError((Object)"no inequality");
            }
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + (Object)((Object)this.mRelationSymbol)));
            }
        }
        Pair<ExplicitLhsPolynomialRelation, Term> tmp = this.divideByIntegerCoefficient(script, bannedForDivCapture);
        if (tmp == null) {
            return null;
        }
        assert (tmp.getSecond() == null);
        ExplicitLhsPolynomialRelation resultElpr = (ExplicitLhsPolynomialRelation)tmp.getFirst();
        return new SolvedBinaryRelation(this.mLhsMonomial.getSingleVariable(), resultElpr.getRhs().toTerm(script), resultElpr.getRelationSymbol(), MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT);
    }

    public MultiCaseSolvedBinaryRelation divByMonomial(Script script, Term subject, MultiCaseSolvedBinaryRelation.Xnf xnf, Set<TermVariable> bannedForDivCapture, Term intLiteralDivConstraint, MultiCaseSolvedBinaryRelation.IntricateOperation additionalIo) {
        if (!this.mLhsCoefficient.equals((Object)Rational.ONE)) {
            throw new AssertionError((Object)"could be supported, but should not be used in our applications");
        }
        Term rhs = this.mRhs.toTerm(script);
        if (this.mLhsMonomial.isLinear()) {
            throw new AssertionError((Object)"division not necessary");
        }
        if (Arrays.stream(rhs.getFreeVars()).anyMatch(bannedForDivCapture::contains)) {
            return null;
        }
        EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> intricateOperations = additionalIo == null ? EnumSet.of(MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT) : EnumSet.of(MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, additionalIo);
        MultiCaseSolutionBuilder mcsb = new MultiCaseSolutionBuilder(subject, xnf);
        ArrayList<Case> cases = new ArrayList<Case>();
        ArrayList<Term> twoCaseVariables = new ArrayList<Term>();
        HashSet<SupportingTerm> distinctZeroSupportingTerms = new HashSet<SupportingTerm>();
        ArrayList<Term> threeCaseVariables = new ArrayList<Term>();
        ArrayList<SupportingTerm> isNegativeSupportingTerms = new ArrayList<SupportingTerm>();
        ArrayList<SupportingTerm> isPositiveSupportingTerms = new ArrayList<SupportingTerm>();
        ArrayList<Term> factorsOfDivisor = new ArrayList<Term>();
        for (Map.Entry<Term, Rational> var2exp : this.mLhsMonomial.getVariable2Exponent().entrySet()) {
            assert (var2exp.getValue().isIntegral());
            if (var2exp.getKey() == subject) continue;
            cases.add(ExplicitLhsPolynomialRelation.constructDivByVarEqualZeroCase(script, var2exp.getKey(), rhs, this.mRelationSymbol, xnf, intLiteralDivConstraint));
            int exp = var2exp.getValue().numerator().intValueExact();
            int i = 0;
            while (i < exp) {
                factorsOfDivisor.add(var2exp.getKey());
                ++i;
            }
            if (ExplicitLhsPolynomialRelation.isEqOrDistinct(this.mRelationSymbol) || exp % 2 == 0) {
                twoCaseVariables.add(var2exp.getKey());
                distinctZeroSupportingTerms.add(ExplicitLhsPolynomialRelation.constructInRelationToZeroSupportingTerm(script, var2exp.getKey(), SolveForSubjectUtils.negateForCnf(RelationSymbol.DISTINCT, xnf)));
                continue;
            }
            threeCaseVariables.add(var2exp.getKey());
            isNegativeSupportingTerms.add(ExplicitLhsPolynomialRelation.constructInRelationToZeroSupportingTerm(script, var2exp.getKey(), SolveForSubjectUtils.negateForCnf(RelationSymbol.LESS, xnf)));
            isPositiveSupportingTerms.add(ExplicitLhsPolynomialRelation.constructInRelationToZeroSupportingTerm(script, var2exp.getKey(), SolveForSubjectUtils.negateForCnf(RelationSymbol.GREATER, xnf)));
        }
        Term divisor = SmtUtils.mul(script, ((Term)factorsOfDivisor.get(0)).getSort(), factorsOfDivisor.toArray(new Term[factorsOfDivisor.size()]));
        if (threeCaseVariables.isEmpty()) {
            SolvedBinaryRelation sbr = ExplicitLhsPolynomialRelation.constructSolvedBinaryRelation(script, subject, this.mRhs, this.mRelationSymbol, true, divisor, intricateOperations, bannedForDivCapture);
            HashSet<SupportingTerm> thisCaseSupportingTerms = new HashSet<SupportingTerm>(distinctZeroSupportingTerms);
            if (SolveForSubjectUtils.isDerIntegerDivisionSupportingTermRequired(xnf, subject.getSort(), this.mRelationSymbol)) {
                SupportingTerm divisibilityConstraintMonomial = ExplicitLhsPolynomialRelation.constructDerIntegerDivisionSupportingTerm(script, rhs, this.mRelationSymbol, divisor);
                thisCaseSupportingTerms.add(divisibilityConstraintMonomial);
                if (intLiteralDivConstraint != null) {
                    SupportingTerm divisibilityConstraintLiteral = SolveForSubjectUtils.constructDerIntegerDivisionSupportingTerm(script, intLiteralDivConstraint);
                    thisCaseSupportingTerms.add(divisibilityConstraintLiteral);
                }
            }
            cases.add(new Case(sbr, thisCaseSupportingTerms, xnf));
        } else {
            if (threeCaseVariables.size() > 30) {
                throw new UnsupportedOperationException("Exponential blowup too huge. Exponent is " + threeCaseVariables.size());
            }
            int numberOfCases = BigInteger.valueOf(2L).pow(threeCaseVariables.size()).intValueExact();
            int i = 0;
            while (i < numberOfCases) {
                boolean isDivisorPositive = BigInteger.valueOf(i).bitCount() % 2 == 0;
                SolvedBinaryRelation sbr = ExplicitLhsPolynomialRelation.constructSolvedBinaryRelation(script, subject, this.mRhs, this.mRelationSymbol, isDivisorPositive, divisor, intricateOperations, bannedForDivCapture);
                HashSet<SupportingTerm> thisCaseSupportingTerms = new HashSet<SupportingTerm>(distinctZeroSupportingTerms);
                int j = 0;
                while (j < threeCaseVariables.size()) {
                    SupportingTerm posOrNegSupportingTerm = BigInteger.valueOf(i).testBit(j) ? (SupportingTerm)isNegativeSupportingTerms.get(j) : (SupportingTerm)isPositiveSupportingTerms.get(j);
                    thisCaseSupportingTerms.add(posOrNegSupportingTerm);
                    ++j;
                }
                if (SolveForSubjectUtils.isDerIntegerDivisionSupportingTermRequired(xnf, subject.getSort(), this.mRelationSymbol)) {
                    SupportingTerm divisibilityConstraint = ExplicitLhsPolynomialRelation.constructDerIntegerDivisionSupportingTerm(script, rhs, this.mRelationSymbol, divisor);
                    thisCaseSupportingTerms.add(divisibilityConstraint);
                    assert (intLiteralDivConstraint != null);
                    SupportingTerm divisibilityConstraintLiteral = SolveForSubjectUtils.constructDerIntegerDivisionSupportingTerm(script, intLiteralDivConstraint);
                    thisCaseSupportingTerms.add(divisibilityConstraintLiteral);
                }
                cases.add(new Case(sbr, thisCaseSupportingTerms, xnf));
                ++i;
            }
        }
        if (SolveForSubjectUtils.isAntiDerIntegerDivisionCaseRequired(xnf, subject.getSort(), this.mRelationSymbol)) {
            Case result = ExplicitLhsPolynomialRelation.constructAntiDerIntegerDivisibilityCase(script, xnf, rhs, this.mRelationSymbol, divisor);
            cases.add(result);
            if (intLiteralDivConstraint != null) {
                SupportingTerm intLiteralDivConstraintSuppTerm = new SupportingTerm(intLiteralDivConstraint, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT, Collections.emptySet());
                Case caseForLiteral = new Case(null, Collections.singleton(intLiteralDivConstraintSuppTerm), xnf);
                cases.add(caseForLiteral);
            }
        }
        mcsb.splitCases(cases);
        MultiCaseSolvedBinaryRelation result = mcsb.buildResult();
        return result;
    }

    private static SupportingTerm constructDerIntegerDivisionSupportingTerm(Script script, Term stageTwoRhs, RelationSymbol relSymb, Term divisor) {
        boolean negate = relSymb.equals((Object)RelationSymbol.DISTINCT);
        Term divisibilityConstraintTerm = ExplicitLhsPolynomialRelation.constructDivisibilityConstraint(script, negate, stageTwoRhs, SmtUtils.mul(script, stageTwoRhs.getSort(), divisor));
        SupportingTerm divisibilityConstraint = new SupportingTerm(divisibilityConstraintTerm, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
        return divisibilityConstraint;
    }

    private static Case constructAntiDerIntegerDivisibilityCase(Script script, MultiCaseSolvedBinaryRelation.Xnf xnf, Term stageTwoRhs, RelationSymbol relSymb, Term divisorAsArray) {
        HashSet<SupportingTerm> suppTerms = new HashSet<SupportingTerm>();
        boolean negate = relSymb.equals((Object)RelationSymbol.DISTINCT);
        Term divisibilityConstraintTerm = ExplicitLhsPolynomialRelation.constructDivisibilityConstraint(script, negate, stageTwoRhs, SmtUtils.mul(script, stageTwoRhs.getSort(), divisorAsArray));
        SupportingTerm divisibilityConstraint = new SupportingTerm(divisibilityConstraintTerm, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
        suppTerms.add(divisibilityConstraint);
        SupportingTerm inRelationToZero = ExplicitLhsPolynomialRelation.constructInRelationToZeroSupportingTerm(script, SmtUtils.mul(script, stageTwoRhs.getSort(), divisorAsArray), SolveForSubjectUtils.negateForCnf(RelationSymbol.DISTINCT, xnf));
        suppTerms.add(inRelationToZero);
        Case result = new Case(null, suppTerms, xnf);
        return result;
    }

    private static SupportingTerm constructInRelationToZeroSupportingTerm(Script script, Term term, RelationSymbol relSym) {
        Term zero = SmtUtils.rational2Term(script, Rational.ZERO, term.getSort());
        Term termRelZero = relSym.constructTerm(script, term, zero);
        return new SupportingTerm(termRelZero, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
    }

    private static SolvedBinaryRelation constructSolvedBinaryRelation(Script script, Term subject, IPolynomialTerm rhs, RelationSymbol relSymb, boolean isDivisorPositive, Term divisor, EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> intricateOperations, Set<TermVariable> bannedForDivCapture) {
        Term resultRhs;
        RelationSymbol resultRelationSymbol = isDivisorPositive ? relSymb : relSymb.swapParameters();
        if (SmtSortUtils.isIntSort(rhs.getSort())) {
            resultRhs = SolveForSubjectUtils.constructRhsIntegerQuotient(script, relSymb, rhs, isDivisorPositive, divisor, bannedForDivCapture).toTerm(script);
            if (resultRhs == null) {
                return null;
            }
        } else {
            resultRhs = SmtUtils.divReal(script, SolveForSubjectUtils.prepend(rhs.toTerm(script), divisor));
        }
        SolvedBinaryRelation sbr = new SolvedBinaryRelation(subject, resultRhs, resultRelationSymbol, intricateOperations.toArray(new MultiCaseSolvedBinaryRelation.IntricateOperation[intricateOperations.size()]));
        return sbr;
    }

    public static Term constructDivisibilityConstraint(Script script, boolean negate, Term divident, Term divisor) {
        Term modTerm = SmtUtils.mod(script, divident, divisor);
        Term tmp = SmtUtils.binaryEquality(script, modTerm, SmtUtils.constructIntegerValue(script, SmtSortUtils.getIntSort(script), BigInteger.ZERO));
        Term result = negate ? SmtUtils.not(script, tmp) : tmp;
        return result;
    }

    private static Case constructDivByVarEqualZeroCase(Script script, Term divisorVar, Term rhs, RelationSymbol relSym, MultiCaseSolvedBinaryRelation.Xnf xnf, Term intLiteralDivConstraint) {
        Term rhsRelationZeroTerm;
        SupportingTerm st;
        LinkedHashSet<SupportingTerm> suppTerms = new LinkedHashSet<SupportingTerm>();
        if (SolveForSubjectUtils.isDerIntegerDivisionSupportingTermRequired(xnf, divisorVar.getSort(), relSym) && intLiteralDivConstraint != null) {
            suppTerms.add(SolveForSubjectUtils.constructDerIntegerDivisionSupportingTerm(script, intLiteralDivConstraint));
        }
        Term zeroTerm = SmtUtils.rational2Term(script, Rational.ZERO, divisorVar.getSort());
        Term varEqualZero = SmtUtils.binaryEquality(script, zeroTerm, divisorVar);
        switch (xnf) {
            case CNF: {
                st = new SupportingTerm(SmtUtils.not(script, varEqualZero), MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
                break;
            }
            case DNF: {
                st = new SupportingTerm(varEqualZero, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + (Object)((Object)xnf)));
            }
        }
        suppTerms.add(st);
        switch (relSym) {
            case EQ: {
                rhsRelationZeroTerm = SmtUtils.binaryEquality(script, zeroTerm, rhs);
                break;
            }
            case DISTINCT: {
                rhsRelationZeroTerm = SmtUtils.distinct(script, zeroTerm, rhs);
                break;
            }
            case LEQ: {
                rhsRelationZeroTerm = SmtUtils.leq(script, zeroTerm, rhs);
                break;
            }
            case LESS: {
                rhsRelationZeroTerm = SmtUtils.less(script, zeroTerm, rhs);
                break;
            }
            case GEQ: {
                rhsRelationZeroTerm = SmtUtils.geq(script, zeroTerm, rhs);
                break;
            }
            case GREATER: {
                rhsRelationZeroTerm = SmtUtils.greater(script, zeroTerm, rhs);
                break;
            }
            case BVULE: {
                rhsRelationZeroTerm = SmtUtils.bvule(script, zeroTerm, rhs);
                break;
            }
            case BVULT: {
                rhsRelationZeroTerm = SmtUtils.bvult(script, zeroTerm, rhs);
                break;
            }
            case BVUGE: {
                rhsRelationZeroTerm = SmtUtils.bvuge(script, zeroTerm, rhs);
                break;
            }
            case BVUGT: {
                rhsRelationZeroTerm = SmtUtils.bvugt(script, zeroTerm, rhs);
                break;
            }
            case BVSLE: {
                rhsRelationZeroTerm = SmtUtils.bvsle(script, zeroTerm, rhs);
                break;
            }
            case BVSLT: {
                rhsRelationZeroTerm = SmtUtils.bvslt(script, zeroTerm, rhs);
                break;
            }
            case BVSGE: {
                rhsRelationZeroTerm = SmtUtils.bvsge(script, zeroTerm, rhs);
                break;
            }
            case BVSGT: {
                rhsRelationZeroTerm = SmtUtils.bvsgt(script, zeroTerm, rhs);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown RelationSymbol: " + (Object)((Object)relSym)));
            }
        }
        suppTerms.add(new SupportingTerm(rhsRelationZeroTerm, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet()));
        return new Case(null, suppTerms, xnf);
    }

    public ExplicitLhsPolynomialRelation changeStrictness(PolynomialRelation.TransformInequality strictnessTrans) {
        if (!SmtSortUtils.isIntSort(this.mRhs.getSort())) {
            throw new UnsupportedOperationException("Change of strictness only for ints.");
        }
        if (strictnessTrans == PolynomialRelation.TransformInequality.NO_TRANFORMATION) {
            return this;
        }
        switch (this.mRelationSymbol) {
            case EQ: 
            case DISTINCT: {
                throw new UnsupportedOperationException("Only applicable to integer inequalities");
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new UnsupportedOperationException("Only applicable to integer inequalities");
            }
            case GEQ: {
                if (strictnessTrans == PolynomialRelation.TransformInequality.NONSTRICT2STRICT) {
                    return new ExplicitLhsPolynomialRelation(RelationSymbol.GREATER, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs.add(Rational.MONE));
                }
                throw new UnsupportedOperationException("Not strict");
            }
            case GREATER: {
                if (strictnessTrans == PolynomialRelation.TransformInequality.STRICT2NONSTRICT) {
                    return new ExplicitLhsPolynomialRelation(RelationSymbol.GEQ, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs.add(Rational.ONE));
                }
                throw new UnsupportedOperationException("Is strict");
            }
            case LEQ: {
                if (strictnessTrans == PolynomialRelation.TransformInequality.NONSTRICT2STRICT) {
                    return new ExplicitLhsPolynomialRelation(RelationSymbol.LESS, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs.add(Rational.ONE));
                }
                throw new UnsupportedOperationException("Not strict");
            }
            case LESS: {
                if (strictnessTrans == PolynomialRelation.TransformInequality.STRICT2NONSTRICT) {
                    return new ExplicitLhsPolynomialRelation(RelationSymbol.LEQ, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs.add(Rational.MONE));
                }
                throw new UnsupportedOperationException("Is strict");
            }
        }
        throw new AssertionError((Object)("Unknown relation symbol " + (Object)((Object)this.mRelationSymbol)));
    }

    public ExplicitLhsPolynomialRelation makeTight() {
        Rational divisor;
        if (SmtSortUtils.isRealSort(this.mRhs.getSort())) {
            divisor = this.mLhsCoefficient;
        } else if (SmtSortUtils.isBitvecSort(this.mRhs.getSort())) {
            if (!this.mLhsCoefficient.equals((Object)Rational.ONE) && !SmtUtils.isBvMinusOneButNotOne(this.mLhsCoefficient, this.mRhs.getSort())) {
                throw new AssertionError((Object)"Expect that bitvector relations can only habe coefficient 1 and -1.");
            }
            divisor = this.mLhsCoefficient;
        } else if (SmtSortUtils.isIntSort(this.mRhs.getSort())) {
            Rational gcd = this.mLhsCoefficient.gcd(this.mRhs.computeGcdOfCoefficients());
            divisor = !gcd.isNegative() && this.mLhsCoefficient.isNegative() ? gcd.negate() : gcd;
        } else {
            throw new UnsupportedOperationException("Unsupported sort: " + this.mRhs.getSort());
        }
        if (divisor.equals((Object)Rational.ONE)) {
            return this;
        }
        ExplicitLhsPolynomialRelation res = this.divInvertible(divisor);
        if (res == null) {
            throw new AssertionError((Object)("Invertible division must not fail for " + divisor));
        }
        return res;
    }

    private static boolean isEqOrDistinct(RelationSymbol relSym) {
        return relSym.equals((Object)RelationSymbol.EQ) || relSym.equals((Object)RelationSymbol.DISTINCT);
    }

    @Override
    public SolvedBinaryRelation solveForSubject(Script script, Term subject) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Term asTerm(Script script) {
        Term lhs = SmtUtils.mul(script, this.mLhsCoefficient, this.mLhsMonomial.toTerm(script));
        return this.mRelationSymbol.constructTerm(script, lhs, this.mRhs.toTerm(script));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mLhsCoefficient);
        builder.append("*");
        builder.append(this.mLhsMonomial);
        builder.append(" ");
        builder.append((Object)this.mRelationSymbol);
        builder.append(" ");
        builder.append(this.mRhs);
        return builder.toString();
    }
}

