/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Monomial {
    private final Map<Term, Rational> mVariable2Exponent;
    private final Sort mSort;

    public Monomial(Term t, Rational r) {
        this.checkIfTermIsLegalVariable(t);
        this.mSort = t.getSort();
        this.mVariable2Exponent = Collections.singletonMap(t, r);
    }

    public Monomial(Monomial ... monomials) {
        this.mSort = monomials[0].getSort();
        this.mVariable2Exponent = new HashMap<Term, Rational>();
        Monomial[] monomialArray = monomials;
        int n = monomials.length;
        int n2 = 0;
        while (n2 < n) {
            Monomial monomial = monomialArray[n2];
            for (Map.Entry<Term, Rational> factor : monomial.getVariable2Exponent().entrySet()) {
                assert (factor.getKey().getSort() == this.mSort) : "Sort mismatch: " + factor.getKey().getSort() + " vs. " + this.mSort;
                assert (factor.getValue().signum() != -1);
                Rational exp = this.mVariable2Exponent.get(factor.getKey());
                if (exp == null) {
                    this.mVariable2Exponent.put(factor.getKey(), factor.getValue());
                    continue;
                }
                if (exp.isNegative() || factor.getValue().isNegative()) {
                    throw new UnsupportedOperationException("Division is only allowed by constants");
                }
                Rational newExp = exp.add(factor.getValue());
                if (newExp.equals((Object)Rational.ZERO)) {
                    this.mVariable2Exponent.remove(factor.getKey());
                    continue;
                }
                this.mVariable2Exponent.put(factor.getKey(), newExp);
            }
            ++n2;
        }
    }

    public void checkIfTermIsLegalVariable(Term term) {
        if (!(term instanceof TermVariable) && !(term instanceof ApplicationTerm)) {
            throw new IllegalArgumentException("Variable of Monomial has to be TermVariable or ApplicationTerm");
        }
    }

    public boolean isLinear() {
        return this.getSingleVariable() != null;
    }

    public Term getSingleVariable() {
        Iterator<Map.Entry<Term, Rational>> it = this.getVariable2Exponent().entrySet().iterator();
        if (!it.hasNext()) {
            throw new AssertionError((Object)"empty monomial are not supported");
        }
        Map.Entry<Term, Rational> first = it.next();
        if (!first.getValue().equals((Object)Rational.ONE)) {
            return null;
        }
        if (it.hasNext()) {
            return null;
        }
        return first.getKey();
    }

    public Map<Term, Rational> getVariable2Exponent() {
        return Collections.unmodifiableMap(this.mVariable2Exponent);
    }

    public boolean isVariable(Term var) {
        return this.getVariable2Exponent().keySet().contains(var);
    }

    public Occurrence isExclusiveVariable(Term var) {
        boolean varOccurred = false;
        for (Map.Entry<Term, Rational> var2exp : this.getVariable2Exponent().entrySet()) {
            if (var2exp.getKey().equals(var)) {
                if (varOccurred) {
                    throw new AssertionError((Object)"var occurs twice");
                }
                varOccurred = true;
                continue;
            }
            boolean subjectOccursAsSubterm = new SubtermPropertyChecker(x -> x == var).isSatisfiedBySomeSubterm(var2exp.getKey());
            if (!subjectOccursAsSubterm) continue;
            return Occurrence.NON_EXCLUSIVE_OR_SUBTERM;
        }
        if (varOccurred) {
            return Occurrence.AS_EXCLUSIVE_VARIABlE;
        }
        return Occurrence.NOT;
    }

    public Sort getSort() {
        return this.mSort;
    }

    public Term toTerm(Script script) {
        return this.timesCoefficientToTerm(script, Rational.ONE);
    }

    public Term timesCoefficientToTerm(Script script, Rational coeff) {
        int i;
        Term[] factors;
        int size = this.sumOfExponents();
        if (coeff.equals((Object)Rational.ONE)) {
            factors = new Term[size];
            i = 0;
        } else {
            factors = new Term[size + 1];
            factors[0] = SmtUtils.rational2Term(script, coeff, this.mSort);
            i = 1;
        }
        for (Map.Entry<Term, Rational> entry : this.mVariable2Exponent.entrySet()) {
            Term factor = entry.getKey();
            int exponent = entry.getValue().numerator().intValueExact();
            int j = 0;
            while (j < exponent) {
                factors[i] = factor;
                ++i;
                ++j;
            }
        }
        Term result = SmtUtils.mul(script, this.mSort, factors);
        return result;
    }

    private int sumOfExponents() {
        Rational size = Rational.ZERO;
        for (Rational exp : this.mVariable2Exponent.values()) {
            assert (!exp.equals((Object)Rational.ZERO)) : "zero is no legal exponent in AffineTerm";
            assert (exp.signum() != -1);
            assert (exp.isIntegral());
            size = size.add(exp);
        }
        return size.numerator().intValueExact();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Term, Rational> entry : this.mVariable2Exponent.entrySet()) {
            sb.append(entry.getKey());
            sb.append("^" + (entry.getValue().isNegative() ? "[-" : "[") + entry.getValue().abs() + "]");
        }
        String result = sb.toString();
        if (result.charAt(0) == ' ') {
            result = result.substring(1);
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mSort == null ? 0 : this.mSort.hashCode());
        result = 31 * result + (this.mVariable2Exponent == null ? 0 : this.mVariable2Exponent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Monomial)) {
            return false;
        }
        Monomial other = (Monomial)obj;
        if (this.mSort == null ? other.getSort() != null : !this.mSort.equals(other.getSort())) {
            return false;
        }
        return !(this.mVariable2Exponent == null ? other.getVariable2Exponent() != null : !this.mVariable2Exponent.equals(other.getVariable2Exponent()));
    }

    public static enum Occurrence {
        NOT,
        AS_EXCLUSIVE_VARIABlE,
        NON_EXCLUSIVE_OR_SUBTERM;

    }
}

