/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.LexicographicCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultiCaseSolutionBuilder {
    private final Term mSubject;
    private final MultiCaseSolvedBinaryRelation.Xnf mXnf;
    private final Set<TermVariable> mAdditionalAuxiliaryVariables;
    private final Set<MultiCaseSolvedBinaryRelation.IntricateOperation> mAdditionalIntricateOperations;
    private List<Case> mCases;
    private boolean mConstructionFinished = false;

    public MultiCaseSolutionBuilder(Term subject, MultiCaseSolvedBinaryRelation.Xnf xnf) {
        this.mXnf = xnf;
        this.mSubject = subject;
        this.mCases = new ArrayList<Case>();
        this.mAdditionalAuxiliaryVariables = new HashSet<TermVariable>();
        this.mAdditionalIntricateOperations = new HashSet<MultiCaseSolvedBinaryRelation.IntricateOperation>();
    }

    public void addAtoms(Object ... newAtoms) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("construction already finished");
        }
        if (this.mCases.isEmpty()) {
            this.mCases.add(new Case(null, Collections.emptySet(), this.mXnf));
        }
        this.mCases = this.buildCopyAndAddToEachCase(this.mCases, this.buildCase(newAtoms));
    }

    public void splitCases(Collection<Case> newCases) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("construction already finished");
        }
        ArrayList<Case> resultCases = new ArrayList<Case>();
        for (Case newCase : newCases) {
            if (this.mCases.isEmpty()) {
                resultCases.add(newCase);
                continue;
            }
            resultCases.addAll(this.buildCopyAndAddToEachCase(this.mCases, newCase));
        }
        this.mCases = resultCases;
    }

    private static List<List<?>> convertDnfToCnf(List<List<?>> dnf) {
        int[] numberOfValues = dnf.stream().mapToInt(x -> x.size()).toArray();
        LexicographicCounter lc = new LexicographicCounter(numberOfValues);
        ArrayList result = new ArrayList();
        do {
            ArrayList inner = new ArrayList();
            int i = 0;
            while (i < dnf.size()) {
                Object atom = dnf.get(i).get(lc.getCurrentValue()[i]);
                inner.add(atom);
                ++i;
            }
            result.add(inner);
            lc.increment();
        } while (!lc.isZero());
        return result;
    }

    public void reportAdditionalIntricateOperation(MultiCaseSolvedBinaryRelation.IntricateOperation intricateOperation) {
        this.mAdditionalIntricateOperations.add(intricateOperation);
    }

    public void reportAdditionalAuxiliaryVariable(TermVariable auxiliaryVariable) {
        this.mAdditionalAuxiliaryVariables.add(auxiliaryVariable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Case buildCase(Object ... newElems) throws AssertionError {
        SolvedBinaryRelation solvedBinaryRelation = null;
        HashSet<SupportingTerm> supportingTerms = new HashSet<SupportingTerm>();
        Object[] objectArray = newElems;
        int n = newElems.length;
        int n2 = 0;
        while (n2 < n) {
            Object newElem = objectArray[n2];
            if (newElem instanceof SolvedBinaryRelation) {
                if (solvedBinaryRelation != null) throw new AssertionError((Object)"already have a solvedBinayRelation");
                solvedBinaryRelation = (SolvedBinaryRelation)newElem;
            } else {
                if (!(newElem instanceof SupportingTerm)) throw new UnsupportedOperationException();
                supportingTerms.add((SupportingTerm)newElem);
            }
            ++n2;
        }
        return new Case(solvedBinaryRelation, supportingTerms, this.mXnf);
    }

    private List<Case> buildSingletonCases(Object ... newElems) throws AssertionError {
        ArrayList<Case> result = new ArrayList<Case>();
        Object[] objectArray = newElems;
        int n = newElems.length;
        int n2 = 0;
        while (n2 < n) {
            Case newCase;
            Object newElem = objectArray[n2];
            if (newElem instanceof SolvedBinaryRelation) {
                newCase = new Case((SolvedBinaryRelation)newElem, Collections.emptySet(), this.mXnf);
                result.add(newCase);
            } else if (newElem instanceof SupportingTerm) {
                newCase = new Case(null, Collections.singleton((SupportingTerm)newElem), this.mXnf);
                result.add(newCase);
            } else {
                throw new UnsupportedOperationException();
            }
            ++n2;
        }
        return result;
    }

    private List<Case> buildCopyAndAddToEachCase(List<Case> cases, Case distributionCase) {
        ArrayList<Case> newCases = new ArrayList<Case>();
        for (Case c : cases) {
            SolvedBinaryRelation solvedBinaryRelation = null;
            HashSet<SupportingTerm> supportingTerms = new HashSet<SupportingTerm>(c.getSupportingTerms());
            solvedBinaryRelation = c.getSolvedBinaryRelation();
            if (distributionCase.getSolvedBinaryRelation() != null) {
                if (solvedBinaryRelation == null) {
                    solvedBinaryRelation = distributionCase.getSolvedBinaryRelation();
                } else {
                    throw new AssertionError((Object)"already have a solvedBinayRelation");
                }
            }
            supportingTerms.addAll(distributionCase.getSupportingTerms());
            Case newCase = new Case(solvedBinaryRelation, supportingTerms, this.mXnf);
            newCases.add(newCase);
        }
        return newCases;
    }

    private List<Case> buildProduct(List<Case> cases, Object ... newElems) {
        ArrayList<Case> newCases = new ArrayList<Case>();
        for (Case c : cases) {
            Object[] objectArray = newElems;
            int n = newElems.length;
            int n2 = 0;
            while (n2 < n) {
                Case newCase;
                Object newElem = objectArray[n2];
                if (c.getSolvedBinaryRelation() != null) {
                    throw new AssertionError((Object)"already have a solvedBinayRelation");
                }
                if (newElem instanceof SolvedBinaryRelation) {
                    SolvedBinaryRelation solvedBinaryRelation = (SolvedBinaryRelation)newElem;
                    newCase = new Case(solvedBinaryRelation, c.getSupportingTerms(), this.mXnf);
                    newCases.add(newCase);
                } else if (newElem instanceof SupportingTerm) {
                    HashSet<SupportingTerm> newSupportingTerms = new HashSet<SupportingTerm>(c.getSupportingTerms());
                    newSupportingTerms.add((SupportingTerm)newElem);
                    newCase = new Case(c.getSolvedBinaryRelation(), newSupportingTerms, this.mXnf);
                    newCases.add(newCase);
                } else {
                    throw new UnsupportedOperationException();
                }
                ++n2;
            }
        }
        return newCases;
    }

    public MultiCaseSolvedBinaryRelation buildResult() {
        this.mConstructionFinished = true;
        EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> additionalIntricateOperations = this.mAdditionalIntricateOperations.isEmpty() ? EnumSet.noneOf(MultiCaseSolvedBinaryRelation.IntricateOperation.class) : EnumSet.copyOf(this.mAdditionalIntricateOperations);
        return new MultiCaseSolvedBinaryRelation(this.mSubject, this.mCases, this.mAdditionalAuxiliaryVariables, additionalIntricateOperations, this.mXnf);
    }
}

