/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProviderOnDemand;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolutionBuilder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiCaseSolvedBinaryRelation
implements ITermProviderOnDemand {
    private final Term mSubject;
    private final List<Case> mCases;
    private final Set<TermVariable> mAdditionalAuxiliaryVariables;
    private final EnumSet<IntricateOperation> mAdditionalIntricateOperations;
    private final Xnf mXnf;

    public MultiCaseSolvedBinaryRelation(Term subject, List<Case> cases, Set<TermVariable> additionalAuxiliaryVariables, EnumSet<IntricateOperation> additionalIntricateOperations, Xnf xnf) {
        this.mSubject = subject;
        this.mCases = cases;
        this.mAdditionalAuxiliaryVariables = additionalAuxiliaryVariables;
        this.mAdditionalIntricateOperations = additionalIntricateOperations;
        this.mXnf = xnf;
    }

    public Term getSubject() {
        return this.mSubject;
    }

    public List<Case> getCases() {
        return this.mCases;
    }

    public Set<IntricateOperation> getIntricateOperations() {
        return Stream.concat(this.mAdditionalIntricateOperations.stream(), this.mCases.stream().flatMap(Case::streamOfIntricateOperations)).collect(Collectors.toSet());
    }

    public Set<TermVariable> getAuxiliaryVariables() {
        return Stream.concat(this.mAdditionalAuxiliaryVariables.stream(), this.mCases.stream().flatMap(x -> x.getAuxiliaryVariables().stream())).collect(Collectors.toSet());
    }

    public Xnf getXnf() {
        return this.mXnf;
    }

    @Override
    public Term asTerm(Script script) {
        int quantifier;
        Term body;
        Collection params = this.mCases.stream().map(x -> x.asTerm(script)).collect(Collectors.toList());
        switch (this.mXnf) {
            case CNF: {
                body = SmtUtils.and(script, params);
                quantifier = 1;
                break;
            }
            case DNF: {
                body = SmtUtils.or(script, params);
                quantifier = 0;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown case " + (Object)((Object)this.mXnf)));
            }
        }
        Set<TermVariable> vars = this.getAuxiliaryVariables();
        Term result = SmtUtils.quantifier(script, quantifier, vars, body);
        return result;
    }

    public MultiCaseSolutionBuilder constructCopy() {
        MultiCaseSolutionBuilder result = new MultiCaseSolutionBuilder(this.getSubject(), this.getXnf());
        result.splitCases(this.getCases());
        for (TermVariable termVariable : this.mAdditionalAuxiliaryVariables) {
            result.reportAdditionalAuxiliaryVariable(termVariable);
        }
        for (IntricateOperation intricateOperation : this.mAdditionalIntricateOperations) {
            result.reportAdditionalIntricateOperation(intricateOperation);
        }
        return result;
    }

    public boolean isSubjectOnlyOnRhs() {
        for (Case c : this.getCases()) {
            boolean isSubjectOnlyOnRhs = this.isSubjectOnlyOnRhs(this.mSubject, c);
            if (isSubjectOnlyOnRhs) continue;
            return false;
        }
        return true;
    }

    private boolean isSubjectOnlyOnRhs(Term subject, Case c) {
        if (c.getSolvedBinaryRelation() != null && !c.getSolvedBinaryRelation().getLeftHandSide().equals(subject)) {
            throw new AssertionError((Object)"illegal subject");
        }
        for (SupportingTerm st : c.getSupportingTerms()) {
            boolean containsSubject = SmtUtils.isSubterm(st.asTerm(), subject);
            if (!containsSubject) continue;
            return false;
        }
        return true;
    }

    public static enum IntricateOperation {
        DIV_BY_NONCONSTANT,
        DIV_BY_INTEGER_CONSTANT,
        MUL_BY_INTEGER_CONSTANT;

    }

    public static enum Xnf {
        CNF,
        DNF;


        public static Xnf fromQuantifier(int quantifier) {
            if (quantifier == 0) {
                return DNF;
            }
            if (quantifier == 1) {
                return CNF;
            }
            throw new AssertionError();
        }
    }
}

