/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OctagonRelation {
    private final boolean mNegateVar1;
    private final Term mVar1;
    private final boolean mNegateVar2;
    private final Term mVar2;
    private final RelationSymbol mRelationSymbol;
    private final Rational mConstant;

    public OctagonRelation(boolean negateVar1, Term var1, boolean negateVar2, Term var2, RelationSymbol relationSymbol, Rational constant) {
        this.mNegateVar1 = negateVar1;
        this.mVar1 = var1;
        this.mNegateVar2 = negateVar2;
        this.mVar2 = var2;
        this.mRelationSymbol = relationSymbol;
        this.mConstant = constant;
    }

    public static OctagonRelation from(PolynomialRelation polyRel) {
        Set<Term> variables = polyRel.getPolynomialTerm().getAbstractVariable2Coefficient().keySet();
        for (Term v : variables) {
            if (v instanceof TermVariable || SmtUtils.isConstant(v)) continue;
            return null;
        }
        switch (variables.size()) {
            case 1: {
                return OctagonRelation.from1Var(polyRel);
            }
            case 2: {
                return OctagonRelation.from2Vars(polyRel);
            }
        }
        return null;
    }

    private static OctagonRelation from1Var(PolynomialRelation arWith1Var) {
        OctagonRelation.checkNumberOfVariables(1, arWith1Var.getPolynomialTerm().getAbstractVariable2Coefficient().size());
        Map.Entry<Term, Rational> var2coeff = arWith1Var.getPolynomialTerm().getAbstractVariable2Coefficient().entrySet().iterator().next();
        Term var = var2coeff.getKey();
        Rational absCoeff = var2coeff.getValue().abs();
        boolean negVar = var2coeff.getValue().isNegative();
        Rational constant = arWith1Var.getPolynomialTerm().getConstant().mul(Rational.TWO).div(absCoeff).negate();
        return new OctagonRelation(negVar, var, !negVar, var, arWith1Var.getRelationSymbol(), constant);
    }

    private static OctagonRelation from2Vars(PolynomialRelation arWith2Vars) {
        Map<Term, Rational> var2coeff = arWith2Vars.getPolynomialTerm().getAbstractVariable2Coefficient();
        OctagonRelation.checkNumberOfVariables(2, var2coeff.size());
        Iterator<Map.Entry<Term, Rational>> iter = var2coeff.entrySet().iterator();
        Map.Entry<Term, Rational> var2coeff1 = iter.next();
        Map.Entry<Term, Rational> var2coeff2 = iter.next();
        Rational absCommonCoeff = var2coeff1.getValue().abs();
        if (!absCommonCoeff.equals((Object)var2coeff2.getValue().abs())) {
            return null;
        }
        Rational constant = arWith2Vars.getPolynomialTerm().getConstant().div(absCommonCoeff).negate();
        return new OctagonRelation(var2coeff1.getValue().isNegative(), var2coeff1.getKey(), !var2coeff2.getValue().isNegative(), var2coeff2.getKey(), arWith2Vars.getRelationSymbol(), constant);
    }

    private static void checkNumberOfVariables(int expected, int actual) {
        if (expected != actual) {
            throw new IllegalArgumentException("Expected " + expected + " variable(s), found " + actual);
        }
    }

    public boolean isNegateVar1() {
        return this.mNegateVar1;
    }

    public Term getVar1() {
        return this.mVar1;
    }

    public boolean isNegateVar2() {
        return this.mNegateVar2;
    }

    public Term getVar2() {
        return this.mVar2;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public Rational getConstant() {
        return this.mConstant;
    }

    public String toString() {
        return String.format("(%s%s) - (%s%s) %s %s", new Object[]{Character.valueOf(OctagonRelation.sign(this.mNegateVar1)), this.mVar1, Character.valueOf(OctagonRelation.sign(this.mNegateVar2)), this.mVar2, this.mRelationSymbol, this.mConstant});
    }

    private static char sign(boolean negate) {
        return negate ? (char)'-' : '+';
    }
}

