/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolyPoNe {
    protected final Script mScript;
    private final Set<Term> mPositive = new HashSet<Term>();
    private final Set<Term> mNegative = new HashSet<Term>();
    private final HashRelation<Map<?, Rational>, PolynomialRelation> mPolyRels = new HashRelation();
    private boolean mInconsistent = false;
    private boolean mSimplificationPossible = false;

    PolyPoNe(Script script) {
        this.mScript = script;
    }

    public boolean isInconsistent() {
        return this.mInconsistent;
    }

    void add(Collection<Term> params, boolean negate) {
        for (Term param : params) {
            boolean isInconsistent;
            PolynomialRelation polyPolyRel = PolynomialRelation.convert(this.mScript, param);
            if (polyPolyRel != null) {
                PolynomialRelation addedRel = negate ? polyPolyRel.negate(this.mScript) : polyPolyRel;
                isInconsistent = this.addPolyRel(this.mScript, addedRel, true);
                if (!isInconsistent) continue;
                this.mInconsistent = true;
                return;
            }
            Term addedNonPolyRel = negate ? SmtUtils.not(this.mScript, param) : param;
            isInconsistent = this.addNonPolynomial(addedNonPolyRel);
            if (!isInconsistent) continue;
            this.mInconsistent = true;
            return;
        }
    }

    Term and(List<Term> params) {
        this.add(params, false);
        if (this.mSimplificationPossible) {
            return this.and();
        }
        return SmtUtils.and(this.mScript, params);
    }

    Term or(List<Term> params) {
        this.add(params, true);
        if (this.mSimplificationPossible) {
            return this.or();
        }
        return SmtUtils.or(this.mScript, params);
    }

    protected Check checkPolyRel(Script script, PolynomialRelation newPolyRel, boolean removeExpliedPolyRels) {
        Check res1 = this.compareToExistingRepresentations(newPolyRel, removeExpliedPolyRels);
        if (res1 != null) {
            return res1;
        }
        PolynomialRelation alternativeRepresentation = newPolyRel.mul(this.mScript, Rational.MONE);
        Check res2 = this.compareToExistingRepresentations(alternativeRepresentation, removeExpliedPolyRels);
        if (res2 != null) {
            return res2;
        }
        return Check.MAYBE_USEFUL;
    }

    private Check compareToExistingRepresentations(PolynomialRelation newPolyRel, boolean removeExpliedPolyRels) {
        Set existingPolyRels = this.mPolyRels.getImage(newPolyRel.getPolynomialTerm().getAbstractVariable2Coefficient());
        ArrayList<PolynomialRelation> existingThatExplyNew = new ArrayList<PolynomialRelation>();
        block5: for (PolynomialRelation existingPolyRel : existingPolyRels) {
            AbstractGeneralizedAffineTerm.ComparisonResult comp = AbstractGeneralizedAffineTerm.compareRepresentation(existingPolyRel, newPolyRel);
            if (comp == null) continue;
            switch (comp) {
                case IMPLIES: 
                case EQUIVALENT: {
                    return Check.REDUNDANT;
                }
                case EXPLIES: {
                    if (!removeExpliedPolyRels) continue block5;
                    existingThatExplyNew.add(existingPolyRel);
                    break;
                }
                case INCONSISTENT: {
                    return Check.INCONSISTENT;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)comp)));
                }
            }
        }
        if (removeExpliedPolyRels) {
            for (PolynomialRelation existing : existingThatExplyNew) {
                boolean modified = this.mPolyRels.removePair(existing.getPolynomialTerm().getAbstractVariable2Coefficient(), (Object)existing);
                assert (modified) : "nothing removed";
                this.mSimplificationPossible = true;
            }
        }
        return null;
    }

    protected final boolean addPolyRel(Script script, PolynomialRelation polyRel, boolean removeExpliedPolyRels) {
        if (this.mInconsistent) {
            throw new AssertionError((Object)"must not add if already inconsistent");
        }
        Check check = this.checkPolyRel(script, polyRel, removeExpliedPolyRels);
        if (check == Check.MAYBE_USEFUL) {
            this.mPolyRels.addPair(polyRel.getPolynomialTerm().getAbstractVariable2Coefficient(), (Object)polyRel);
            return false;
        }
        if (check == Check.REDUNDANT) {
            this.mSimplificationPossible = true;
            return false;
        }
        if (check == Check.INCONSISTENT) {
            this.mSimplificationPossible = true;
            return true;
        }
        throw new AssertionError((Object)("unknown value " + (Object)((Object)check)));
    }

    protected final boolean addNonPolynomial(Term nonPolynomial) {
        if (this.mInconsistent) {
            throw new AssertionError((Object)"must not add if already inconsistent");
        }
        Term neg = SmtUtils.unzipNot(nonPolynomial);
        boolean result = neg != null ? this.addNegative(neg) : this.addPositive(nonPolynomial);
        return result;
    }

    protected Check checkNegative(Term term) {
        Check result;
        if (this.mNegative.contains(term)) {
            assert (!this.mPositive.contains(term));
            result = Check.REDUNDANT;
        } else {
            result = this.mPositive.contains(term) ? Check.INCONSISTENT : Check.MAYBE_USEFUL;
        }
        return result;
    }

    private final boolean addNegative(Term term) {
        boolean result;
        Check check = this.checkNegative(term);
        switch (check) {
            case INCONSISTENT: {
                this.mSimplificationPossible = true;
                result = true;
                break;
            }
            case MAYBE_USEFUL: {
                this.mNegative.add(term);
                result = false;
                break;
            }
            case REDUNDANT: {
                this.mSimplificationPossible = true;
                result = false;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + (Object)((Object)check)));
            }
        }
        return result;
    }

    protected Check checkPositive(Term term) {
        Check result;
        if (this.mPositive.contains(term)) {
            assert (!this.mNegative.contains(term));
            result = Check.REDUNDANT;
        } else {
            result = this.mNegative.contains(term) ? Check.INCONSISTENT : Check.MAYBE_USEFUL;
        }
        return result;
    }

    private final boolean addPositive(Term term) {
        boolean result;
        Check check = this.checkPositive(term);
        switch (check) {
            case INCONSISTENT: {
                this.mSimplificationPossible = true;
                result = true;
                break;
            }
            case MAYBE_USEFUL: {
                this.mPositive.add(term);
                result = false;
                break;
            }
            case REDUNDANT: {
                this.mSimplificationPossible = true;
                result = false;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + (Object)((Object)check)));
            }
        }
        return result;
    }

    public final Term and() {
        if (this.mInconsistent) {
            return this.mScript.term("false", new Term[0]);
        }
        ArrayList<Term> params = new ArrayList<Term>();
        for (Map.Entry pair : this.mPolyRels.getSetOfPairs()) {
            params.add(((PolynomialRelation)pair.getValue()).positiveNormalForm(this.mScript));
        }
        for (Term term : this.mPositive) {
            params.add(term);
        }
        for (Term term : this.mNegative) {
            params.add(SmtUtils.not(this.mScript, term));
        }
        return SmtUtils.and(this.mScript, params);
    }

    public final Term or() {
        if (this.mInconsistent) {
            return this.mScript.term("true", new Term[0]);
        }
        ArrayList<Term> params = new ArrayList<Term>();
        for (Map.Entry pair : this.mPolyRels.getSetOfPairs()) {
            params.add(((PolynomialRelation)pair.getValue()).negate(this.mScript).positiveNormalForm(this.mScript));
        }
        for (Term term : this.mPositive) {
            params.add(SmtUtils.not(this.mScript, term));
        }
        for (Term term : this.mNegative) {
            params.add(term);
        }
        return SmtUtils.or(this.mScript, params);
    }

    protected static enum Check {
        REDUNDANT,
        INCONSISTENT,
        MAYBE_USEFUL;

    }
}

