/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolyPoNe;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PolyPoNeWithContext
extends PolyPoNe {
    final PolyPoNe mContext;

    PolyPoNeWithContext(Script script, PolyPoNe context) {
        super(script);
        if (context.isInconsistent()) {
            throw new AssertionError((Object)"must not add inconsistent context");
        }
        this.mContext = context;
    }

    Term and(Term context, List<Term> params) {
        if (SmtUtils.isFalseLiteral(context)) {
            return this.mScript.term("false", new Term[0]);
        }
        return this.and(Arrays.asList(SmtUtils.getConjuncts(context)), params);
    }

    private Term and(Collection<Term> contextConjuncts, List<Term> params) {
        this.addContext(contextConjuncts);
        return super.and(params);
    }

    Term or(Term context, List<Term> params) {
        if (SmtUtils.isFalseLiteral(context)) {
            return this.mScript.term("true", new Term[0]);
        }
        return this.or(Arrays.asList(SmtUtils.getConjuncts(context)), params);
    }

    private Term or(Collection<Term> contextConjuncts, List<Term> params) {
        this.addContext(contextConjuncts);
        return super.or(params);
    }

    private boolean addContext(Collection<Term> contextParams) {
        for (Term param : contextParams) {
            boolean isInconsistent;
            PolynomialRelation polyRel = PolynomialRelation.convert(this.mScript, param);
            if (!(polyRel != null ? (isInconsistent = this.mContext.addPolyRel(this.mScript, polyRel, true)) : (isInconsistent = this.mContext.addNonPolynomial(param)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected PolyPoNe.Check checkPolyRel(Script script, PolynomialRelation newPolyRel, boolean removeExpliedPolyRels) {
        PolyPoNe.Check contextCheck = this.mContext.checkPolyRel(script, newPolyRel, false);
        if (contextCheck != PolyPoNe.Check.MAYBE_USEFUL) {
            return contextCheck;
        }
        return super.checkPolyRel(this.mScript, newPolyRel, true);
    }

    @Override
    protected PolyPoNe.Check checkNegative(Term term) {
        PolyPoNe.Check contextCheck = this.mContext.checkNegative(term);
        if (contextCheck != PolyPoNe.Check.MAYBE_USEFUL) {
            return contextCheck;
        }
        return super.checkNegative(term);
    }

    @Override
    protected PolyPoNe.Check checkPositive(Term term) {
        PolyPoNe.Check contextCheck = this.mContext.checkPositive(term);
        if (contextCheck != PolyPoNe.Check.MAYBE_USEFUL) {
            return contextCheck;
        }
        return super.checkPositive(term);
    }
}

