/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.IBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.ExplicitLhsPolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermOperations;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.logic.INonSolverScript;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class PolynomialRelation
implements IBinaryRelation {
    protected static final String NO_AFFINE_REPRESENTATION_WHERE_DESIRED_VARIABLE_IS_ON_LEFT_HAND_SIDE = "No affine representation where desired variable is on left hand side";
    protected static final boolean TEMPORARY_POLYNOMIAL_TERM_TEST = false;
    protected final RelationSymbol mRelationSymbol;
    protected final TrivialityStatus mTrivialityStatus;
    protected final AbstractGeneralizedAffineTerm<Term> mPolynomialTerm;

    @Deprecated
    public PolynomialRelation(Script script, AbstractGeneralizedAffineTerm<?> term, RelationSymbol relationSymbol) {
        this.mPolynomialTerm = Objects.requireNonNull(PolynomialRelation.checkThenCast(term));
        this.mRelationSymbol = relationSymbol;
        this.mTrivialityStatus = PolynomialRelation.computeTrivialityStatus(this.mPolynomialTerm, this.mRelationSymbol);
    }

    public PolynomialRelation(TransformInequality transformInequality, RelationSymbol relationSymbol, AbstractGeneralizedAffineTerm<?> polyLhs, AbstractGeneralizedAffineTerm<?> polyRhs) {
        RelationSymbol relationSymbolAfterTransformation;
        AbstractGeneralizedAffineTerm<Term> polyTerm;
        block17: {
            AbstractGeneralizedAffineTerm<Term> difference;
            block15: {
                block18: {
                    block16: {
                        if (polyLhs.getSort() != polyRhs.getSort()) {
                            throw new AssertionError((Object)"Inconsistent sorts");
                        }
                        if (!SmtSortUtils.isNumericSort(polyLhs.getSort()) && !SmtSortUtils.isBitvecSort(polyLhs.getSort())) {
                            throw new AssertionError((Object)"Unsupported sorts");
                        }
                        if (relationSymbol.isConvexInequality() && SmtSortUtils.isBitvecSort(polyLhs.getSort())) {
                            throw new AssertionError((Object)"Unsupported inequality/sort combination");
                        }
                        difference = this.sum(PolynomialRelation.checkThenCast(polyLhs), this.mul(PolynomialRelation.checkThenCast(polyRhs), Rational.MONE));
                        if (transformInequality == TransformInequality.NO_TRANFORMATION || !SmtSortUtils.isIntSort(difference.getSort())) break block15;
                        if (transformInequality != TransformInequality.STRICT2NONSTRICT) break block16;
                        switch (relationSymbol) {
                            case EQ: 
                            case DISTINCT: 
                            case LEQ: 
                            case GEQ: 
                            case BVULE: 
                            case BVUGE: 
                            case BVSLE: 
                            case BVSGE: {
                                polyTerm = difference;
                                relationSymbolAfterTransformation = relationSymbol;
                                break block17;
                            }
                            case LESS: {
                                relationSymbolAfterTransformation = RelationSymbol.LEQ;
                                polyTerm = this.sum(difference, this.constructConstant(difference.getSort(), Rational.ONE));
                                break block17;
                            }
                            case GREATER: {
                                relationSymbolAfterTransformation = RelationSymbol.GEQ;
                                polyTerm = this.sum(difference, this.constructConstant(difference.getSort(), Rational.MONE));
                                break block17;
                            }
                            case BVULT: 
                            case BVUGT: 
                            case BVSLT: 
                            case BVSGT: {
                                throw new AssertionError((Object)"STRICT2NONSTRICT for Bitvector not implemented");
                            }
                            default: {
                                throw new AssertionError((Object)"unknown symbol");
                            }
                        }
                    }
                    if (transformInequality != TransformInequality.NONSTRICT2STRICT) break block18;
                    switch (relationSymbol) {
                        case EQ: 
                        case DISTINCT: 
                        case LESS: 
                        case GREATER: 
                        case BVULT: 
                        case BVUGT: 
                        case BVSLT: 
                        case BVSGT: {
                            polyTerm = difference;
                            relationSymbolAfterTransformation = relationSymbol;
                            break block17;
                        }
                        case GEQ: {
                            relationSymbolAfterTransformation = RelationSymbol.GREATER;
                            polyTerm = this.sum(difference, this.constructConstant(difference.getSort(), Rational.ONE));
                            break block17;
                        }
                        case LEQ: {
                            relationSymbolAfterTransformation = RelationSymbol.LESS;
                            polyTerm = this.sum(difference, this.constructConstant(difference.getSort(), Rational.MONE));
                            break block17;
                        }
                        case BVULE: 
                        case BVUGE: 
                        case BVSLE: 
                        case BVSGE: {
                            throw new AssertionError((Object)"NONSTRICT2STRICT for Bitvector not implemented");
                        }
                        default: {
                            throw new AssertionError((Object)"unknown symbol");
                        }
                    }
                }
                throw new AssertionError((Object)"unknown case");
            }
            polyTerm = difference;
            relationSymbolAfterTransformation = relationSymbol;
        }
        this.mPolynomialTerm = polyTerm;
        this.mRelationSymbol = relationSymbolAfterTransformation;
        this.mTrivialityStatus = PolynomialRelation.computeTrivialityStatus(polyTerm, relationSymbolAfterTransformation);
    }

    private AbstractGeneralizedAffineTerm<Term> sum(AbstractGeneralizedAffineTerm<Term> op1, AbstractGeneralizedAffineTerm<Term> op2) {
        AbstractGeneralizedAffineTerm result;
        if (op1.isAffine() && op2.isAffine()) {
            result = AffineTerm.sum(op1, op2);
        } else {
            AbstractGeneralizedAffineTerm<?> polynomialSum = PolynomialTerm.sum(op1, op2);
            result = PolynomialRelation.unsafeCast(polynomialSum);
        }
        return result;
    }

    private AbstractGeneralizedAffineTerm<Term> mul(AbstractGeneralizedAffineTerm<Term> op, Rational r) {
        AbstractGeneralizedAffineTerm result;
        if (op.isAffine()) {
            result = AffineTerm.mul(op, r);
        } else {
            AbstractGeneralizedAffineTerm<?> polynomialSum = PolynomialTerm.mul(op, r);
            result = PolynomialRelation.unsafeCast(polynomialSum);
        }
        return result;
    }

    private AffineTerm constructConstant(Sort s, Rational r) {
        return AffineTerm.constructConstant(s, r);
    }

    private static AbstractGeneralizedAffineTerm<Term> checkThenCast(AbstractGeneralizedAffineTerm<?> poly) {
        if (!(poly instanceof AffineTerm) && !(poly instanceof PolynomialTerm)) {
            throw new IllegalArgumentException("PolynomialRelation accepts only AffineTerm and PolynomialTerm as internal terms.");
        }
        return PolynomialRelation.unsafeCast(poly);
    }

    private static AbstractGeneralizedAffineTerm<Term> unsafeCast(AbstractGeneralizedAffineTerm<?> poly) {
        return poly;
    }

    private static TrivialityStatus computeTrivialityStatus(AbstractGeneralizedAffineTerm<Term> term, RelationSymbol symbol) {
        if (!term.isConstant()) {
            return PolynomialRelation.checkMinMaxValues(term, symbol);
        }
        switch (symbol) {
            case DISTINCT: {
                return PolynomialRelation.computeTrivialityStatus(term, (Integer a) -> a != 0);
            }
            case EQ: {
                return PolynomialRelation.computeTrivialityStatus(term, (Integer a) -> a == 0);
            }
            case LESS: {
                return PolynomialRelation.computeTrivialityStatus(term, (Integer a) -> a < 0);
            }
            case GREATER: {
                return PolynomialRelation.computeTrivialityStatus(term, (Integer a) -> a > 0);
            }
            case GEQ: {
                return PolynomialRelation.computeTrivialityStatus(term, (Integer a) -> a >= 0);
            }
            case LEQ: {
                return PolynomialRelation.computeTrivialityStatus(term, (Integer a) -> a <= 0);
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                return TrivialityStatus.NONTRIVIAL;
            }
        }
        throw new UnsupportedOperationException("unknown relation symbol: " + (Object)((Object)symbol));
    }

    private static TrivialityStatus checkMinMaxValues(AbstractGeneralizedAffineTerm<Term> term, RelationSymbol symbol) {
        TrivialityStatus result;
        Pair<Rational, Rational> minMaxValues = term.computeMinMax();
        if (minMaxValues == null) {
            result = TrivialityStatus.NONTRIVIAL;
        } else {
            Rational minimalValue = (Rational)minMaxValues.getFirst();
            Rational maximalValue = (Rational)minMaxValues.getSecond();
            switch (symbol) {
                case DISTINCT: {
                    if (minimalValue.compareTo(Rational.ZERO) > 0 || maximalValue.compareTo(Rational.ZERO) < 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    result = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case EQ: {
                    if (minimalValue.compareTo(Rational.ZERO) > 0 || maximalValue.compareTo(Rational.ZERO) < 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    result = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case LESS: {
                    if (maximalValue.compareTo(Rational.ZERO) < 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    if (minimalValue.compareTo(Rational.ZERO) >= 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    result = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case GREATER: {
                    if (minimalValue.compareTo(Rational.ZERO) > 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    if (maximalValue.compareTo(Rational.ZERO) <= 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    result = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case GEQ: {
                    if (minimalValue.compareTo(Rational.ZERO) >= 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    if (maximalValue.compareTo(Rational.ZERO) < 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    result = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case LEQ: {
                    if (maximalValue.compareTo(Rational.ZERO) <= 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_TRUE;
                        break;
                    }
                    if (minimalValue.compareTo(Rational.ZERO) > 0) {
                        result = TrivialityStatus.EQUIVALENT_TO_FALSE;
                        break;
                    }
                    result = TrivialityStatus.NONTRIVIAL;
                    break;
                }
                case BVULE: 
                case BVULT: 
                case BVUGE: 
                case BVUGT: 
                case BVSLE: 
                case BVSLT: 
                case BVSGE: 
                case BVSGT: {
                    TrivialityStatus result2 = TrivialityStatus.NONTRIVIAL;
                }
                default: {
                    throw new UnsupportedOperationException("unknown relation symbol: " + (Object)((Object)symbol));
                }
            }
        }
        return result;
    }

    private static TrivialityStatus computeTrivialityStatus(AbstractGeneralizedAffineTerm<Term> term, Predicate<Integer> pred) {
        if (pred.test(term.getConstant().signum())) {
            return TrivialityStatus.EQUIVALENT_TO_TRUE;
        }
        return TrivialityStatus.EQUIVALENT_TO_FALSE;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public AbstractGeneralizedAffineTerm<Term> getPolynomialTerm() {
        return this.mPolynomialTerm;
    }

    public Term positiveNormalForm(Script script) {
        if (this.mTrivialityStatus == TrivialityStatus.EQUIVALENT_TO_TRUE) {
            return script.term("true", new Term[0]);
        }
        if (this.mTrivialityStatus == TrivialityStatus.EQUIVALENT_TO_FALSE) {
            return script.term("false", new Term[0]);
        }
        assert (this.mTrivialityStatus == TrivialityStatus.NONTRIVIAL);
        ArrayList<Term> lhsSummands = new ArrayList<Term>();
        ArrayList<Term> rhsSummands = new ArrayList<Term>();
        for (Map.Entry<Term, Rational> entry : this.mPolynomialTerm.getAbstractVariableAsTerm2Coefficient(script).entrySet()) {
            Term abstractVariableAsTerm = entry.getKey();
            if (SmtSortUtils.isBitvecSort(this.mPolynomialTerm.getSort())) {
                if (PolynomialRelation.isNegativeAsSignedInt(entry.getValue(), this.mPolynomialTerm.getSort())) {
                    Rational newCoefficient = PolynomialTermUtils.bringBitvectorValueInRange(entry.getValue().mul(Rational.MONE), this.mPolynomialTerm.getSort());
                    rhsSummands.add(SmtUtils.mul(script, newCoefficient, abstractVariableAsTerm));
                    continue;
                }
                lhsSummands.add(SmtUtils.mul(script, entry.getValue(), abstractVariableAsTerm));
                continue;
            }
            if (entry.getValue().isNegative()) {
                rhsSummands.add(SmtUtils.mul(script, entry.getValue().abs(), abstractVariableAsTerm));
                continue;
            }
            lhsSummands.add(SmtUtils.mul(script, entry.getValue(), abstractVariableAsTerm));
        }
        if (this.mPolynomialTerm.getConstant() != Rational.ZERO) {
            if (SmtSortUtils.isBitvecSort(this.mPolynomialTerm.getSort())) {
                if (PolynomialRelation.isNegativeAsSignedInt(this.mPolynomialTerm.getConstant(), this.mPolynomialTerm.getSort())) {
                    Rational newConstant = PolynomialTermUtils.bringBitvectorValueInRange(this.mPolynomialTerm.getConstant().mul(Rational.MONE), this.mPolynomialTerm.getSort());
                    rhsSummands.add(SmtUtils.rational2Term(script, newConstant, this.mPolynomialTerm.getSort()));
                } else {
                    lhsSummands.add(SmtUtils.rational2Term(script, this.mPolynomialTerm.getConstant(), this.mPolynomialTerm.getSort()));
                }
            } else if (this.mPolynomialTerm.getConstant().isNegative()) {
                rhsSummands.add(SmtUtils.rational2Term(script, this.mPolynomialTerm.getConstant().abs(), this.mPolynomialTerm.getSort()));
            } else {
                lhsSummands.add(SmtUtils.rational2Term(script, this.mPolynomialTerm.getConstant(), this.mPolynomialTerm.getSort()));
            }
        }
        Term lhsTerm = SmtUtils.sum(script, this.mPolynomialTerm.getSort(), lhsSummands.toArray(new Term[lhsSummands.size()]));
        Term rhsTerm = SmtUtils.sum(script, this.mPolynomialTerm.getSort(), rhsSummands.toArray(new Term[rhsSummands.size()]));
        Term result = BinaryRelation.constructLessNormalForm(script, this.mRelationSymbol, lhsTerm, rhsTerm);
        return result;
    }

    private static boolean isNegativeAsSignedInt(Rational value, Sort sort) {
        if (!value.isIntegral()) {
            throw new AssertionError();
        }
        if (!SmtSortUtils.isBitvecSort(sort)) {
            throw new AssertionError();
        }
        BitvectorConstant bc = BitvectorUtils.constructBitvectorConstant(value.numerator(), sort);
        return bc.toSignedInt().compareTo(BigInteger.ZERO) < 0;
    }

    @Override
    public SolvedBinaryRelation solveForSubject(Script script, Term subject) {
        ExplicitLhsPolynomialRelation elpr = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, subject, this);
        if (elpr == null) {
            return null;
        }
        if (!elpr.getLhsMonomial().isLinear()) {
            return null;
        }
        ExplicitLhsPolynomialRelation solvedElpr = elpr.divInvertible(elpr.getLhsCoefficient());
        if (solvedElpr == null) {
            return null;
        }
        assert (subject.equals(solvedElpr.getLhsMonomial().getSingleVariable()));
        SolvedBinaryRelation result = new SolvedBinaryRelation(subject, solvedElpr.getRhs().toTerm(script), solvedElpr.getRelationSymbol(), new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
        Term relationToTerm = result.asTerm(script);
        assert (script instanceof INonSolverScript || SmtUtils.checkEquivalence(this.positiveNormalForm(script), relationToTerm, script) != Script.LBool.SAT) : "solveForSubject unsound";
        return result;
    }

    public MultiCaseSolvedBinaryRelation solveForSubject(ManagedScript mgdScript, Term subject, MultiCaseSolvedBinaryRelation.Xnf xnf, Set<TermVariable> bannedForDivCapture) {
        return SolveForSubjectUtils.solveForSubject(mgdScript, subject, xnf, this, bannedForDivCapture);
    }

    public boolean isAffine() {
        return this.mPolynomialTerm.isAffine();
    }

    public boolean isVariable(Term var) {
        return this.mPolynomialTerm.isVariable(var);
    }

    public PolynomialRelation negate(Script script) {
        return new PolynomialRelation(script, this.mPolynomialTerm, this.mRelationSymbol.negate());
    }

    public PolynomialRelation mul(Script script, Rational r) {
        RelationSymbol resultRelationSymbol = ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(r, this.mPolynomialTerm.getSort()) ? this.mRelationSymbol.swapParameters() : this.mRelationSymbol;
        return new PolynomialRelation(script, (AbstractGeneralizedAffineTerm)PolynomialTermOperations.mul(this.mPolynomialTerm, r), resultRelationSymbol);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mPolynomialTerm == null ? 0 : this.mPolynomialTerm.hashCode());
        result = 31 * result + (this.mRelationSymbol == null ? 0 : this.mRelationSymbol.ordinal());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolynomialRelation other = (PolynomialRelation)obj;
        if (this.mPolynomialTerm == null ? other.mPolynomialTerm != null : !this.mPolynomialTerm.equals(other.mPolynomialTerm)) {
            return false;
        }
        return this.mRelationSymbol == other.mRelationSymbol;
    }

    public String toString() {
        String zero = SmtSortUtils.isBitvecSort(this.getPolynomialTerm().getSort()) ? BitvectorUtils.constructBitvectorConstant(BigInteger.ZERO, this.getPolynomialTerm().getSort()).toString() : Rational.ZERO.toTerm(this.mPolynomialTerm.getSort()).toString();
        return String.format("(%s, %s, %s)", this.mRelationSymbol.toString(), this.mPolynomialTerm.toString(), zero);
    }

    public static PolynomialRelation convert(Script script, Term term) {
        return PolynomialRelation.convert(script, term, TransformInequality.NO_TRANFORMATION);
    }

    public static PolynomialRelation convert(Script script, Term term, TransformInequality transformInequality) {
        BinaryNumericRelation bnr = BinaryNumericRelation.convert(term);
        if (bnr == null) {
            return null;
        }
        Term lhs = bnr.getLhs();
        Term rhs = bnr.getRhs();
        AbstractGeneralizedAffineTerm<?> polyLhs = PolynomialRelation.transformToPolynomialTerm(script, lhs);
        AbstractGeneralizedAffineTerm<?> polyRhs = PolynomialRelation.transformToPolynomialTerm(script, rhs);
        if (polyLhs.isErrorTerm() || polyRhs.isErrorTerm()) {
            return null;
        }
        if (bnr.getRelationSymbol().isConvexInequality() && SmtSortUtils.isBitvecSort(lhs.getSort())) {
            return null;
        }
        RelationSymbol relationSymbol = bnr.getRelationSymbol();
        return new PolynomialRelation(transformInequality, relationSymbol, polyLhs, polyRhs);
    }

    public static PolynomialRelation of(Script script, RelationSymbol relationSymbol, Term lhs, Term rhs) {
        IPolynomialTerm lhsPoly = PolynomialTermTransformer.convert(script, lhs);
        IPolynomialTerm rhsPoly = PolynomialTermTransformer.convert(script, rhs);
        if (lhsPoly == null || rhsPoly == null) {
            throw new AssertionError((Object)"lhs or rhs not suitable for polynomial");
        }
        return new PolynomialRelation(TransformInequality.NO_TRANFORMATION, relationSymbol, (AbstractGeneralizedAffineTerm)lhsPoly, (AbstractGeneralizedAffineTerm)rhsPoly);
    }

    private static AbstractGeneralizedAffineTerm<?> transformToPolynomialTerm(Script script, Term term) {
        return (AbstractGeneralizedAffineTerm)PolynomialTermTransformer.convert(script, term);
    }

    public static enum TransformInequality {
        NO_TRANFORMATION,
        STRICT2NONSTRICT,
        NONSTRICT2STRICT;


        public static TransformInequality determineTransformationForTir(int quantifier) {
            TransformInequality result;
            if (quantifier == 0) {
                result = STRICT2NONSTRICT;
            } else if (quantifier == 1) {
                result = NONSTRICT2STRICT;
            } else {
                throw new AssertionError((Object)"Unknown quantifier");
            }
            return result;
        }
    }

    public static enum TrivialityStatus {
        EQUIVALENT_TO_TRUE,
        EQUIVALENT_TO_FALSE,
        NONTRIVIAL;

    }
}

