/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SparseMapBuilder;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class PolynomialTerm
extends AbstractGeneralizedAffineTerm<Monomial> {
    public PolynomialTerm(Sort s, Rational constant, Map<Monomial, Rational> map) {
        super(s, constant, map);
        assert (!PolynomialTermUtils.isAffineMap(map)) : "This PolynomialTerm can be represented as an AffineTerm!";
    }

    public PolynomialTerm() {
    }

    @Override
    protected IPolynomialTerm constructNew(Sort sort, Rational constant, Map<Monomial, Rational> variables2coeffcient) {
        return PolynomialTerm.minimalRepresentation(sort, constant, variables2coeffcient);
    }

    @Override
    protected Monomial constructAbstractVar(Term term) {
        return new Monomial(term, Rational.ONE);
    }

    @Override
    public void checkIfTermIsLegalVariable(Term term) {
        if (!(term instanceof TermVariable) && !(term instanceof ApplicationTerm)) {
            throw new IllegalArgumentException("Variable of PolynomialTerm has to be TermVariable or ApplicationTerm");
        }
    }

    public static AbstractGeneralizedAffineTerm<?> mul(IPolynomialTerm polynomialTerm, Rational multiplier) {
        PolynomialTermUtils.GeneralizedConstructor constructor = PolynomialTerm::minimalRepresentation;
        return PolynomialTermUtils.constructMul(x -> ((PolynomialTerm)x).getMonomial2Coefficient(), constructor, polynomialTerm, multiplier);
    }

    private static AbstractGeneralizedAffineTerm<?> minimalRepresentation(Sort sort, Rational coeff, Map<Monomial, Rational> map) {
        if (PolynomialTermUtils.isAffineMap(map)) {
            return new AffineTerm(sort, coeff, PolynomialTermUtils.convertToAffineMap(map));
        }
        return new PolynomialTerm(sort, coeff, map);
    }

    public static IPolynomialTerm mulPolynomials(IPolynomialTerm poly1, IPolynomialTerm poly2) {
        Rational newConstant = PolynomialTermUtils.bringValueInRange(poly1.getConstant().mul(poly2.getConstant()), poly1.getSort());
        Map<Monomial, Rational> polyMap = PolynomialTerm.calculateProductMap(poly1, poly2);
        return PolynomialTerm.minimalRepresentation(poly1.getSort(), newConstant, polyMap);
    }

    private static Map<Monomial, Rational> calculateProductMap(IPolynomialTerm poly1, IPolynomialTerm poly2) {
        SparseMapBuilder mapBuilder = new SparseMapBuilder();
        PolynomialTerm.monoTimesMonoIntoMap((SparseMapBuilder<Monomial, Rational>)mapBuilder, poly1, poly2);
        PolynomialTerm.monomialsTimesConstantIntoMap((SparseMapBuilder<Monomial, Rational>)mapBuilder, poly1, poly2);
        PolynomialTerm.monomialsTimesConstantIntoMap((SparseMapBuilder<Monomial, Rational>)mapBuilder, poly2, poly1);
        return mapBuilder.getBuiltMap();
    }

    private static SparseMapBuilder<Monomial, Rational> monoTimesMonoIntoMap(SparseMapBuilder<Monomial, Rational> builder, IPolynomialTerm poly1, IPolynomialTerm poly2) {
        for (Map.Entry<Monomial, Rational> summand1 : poly1.getMonomial2Coefficient().entrySet()) {
            for (Map.Entry<Monomial, Rational> summand2 : poly2.getMonomial2Coefficient().entrySet()) {
                Monomial mono = new Monomial(summand1.getKey(), summand2.getKey());
                Rational coeff = (Rational)builder.get((Object)mono);
                Rational tempCoeff = coeff == null ? summand1.getValue().mul(summand2.getValue()) : summand1.getValue().mul(summand2.getValue()).add(coeff);
                Rational newCoeff = PolynomialTermUtils.bringValueInRange(tempCoeff, poly1.getSort());
                if (newCoeff.equals((Object)Rational.ZERO)) continue;
                builder.put((Object)mono, (Object)newCoeff);
            }
        }
        return builder;
    }

    private static SparseMapBuilder<Monomial, Rational> monomialsTimesConstantIntoMap(SparseMapBuilder<Monomial, Rational> builder, IPolynomialTerm poly1, IPolynomialTerm poly2) {
        for (Map.Entry<Monomial, Rational> summand : poly1.getMonomial2Coefficient().entrySet()) {
            Rational coeff = (Rational)builder.get((Object)summand.getKey());
            Rational tempCoeff = coeff == null ? summand.getValue().mul(poly2.getConstant()) : summand.getValue().mul(poly2.getConstant()).add(coeff);
            Rational newCoeff = PolynomialTermUtils.bringValueInRange(tempCoeff, poly1.getSort());
            if (newCoeff.equals((Object)Rational.ZERO)) continue;
            builder.put((Object)summand.getKey(), (Object)newCoeff);
        }
        return builder;
    }

    public static AbstractGeneralizedAffineTerm<?> sum(IPolynomialTerm ... summands) {
        PolynomialTermUtils.GeneralizedConstructor constructor = PolynomialTerm::minimalRepresentation;
        return PolynomialTermUtils.constructSum(PolynomialTerm::termWrapper, constructor, summands);
    }

    private static Map<Monomial, Rational> termWrapper(IPolynomialTerm poly) {
        if (poly.isAffine()) {
            SparseMapBuilder mapBuilder = new SparseMapBuilder();
            for (Map.Entry<Term, Rational> var2coeff : ((AffineTerm)poly).getVariable2Coefficient().entrySet()) {
                mapBuilder.put((Object)new Monomial(var2coeff.getKey(), Rational.ONE), (Object)var2coeff.getValue());
            }
            return mapBuilder.getBuiltMap();
        }
        return ((PolynomialTerm)poly).getMonomial2Coefficient();
    }

    public static IPolynomialTerm divide(IPolynomialTerm[] polynomialTerms, Script script) {
        if (!PolynomialTerm.divisionPossible(polynomialTerms)) {
            return PolynomialTermUtils.simplifyImpossibleDivision("/", polynomialTerms, script);
        }
        return PolynomialTerm.constructDivision(polynomialTerms, script);
    }

    public static IPolynomialTerm div(IPolynomialTerm[] polynomialArgs, Script script) {
        if (!PolynomialTerm.divisionPossible(polynomialArgs)) {
            return PolynomialTermUtils.simplifyImpossibleDivision("div", polynomialArgs, script);
        }
        IPolynomialTerm result = PolynomialTerm.constructDivision(polynomialArgs, script);
        if (result.isIntegral()) {
            return result;
        }
        return PolynomialTermUtils.simplifyImpossibleDivision("div", polynomialArgs, script);
    }

    public static boolean divisionPossible(IPolynomialTerm[] polynomialTerms) {
        int i = 1;
        while (i < polynomialTerms.length) {
            if (!polynomialTerms[i].isConstant() || polynomialTerms[i].isZero()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static IPolynomialTerm constructDivision(IPolynomialTerm[] polynomialTerms, Script script) {
        AbstractGeneralizedAffineTerm<?> poly = PolynomialTerm.mul(polynomialTerms[0], polynomialTerms[1].getConstant().inverse());
        int i = 2;
        while (i < polynomialTerms.length) {
            poly = PolynomialTerm.mul(poly, polynomialTerms[i].getConstant().inverse());
            ++i;
        }
        return poly;
    }

    @Override
    protected Term abstractVariableToTerm(Script script, Monomial abstractVariable) {
        return abstractVariable.toTerm(script);
    }

    @Override
    protected Collection<Term> getFreeVars(Monomial var) {
        return var.getVariable2Exponent().entrySet().stream().flatMap(x -> Arrays.stream(((Term)x.getKey()).getFreeVars())).collect(Collectors.toSet());
    }

    @Override
    protected Term abstractVariableTimesCoeffToTerm(Script script, Monomial abstractVariable, Rational coeff) {
        return abstractVariable.timesCoefficientToTerm(script, coeff);
    }

    public static PolynomialTerm applyModuloToAllCoefficients(PolynomialTerm polynomialTerm, BigInteger divident) {
        PolynomialTermUtils.GeneralizedConstructor constructor = PolynomialTerm::new;
        return PolynomialTermUtils.applyModuloToAllCoefficients(polynomialTerm, divident, constructor);
    }

    @Override
    public Map<Monomial, Rational> getMonomial2Coefficient() {
        return this.mAbstractVariable2Coefficient;
    }

    @Override
    public boolean isVariable(Term var) {
        for (Monomial mono : this.getMonomial2Coefficient().keySet()) {
            if (!mono.isVariable(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAffine() {
        return false;
    }

    @Override
    public String toString() {
        String result;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Monomial, Rational> entry : this.getMonomial2Coefficient().entrySet()) {
            sb.append(entry.getValue().isNegative() ? " - " : " + ");
            sb.append(entry.getValue().abs() + "*" + entry.getKey());
        }
        if (!this.mConstant.equals((Object)Rational.ZERO) || sb.length() == 0) {
            if (this.mConstant.isNegative() || sb.length() > 0) {
                sb.append(this.mConstant.isNegative() ? " - " : " + ");
            }
            sb.append(this.mConstant.abs());
        }
        if ((result = sb.toString()).charAt(0) == ' ') {
            result = result.substring(1);
        }
        return result;
    }

    @Override
    protected Pair<Rational, Rational> computeMinMax() {
        return null;
    }

    @Override
    public AbstractGeneralizedAffineTerm<?> removeAndNegate(Monomial monomialOfSubject) {
        boolean allMonomialsAreLinear = true;
        HashMap<Monomial, Rational> newAbstractVariable2Coefficient = new HashMap<Monomial, Rational>();
        for (Map.Entry entry : this.mAbstractVariable2Coefficient.entrySet()) {
            if (((Monomial)entry.getKey()).equals(monomialOfSubject)) continue;
            Rational newCoefficient = PolynomialTermUtils.bringValueInRange(((Rational)entry.getValue()).negate(), this.getSort());
            newAbstractVariable2Coefficient.put((Monomial)entry.getKey(), newCoefficient);
            if (((Monomial)entry.getKey()).isLinear()) continue;
            allMonomialsAreLinear = false;
        }
        Rational newConstant = PolynomialTermUtils.bringValueInRange(this.getConstant().negate(), this.getSort());
        if (allMonomialsAreLinear) {
            Map<Term, Rational> map = newAbstractVariable2Coefficient.entrySet().stream().collect(Collectors.toMap(x -> ((Monomial)x.getKey()).getSingleVariable(), x -> (Rational)x.getValue()));
            return new AffineTerm(this.getSort(), newConstant, map);
        }
        return new PolynomialTerm(this.getSort(), newConstant, (Map<Monomial, Rational>)newAbstractVariable2Coefficient);
    }

    @Override
    public PolynomialTerm divInvertible(Rational divisor) {
        HashMap<Monomial, Rational> newAbstractVariable2Coefficient = new HashMap<Monomial, Rational>();
        for (Map.Entry entry : this.mAbstractVariable2Coefficient.entrySet()) {
            Rational newCoefficient = PolynomialTermUtils.divInvertible(this.getSort(), (Rational)entry.getValue(), divisor);
            if (newCoefficient == null) {
                return null;
            }
            newAbstractVariable2Coefficient.put((Monomial)entry.getKey(), newCoefficient);
        }
        Rational newConstant = PolynomialTermUtils.divInvertible(this.getSort(), this.getConstant(), divisor);
        if (newConstant == null) {
            return null;
        }
        return new PolynomialTerm(this.getSort(), newConstant, (Map<Monomial, Rational>)newAbstractVariable2Coefficient);
    }
}

