/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;

public class PolynomialTermOperations {
    private PolynomialTermOperations() {
    }

    public static IPolynomialTerm mul(IPolynomialTerm poly, Rational rat) {
        if (poly instanceof AffineTerm) {
            return AffineTerm.mul(poly, rat);
        }
        if (poly instanceof PolynomialTerm) {
            return PolynomialTerm.mul(poly, rat);
        }
        throw new AssertionError((Object)"unknown kind of IPolynomialTerm");
    }

    public static IPolynomialTerm sum(IPolynomialTerm ... summands) {
        if (Arrays.stream(summands).allMatch(x -> x instanceof AffineTerm)) {
            return AffineTerm.sum(summands);
        }
        return PolynomialTerm.sum(summands);
    }

    public static IPolynomialTerm convert(Script script, Term term) {
        return (IPolynomialTerm)new PolynomialTermTransformer(script).transform(term);
    }
}

