/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.function.Predicate;

public class PolynomialTermTransformer
extends TermTransformer {
    private final Script mScript;
    private final Predicate<Term> mIsPolynomialVariable = x -> x instanceof TermVariable || x instanceof ApplicationTerm;

    public PolynomialTermTransformer(Script script) {
        this.mScript = script;
    }

    protected void convert(Term term) {
        if (!PolynomialTermTransformer.hasSupportedSort(term)) {
            this.inputIsNotPolynomial();
            return;
        }
        Rational valueOfLiteral = SmtUtils.tryToConvertToLiteral(term);
        if (valueOfLiteral != null) {
            AffineTerm result = AffineTerm.constructConstant(term.getSort(), valueOfLiteral);
            this.setResult(result);
            return;
        }
        if (PolynomialTermTransformer.isPolynomialFunction(term)) {
            super.convert(term);
            return;
        }
        if (this.mIsPolynomialVariable.test(term)) {
            AffineTerm result = AffineTerm.constructVariable(term);
            this.setResult(result);
            return;
        }
        this.inputIsNotPolynomial();
    }

    private void inputIsNotPolynomial() {
        this.setResult(new PolynomialTerm());
    }

    private static boolean hasSupportedSort(Term term) {
        return SmtSortUtils.isNumericSort(term.getSort()) || SmtSortUtils.isBitvecSort(term.getSort());
    }

    private static boolean isPolynomialFunction(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            return PolynomialTermTransformer.isPolynomialFunctionSymbol(appTerm.getFunction().getName());
        }
        return false;
    }

    private static boolean isPolynomialFunctionSymbol(String funName) {
        return funName.equals("+") || funName.equals("-") || funName.equals("*") || funName.equals("/") || funName.equals("bvadd") || funName.equals("bvsub") || funName.equals("bvmul") || funName.equals("div");
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        assert (PolynomialTermTransformer.isPolynomialFunctionSymbol(appTerm.getFunction().getName())) : "We only descended for polynomial functions";
        IPolynomialTerm[] polynomialArgs = PolynomialTermTransformer.castAndCheckForNonPolynomialArguments(newArgs);
        if (polynomialArgs == null) {
            this.inputIsNotPolynomial();
            return;
        }
        String funName = appTerm.getFunction().getName();
        IPolynomialTerm result = this.convertArgumentsToFunction(polynomialArgs, funName);
        this.castAndSetResult(result);
    }

    private IPolynomialTerm convertArgumentsToFunction(IPolynomialTerm[] polynomialArgs, String funName) {
        switch (funName) {
            case "*": {
                return PolynomialTermTransformer.multiply(polynomialArgs);
            }
            case "bvmul": {
                return PolynomialTermTransformer.multiply(polynomialArgs);
            }
            case "+": {
                return PolynomialTermTransformer.add(polynomialArgs);
            }
            case "bvadd": {
                return PolynomialTermTransformer.add(polynomialArgs);
            }
            case "-": {
                if (polynomialArgs.length == 1) {
                    return PolynomialTermTransformer.negate(polynomialArgs[0]);
                }
                return PolynomialTermTransformer.subtract(polynomialArgs);
            }
            case "bvsub": {
                if (polynomialArgs.length == 1) {
                    return PolynomialTermTransformer.negate(polynomialArgs[0]);
                }
                return PolynomialTermTransformer.subtract(polynomialArgs);
            }
            case "/": {
                return this.divide(polynomialArgs);
            }
            case "div": {
                return this.div(polynomialArgs);
            }
        }
        throw new UnsupportedOperationException("unsupported symbol " + funName);
    }

    private void castAndSetResult(IPolynomialTerm poly) {
        if (poly instanceof PolynomialTerm) {
            this.setResult((PolynomialTerm)poly);
            return;
        }
        if (poly instanceof AffineTerm) {
            this.setResult((AffineTerm)poly);
            return;
        }
        throw new UnsupportedOperationException("This IPolynomialTerm is instance of no known class.");
    }

    private static IPolynomialTerm multiply(IPolynomialTerm[] polynomialArgs) {
        IPolynomialTerm poly = PolynomialTermTransformer.multiplyTwoPolynomials(polynomialArgs[0], polynomialArgs[1]);
        int i = 2;
        while (i < polynomialArgs.length) {
            poly = PolynomialTermTransformer.multiplyTwoPolynomials(poly, polynomialArgs[i]);
            ++i;
        }
        return poly;
    }

    private static IPolynomialTerm multiplyTwoPolynomials(IPolynomialTerm poly1, IPolynomialTerm poly2) {
        if (PolynomialTermTransformer.productWillBePolynomial(poly1, poly2)) {
            return PolynomialTerm.mulPolynomials(poly1, poly2);
        }
        return AffineTerm.mulAffineTerms(poly1, poly2);
    }

    private static boolean productWillBePolynomial(IPolynomialTerm poly1, IPolynomialTerm poly2) {
        return !poly1.isAffine() || !poly2.isAffine() || !poly1.isConstant() && !poly2.isConstant();
    }

    private static IPolynomialTerm add(IPolynomialTerm[] polynomialArgs) {
        if (PolynomialTermTransformer.someTermIsPolynomial(polynomialArgs)) {
            return PolynomialTerm.sum(polynomialArgs);
        }
        return AffineTerm.sum(polynomialArgs);
    }

    private static boolean someTermIsPolynomial(IPolynomialTerm[] polynomialTerms) {
        IPolynomialTerm[] iPolynomialTermArray = polynomialTerms;
        int n = polynomialTerms.length;
        int n2 = 0;
        while (n2 < n) {
            IPolynomialTerm polynomialTerm = iPolynomialTermArray[n2];
            if (!polynomialTerm.isAffine()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IPolynomialTerm negate(IPolynomialTerm polynomialTerm) {
        if (polynomialTerm.isAffine()) {
            return AffineTerm.mul(polynomialTerm, Rational.MONE);
        }
        return PolynomialTerm.mul(polynomialTerm, Rational.MONE);
    }

    private static IPolynomialTerm subtract(IPolynomialTerm[] input) {
        assert (input.length > 1);
        IPolynomialTerm[] argumentsForSum = new IPolynomialTerm[input.length];
        argumentsForSum[0] = input[0];
        int i = 1;
        while (i < argumentsForSum.length) {
            argumentsForSum[i] = PolynomialTermTransformer.negate(input[i]);
            ++i;
        }
        return PolynomialTermTransformer.add(argumentsForSum);
    }

    private IPolynomialTerm divide(IPolynomialTerm[] polynomialArgs) {
        assert (SmtSortUtils.isRealSort(polynomialArgs[0].getSort()));
        if (polynomialArgs[0].isAffine()) {
            return AffineTerm.divide(polynomialArgs, this.mScript);
        }
        return PolynomialTerm.divide(polynomialArgs, this.mScript);
    }

    private IPolynomialTerm div(IPolynomialTerm[] polynomialArgs) {
        assert (SmtSortUtils.isIntSort(polynomialArgs[0].getSort()));
        if (polynomialArgs[0].isAffine()) {
            return AffineTerm.div(polynomialArgs, this.mScript);
        }
        return PolynomialTerm.div(polynomialArgs, this.mScript);
    }

    private static IPolynomialTerm[] castAndCheckForNonPolynomialArguments(Term[] terms) {
        IPolynomialTerm[] polynomialTerms = new IPolynomialTerm[terms.length];
        int i = 0;
        while (i < polynomialTerms.length) {
            if (terms[i] instanceof IPolynomialTerm) {
                polynomialTerms[i] = (IPolynomialTerm)terms[i];
                if (polynomialTerms[i].isErrorTerm()) {
                    return null;
                }
            } else {
                throw new AssertionError();
            }
            ++i;
        }
        return polynomialTerms;
    }

    public static IPolynomialTerm convert(Script script, Term term) {
        IPolynomialTerm result;
        if (!PolynomialTermTransformer.hasSupportedSort(term)) {
            result = null;
        } else {
            result = (IPolynomialTerm)new PolynomialTermTransformer(script).transform(term);
            if (result.isErrorTerm()) {
                throw new UnsupportedOperationException("Unknown conversion problem: " + term);
            }
        }
        return result;
    }
}

