/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.ArithmeticUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SparseMapBuilder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PolynomialTermUtils {
    private PolynomialTermUtils() {
    }

    public static Rational bringBitvectorValueInRange(Rational bv, Sort sort) {
        assert (SmtSortUtils.isBitvecSort(sort));
        int bitsize = SmtSortUtils.getBitvectorLength(sort);
        BigInteger bvBigInt = bv.numerator();
        BigInteger numberOfValues = BigInteger.valueOf(2L).pow(bitsize);
        BigInteger resultBigInt = ArithmeticUtils.euclideanMod((BigInteger)bvBigInt, (BigInteger)numberOfValues);
        return Rational.valueOf((BigInteger)resultBigInt, (BigInteger)BigInteger.ONE);
    }

    public static Rational bringValueInRange(Rational rat, Sort sort) {
        if (SmtSortUtils.isBitvecSort(sort)) {
            return PolynomialTermUtils.bringBitvectorValueInRange(rat, sort);
        }
        return rat;
    }

    public static IPolynomialTerm simplifyImpossibleDivision(String functionSymbol, IPolynomialTerm[] polynomialArgs, Script script) {
        Term simplifiedVariable;
        Rational coefficient;
        if (functionSymbol.equals("/")) {
            coefficient = PolynomialTermUtils.constructCoefficient(polynomialArgs);
            simplifiedVariable = PolynomialTermUtils.constructFutureVariableReal(polynomialArgs, script);
        } else if (functionSymbol.equals("div")) {
            coefficient = Rational.ONE;
            simplifiedVariable = PolynomialTermUtils.constructFutureVariableInt(polynomialArgs, script);
        } else {
            throw new UnsupportedOperationException("Given type of division unknown.");
        }
        AffineTerm wrappedVariable = AffineTerm.constructVariable(simplifiedVariable);
        return AffineTerm.mul(wrappedVariable, coefficient);
    }

    private static Rational constructCoefficient(IPolynomialTerm[] polynomialArgs) {
        Rational coeff = Rational.ONE;
        int i = polynomialArgs.length - 1;
        while (i >= 0) {
            if (!polynomialArgs[i].isConstant() || polynomialArgs[i].getConstant().equals((Object)Rational.ZERO)) break;
            coeff = coeff.mul(polynomialArgs[i].getConstant());
            --i;
        }
        return coeff.inverse();
    }

    private static Term constructFutureVariableReal(IPolynomialTerm[] polynomialArgs, Script script) {
        IPolynomialTerm numerator = PolynomialTermUtils.constructNumeratorReal(polynomialArgs, script);
        int endOfVariableIncluded = PolynomialTermUtils.calculateEndOfVariable(polynomialArgs);
        int beginOfVariableIncluded = PolynomialTermUtils.calculateBeginOfVariable(polynomialArgs);
        Term[] variable = PolynomialTermUtils.subArrayToTermSimplifyIntermediate(polynomialArgs, beginOfVariableIncluded - 1, endOfVariableIncluded, script);
        variable[0] = numerator.toTerm(script);
        return script.term("/", variable);
    }

    private static int calculateEndOfVariable(IPolynomialTerm[] polynomialArgs) {
        int endOfVariableIncluded = polynomialArgs.length - 1;
        boolean endOfVariableFound = false;
        while (!endOfVariableFound) {
            endOfVariableFound = !polynomialArgs[endOfVariableIncluded].isConstant() || polynomialArgs[endOfVariableIncluded].getConstant().equals((Object)Rational.ZERO);
            --endOfVariableIncluded;
        }
        return ++endOfVariableIncluded;
    }

    private static int calculateBeginOfVariable(IPolynomialTerm[] polynomialArgs) {
        int beginOfVariableIncluded = 1;
        boolean beginOfVariableFound = false;
        while (!beginOfVariableFound) {
            beginOfVariableFound = !polynomialArgs[beginOfVariableIncluded].isConstant() || polynomialArgs[beginOfVariableIncluded].getConstant().equals((Object)Rational.ZERO);
            ++beginOfVariableIncluded;
        }
        return --beginOfVariableIncluded;
    }

    private static Term[] subArrayToTermSimplifyIntermediate(IPolynomialTerm[] polynomialArgs, int beginOfVariableIncluded, int endOfSubArrayIncl, Script script) {
        ArrayList<Term> subList = new ArrayList<Term>();
        IPolynomialTerm simplifiedTerm = null;
        int i = beginOfVariableIncluded;
        while (i <= endOfSubArrayIncl) {
            if (!polynomialArgs[i].isConstant() || polynomialArgs[i].getConstant().equals((Object)Rational.ZERO)) {
                if (simplifiedTerm != null) {
                    subList.add(simplifiedTerm.toTerm(script));
                    simplifiedTerm = null;
                }
                subList.add(polynomialArgs[i].toTerm(script));
            } else if (polynomialArgs[i].isConstant() && polynomialArgs[i].getConstant().equals((Object)Rational.ONE)) {
                if (i == beginOfVariableIncluded) {
                    subList.add(polynomialArgs[i].toTerm(script));
                }
            } else {
                simplifiedTerm = simplifiedTerm == null ? polynomialArgs[i] : AffineTerm.mul(simplifiedTerm, polynomialArgs[i].getConstant());
            }
            ++i;
        }
        Term[] subArray = new Term[subList.size()];
        subList.toArray(subArray);
        return subArray;
    }

    private static IPolynomialTerm constructNumeratorReal(IPolynomialTerm[] divArray, Script script) {
        ArrayList<IPolynomialTerm> denominatorConstants = new ArrayList<IPolynomialTerm>();
        boolean continueDivision = true;
        int i = 1;
        while (continueDivision && i < divArray.length) {
            boolean bl = continueDivision = divArray[i].isConstant() && !divArray[i].isZero();
            if (continueDivision) {
                denominatorConstants.add(divArray[i]);
            }
            ++i;
        }
        if (denominatorConstants.isEmpty()) {
            return divArray[0];
        }
        return PolynomialTermUtils.divideIPolynomialTermByConstants(divArray[0], denominatorConstants, script);
    }

    private static IPolynomialTerm divideIPolynomialTermByConstants(IPolynomialTerm numerator, ArrayList<IPolynomialTerm> denomConstants, Script script) {
        IPolynomialTerm[] allConstants = new IPolynomialTerm[denomConstants.size() + 1];
        allConstants[0] = numerator;
        Iterator<IPolynomialTerm> iter = denomConstants.iterator();
        int i = 1;
        while (iter.hasNext()) {
            allConstants[i] = iter.next();
            ++i;
        }
        if (numerator.isAffine()) {
            return AffineTerm.divide(allConstants, script);
        }
        return PolynomialTerm.divide(allConstants, script);
    }

    private static Term constructFutureVariableInt(IPolynomialTerm[] polynomialArgs, Script script) {
        BiFunction<IPolynomialTerm[], Script, IPolynomialTerm> divider = polynomialArgs[0].isAffine() ? AffineTerm::divide : PolynomialTerm::divide;
        IPolynomialTerm newNumerator = polynomialArgs[0];
        IPolynomialTerm[] binaryDivision = new IPolynomialTerm[2];
        binaryDivision[0] = polynomialArgs[0];
        int endOfSimplificationExcluded = 1;
        boolean stillSimplifiable = true;
        while (stillSimplifiable && endOfSimplificationExcluded < polynomialArgs.length) {
            if (polynomialArgs[endOfSimplificationExcluded].isConstant() && !polynomialArgs[endOfSimplificationExcluded].isZero()) {
                binaryDivision[1] = polynomialArgs[endOfSimplificationExcluded];
                newNumerator = divider.apply(binaryDivision, script);
                if (newNumerator.isIntegral()) {
                    binaryDivision[0] = newNumerator;
                } else {
                    newNumerator = binaryDivision[0];
                    stillSimplifiable = false;
                    --endOfSimplificationExcluded;
                }
            } else {
                stillSimplifiable = false;
                --endOfSimplificationExcluded;
            }
            ++endOfSimplificationExcluded;
        }
        Term[] variable = PolynomialTermUtils.subArrayToTermSkipOnes(polynomialArgs, endOfSimplificationExcluded - 1, polynomialArgs.length - 1, script);
        variable[0] = newNumerator.toTerm(script);
        return script.term("div", variable);
    }

    private static Term[] subArrayToTermSkipOnes(IPolynomialTerm[] polynomialArgs, int beginOfVariableIncluded, int endOfSubArrayIncl, Script script) {
        ArrayList<Term> subList = new ArrayList<Term>();
        int i = beginOfVariableIncluded;
        while (i <= endOfSubArrayIncl) {
            if (polynomialArgs[i].isConstant() && polynomialArgs[i].getConstant().equals((Object)Rational.ONE)) {
                if (i == beginOfVariableIncluded) {
                    subList.add(polynomialArgs[i].toTerm(script));
                }
            } else {
                subList.add(polynomialArgs[i].toTerm(script));
            }
            ++i;
        }
        Term[] subArray = new Term[subList.size()];
        subList.toArray(subArray);
        return subArray;
    }

    public static <T extends AbstractGeneralizedAffineTerm<MNL>, MNL> T applyModuloToAllCoefficients(T agAffineTerm, BigInteger divident, GeneralizedConstructor<MNL, T> constructor) {
        assert (SmtSortUtils.isIntSort(agAffineTerm.getSort()));
        SparseMapBuilder mapBuilder = new SparseMapBuilder();
        for (Map.Entry<MNL, Rational> entry : agAffineTerm.getAbstractVariable2Coefficient().entrySet()) {
            Rational newCoeff = SmtUtils.toRational(ArithmeticUtils.euclideanMod((BigInteger)SmtUtils.toInt(entry.getValue()), (BigInteger)divident));
            if (newCoeff == Rational.ZERO) continue;
            mapBuilder.put(entry.getKey(), (Object)newCoeff);
        }
        Rational constant = SmtUtils.toRational(ArithmeticUtils.euclideanMod((BigInteger)SmtUtils.toInt(agAffineTerm.getConstant()), (BigInteger)divident));
        return (T)((AbstractGeneralizedAffineTerm)constructor.apply(agAffineTerm.getSort(), constant, mapBuilder.getBuiltMap()));
    }

    public static boolean isAffineMap(Map<Monomial, Rational> map) {
        for (Map.Entry<Monomial, Rational> entry : map.entrySet()) {
            if (entry.getKey().isLinear()) continue;
            return false;
        }
        return true;
    }

    public static Map<Term, Rational> convertToAffineMap(Map<Monomial, Rational> map) {
        SparseMapBuilder mapBuilder = new SparseMapBuilder();
        for (Map.Entry<Monomial, Rational> entry : map.entrySet()) {
            Map<Term, Rational> monomialMap = entry.getKey().getVariable2Exponent();
            assert (monomialMap.size() == 1) : "Cannot convert to AffineMap.";
            Term term = monomialMap.keySet().iterator().next();
            mapBuilder.put((Object)term, (Object)entry.getValue());
        }
        return mapBuilder.getBuiltMap();
    }

    static <T extends AbstractGeneralizedAffineTerm<?>, MNL> T constructSum(Function<IPolynomialTerm, Map<MNL, Rational>> term2map, GeneralizedConstructor<MNL, T> constructor, IPolynomialTerm ... summands) {
        Sort sort = summands[0].getSort();
        HashMap<MNL, Rational> variable2Coefficient = new HashMap<MNL, Rational>();
        Rational newConstant = Rational.ZERO;
        IPolynomialTerm[] iPolynomialTermArray = summands;
        int n = summands.length;
        int n2 = 0;
        while (n2 < n) {
            IPolynomialTerm term = iPolynomialTermArray[n2];
            for (Map.Entry<MNL, Rational> summand : term2map.apply(term).entrySet()) {
                Rational coeff = (Rational)variable2Coefficient.get(summand.getKey());
                if (coeff == null) {
                    variable2Coefficient.put(summand.getKey(), summand.getValue());
                    continue;
                }
                Rational newCoeff = PolynomialTermUtils.bringValueInRange(coeff.add(summand.getValue()), sort);
                if (newCoeff.equals((Object)Rational.ZERO)) {
                    variable2Coefficient.remove(summand.getKey());
                    continue;
                }
                variable2Coefficient.put(summand.getKey(), newCoeff);
            }
            newConstant = PolynomialTermUtils.bringValueInRange(newConstant.add(term.getConstant()), sort);
            ++n2;
        }
        return (T)((AbstractGeneralizedAffineTerm)constructor.apply(sort, newConstant, variable2Coefficient));
    }

    static <T extends IPolynomialTerm, MNL> T constructMul(Function<IPolynomialTerm, Map<MNL, Rational>> term2map, GeneralizedConstructor<MNL, T> constructor, IPolynomialTerm term, Rational multiplier) {
        Map<Object, Object> variable2Coefficient;
        Rational constant;
        Sort sort;
        if (multiplier.equals((Object)Rational.ZERO)) {
            sort = term.getSort();
            constant = Rational.ZERO;
            variable2Coefficient = Collections.emptyMap();
        } else if (multiplier.equals((Object)Rational.ONE)) {
            sort = term.getSort();
            constant = term.getConstant();
            variable2Coefficient = term2map.apply(term);
        } else {
            variable2Coefficient = new HashMap();
            sort = term.getSort();
            constant = PolynomialTermUtils.bringValueInRange(term.getConstant().mul(multiplier), sort);
            for (Map.Entry<MNL, Rational> summand : term2map.apply(term).entrySet()) {
                Rational newCoefficient = PolynomialTermUtils.bringValueInRange(summand.getValue().mul(multiplier), sort);
                variable2Coefficient.put(summand.getKey(), newCoefficient);
            }
        }
        return (T)((IPolynomialTerm)constructor.apply(sort, constant, variable2Coefficient));
    }

    public static Rational divInvertible(Sort sort, Rational divident, Rational divisor) {
        Object result;
        if (divisor.equals((Object)Rational.ZERO)) {
            result = null;
        } else if (SmtSortUtils.isRealSort(sort)) {
            Rational quot;
            result = quot = divident.div(divisor);
        } else if (SmtSortUtils.isIntSort(sort)) {
            Rational quot = divident.div(divisor);
            result = quot.isIntegral() ? quot : null;
        } else if (SmtSortUtils.isBitvecSort(sort)) {
            result = divisor.equals((Object)Rational.ONE) || SmtUtils.isBvMinusOneButNotOne(divisor, sort) ? PolynomialTermUtils.bringBitvectorValueInRange(divident.mul(divisor), sort) : null;
        } else {
            throw new AssertionError((Object)"unsupported sort");
        }
        return result;
    }

    @FunctionalInterface
    public static interface GeneralizedConstructor<V, T> {
        public T apply(Sort var1, Rational var2, Map<V, Rational> var3);
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, R, S> {
        public S apply(T var1, U var2, R var3);
    }
}

