/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.ExplicitLhsPolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolutionBuilder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermOperations;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.INonSolverScript;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SolveForSubjectUtils {
    static MultiCaseSolvedBinaryRelation solveForSubject(ManagedScript mgdScript, Term subject, MultiCaseSolvedBinaryRelation.Xnf xnf, PolynomialRelation polyRel, Set<TermVariable> bannedForDivCapture) throws AssertionError {
        MultiCaseSolvedBinaryRelation res = SmtSortUtils.isNumericSort(subject.getSort()) ? SolveForSubjectUtils.findTreatableDivModSubterm(mgdScript, subject, polyRel.getPolynomialTerm(), null, xnf, polyRel.positiveNormalForm(mgdScript.getScript()), bannedForDivCapture) : null;
        if (res == null) {
            res = SolveForSubjectUtils.solveForSubjectWithoutTreatableDivMod(mgdScript.getScript(), subject, polyRel, xnf, bannedForDivCapture);
        }
        if (res == null) {
            return null;
        }
        assert (res.isSubjectOnlyOnRhs()) : "subject not only LHS";
        assert (mgdScript instanceof INonSolverScript || SmtUtils.checkEquivalence(polyRel.positiveNormalForm(mgdScript.getScript()), res.asTerm(mgdScript.getScript()), mgdScript.getScript()) != Script.LBool.SAT) : "solveForSubject unsound";
        return res;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static MultiCaseSolvedBinaryRelation solveForSubjectWithoutTreatableDivMod(Script script, Term subject, PolynomialRelation polyRel, MultiCaseSolvedBinaryRelation.Xnf xnf, Set<TermVariable> bannedForDivCapture) throws AssertionError {
        Term intLiteralDivConstraint;
        MultiCaseSolvedBinaryRelation.IntricateOperation additionalIo;
        ExplicitLhsPolynomialRelation solvedElpr;
        ExplicitLhsPolynomialRelation elpr;
        block13: {
            elpr = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, subject, polyRel);
            if (elpr == null) {
                return null;
            }
            solvedElpr = elpr.divInvertible(elpr.getLhsCoefficient());
            if (solvedElpr == null) {
                if (SmtSortUtils.isRealSort(elpr.getLhsMonomial().getSort())) {
                    throw new AssertionError();
                }
                if (SmtSortUtils.isIntSort(elpr.getLhsMonomial().getSort())) {
                    Pair<ExplicitLhsPolynomialRelation, Term> tmp = elpr.divideByIntegerCoefficient(script, bannedForDivCapture);
                    if (tmp == null) {
                        return null;
                    }
                    solvedElpr = (ExplicitLhsPolynomialRelation)tmp.getFirst();
                    additionalIo = MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT;
                    intLiteralDivConstraint = (Term)tmp.getSecond();
                    break block13;
                } else {
                    if (SmtSortUtils.isBitvecSort(elpr.getLhsMonomial().getSort())) {
                        return null;
                    }
                    throw new AssertionError((Object)"unsupported sort");
                }
            }
            additionalIo = null;
            intLiteralDivConstraint = null;
        }
        if (solvedElpr.getLhsMonomial().isLinear()) {
            void var12_15;
            assert (solvedElpr.getLhsMonomial().getSingleVariable().equals(subject));
            MultiCaseSolutionBuilder mcsb = new MultiCaseSolutionBuilder(subject, xnf);
            ArrayList<Case> cases = new ArrayList<Case>();
            SolvedBinaryRelation sbr = additionalIo == null ? new SolvedBinaryRelation(solvedElpr.getLhsMonomial().getSingleVariable(), solvedElpr.getRhs().toTerm(script), solvedElpr.getRelationSymbol(), new MultiCaseSolvedBinaryRelation.IntricateOperation[0]) : new SolvedBinaryRelation(solvedElpr.getLhsMonomial().getSingleVariable(), solvedElpr.getRhs().toTerm(script), solvedElpr.getRelationSymbol(), additionalIo);
            if (SolveForSubjectUtils.isDerIntegerDivisionSupportingTermRequired(xnf, subject.getSort(), solvedElpr.getRelationSymbol()) && intLiteralDivConstraint != null) {
                SupportingTerm divisibilityConstraint = SolveForSubjectUtils.constructDerIntegerDivisionSupportingTerm(script, intLiteralDivConstraint);
                Set<SupportingTerm> set = Collections.singleton(divisibilityConstraint);
            } else {
                Set set = Collections.emptySet();
            }
            cases.add(new Case(sbr, (Set<SupportingTerm>)var12_15, xnf));
            if (SolveForSubjectUtils.isAntiDerIntegerDivisionCaseRequired(xnf, subject.getSort(), solvedElpr.getRelationSymbol()) && intLiteralDivConstraint != null) {
                HashSet<SupportingTerm> suppTerms = new HashSet<SupportingTerm>();
                solvedElpr.getRelationSymbol().equals((Object)RelationSymbol.DISTINCT);
                Term divisibilityConstraintTerm = intLiteralDivConstraint;
                SupportingTerm divisibilityConstraint = new SupportingTerm(divisibilityConstraintTerm, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT, Collections.emptySet());
                suppTerms.add(divisibilityConstraint);
                Case result = new Case(null, suppTerms, xnf);
                cases.add(result);
            }
            mcsb.splitCases(cases);
            return mcsb.buildResult();
        }
        if (SmtSortUtils.isBitvecSort(elpr.getLhsMonomial().getSort()) && !solvedElpr.getLhsMonomial().isLinear()) {
            return null;
        }
        return solvedElpr.divByMonomial(script, subject, xnf, bannedForDivCapture, intLiteralDivConstraint, additionalIo);
    }

    private static MultiCaseSolvedBinaryRelation tryToHandleDivModSubterm(ManagedScript mgdScript, Term subject, MultiCaseSolvedBinaryRelation.Xnf xnf, ApplicationTerm divModSubterm, Term pnf, Set<TermVariable> bannedForDivCapture) {
        Term divisor = SmtUtils.mul(mgdScript.getScript(), "*", Arrays.copyOfRange(divModSubterm.getParameters(), 1, divModSubterm.getParameters().length));
        assert (divisor instanceof ConstantTerm) : "not constant";
        Sort termSort = subject.getSort();
        int recVarName = divModSubterm.toString().length();
        TermVariable auxDiv = mgdScript.variable(SmtUtils.removeSmtQuoteCharacters("aux_div_" + subject + "_" + recVarName), termSort);
        TermVariable auxMod = mgdScript.variable(SmtUtils.removeSmtQuoteCharacters("aux_mod_" + subject + "_" + recVarName), termSort);
        if (Arrays.stream(pnf.getFreeVars()).anyMatch(x -> x.getName().equals(auxDiv.getName()))) {
            throw new AssertionError((Object)("Possible infinite loop detected " + auxDiv + " already exists"));
        }
        if (Arrays.stream(pnf.getFreeVars()).anyMatch(x -> x.getName().equals(auxMod.getName()))) {
            throw new AssertionError((Object)("Possible infinite loop detected " + auxMod + " already exists"));
        }
        Term multiplication = SmtUtils.mul(mgdScript.getScript(), termSort, new Term[]{divisor, auxDiv});
        Term sum = SmtUtils.sum(mgdScript.getScript(), termSort, new Term[]{auxMod, multiplication});
        Term subtermSumComparison = BinaryRelation.toTerm(mgdScript.getScript(), SolveForSubjectUtils.negateForCnf(RelationSymbol.EQ, xnf), divModSubterm.getParameters()[0], sum);
        HashSet<TermVariable> bannedForDivCaptureWithAuxiliary = new HashSet<TermVariable>(bannedForDivCapture);
        bannedForDivCaptureWithAuxiliary.add(auxDiv);
        bannedForDivCaptureWithAuxiliary.add(auxMod);
        MultiCaseSolvedBinaryRelation solvedComparison = PolynomialRelation.convert(mgdScript.getScript(), subtermSumComparison).solveForSubject(mgdScript, subject, xnf, bannedForDivCaptureWithAuxiliary);
        if (solvedComparison == null) {
            return null;
        }
        MultiCaseSolutionBuilder mcsb = new MultiCaseSolutionBuilder(subject, xnf);
        LinkedHashSet<TermVariable> setAuxVars = new LinkedHashSet<TermVariable>();
        setAuxVars.add(auxMod);
        HashMap<Object, Object> substitutionMapping = new HashMap<Object, Object>();
        if (SmtUtils.isIntMod((Term)divModSubterm)) {
            substitutionMapping.put(divModSubterm, auxMod);
            mcsb.reportAdditionalAuxiliaryVariable(auxDiv);
        } else if (SmtUtils.isIntDiv((Term)divModSubterm)) {
            setAuxVars.add(auxDiv);
            substitutionMapping.put(divModSubterm, auxDiv);
        } else {
            throw new AssertionError((Object)"input must be div or mod");
        }
        ArrayList<Case> resultCases = new ArrayList<Case>();
        for (Case case_ : solvedComparison.getCases()) {
            boolean containsSubject;
            if (case_.getSolvedBinaryRelation() != null) {
                substitutionMapping.put(subject, case_.getSolvedBinaryRelation().getRightHandSide());
            }
            Term auxModEqualsTerm = Substitution.apply(mgdScript, substitutionMapping, pnf);
            if (case_.getSolvedBinaryRelation() == null && (containsSubject = SmtUtils.isSubterm(auxModEqualsTerm, subject))) {
                return null;
            }
            SupportingTerm auxEquals = new SupportingTerm(auxModEqualsTerm, MultiCaseSolvedBinaryRelation.IntricateOperation.MUL_BY_INTEGER_CONSTANT, new HashSet<TermVariable>(setAuxVars));
            HashSet<SupportingTerm> resultSupportingTerms = new HashSet<SupportingTerm>(case_.getSupportingTerms());
            resultSupportingTerms.add(auxEquals);
            Case resultCase = new Case(case_.getSolvedBinaryRelation(), resultSupportingTerms, xnf);
            resultCases.add(resultCase);
        }
        mcsb.splitCases(resultCases);
        for (TermVariable termVariable : solvedComparison.getAuxiliaryVariables()) {
            mcsb.reportAdditionalAuxiliaryVariable(termVariable);
        }
        for (MultiCaseSolvedBinaryRelation.IntricateOperation intricateOperation : solvedComparison.getIntricateOperations()) {
            mcsb.reportAdditionalIntricateOperation(intricateOperation);
        }
        Term term = BinaryRelation.toTerm(mgdScript.getScript(), SolveForSubjectUtils.negateForCnf(RelationSymbol.LEQ, xnf), Rational.ZERO.toTerm(termSort), (Term)auxMod);
        SupportingTerm auxModGreaterZero = new SupportingTerm(term, MultiCaseSolvedBinaryRelation.IntricateOperation.MUL_BY_INTEGER_CONSTANT, setAuxVars);
        Term auxModLessCoefTerm = BinaryRelation.toTerm(mgdScript.getScript(), SolveForSubjectUtils.negateForCnf(RelationSymbol.LESS, xnf), (Term)auxMod, SmtUtils.abs(mgdScript.getScript(), divisor));
        SupportingTerm auxModLessCoef = new SupportingTerm(auxModLessCoefTerm, MultiCaseSolvedBinaryRelation.IntricateOperation.MUL_BY_INTEGER_CONSTANT, setAuxVars);
        mcsb.addAtoms(auxModLessCoef, auxModGreaterZero);
        MultiCaseSolvedBinaryRelation result = mcsb.buildResult();
        assert (result.isSubjectOnlyOnRhs()) : "subject not only LHS";
        assert (mgdScript instanceof INonSolverScript || SmtUtils.checkEquivalence(pnf, result.asTerm(mgdScript.getScript()), mgdScript.getScript()) != Script.LBool.SAT) : "solveForSubject unsound";
        return result;
    }

    @Deprecated
    private static Term constructRhsIntegerQuotient(Script script, RelationSymbol relSymb, Term rhs, boolean divisorIsPositive, Term divisor) {
        Term result;
        switch (relSymb) {
            case LESS: {
                if (divisorIsPositive) {
                    result = SolveForSubjectUtils.constructRhsIntegerQuotientHelper(script, rhs, Rational.ONE, divisor);
                    break;
                }
                result = SolveForSubjectUtils.constructRhsIntegerQuotientHelper(script, rhs, Rational.MONE, divisor);
                break;
            }
            case GREATER: {
                result = SmtUtils.division(script, rhs.getSort(), SolveForSubjectUtils.prepend(rhs, divisor));
                break;
            }
            case LEQ: {
                result = SmtUtils.division(script, rhs.getSort(), SolveForSubjectUtils.prepend(rhs, divisor));
                break;
            }
            case GEQ: {
                if (divisorIsPositive) {
                    result = SolveForSubjectUtils.constructRhsIntegerQuotientHelper(script, rhs, Rational.ONE, divisor);
                    break;
                }
                result = SolveForSubjectUtils.constructRhsIntegerQuotientHelper(script, rhs, Rational.MONE, divisor);
                break;
            }
            case EQ: {
                result = SmtUtils.division(script, rhs.getSort(), SolveForSubjectUtils.prepend(rhs, divisor));
                break;
            }
            case DISTINCT: {
                result = SmtUtils.division(script, rhs.getSort(), SolveForSubjectUtils.prepend(rhs, divisor));
                break;
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)("bitvector relation with integer not possible: " + (Object)((Object)relSymb)));
            }
            default: {
                throw new AssertionError((Object)("unknown relation symbol: " + (Object)((Object)relSymb)));
            }
        }
        return result;
    }

    public static IPolynomialTerm constructRhsIntegerQuotient(Script script, RelationSymbol relSymb, IPolynomialTerm rhs, boolean divisorIsPositive, Term divisor, Set<TermVariable> bannedForDivCapture) {
        IPolynomialTerm afterDiv;
        Rational postDivisionOffset;
        Rational preDivisionOffset;
        switch (relSymb) {
            case LESS: {
                if (divisorIsPositive) {
                    preDivisionOffset = Rational.MONE;
                    postDivisionOffset = Rational.ONE;
                    break;
                }
                preDivisionOffset = Rational.MONE;
                postDivisionOffset = Rational.MONE;
                break;
            }
            case GREATER: {
                preDivisionOffset = Rational.ZERO;
                postDivisionOffset = Rational.ZERO;
                break;
            }
            case LEQ: {
                preDivisionOffset = Rational.ZERO;
                postDivisionOffset = Rational.ZERO;
                break;
            }
            case GEQ: {
                if (divisorIsPositive) {
                    preDivisionOffset = Rational.MONE;
                    postDivisionOffset = Rational.ONE;
                    break;
                }
                preDivisionOffset = Rational.MONE;
                postDivisionOffset = Rational.MONE;
                break;
            }
            case EQ: {
                preDivisionOffset = Rational.ZERO;
                postDivisionOffset = Rational.ZERO;
                break;
            }
            case DISTINCT: {
                preDivisionOffset = Rational.ZERO;
                postDivisionOffset = Rational.ZERO;
                break;
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new AssertionError((Object)("bitvector relation with integer not possible: " + (Object)((Object)relSymb)));
            }
            default: {
                throw new AssertionError((Object)("unknown relation symbol: " + (Object)((Object)relSymb)));
            }
        }
        IPolynomialTerm beforeDiv = preDivisionOffset.equals((Object)Rational.ZERO) ? rhs : ((AbstractGeneralizedAffineTerm)rhs).add(preDivisionOffset);
        Rational divisorAsRational = SmtUtils.tryToConvertToLiteral(divisor);
        if (divisorAsRational == null) {
            afterDiv = Arrays.stream(beforeDiv.toTerm(script).getFreeVars()).anyMatch(bannedForDivCapture::contains) ? null : PolynomialTermOperations.convert(script, SmtUtils.div(script, beforeDiv.toTerm(script), divisor));
        } else {
            if (!divisorAsRational.isIntegral()) {
                throw new AssertionError((Object)"expected int");
            }
            if (divisorAsRational.isNegative() == divisorIsPositive) {
                throw new AssertionError((Object)"inconsistent information on sign");
            }
            BigInteger divisorAsInt = divisorAsRational.numerator();
            afterDiv = ((AbstractGeneralizedAffineTerm)beforeDiv).div(script, divisorAsInt, bannedForDivCapture);
        }
        if (afterDiv == null) {
            return null;
        }
        IPolynomialTerm result = postDivisionOffset.equals((Object)Rational.ZERO) ? afterDiv : ((AbstractGeneralizedAffineTerm)afterDiv).add(postDivisionOffset);
        return result;
    }

    @Deprecated
    private static Term constructRhsIntegerQuotientHelper(Script script, Term divident, Rational postDivisionOffset, Term divisor) {
        Term preDivisionOffset = SmtUtils.rational2Term(script, Rational.MONE, divident.getSort());
        Term divArgument = SmtUtils.sum(script, divident.getSort(), divident, preDivisionOffset);
        Term simplifiedDivArgument = ((IPolynomialTerm)new PolynomialTermTransformer(script).transform(divArgument)).toTerm(script);
        Term[] result = SolveForSubjectUtils.prepend(simplifiedDivArgument, divisor);
        Term quotient = SmtUtils.division(script, divident.getSort(), result);
        return SmtUtils.sum(script, divident.getSort(), quotient, SmtUtils.rational2Term(script, postDivisionOffset, divident.getSort()));
    }

    static Term[] prepend(Term head, Term ... tail) {
        ArrayList<Term> resultAsList = new ArrayList<Term>(tail.length + 1);
        resultAsList.add(head);
        resultAsList.addAll(Arrays.asList(tail));
        Term[] resultArray = resultAsList.toArray(new Term[resultAsList.size()]);
        return resultArray;
    }

    public static boolean tailIsConstant(List<Term> parameters) {
        assert (parameters.size() > 1);
        Iterator<Term> it = parameters.iterator();
        it.next();
        while (it.hasNext()) {
            if (it.next() instanceof ConstantTerm) continue;
            return false;
        }
        return true;
    }

    static RelationSymbol negateForCnf(RelationSymbol symb, MultiCaseSolvedBinaryRelation.Xnf xnf) {
        if (xnf == MultiCaseSolvedBinaryRelation.Xnf.CNF) {
            return symb.negate();
        }
        return symb;
    }

    static boolean isDerIntegerDivisionSupportingTermRequired(MultiCaseSolvedBinaryRelation.Xnf xnf, Sort sort, RelationSymbol relSymb) {
        return SmtSortUtils.isIntSort(sort) && (relSymb == RelationSymbol.EQ && xnf == MultiCaseSolvedBinaryRelation.Xnf.DNF || relSymb == RelationSymbol.DISTINCT && xnf == MultiCaseSolvedBinaryRelation.Xnf.CNF);
    }

    static boolean isAntiDerIntegerDivisionCaseRequired(MultiCaseSolvedBinaryRelation.Xnf xnf, Sort sort, RelationSymbol relSymb) {
        return SmtSortUtils.isIntSort(sort) && (relSymb == RelationSymbol.DISTINCT && xnf == MultiCaseSolvedBinaryRelation.Xnf.DNF || relSymb == RelationSymbol.EQ && xnf == MultiCaseSolvedBinaryRelation.Xnf.CNF);
    }

    static SupportingTerm constructDerIntegerDivisionSupportingTerm(Script script, Term intLiteralDivConstraint) {
        SupportingTerm result = new SupportingTerm(intLiteralDivConstraint, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT, Collections.emptySet());
        return result;
    }

    private static MultiCaseSolvedBinaryRelation findTreatableDivModSubterm(ManagedScript mgdScript, Term subject, IPolynomialTerm divident, ApplicationTerm parentDivModTerm, MultiCaseSolvedBinaryRelation.Xnf xnf, Term relationInPnf, Set<TermVariable> bannedForDivCapture) {
        for (Monomial m : divident.getMonomial2Coefficient().keySet()) {
            for (Term abstractVariable : m.getVariable2Exponent().keySet()) {
                Object suiteableDivModParent;
                IPolynomialTerm innerDivident;
                MultiCaseSolvedBinaryRelation rec;
                if (!SmtUtils.isIntDiv(abstractVariable) && !SmtUtils.isIntMod(abstractVariable)) continue;
                ApplicationTerm appTerm = (ApplicationTerm)abstractVariable;
                boolean dividentContainsSubject = SmtUtils.isSubterm(appTerm.getParameters()[0], subject);
                boolean tailIsConstant = SolveForSubjectUtils.tailIsConstant(Arrays.asList(appTerm.getParameters()));
                if (!dividentContainsSubject || (rec = SolveForSubjectUtils.findTreatableDivModSubterm(mgdScript, subject, innerDivident = (IPolynomialTerm)new PolynomialTermTransformer(mgdScript.getScript()).transform(appTerm.getParameters()[0]), suiteableDivModParent = tailIsConstant ? appTerm : null, xnf, relationInPnf, bannedForDivCapture)) == null) continue;
                return rec;
            }
        }
        if (parentDivModTerm == null) {
            return null;
        }
        return SolveForSubjectUtils.tryToHandleDivModSubterm(mgdScript, subject, xnf, parentDivModTerm, relationInPnf, bannedForDivCapture);
    }

    public static boolean isVariableDivCaptured(SolvedBinaryRelation sbr, Set<TermVariable> termVariables) {
        if (sbr.getIntricateOperation().contains((Object)MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT)) {
            Term term = sbr.getRightHandSide();
            return SolveForSubjectUtils.someGivenTermVariableOccursInTerm(term, termVariables);
        }
        return false;
    }

    @Deprecated
    private static boolean someGivenTermVariableOccursInTerm(Term term, Set<TermVariable> termVariables) {
        Set<Term> divSubterms = SmtUtils.extractApplicationTerms("div", term, false);
        return divSubterms.stream().anyMatch(x -> Arrays.stream(x.getFreeVars()).anyMatch(termVariables::contains));
    }

    public static boolean isVariableDivCaptured(MultiCaseSolvedBinaryRelation mcsbr, Set<TermVariable> termVariables) {
        if (mcsbr.getIntricateOperations().contains((Object)MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT)) {
            for (Case c : mcsbr.getCases()) {
                if (c.getSolvedBinaryRelation() != null && SolveForSubjectUtils.someGivenTermVariableOccursInTerm(c.getSolvedBinaryRelation().getRightHandSide(), termVariables)) {
                    return true;
                }
                for (SupportingTerm st : c.getSupportingTerms()) {
                    if (st.getIntricateOperation() != MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT) continue;
                    if (!Arrays.stream(st.asTerm().getFreeVars()).anyMatch(termVariables::contains)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

