/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractAssumption;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedList;

public class VariableNotZeroAssumption
extends AbstractAssumption {
    private final LinkedList<Term> mVariables;

    public VariableNotZeroAssumption(Script script, Term variable) {
        super(script, variable.getSort(), VariableNotZeroAssumption::notEqualZero);
        this.mVariables = new LinkedList();
        this.mVariables.add(variable);
    }

    public VariableNotZeroAssumption(Script script, Sort sort, VariableNotZeroAssumption ... assumptions) {
        super(script, sort, VariableNotZeroAssumption::notEqualZero);
        assert (assumptions.length > 1) : "This constructor only makes sense for 2 or more assumptions";
        this.mVariables = assumptions[0].getVariables();
        int i = 1;
        while (i < assumptions.length) {
            this.mVariables.addAll(assumptions[i].getVariables());
            ++i;
        }
    }

    public static Term notEqualZero(Script script, Sort sort, Term term) {
        if (SmtSortUtils.isRealSort(sort)) {
            return VariableNotZeroAssumption.notEqualZeroReal(script, term);
        }
        if (SmtSortUtils.isIntSort(sort)) {
            return VariableNotZeroAssumption.notEqualZeroInt(script, term);
        }
        throw new UnsupportedOperationException("This method is not implemented for this sort.");
    }

    private static Term notEqualZeroReal(Script script, Term term) {
        return SmtUtils.not(script, SmtUtils.binaryEquality(script, term, SmtUtils.rational2Term(script, Rational.ZERO, SmtSortUtils.getRealSort(script))));
    }

    private static Term notEqualZeroInt(Script script, Term term) {
        return SmtUtils.not(script, SmtUtils.binaryEquality(script, term, SmtUtils.constructIntValue(script, BigInteger.ZERO)));
    }

    @Override
    public boolean hasContractedForm() {
        return true;
    }

    @Override
    protected Term constructContractedLhs() {
        Term[] factorArray = new Term[this.mVariables.size()];
        int i = 0;
        Iterator iterator = this.mVariables.iterator();
        while (iterator.hasNext()) {
            Term term;
            factorArray[i] = term = (Term)iterator.next();
            ++i;
        }
        Term product = SmtUtils.mul(this.mScript, this.mSort, factorArray);
        return (Term)this.mRhsAppender.apply(this.mScript, this.mSort, product);
    }

    @Override
    protected Term[] getConjunctsForExplicitForm() {
        Term[] conjuncts = new Term[this.mVariables.size()];
        int i = 0;
        for (Term term : this.mVariables) {
            conjuncts[i] = (Term)this.mRhsAppender.apply(this.mScript, this.mSort, term);
            ++i;
        }
        return conjuncts;
    }

    private LinkedList<Term> getVariables() {
        return this.mVariables;
    }
}

