/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisTermTransducer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CondisDepthCodeGenerator
extends CondisTermTransducer<CondisDepthCode> {
    private CondisDepthCodeGenerator() {
    }

    @Override
    protected CondisDepthCode transduceAtom(Term term) {
        return new CondisDepthCode(Adk.ATOM, Arrays.asList(1));
    }

    @Override
    protected CondisDepthCode transduceConjunction(ApplicationTerm originalTerm, List<CondisDepthCode> transducedArguments) {
        List<Integer> tmp = new ArrayList<Integer>();
        for (CondisDepthCode input : transducedArguments) {
            if (input.getAdk() == Adk.ATOM || input.getAdk() == Adk.DISJUNCTION) {
                tmp = CondisDepthCodeGenerator.computeMaximum(tmp, input.getDualJuncts());
                continue;
            }
            throw new AssertionError((Object)"expected conjunction-disjunction alternation");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(transducedArguments.size());
        result.addAll(tmp);
        return new CondisDepthCode(Adk.CONJUNCTION, result);
    }

    @Override
    protected CondisDepthCode transduceDisjunction(ApplicationTerm originalTerm, List<CondisDepthCode> transducedArguments) {
        List<Integer> tmp = new ArrayList<Integer>();
        for (CondisDepthCode input : transducedArguments) {
            if (input.getAdk() == Adk.ATOM || input.getAdk() == Adk.CONJUNCTION) {
                tmp = CondisDepthCodeGenerator.computeMaximum(tmp, input.getDualJuncts());
                continue;
            }
            throw new AssertionError((Object)"expected conjunction-disjunction alternation");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(transducedArguments.size());
        result.addAll(tmp);
        return new CondisDepthCode(Adk.DISJUNCTION, result);
    }

    private static List<Integer> computeMaximum(List<Integer> list1, List<Integer> list2) {
        List<Integer> smaller;
        List<Integer> larger;
        if (list1.size() >= list2.size()) {
            larger = list1;
            smaller = list2;
        } else {
            larger = list2;
            smaller = list1;
        }
        int i = 0;
        while (i < smaller.size()) {
            larger.set(i, Integer.max(larger.get(i), smaller.get(i)));
            ++i;
        }
        return larger;
    }

    public static enum Adk {
        ATOM,
        DISJUNCTION,
        CONJUNCTION;


        public String getSymbol() {
            String result;
            switch (this) {
                case ATOM: {
                    result = this.toString();
                    break;
                }
                case CONJUNCTION: {
                    result = "\u2227";
                    break;
                }
                case DISJUNCTION: {
                    result = "\u2228";
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)this)));
                }
            }
            return result;
        }
    }

    public static class CondisDepthCode {
        private final Adk mAdk;
        private final List<Integer> mDualJuncts;

        public CondisDepthCode(Adk adk, List<Integer> dualJuncts) {
            this.mAdk = adk;
            this.mDualJuncts = dualJuncts;
        }

        public Adk getAdk() {
            return this.mAdk;
        }

        public List<Integer> getDualJuncts() {
            return this.mDualJuncts;
        }

        public String toString() {
            return String.valueOf(this.mAdk.getSymbol()) + "-" + this.mDualJuncts.stream().map(Object::toString).collect(Collectors.joining("-"));
        }

        public static CondisDepthCode of(Term term) {
            return (CondisDepthCode)new CondisDepthCodeGenerator().transduce(term);
        }
    }
}

