/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectionPartition {
    Map<NonTheorySymbol<?>, Set<Term>> mNonTheorySymbols2Terms = new HashMap();
    UnionFind<NonTheorySymbol<?>> mUnionFind = new UnionFind();
    List<Term> mTermWithoutNonTheorySymbols = new ArrayList<Term>();

    public ConnectionPartition(Collection<Term> parameters) {
        for (Term term : parameters) {
            this.addTerm(term);
        }
    }

    private void addTerm(Term term) {
        Set<NonTheorySymbol<?>> symbols = NonTheorySymbol.extractNonTheorySymbols(term);
        if (symbols.isEmpty()) {
            this.mTermWithoutNonTheorySymbols.add(term);
            return;
        }
        NonTheorySymbol<?> last = null;
        for (NonTheorySymbol<?> symbol : symbols) {
            this.add(term, symbol);
            if (this.mUnionFind.find(symbol) == null) {
                this.mUnionFind.makeEquivalenceClass(symbol);
            }
            if (last != null && !((NonTheorySymbol)this.mUnionFind.find(last)).equals(this.mUnionFind.find(symbol))) {
                this.mUnionFind.union(symbol, last);
            }
            last = symbol;
        }
    }

    private void add(Term term, NonTheorySymbol<?> symbol) {
        Set<Term> terms = this.mNonTheorySymbols2Terms.get(symbol);
        if (terms == null) {
            terms = new HashSet<Term>();
            this.mNonTheorySymbols2Terms.put(symbol, terms);
        }
        terms.add(term);
    }

    public Iterable<Set<NonTheorySymbol<?>>> getConnectedNonTheorySymbols() {
        return new Iterable<Set<NonTheorySymbol<?>>>(){

            @Override
            public Iterator<Set<NonTheorySymbol<?>>> iterator() {
                return new Iterator<Set<NonTheorySymbol<?>>>(){
                    private final Iterator<NonTheorySymbol<?>> mIt;
                    {
                        this.mIt = (this).ConnectionPartition.this.mUnionFind.getAllRepresentatives().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mIt.hasNext();
                    }

                    @Override
                    public Set<NonTheorySymbol<?>> next() {
                        ImmutableSet eqMembers = (this).ConnectionPartition.this.mUnionFind.getEquivalenceClassMembers(this.mIt.next());
                        return eqMembers;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Set<Term> getTermsOfConnectedNonTheorySymbols(Set<NonTheorySymbol<?>> eqMembers) {
        HashSet<Term> result = new HashSet<Term>();
        for (NonTheorySymbol<?> symbol : eqMembers) {
            result.addAll((Collection<Term>)this.mNonTheorySymbols2Terms.get(symbol));
        }
        return result;
    }

    public List<Term> getTermsWithNonTheorySymbols() {
        return this.mTermWithoutNonTheorySymbols;
    }
}

