/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierOverapproximator;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Context {
    private static final CcTransformation OPTION_CCTRANSFORMATION = CcTransformation.OVERAPPROXIMATE_QUANTIFIERS;
    private final Term mCriticalConstraint;
    private final CcTransformation mCcTransformation = OPTION_CCTRANSFORMATION;
    private final Set<TermVariable> mBoundByAncestors;

    public Context(Script script) {
        this.mCriticalConstraint = script.term("true", new Term[0]);
        this.mBoundByAncestors = Collections.emptySet();
    }

    public Context(Term criticalConstraint, Set<TermVariable> boundByAncestors) {
        Objects.requireNonNull(criticalConstraint);
        Objects.requireNonNull(boundByAncestors);
        this.mCriticalConstraint = criticalConstraint;
        this.mBoundByAncestors = boundByAncestors;
    }

    public Term getCriticalConstraint() {
        return this.mCriticalConstraint;
    }

    public Set<TermVariable> getBoundByAncestors() {
        return Collections.unmodifiableSet(this.mBoundByAncestors);
    }

    public Context constructChildContextForQuantifiedFormula(Script script, List<TermVariable> quantifiedVars) {
        Set<TermVariable> all = Stream.concat(Arrays.asList(this.mCriticalConstraint.getFreeVars()).stream(), quantifiedVars.stream()).collect(Collectors.toSet());
        String nameOfTwoDifferentVars = this.checkForDifferentVariablesWithSameName(all);
        if (nameOfTwoDifferentVars != null) {
            throw new UnsupportedOperationException("Different variables with same name: " + nameOfTwoDifferentVars);
        }
        Term criticalConstraint = Context.buildCriticalContraintForQuantifiedFormula(script, this.mCriticalConstraint, quantifiedVars, this.mCcTransformation);
        HashSet<TermVariable> boundByAncestors = new HashSet<TermVariable>(this.mBoundByAncestors);
        boundByAncestors.addAll(quantifiedVars);
        return new Context(criticalConstraint, boundByAncestors);
    }

    public Context constructChildContextForConDis(IUltimateServiceProvider services, ManagedScript mgdScript, FunctionSymbol symb, List<Term> allParams, int selectedParam) {
        Term criticalConstraint = Context.buildCriticalConstraintForConDis(services, mgdScript, this.mCriticalConstraint, symb, allParams, selectedParam, this.mCcTransformation);
        return new Context(criticalConstraint, this.mBoundByAncestors);
    }

    public Context constructChildContextForConDis(IUltimateServiceProvider services, ManagedScript mgdScript, FunctionSymbol symb, List<Term> otherParams) {
        Term criticalConstraint = Context.buildCriticalConstraintForConDis(services, mgdScript, this.mCriticalConstraint, symb, otherParams, this.mCcTransformation);
        return new Context(criticalConstraint, this.mBoundByAncestors);
    }

    public static Term buildCriticalContraintForQuantifiedFormula(Script script, Term parentCriticalConstraint, List<TermVariable> boundVars, CcTransformation ccTransformation) {
        Term quantified = SmtUtils.quantifier(script, 0, boundVars, parentCriticalConstraint);
        Term result = ccTransformation == CcTransformation.OVERAPPROXIMATE_QUANTIFIERS ? QuantifierOverapproximator.apply(script, quantified) : quantified;
        return result;
    }

    public static Term buildConjunctiveCriticalContraintForQuantifiedFormula(Script script, Term parentCriticalConstraint, List<TermVariable> boundVars) {
        Term[] conjuncts = SmtUtils.getConjuncts(parentCriticalConstraint);
        ArrayList<Term> resultConjuncts = new ArrayList<Term>();
        Term[] termArray = conjuncts;
        int n = conjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term conjunct = termArray[n2];
            assert (SmtUtils.isAtomicFormula(conjunct)) : "non-atom in critical constraint";
            if (!Arrays.stream(conjunct.getFreeVars()).anyMatch(boundVars::contains)) {
                resultConjuncts.add(conjunct);
            }
            ++n2;
        }
        return SmtUtils.and(script, resultConjuncts);
    }

    public static Term buildCriticalConstraintForConDis(IUltimateServiceProvider services, ManagedScript mgdScript, Term parentCriticalConstraint, FunctionSymbol symb, List<Term> allParams, int selectedParam, CcTransformation ccTransformation) {
        ArrayList<Term> otherParams = new ArrayList<Term>(allParams);
        otherParams.remove(selectedParam);
        return Context.buildCriticalConstraintForConDis(services, mgdScript, parentCriticalConstraint, symb, otherParams, ccTransformation);
    }

    private static Term buildCriticalConstraintForConDis(IUltimateServiceProvider services, ManagedScript mgdScript, Term parentCriticalConstraint, FunctionSymbol symb, List<Term> otherParams, CcTransformation ccTransformation) {
        Term tmp;
        if (symb.getName().equals("and")) {
            tmp = SmtUtils.and(mgdScript.getScript(), otherParams);
        } else if (symb.getName().equals("or")) {
            List<Term> otherParamsNegated;
            switch (ccTransformation) {
                case NONE: {
                    otherParamsNegated = otherParams.stream().map(x -> SmtUtils.not(mgdScript.getScript(), x)).collect(Collectors.toList());
                    break;
                }
                case TO_NNF: 
                case OVERAPPROXIMATE_QUANTIFIERS: {
                    otherParamsNegated = otherParams.stream().map(x -> new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.KEEP).transform(SmtUtils.not(mgdScript.getScript(), x))).collect(Collectors.toList());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)ccTransformation)));
                }
            }
            tmp = SmtUtils.and(mgdScript.getScript(), otherParamsNegated);
        } else if (symb.getName().equals("=")) {
            tmp = mgdScript.getScript().term("true", new Term[0]);
        } else {
            throw new AssertionError((Object)("Supported: conjunction and disjunction. Got: " + symb));
        }
        Term tmpWithParent = SmtUtils.and(mgdScript.getScript(), tmp, parentCriticalConstraint);
        Term result = ccTransformation == CcTransformation.OVERAPPROXIMATE_QUANTIFIERS ? QuantifierOverapproximator.apply(mgdScript.getScript(), tmpWithParent) : tmp;
        return result;
    }

    public static Term buildConjunctiveCriticalConstraintForConDis(IUltimateServiceProvider services, ManagedScript mgdScript, Term parentCriticalConstraint, FunctionSymbol symb, List<Term> allParams, int selectedParam) {
        ArrayList<Term> otherParams = new ArrayList<Term>(allParams);
        otherParams.remove(selectedParam);
        return Context.buildConjunctiveCriticalConstraintForConDis(services, mgdScript, parentCriticalConstraint, symb, otherParams);
    }

    private static Term buildConjunctiveCriticalConstraintForConDis(IUltimateServiceProvider services, ManagedScript mgdScript, Term parentCriticalConstraint, FunctionSymbol symb, List<Term> otherParams) {
        Term result;
        if (symb.getName().equals("and")) {
            result = SmtUtils.and(mgdScript.getScript(), otherParams.stream().filter(SmtUtils::isAtomicFormula).collect(Collectors.toList()));
        } else if (symb.getName().equals("or")) {
            List<Term> otherParamsNegated = otherParams.stream().filter(SmtUtils::isAtomicFormula).map(x -> new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.KEEP).transform(SmtUtils.not(mgdScript.getScript(), x))).collect(Collectors.toList());
            result = SmtUtils.and(mgdScript.getScript(), otherParamsNegated);
        } else if (symb.getName().equals("=")) {
            result = mgdScript.getScript().term("true", new Term[0]);
        } else {
            throw new AssertionError((Object)"only conjunction and disjunction are supported");
        }
        result = SmtUtils.and(mgdScript.getScript(), result, parentCriticalConstraint);
        return result;
    }

    public String checkForDifferentVariablesWithSameName(Collection<TermVariable> termVariables) {
        HashMap<String, TermVariable> map = new HashMap<String, TermVariable>();
        for (TermVariable tv : termVariables) {
            TermVariable old = map.put(tv.getName(), tv);
            if (old == null || old.equals(tv)) continue;
            return old.getName();
        }
        return null;
    }

    public static enum CcTransformation {
        NONE,
        TO_NNF,
        OVERAPPROXIMATE_QUANTIFIERS;

    }
}

