/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisTermTransducer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeHashRelation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class DerScout
extends CondisTermTransducer<DerApplicability> {
    public final TermVariable mEliminatee;
    public final Script mScript;
    public final int mQuantifier;

    public DerScout(TermVariable eliminatee, Script script, int quantifier) {
        this.mEliminatee = eliminatee;
        this.mScript = script;
        this.mQuantifier = quantifier;
    }

    @Override
    protected DerApplicability transduceAtom(Term term) {
        BigInteger withoutDer;
        BigInteger withoutVar;
        if (Arrays.asList(term.getFreeVars()).contains(this.mEliminatee)) {
            SolvedBinaryRelation sbr;
            withoutVar = BigInteger.ZERO;
            PolynomialRelation polyRel = PolynomialRelation.convert(this.mScript, term);
            withoutDer = polyRel == null ? BigInteger.ONE : ((sbr = polyRel.solveForSubject(this.mScript, (Term)this.mEliminatee)) == null ? BigInteger.ONE : (polyRel.getRelationSymbol() == QuantifierUtils.getDerOperator(this.mQuantifier) ? BigInteger.ZERO : BigInteger.ONE));
        } else {
            withoutDer = BigInteger.ONE;
            withoutVar = BigInteger.ONE;
        }
        return new DerApplicability(Adk.ATOM, BigInteger.ONE, withoutDer, withoutVar);
    }

    @Override
    protected DerApplicability transduceConjunction(ApplicationTerm originalTerm, List<DerApplicability> transducedArguments) {
        DerApplicability result;
        Adk subTermConnective = Adk.DISJUNCTION;
        Adk ownConnective = Adk.CONJUNCTION;
        if (this.mQuantifier == 0) {
            result = DerScout.multiply(transducedArguments, subTermConnective, ownConnective);
        } else if (this.mQuantifier == 1) {
            result = DerScout.add(transducedArguments, subTermConnective, ownConnective);
        } else {
            throw new AssertionError();
        }
        return result;
    }

    @Override
    protected DerApplicability transduceDisjunction(ApplicationTerm originalTerm, List<DerApplicability> transducedArguments) {
        DerApplicability result;
        Adk subTermConnective = Adk.CONJUNCTION;
        Adk ownConnective = Adk.DISJUNCTION;
        if (this.mQuantifier == 0) {
            result = DerScout.add(transducedArguments, subTermConnective, ownConnective);
        } else if (this.mQuantifier == 1) {
            result = DerScout.multiply(transducedArguments, subTermConnective, ownConnective);
        } else {
            throw new AssertionError();
        }
        return result;
    }

    private static DerApplicability multiply(List<DerApplicability> transducedArguments, Adk subTermConnective, Adk ownConnective) throws AssertionError {
        BigInteger cases = BigInteger.ONE;
        BigInteger withoutDer = BigInteger.ONE;
        BigInteger withoutVar = BigInteger.ONE;
        for (DerApplicability input : transducedArguments) {
            if (input.getAdk() == Adk.ATOM || input.getAdk() == subTermConnective) {
                cases = cases.multiply(input.getCases());
                withoutDer = withoutDer.multiply(input.getWithoutDerCases());
                withoutVar = withoutVar.multiply(input.getWithoutVarCases());
                continue;
            }
            throw new AssertionError((Object)"expected conjuntion-disjunction alternation");
        }
        return new DerApplicability(ownConnective, cases, withoutDer, withoutVar);
    }

    private static DerApplicability add(List<DerApplicability> transducedArguments, Adk subTermConnective, Adk ownConnective) throws AssertionError {
        BigInteger cases = BigInteger.ZERO;
        BigInteger withoutDer = BigInteger.ZERO;
        BigInteger withoutVar = BigInteger.ZERO;
        for (DerApplicability input : transducedArguments) {
            if (input.getAdk() == Adk.ATOM || input.getAdk() == subTermConnective) {
                cases = cases.add(input.getCases());
                withoutDer = withoutDer.add(input.getWithoutDerCases());
                withoutVar = withoutVar.add(input.getWithoutVarCases());
                continue;
            }
            throw new AssertionError((Object)"expected conjuntion-disjunction alternation");
        }
        return new DerApplicability(ownConnective, cases, withoutDer, withoutVar);
    }

    private static List<Integer> computeMaximum(List<Integer> list1, List<Integer> list2) {
        List<Integer> smaller;
        List<Integer> larger;
        if (list1.size() >= list2.size()) {
            larger = list1;
            smaller = list2;
        } else {
            larger = list2;
            smaller = list1;
        }
        int i = 0;
        while (i < smaller.size()) {
            larger.set(i, Integer.max(larger.get(i), smaller.get(i)));
            ++i;
        }
        return larger;
    }

    public static TermVariable selectBestEliminatee(Script script, int quantifier, List<TermVariable> eliminatees, List<Term> currentDualFiniteParams) {
        if (eliminatees.size() == 1) {
            return eliminatees.iterator().next();
        }
        Map<TermVariable, BigInteger> score = DerScout.computeDerApplicabilityScore(script, quantifier, eliminatees, currentDualFiniteParams);
        TreeHashRelation tr = new TreeHashRelation();
        tr.reverseAddAll(score);
        Map.Entry best = (Map.Entry)tr.entrySet().iterator().next();
        return (TermVariable)((HashSet)best.getValue()).iterator().next();
    }

    private static Map<TermVariable, BigInteger> computeDerApplicabilityScore(Script script, int quantifier, List<TermVariable> eliminatees, List<Term> currentDualFiniteParams) {
        Term correspondingFiniteJunction = QuantifierUtils.applyDualFiniteConnective(script, quantifier, currentDualFiniteParams);
        HashMap<TermVariable, BigInteger> result = new HashMap<TermVariable, BigInteger>();
        for (TermVariable eliminatee : eliminatees) {
            DerApplicability da = (DerApplicability)new DerScout(eliminatee, script, quantifier).transduce(correspondingFiniteJunction);
            BigInteger score = da.getWithoutDerCases().subtract(da.getWithoutVarCases());
            result.put(eliminatee, score);
        }
        return result;
    }

    public static int computeRecommendation(Script script, Set<TermVariable> eliminatees, Term[] dualFiniteParams, int quantifier) {
        HashMap<TermVariable, ArrayList<DerApplicability>> map = new HashMap<TermVariable, ArrayList<DerApplicability>>();
        for (TermVariable eliminatee : eliminatees) {
            ArrayList<DerApplicability> list = new ArrayList<DerApplicability>();
            Term[] termArray = dualFiniteParams;
            int n = dualFiniteParams.length;
            int n2 = 0;
            while (n2 < n) {
                Term param = termArray[n2];
                DerApplicability da = (DerApplicability)new DerScout(eliminatee, script, quantifier).transduce(param);
                list.add(da);
                ++n2;
            }
            DerApplicability appl = DerScout.multiply(list, Adk.getCorrespondingFiniteConnective(quantifier), Adk.getDualFiniteConnective(quantifier));
            BigInteger nonElimCases = appl.getWithoutDerCases().subtract(appl.getWithoutVarCases());
            boolean eliminationGuarantee = nonElimCases.equals(BigInteger.ZERO);
            if (!eliminationGuarantee) continue;
            map.put(eliminatee, list);
        }
        double[] paramScore = new double[dualFiniteParams.length];
        for (Map.Entry entry : map.entrySet()) {
            int i = 0;
            for (DerApplicability appl : (List)entry.getValue()) {
                BigInteger derCases = appl.getCases().subtract(appl.getWithoutDerCases());
                Rational derCasedRat = Rational.valueOf((BigInteger)derCases, (BigInteger)BigInteger.ONE);
                Rational casesRat = Rational.valueOf((BigInteger)appl.getCases(), (BigInteger)BigInteger.ONE);
                double eliminateeScore = SmtUtils.approximateAsDouble(derCasedRat.div(casesRat));
                int n = i++;
                paramScore[n] = paramScore[n] + eliminateeScore;
            }
        }
        double currentMax = paramScore[0];
        int currentMaxIndex = 0;
        int i = 1;
        while (i < paramScore.length) {
            if (paramScore[i] > currentMax) {
                currentMaxIndex = i;
                currentMax = paramScore[i];
            }
            ++i;
        }
        assert (currentMax >= 0.0);
        if (currentMax > 0.0) {
            return currentMaxIndex;
        }
        return -1;
    }

    public static enum Adk {
        ATOM,
        DISJUNCTION,
        CONJUNCTION;


        public static Adk getCorrespondingFiniteConnective(int quantifier) {
            if (quantifier == 0) {
                return DISJUNCTION;
            }
            if (quantifier == 1) {
                return CONJUNCTION;
            }
            throw new AssertionError((Object)("unknown value " + quantifier));
        }

        public static Adk getDualFiniteConnective(int quantifier) {
            if (quantifier == 0) {
                return CONJUNCTION;
            }
            if (quantifier == 1) {
                return DISJUNCTION;
            }
            throw new AssertionError((Object)("unknown value " + quantifier));
        }
    }

    public static class DerApplicability {
        private final Adk mAdk;
        private final BigInteger mCases;
        private final BigInteger mWitoutDerCases;
        private final BigInteger mWithoutVarCases;

        public DerApplicability(Adk adk, BigInteger cases, BigInteger withoutDerCases, BigInteger withoutVarCases) {
            this.mAdk = adk;
            this.mCases = cases;
            this.mWitoutDerCases = withoutDerCases;
            this.mWithoutVarCases = withoutVarCases;
        }

        public Adk getAdk() {
            return this.mAdk;
        }

        public BigInteger getCases() {
            return this.mCases;
        }

        public BigInteger getWithoutDerCases() {
            return this.mWitoutDerCases;
        }

        public BigInteger getWithoutVarCases() {
            return this.mWithoutVarCases;
        }

        public String toString() {
            return String.valueOf(this.mAdk.toString()) + this.mCases + "/" + this.mWitoutDerCases + "/" + this.mWithoutVarCases;
        }
    }
}

