/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DualJunctionDer
extends DualJunctionQuantifierElimination {
    private static final boolean DO_OLD_DIV_CAPTURE_CHECK = false;
    private final boolean mExpensiveEliminations;

    public DualJunctionDer(ManagedScript script, IUltimateServiceProvider services, boolean expensiveEliminations) {
        super(script, services);
        this.mExpensiveEliminations = expensiveEliminations;
    }

    @Override
    public String getName() {
        return "destructive equality resolution";
    }

    @Override
    public String getAcronym() {
        return "DER";
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask inputEt) {
        IDerHelper[] helpers = this.mExpensiveEliminations ? new IDerHelper[]{new DerHelperMcsbr(IntricateOperations.AUXILIARY_VARIABLES), new DerHelperMcsbr(IntricateOperations.CASE_DISTINCTION)} : new IDerHelper[]{new DerHelperSbr(), new DerHelperMcsbr(IntricateOperations.ADDITIONAL_DUAL_JUNCTS)};
        DualJunctionQuantifierElimination.EliminationResult er = this.tryExhaustivelyToEliminate(inputEt, helpers);
        return er;
    }

    public DualJunctionQuantifierElimination.EliminationResult tryExhaustivelyToEliminate(EliminationTask inputEt, IDerHelper<?> ... derHelpers) {
        DualJunctionQuantifierElimination.EliminationResult er;
        EliminationTask currentEt = inputEt;
        LinkedHashSet<TermVariable> aquiredEliminatees = new LinkedHashSet<TermVariable>();
        while ((er = this.tryToEliminateOne(currentEt, derHelpers)) != null) {
            aquiredEliminatees.addAll(er.getNewEliminatees());
            currentEt = er.getEliminationTask();
            if (aquiredEliminatees.isEmpty() && !QuantifierUtils.isCorrespondingFiniteJunction(currentEt.getQuantifier(), er.getEliminationTask().getTerm())) continue;
        }
        if (currentEt == inputEt) {
            return null;
        }
        return new DualJunctionQuantifierElimination.EliminationResult(currentEt, aquiredEliminatees);
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(EliminationTask inputEt, IDerHelper<?> ... derHelpers) {
        IDerHelper<?>[] iDerHelperArray = derHelpers;
        int n = derHelpers.length;
        int n2 = 0;
        while (n2 < n) {
            IDerHelper<?> derHelper = iDerHelperArray[n2];
            DualJunctionQuantifierElimination.EliminationResult er = this.tryExhaustivelyToEliminate(derHelper, inputEt);
            if (er != null) {
                return er;
            }
            ++n2;
        }
        return null;
    }

    public DualJunctionQuantifierElimination.EliminationResult tryExhaustivelyToEliminate(IDerHelper<?> derHelper, EliminationTask inputEt) {
        DualJunctionQuantifierElimination.EliminationResult er;
        EliminationTask currentEt = inputEt;
        LinkedHashSet<TermVariable> aquiredEliminatees = new LinkedHashSet<TermVariable>();
        while ((er = this.tryToEliminateOne(derHelper, currentEt)) != null) {
            aquiredEliminatees.addAll(er.getNewEliminatees());
            currentEt = er.getEliminationTask();
            if (aquiredEliminatees.isEmpty() && !QuantifierUtils.isCorrespondingFiniteJunction(currentEt.getQuantifier(), er.getEliminationTask().getTerm())) continue;
        }
        if (currentEt == inputEt) {
            return null;
        }
        return new DualJunctionQuantifierElimination.EliminationResult(currentEt, aquiredEliminatees);
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(IDerHelper<?> derHelper, EliminationTask inputEt) {
        for (TermVariable eliminatee : inputEt.getEliminatees()) {
            DualJunctionQuantifierElimination.EliminationResult er = derHelper.tryToEliminateSbr(this.mMgdScript, eliminatee, inputEt);
            if (er == null) continue;
            return er;
        }
        return null;
    }

    private static Term doSubstitutions(ManagedScript mgdScript, int quantifier, List<Term> otherDualJuncts, SolvedBinaryRelation sbr, List<Term> dualJunctsResult) {
        Map<Term, Term> substitutionMapping = Collections.singletonMap(sbr.getLeftHandSide(), sbr.getRightHandSide());
        for (Term otherDualJunct : otherDualJuncts) {
            Term replaced = Substitution.apply(mgdScript, substitutionMapping, otherDualJunct);
            assert (UltimateNormalFormUtils.respectsUltimateNormalForm(replaced)) : "Term not in UltimateNormalForm";
            dualJunctsResult.add(replaced);
        }
        Term dualJunctionResult = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), quantifier, dualJunctsResult);
        return dualJunctionResult;
    }

    private static boolean eachCaseHasDerRelationSymbol(MultiCaseSolvedBinaryRelation mcsbr, int quantifier) {
        for (Case cas : mcsbr.getCases()) {
            if (cas.getSolvedBinaryRelation() == null || QuantifierUtils.isDerRelationSymbol(quantifier, cas.getSolvedBinaryRelation().getRelationSymbol())) continue;
            return false;
        }
        return true;
    }

    public static SolvedBinaryRelation tryPlr(Script script, int quantifier, TermVariable eliminatee, Term atom) {
        Term rightHandSide;
        if (DualJunctionDer.isSimilarModuloNegation((Term)eliminatee, atom)) {
            rightHandSide = QuantifierUtils.negateIfUniversal(script, quantifier, script.term("true", new Term[0]));
        } else if (DualJunctionDer.isDistinctModuloNegation((Term)eliminatee, atom)) {
            rightHandSide = QuantifierUtils.negateIfUniversal(script, quantifier, script.term("false", new Term[0]));
        } else {
            return null;
        }
        RelationSymbol relationSymbol = QuantifierUtils.getDerOperator(quantifier);
        return new SolvedBinaryRelation((Term)eliminatee, rightHandSide, relationSymbol, new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
    }

    public static boolean isSimilarModuloNegation(Term checkedTerm, Term wantedTerm) {
        if (wantedTerm.equals(checkedTerm)) {
            return true;
        }
        Term unzipped = SmtUtils.unzipNot(wantedTerm);
        if (unzipped != null) {
            return DualJunctionDer.isDistinctModuloNegation(checkedTerm, unzipped);
        }
        return false;
    }

    public static boolean isDistinctModuloNegation(Term checkedTerm, Term wantedTerm) {
        Term unzipped = SmtUtils.unzipNot(wantedTerm);
        if (unzipped != null) {
            return DualJunctionDer.isSimilarModuloNegation(checkedTerm, unzipped);
        }
        return false;
    }

    private static <E> List<E> toListAllButOne(E[] array, int idxOmit) {
        assert (idxOmit >= 0 && idxOmit < array.length);
        ArrayList<E> result = new ArrayList<E>(array.length - 1);
        int i = 0;
        while (i < array.length) {
            if (i != idxOmit) {
                result.add(array[i]);
            }
            ++i;
        }
        return result;
    }

    private static class DerHelperMcsbr
    extends IDerHelper<MultiCaseSolvedBinaryRelation> {
        private final IntricateOperations mIntricateOperations;

        public DerHelperMcsbr(IntricateOperations intricateOperations) {
            this.mIntricateOperations = intricateOperations;
        }

        @Override
        public MultiCaseSolvedBinaryRelation solveForSubject(ManagedScript mgdScript, int quantifier, TermVariable eliminatee, Term term, Set<TermVariable> bannedForDivCapture) {
            PolynomialRelation pr = PolynomialRelation.convert(mgdScript.getScript(), term);
            if (pr == null) {
                return null;
            }
            MultiCaseSolvedBinaryRelation mcsbr = pr.solveForSubject(mgdScript, (Term)eliminatee, MultiCaseSolvedBinaryRelation.Xnf.fromQuantifier(quantifier), bannedForDivCapture);
            if (mcsbr == null) {
                return null;
            }
            switch (this.mIntricateOperations) {
                case NONE: {
                    throw new AssertionError();
                }
                case ADDITIONAL_DUAL_JUNCTS: {
                    if (mcsbr.getCases().size() <= 1 && mcsbr.getAuxiliaryVariables().isEmpty()) break;
                    return null;
                }
                case AUXILIARY_VARIABLES: {
                    if (mcsbr.getCases().size() <= 1) break;
                    return null;
                }
                case CASE_DISTINCTION: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknon value " + (Object)((Object)this.mIntricateOperations)));
                }
            }
            if (DualJunctionDer.eachCaseHasDerRelationSymbol(mcsbr, quantifier)) {
                return mcsbr;
            }
            return null;
        }

        @Override
        protected DualJunctionQuantifierElimination.EliminationResult applyReplacement(ManagedScript mgdScript, EliminationTask et, List<Term> otherDualJuncts, MultiCaseSolvedBinaryRelation mcsbr) {
            ArrayList<Term> correspondingJunctsResult = new ArrayList<Term>();
            for (Case cas : mcsbr.getCases()) {
                Term dualJunctionResult;
                ArrayList<Term> dualJunctsResult = new ArrayList<Term>();
                for (SupportingTerm st : cas.getSupportingTerms()) {
                    dualJunctsResult.add(st.asTerm());
                }
                if (cas.getSolvedBinaryRelation() != null) {
                    dualJunctionResult = DualJunctionDer.doSubstitutions(mgdScript, et.getQuantifier(), otherDualJuncts, cas.getSolvedBinaryRelation(), dualJunctsResult);
                } else {
                    dualJunctsResult.addAll(otherDualJuncts);
                    dualJunctionResult = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), et.getQuantifier(), dualJunctsResult);
                }
                correspondingJunctsResult.add(dualJunctionResult);
            }
            Term correspondingJunction = QuantifierUtils.applyCorrespondingFiniteConnective(mgdScript.getScript(), et.getQuantifier(), correspondingJunctsResult);
            return new DualJunctionQuantifierElimination.EliminationResult(et.update(correspondingJunction), mcsbr.getAuxiliaryVariables());
        }
    }

    private static class DerHelperSbr
    extends IDerHelper<SolvedBinaryRelation> {
        @Override
        public SolvedBinaryRelation solveForSubject(ManagedScript mgdScript, int quantifier, TermVariable eliminatee, Term term, Set<TermVariable> bannedForDivCapture) {
            SolvedBinaryRelation sfs;
            SolvedBinaryRelation sbr;
            if (SmtSortUtils.isBoolSort(eliminatee.getSort()) && SmtSortUtils.isBoolSort(term.getSort()) && (sbr = DualJunctionDer.tryPlr(mgdScript.getScript(), quantifier, eliminatee, term)) != null) {
                return sbr;
            }
            BinaryEqualityRelation ber = BinaryEqualityRelation.convert(term);
            if (ber != null && QuantifierUtils.isDerRelationSymbol(quantifier, ber.getRelationSymbol()) && (sfs = ber.solveForSubject(mgdScript.getScript(), (Term)eliminatee)) != null) {
                return sfs;
            }
            PolynomialRelation pr = PolynomialRelation.convert(mgdScript.getScript(), term);
            if (pr == null) {
                return null;
            }
            SolvedBinaryRelation sfs2 = pr.solveForSubject(mgdScript.getScript(), (Term)eliminatee);
            if (sfs2 == null) {
                return null;
            }
            if (SolveForSubjectUtils.isVariableDivCaptured(sfs2, bannedForDivCapture)) {
                throw new AssertionError((Object)"cannot divCaputure with simple solveForSubject");
            }
            if (QuantifierUtils.isDerRelationSymbol(quantifier, sfs2.getRelationSymbol())) {
                return sfs2;
            }
            return null;
        }

        @Override
        protected DualJunctionQuantifierElimination.EliminationResult applyReplacement(ManagedScript mgdScript, EliminationTask et, List<Term> otherDualJuncts, SolvedBinaryRelation sbr) {
            ArrayList<Term> dualJunctsResult = new ArrayList<Term>();
            Term dualJunctionResult = DualJunctionDer.doSubstitutions(mgdScript, et.getQuantifier(), otherDualJuncts, sbr, dualJunctsResult);
            return new DualJunctionQuantifierElimination.EliminationResult(et.update(dualJunctionResult), Collections.emptySet());
        }
    }

    private static abstract class IDerHelper<SR> {
        private IDerHelper() {
        }

        public Pair<Integer, SR> findBestReplacementSbr(ManagedScript mgdScript, int quantifier, TermVariable eliminatee, Term[] dualJuncts, Set<TermVariable> bannedForDivCapture) {
            int i = 0;
            while (i < dualJuncts.length) {
                SR sbr = this.solveForSubject(mgdScript, quantifier, eliminatee, dualJuncts[i], bannedForDivCapture);
                if (sbr != null) {
                    return new Pair((Object)i, sbr);
                }
                ++i;
            }
            return null;
        }

        protected abstract SR solveForSubject(ManagedScript var1, int var2, TermVariable var3, Term var4, Set<TermVariable> var5);

        private DualJunctionQuantifierElimination.EliminationResult tryToEliminateSbr(ManagedScript mgdScript, TermVariable eliminatee, EliminationTask et) {
            Term[] dualJuncts = QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm());
            HashSet<TermVariable> bannedForDivCapture = new HashSet<TermVariable>(et.getEliminatees());
            bannedForDivCapture.addAll(et.getContext().getBoundByAncestors());
            Pair<Integer, SR> pair = this.findBestReplacementSbr(mgdScript, et.getQuantifier(), eliminatee, dualJuncts, bannedForDivCapture);
            if (pair == null) {
                return null;
            }
            List<Term> otherDualJuncts = DualJunctionDer.toListAllButOne(dualJuncts, (Integer)pair.getFirst());
            return this.applyReplacement(mgdScript, et, otherDualJuncts, pair.getSecond());
        }

        protected abstract DualJunctionQuantifierElimination.EliminationResult applyReplacement(ManagedScript var1, EliminationTask var2, List<Term> var3, SR var4);
    }

    public static enum IntricateOperations {
        NONE,
        ADDITIONAL_DUAL_JUNCTS,
        AUXILIARY_VARIABLES,
        CASE_DISTINCTION;

    }
}

