/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTaskSimple;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.LinkedHashSet;

public class DualJunctionQeAdapter2014
extends DualJunctionQuantifierElimination {
    private final XjunctPartialQuantifierElimination mXjunctPqe;

    public DualJunctionQeAdapter2014(ManagedScript mgdScript, IUltimateServiceProvider services, XjunctPartialQuantifierElimination xJunctPqe) {
        super(mgdScript, services);
        this.mXjunctPqe = xJunctPqe;
    }

    @Override
    public String getName() {
        return this.mXjunctPqe.getName();
    }

    @Override
    public String getAcronym() {
        return this.mXjunctPqe.getAcronym();
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask et) {
        Term[] dualJuncts = QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm());
        LinkedHashSet<TermVariable> modifiableEliminateeSet = new LinkedHashSet<TermVariable>(et.getEliminatees());
        Term[] resultdualJuncts = this.mXjunctPqe.tryToEliminate(et.getQuantifier(), dualJuncts, modifiableEliminateeSet);
        Term resultDualJunction = QuantifierUtils.applyDualFiniteConnective(this.mScript, et.getQuantifier(), resultdualJuncts);
        EliminationTaskSimple resultEt = et.update(modifiableEliminateeSet, resultDualJunction);
        if (resultEt.getEliminatees().containsAll(et.getEliminatees())) {
            return null;
        }
        return new DualJunctionQuantifierElimination.EliminationResult((EliminationTask)resultEt, Collections.emptySet());
    }
}

