/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Set;

public abstract class DualJunctionQuantifierElimination {
    protected final Script mScript;
    protected final ManagedScript mMgdScript;
    protected final IUltimateServiceProvider mServices;
    protected final ILogger mLogger;

    public DualJunctionQuantifierElimination(ManagedScript script, IUltimateServiceProvider services) {
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mMgdScript = script;
        this.mScript = script.getScript();
    }

    public abstract String getName();

    public abstract String getAcronym();

    public abstract EliminationResult tryToEliminate(EliminationTask var1);

    public static class EliminationResult {
        private final EliminationTask mEliminationTask;
        private final Set<TermVariable> mNewEliminatees;

        public EliminationResult(EliminationTask eliminationTask, Set<TermVariable> newEliminatees) {
            this.mEliminationTask = eliminationTask;
            this.mNewEliminatees = newEliminatees;
        }

        public EliminationTask getEliminationTask() {
            return this.mEliminationTask;
        }

        public Set<TermVariable> getNewEliminatees() {
            return this.mNewEliminatees;
        }

        public EliminationTask integrateNewEliminatees() {
            return this.mEliminationTask.integrateNewEliminatees(this.mNewEliminatees);
        }
    }
}

