/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTaskPlain;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ElimStorePlain;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DualJunctionSaa
extends DualJunctionQuantifierElimination {
    private static final boolean PRENEX_NORMAL_FORM_FOR_INNERQUANTIFIERS = true;
    private final boolean mExpensiveEliminations;

    public DualJunctionSaa(ManagedScript script, IUltimateServiceProvider services, boolean expensiveEliminations) {
        super(script, services);
        this.mExpensiveEliminations = expensiveEliminations;
    }

    @Override
    public String getName() {
        return "smart array ackermanization";
    }

    @Override
    public String getAcronym() {
        return "saa";
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask inputEt) {
        DualJunctionQuantifierElimination.EliminationResult er = this.tryExhaustivelyToEliminate(inputEt);
        return er;
    }

    public DualJunctionQuantifierElimination.EliminationResult tryExhaustivelyToEliminate(EliminationTask inputEt) {
        DualJunctionQuantifierElimination.EliminationResult er = this.tryToEliminateOne(inputEt);
        if (er == null) {
            return null;
        }
        return er;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(EliminationTask inputEt) {
        for (TermVariable eliminatee : inputEt.getEliminatees()) {
            EliminationTask singletonEliminationTask;
            DualJunctionQuantifierElimination.EliminationResult er;
            if (!SmtSortUtils.isArraySort(eliminatee.getSort()) || (er = this.tryToEliminateOne0(singletonEliminationTask = new EliminationTask(inputEt.getQuantifier(), Collections.singleton(eliminatee), inputEt.getTerm(), inputEt.getContext()))) == null) continue;
            assert (inputEt.getContext() == er.getEliminationTask().getContext()) : "illegal change of context";
            return new DualJunctionQuantifierElimination.EliminationResult((EliminationTask)er.getEliminationTask().update((Set)inputEt.getEliminatees(), er.getEliminationTask().getTerm()), er.getNewEliminatees());
        }
        return null;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne0(EliminationTask inputEt) {
        Pair<Term, EliminationTask> pair = inputEt.makeTight(this.mServices, this.mMgdScript);
        if (pair == null) {
            return this.tryToEliminateOne1(inputEt);
        }
        DualJunctionQuantifierElimination.EliminationResult er = this.tryToEliminateOne1((EliminationTask)pair.getSecond());
        if (er == null) {
            return null;
        }
        Term resultTerm = QuantifierUtils.applyDualFiniteConnective(this.mScript, inputEt.getQuantifier(), (Term)pair.getFirst(), er.getEliminationTask().getTerm());
        EliminationTask resultEliminationTask = new EliminationTask(inputEt.getQuantifier(), inputEt.getEliminatees(), resultTerm, inputEt.getContext());
        return new DualJunctionQuantifierElimination.EliminationResult(resultEliminationTask, er.getNewEliminatees());
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne1(EliminationTask inputEt) {
        DualJunctionQuantifierElimination.EliminationResult er = this.tryToEliminateOne2(inputEt);
        return er;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne2(EliminationTask inputEt) {
        Term pnf = new PrenexNormalForm(this.mMgdScript).transform(inputEt.getTerm());
        QuantifierSequence qs = new QuantifierSequence(this.mMgdScript, pnf);
        EliminationTask et = inputEt.update(qs.getInnerTerm());
        DualJunctionQuantifierElimination.EliminationResult res = this.tryToEliminateOne3(et);
        if (res == null) {
            return null;
        }
        if (qs.getQuantifierBlocks().isEmpty()) {
            return res;
        }
        EliminationTask etWithNewEliminatees = res.integrateNewEliminatees();
        QuantifierSequence qsForResult = new QuantifierSequence(this.mMgdScript, etWithNewEliminatees.toTerm(this.mMgdScript.getScript()), qs.getQuantifierBlocks());
        Term resultTerm = qsForResult.toTerm();
        return new DualJunctionQuantifierElimination.EliminationResult(etWithNewEliminatees.update(resultTerm), Collections.emptySet());
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne3(EliminationTask inputEt) {
        EliminationTaskPlain res = this.tryToEliminate(inputEt.getQuantifier(), inputEt.getTerm(), inputEt.getContext(), inputEt.getEliminatees().iterator().next());
        if (res == null) {
            return null;
        }
        HashSet<TermVariable> newEliminatees = new HashSet<TermVariable>(res.getEliminatees());
        newEliminatees.removeAll(inputEt.getEliminatees());
        return new DualJunctionQuantifierElimination.EliminationResult(new EliminationTask(res.getQuantifier(), inputEt.getEliminatees(), res.getTerm(), inputEt.getContext()), newEliminatees);
    }

    private EliminationTaskPlain tryToEliminate(int quantifier, Term term, Context context, TermVariable eliminatee) {
        EliminationTaskPlain res1;
        EliminationTaskPlain inputEtp = new EliminationTaskPlain(quantifier, Collections.singleton(eliminatee), term, context.getCriticalConstraint());
        try {
            res1 = ElimStorePlain.applyComplexEliminationRules(this.mServices, this.mLogger, this.mMgdScript, inputEtp);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
        catch (ElimStorePlain.ElimStorePlainException e) {
            if (e.getMessage().equals("DER that is not on top-level")) {
                res1 = null;
            }
            if (e.getMessage().equals("Subterm of an index is captued by an inner quantifier")) {
                throw new AssertionError((Object)"Captured index although handling of inner quantfiers is set");
            }
            throw new AssertionError((Object)e);
        }
        if (res1 != null && Arrays.asList(res1.getTerm().getFreeVars()).contains(eliminatee)) {
            throw new AssertionError((Object)("Var not eliminated: " + eliminatee + " " + inputEtp.toTerm(this.mScript)));
        }
        return res1;
    }
}

