/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.ExplicitLhsPolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DualJunctionTir
extends DualJunctionQuantifierElimination {
    private static final boolean HANDLE_DER_OPERATOR = false;
    private static final boolean COMPARE_TO_OLD_RESULT = false;
    private static final boolean ERROR_FOR_OMEGA_TEST_APPLICABILITY = false;
    private final boolean mSupportAntiDerTerms;

    public DualJunctionTir(ManagedScript script, IUltimateServiceProvider services, boolean supportAntiDerTerms) {
        super(script, services);
        this.mSupportAntiDerTerms = supportAntiDerTerms;
    }

    @Override
    public String getName() {
        return "transitive inequality resolution";
    }

    @Override
    public String getAcronym() {
        return "TIR";
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask inputEt) {
        DualJunctionQuantifierElimination.EliminationResult er = this.tryToEliminateOne(inputEt);
        return er;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(EliminationTask inputEt) {
        for (TermVariable eliminatee : inputEt.getEliminatees()) {
            HashSet<TermVariable> bannedForDivCapture = new HashSet<TermVariable>(inputEt.getEliminatees());
            bannedForDivCapture.addAll(inputEt.getContext().getBoundByAncestors());
            Term resultTerm = DualJunctionTir.tryToEliminateConjuncts(this.mServices, this.mScript, inputEt.getQuantifier(), inputEt.getTerm(), eliminatee, bannedForDivCapture, this.mSupportAntiDerTerms);
            if (resultTerm == null) continue;
            return new DualJunctionQuantifierElimination.EliminationResult(inputEt.update(resultTerm), Collections.emptySet());
        }
        return null;
    }

    public static Term tryToEliminateConjuncts(IUltimateServiceProvider services, Script script, int quantifier, Term disjunct, TermVariable eliminatee, Set<TermVariable> bannedForDivCapture, boolean supportAntiDerTerms) {
        Term[] inputAtoms = QuantifierUtils.getDualFiniteJunction(quantifier, disjunct);
        List<Term> withEliminatee = Arrays.stream(inputAtoms).filter(x -> Arrays.asList(x.getFreeVars()).contains(eliminatee)).collect(Collectors.toList());
        List<Term> withoutEliminatee = Arrays.stream(inputAtoms).filter(x -> !Arrays.asList(x.getFreeVars()).contains(eliminatee)).collect(Collectors.toList());
        ExplicitLhsPolynomialRelations elprs = DualJunctionTir.convert(withEliminatee, script, eliminatee, quantifier);
        if (elprs == null) {
            return null;
        }
        if (!supportAntiDerTerms && !elprs.getAntiDerRelations().isEmpty()) {
            return null;
        }
        ExplicitLhsPolynomialRelations bestElprs = DualJunctionTir.makeTight(elprs);
        if (bestElprs == null) {
            return null;
        }
        Term constraint = bestElprs.buildBoundConstraint(services, script, quantifier, bannedForDivCapture);
        if (constraint == null) {
            return null;
        }
        withoutEliminatee.add(constraint);
        return QuantifierUtils.applyDualFiniteConnective(script, quantifier, withoutEliminatee);
    }

    private static ExplicitLhsPolynomialRelations makeTight(ExplicitLhsPolynomialRelations elprs) {
        ExplicitLhsPolynomialRelation tight;
        ExplicitLhsPolynomialRelations result = new ExplicitLhsPolynomialRelations(elprs.getSort());
        for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : elprs.getLowerBounds()) {
            tight = explicitLhsPolynomialRelation.makeTight();
            result.addSimpleRelation(tight);
        }
        for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : elprs.getUpperBounds()) {
            tight = explicitLhsPolynomialRelation.makeTight();
            result.addSimpleRelation(tight);
        }
        for (Pair pair : elprs.getAntiDerRelations()) {
            ExplicitLhsPolynomialRelation tightLower = ((ExplicitLhsPolynomialRelation)pair.getFirst()).makeTight();
            ExplicitLhsPolynomialRelation tightUpper = ((ExplicitLhsPolynomialRelation)pair.getSecond()).makeTight();
            Sort sort = ((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsMonomial().getSort();
            if (ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsCoefficient(), sort)) {
                assert (ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(((ExplicitLhsPolynomialRelation)pair.getSecond()).getLhsCoefficient(), sort));
                result.addAntiDerRelation(tightUpper, tightLower);
                continue;
            }
            result.addAntiDerRelation(tightLower, tightUpper);
        }
        return result;
    }

    @Deprecated
    private static ExplicitLhsPolynomialRelations bestDivision(Script script, TermVariable eliminatee, Set<TermVariable> bannedForDivCapture, int quantifier, ExplicitLhsPolynomialRelations elprs) {
        ExplicitLhsPolynomialRelation solved;
        ExplicitLhsPolynomialRelations result = new ExplicitLhsPolynomialRelations(elprs.getSort());
        for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : elprs.getLowerBounds()) {
            solved = DualJunctionTir.bestDivision(script, bannedForDivCapture, explicitLhsPolynomialRelation);
            if (solved == null) {
                return null;
            }
            result.addSimpleRelation(solved);
        }
        for (ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation : elprs.getUpperBounds()) {
            solved = DualJunctionTir.bestDivision(script, bannedForDivCapture, explicitLhsPolynomialRelation);
            if (solved == null) {
                return null;
            }
            result.addSimpleRelation(solved);
        }
        for (Pair pair : elprs.getAntiDerRelations()) {
            ExplicitLhsPolynomialRelation solvedLower = DualJunctionTir.bestDivision(script, bannedForDivCapture, (ExplicitLhsPolynomialRelation)pair.getFirst());
            ExplicitLhsPolynomialRelation solvedUpper = DualJunctionTir.bestDivision(script, bannedForDivCapture, (ExplicitLhsPolynomialRelation)pair.getSecond());
            if (solvedLower == null) {
                assert (solvedUpper == null);
                return null;
            }
            Sort sort = ((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsMonomial().getSort();
            if (ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(((ExplicitLhsPolynomialRelation)pair.getFirst()).getLhsCoefficient(), sort)) {
                assert (ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(((ExplicitLhsPolynomialRelation)pair.getSecond()).getLhsCoefficient(), sort));
                result.addAntiDerRelation(solvedUpper, solvedLower);
                continue;
            }
            result.addAntiDerRelation(solvedLower, solvedUpper);
        }
        return result;
    }

    @Deprecated
    private static ExplicitLhsPolynomialRelation bestDivision(Script script, Set<TermVariable> bannedForDivCapture, ExplicitLhsPolynomialRelation elpr) {
        ExplicitLhsPolynomialRelation solved = elpr.divInvertible(elpr.getLhsCoefficient());
        if (solved != null) {
            return solved;
        }
        if (SmtSortUtils.isBitvecSort(elpr.getLhsMonomial().getSort())) {
            return null;
        }
        Pair<ExplicitLhsPolynomialRelation, Term> pair = elpr.divideByIntegerCoefficient(script, bannedForDivCapture);
        if (pair != null) {
            if (pair.getSecond() != null) {
                throw new AssertionError((Object)"not this case");
            }
            return (ExplicitLhsPolynomialRelation)pair.getFirst();
        }
        if (elpr.getLhsCoefficient().isNegative()) {
            return elpr.divInvertible(Rational.MONE);
        }
        return elpr;
    }

    private static ExplicitLhsPolynomialRelations convert(List<Term> withEliminatee, Script script, TermVariable eliminatee, int quantifier) {
        RelationSymbol.BvSignedness bvSignedness;
        PolynomialRelation.TransformInequality tfi;
        ExplicitLhsPolynomialRelations result = new ExplicitLhsPolynomialRelations(eliminatee.getSort());
        ArrayList<ExplicitLhsPolynomialRelation> compatibleDistinctAndEqRelations = new ArrayList<ExplicitLhsPolynomialRelation>();
        if (!SmtSortUtils.isIntSort(eliminatee.getSort())) {
            tfi = PolynomialRelation.TransformInequality.NO_TRANFORMATION;
        } else if (quantifier == 0) {
            tfi = PolynomialRelation.TransformInequality.STRICT2NONSTRICT;
        } else if (quantifier == 1) {
            tfi = PolynomialRelation.TransformInequality.NONSTRICT2STRICT;
        } else {
            throw new AssertionError((Object)"Unknown quantifier");
        }
        for (Term t : withEliminatee) {
            ExplicitLhsPolynomialRelation elpr;
            PolynomialRelation polyRel = PolynomialRelation.convert(script, t, tfi);
            if (polyRel == null) {
                BinaryNumericRelation bnr = BinaryNumericRelation.convert(t);
                if (bnr == null) {
                    return null;
                }
                SolvedBinaryRelation sbr = bnr.solveForSubject(script, (Term)eliminatee);
                if (sbr == null) {
                    return null;
                }
                IPolynomialTerm polyRhs = PolynomialTermTransformer.convert(script, sbr.getRightHandSide());
                elpr = new ExplicitLhsPolynomialRelation(sbr.getRelationSymbol(), Rational.ONE, new Monomial(sbr.getLeftHandSide(), Rational.ONE), polyRhs);
            } else {
                elpr = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, (Term)eliminatee, polyRel);
                if (elpr == null) {
                    return null;
                }
                if (!elpr.getLhsMonomial().isLinear()) {
                    return null;
                }
            }
            switch (elpr.getRelationSymbol()) {
                case LEQ: 
                case GEQ: 
                case LESS: 
                case GREATER: 
                case BVULE: 
                case BVULT: 
                case BVUGE: 
                case BVUGT: 
                case BVSLE: 
                case BVSLT: 
                case BVSGE: 
                case BVSGT: {
                    result.addSimpleRelation(elpr);
                    break;
                }
                case EQ: 
                case DISTINCT: {
                    compatibleDistinctAndEqRelations.add(elpr);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown relation " + (Object)((Object)elpr.getRelationSymbol())));
                }
            }
        }
        if (SmtSortUtils.isBitvecSort(eliminatee.getSort())) {
            bvSignedness = DualJunctionTir.determineBvSignedness(result.getLowerBounds(), result.getUpperBounds());
            if (bvSignedness == null) {
                return null;
            }
        } else {
            bvSignedness = null;
        }
        for (ExplicitLhsPolynomialRelation elpr : compatibleDistinctAndEqRelations) {
            boolean inequalitiesAreStrict;
            switch (elpr.getRelationSymbol()) {
                case LEQ: 
                case GEQ: 
                case LESS: 
                case GREATER: 
                case BVULE: 
                case BVULT: 
                case BVUGE: 
                case BVUGT: 
                case BVSLE: 
                case BVSLT: 
                case BVSGE: 
                case BVSGT: {
                    throw new AssertionError((Object)"Should have been handled above.");
                }
                case EQ: {
                    if (quantifier == 0) {
                        return null;
                    }
                    if (quantifier == 1) {
                        inequalitiesAreStrict = false;
                        break;
                    }
                    throw new AssertionError((Object)"unknown quantifier");
                }
                case DISTINCT: {
                    if (quantifier == 0) {
                        inequalitiesAreStrict = true;
                        break;
                    }
                    if (quantifier == 1) {
                        return null;
                    }
                    throw new AssertionError((Object)"unknown quantifier");
                }
                default: {
                    throw new AssertionError((Object)("unknown relation " + (Object)((Object)elpr.getRelationSymbol())));
                }
            }
            RelationSymbol greaterRelationSymbol = RelationSymbol.getGreaterRelationSymbol(inequalitiesAreStrict, eliminatee.getSort(), bvSignedness);
            ExplicitLhsPolynomialRelation lower = SmtSortUtils.isIntSort(elpr.getRhs().getSort()) ? elpr.changeRelationSymbol(greaterRelationSymbol).changeStrictness(tfi) : elpr.changeRelationSymbol(greaterRelationSymbol);
            RelationSymbol lessRelationSymbol = RelationSymbol.getLessRelationSymbol(inequalitiesAreStrict, eliminatee.getSort(), bvSignedness);
            ExplicitLhsPolynomialRelation upper = SmtSortUtils.isIntSort(elpr.getRhs().getSort()) ? elpr.changeRelationSymbol(lessRelationSymbol).changeStrictness(tfi) : elpr.changeRelationSymbol(lessRelationSymbol);
            result.addAntiDerRelation(lower, upper);
        }
        return result;
    }

    private static RelationSymbol.BvSignedness determineBvSignedness(List<ExplicitLhsPolynomialRelation> lowerBounds, List<ExplicitLhsPolynomialRelation> upperBounds) {
        RelationSymbol.BvSignedness result;
        EnumSet<RelationSymbol.BvSignedness> bvSignednesses = DualJunctionTir.collectBvSignednesses(lowerBounds, upperBounds);
        if (bvSignednesses.equals(EnumSet.allOf(RelationSymbol.BvSignedness.class))) {
            result = null;
        } else if (bvSignednesses.equals(EnumSet.of(RelationSymbol.BvSignedness.UNSIGNED))) {
            result = RelationSymbol.BvSignedness.UNSIGNED;
        } else if (bvSignednesses.equals(EnumSet.of(RelationSymbol.BvSignedness.SIGNED))) {
            result = RelationSymbol.BvSignedness.SIGNED;
        } else {
            assert (bvSignednesses.equals(EnumSet.noneOf(RelationSymbol.BvSignedness.class)));
            assert (lowerBounds.isEmpty() && upperBounds.isEmpty());
            result = RelationSymbol.BvSignedness.UNSIGNED;
        }
        return result;
    }

    private static EnumSet<RelationSymbol.BvSignedness> collectBvSignednesses(List<ExplicitLhsPolynomialRelation> lowerBounds, List<ExplicitLhsPolynomialRelation> upperBounds) {
        EnumSet<RelationSymbol.BvSignedness> bvSignednesses = EnumSet.noneOf(RelationSymbol.BvSignedness.class);
        bvSignednesses.addAll(DualJunctionTir.collectBvSignednesses(lowerBounds));
        bvSignednesses.addAll(DualJunctionTir.collectBvSignednesses(upperBounds));
        return bvSignednesses;
    }

    private static EnumSet<RelationSymbol.BvSignedness> collectBvSignednesses(List<ExplicitLhsPolynomialRelation> bounds) {
        EnumSet<RelationSymbol.BvSignedness> bvSignednesses = EnumSet.noneOf(RelationSymbol.BvSignedness.class);
        for (ExplicitLhsPolynomialRelation bound : bounds) {
            if (bound.getRelationSymbol().isUnSignedBvRelation()) {
                bvSignednesses.add(RelationSymbol.BvSignedness.UNSIGNED);
                continue;
            }
            if (!bound.getRelationSymbol().isSignedBvRelation()) continue;
            bvSignednesses.add(RelationSymbol.BvSignedness.SIGNED);
        }
        return bvSignednesses;
    }

    private static Pair<RelationSymbol, Rational> computeRelationSymbolAndOffset(int quantifier, RelationSymbol lowerBoundRelationSymbol, RelationSymbol upperBoundRelationSymbol, Sort sort) {
        Rational offset;
        RelationSymbol resultRelationSymbol;
        RelationSymbol.BvSignedness bvSignedness;
        if (SmtSortUtils.isBitvecSort(sort)) {
            bvSignedness = lowerBoundRelationSymbol.getSignedness();
            if (bvSignedness != upperBoundRelationSymbol.getSignedness()) {
                throw new AssertionError((Object)"Cannot combined signed and unsigned relations.");
            }
        } else {
            bvSignedness = null;
        }
        if (lowerBoundRelationSymbol.isRelationSymbolGE() && upperBoundRelationSymbol.isRelationSymbolLE()) {
            resultRelationSymbol = RelationSymbol.getLessRelationSymbol(upperBoundRelationSymbol.isStrictRelation(), sort, bvSignedness);
            offset = quantifier == 1 && (SmtSortUtils.isIntSort(sort) || SmtSortUtils.isBitvecSort(sort)) ? Rational.MONE : Rational.ZERO;
        } else if (lowerBoundRelationSymbol.isRelationSymbolGE() && upperBoundRelationSymbol.isRelationSymbolLT() || lowerBoundRelationSymbol.isRelationSymbolGT() && upperBoundRelationSymbol.isRelationSymbolLE()) {
            if (quantifier == 0) {
                resultRelationSymbol = RelationSymbol.getLessRelationSymbol(true, sort, bvSignedness);
            } else if (quantifier == 1) {
                resultRelationSymbol = RelationSymbol.getLessRelationSymbol(false, sort, bvSignedness);
            } else {
                throw new AssertionError((Object)"unknown quantifier");
            }
            offset = Rational.ZERO;
        } else if (lowerBoundRelationSymbol.isRelationSymbolGT() && upperBoundRelationSymbol.isRelationSymbolLT()) {
            resultRelationSymbol = RelationSymbol.getLessRelationSymbol(upperBoundRelationSymbol.isStrictRelation(), sort, bvSignedness);
            offset = quantifier == 0 && (SmtSortUtils.isIntSort(sort) || SmtSortUtils.isBitvecSort(sort)) ? Rational.ONE : Rational.ZERO;
        } else {
            throw new AssertionError((Object)String.format("Unsupported relation symbols: Lower %s, Upper %s", new Object[]{lowerBoundRelationSymbol, upperBoundRelationSymbol}));
        }
        return new Pair((Object)resultRelationSymbol, (Object)offset);
    }

    private static class ExplicitLhsPolynomialRelations {
        private final Sort mSort;
        private final List<ExplicitLhsPolynomialRelation> mLowerBounds = new ArrayList<ExplicitLhsPolynomialRelation>();
        private final List<ExplicitLhsPolynomialRelation> mUpperBounds = new ArrayList<ExplicitLhsPolynomialRelation>();
        private final List<Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>> mAntiDerBounds = new ArrayList<Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>>();

        public ExplicitLhsPolynomialRelations(Sort sort) {
            this.mSort = sort;
        }

        void addSimpleRelation(ExplicitLhsPolynomialRelation bound) {
            switch (bound.getRelationSymbol()) {
                case EQ: 
                case DISTINCT: {
                    throw new AssertionError((Object)"should have been split before");
                }
                case GEQ: 
                case GREATER: 
                case BVUGE: 
                case BVUGT: 
                case BVSGE: 
                case BVSGT: {
                    this.mLowerBounds.add(bound);
                    break;
                }
                case LEQ: 
                case LESS: 
                case BVULE: 
                case BVULT: 
                case BVSLE: 
                case BVSLT: {
                    this.mUpperBounds.add(bound);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown relation symbol " + (Object)((Object)bound.getRelationSymbol())));
                }
            }
        }

        void addAntiDerRelation(ExplicitLhsPolynomialRelation lowerBound, ExplicitLhsPolynomialRelation upperBound) {
            this.mAntiDerBounds.add((Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>)new Pair((Object)lowerBound, (Object)upperBound));
        }

        public Sort getSort() {
            return this.mSort;
        }

        public List<ExplicitLhsPolynomialRelation> getLowerBounds() {
            return this.mLowerBounds;
        }

        public List<ExplicitLhsPolynomialRelation> getUpperBounds() {
            return this.mUpperBounds;
        }

        public List<Pair<ExplicitLhsPolynomialRelation, ExplicitLhsPolynomialRelation>> getAntiDerRelations() {
            return this.mAntiDerBounds;
        }

        private Term buildBoundConstraint(IUltimateServiceProvider services, Script script, int quantifier, Set<TermVariable> bannedForDivCapture) {
            boolean bvSingleDirectionBounds;
            List<ExplicitLhsPolynomialRelation> lowerBounds = this.mLowerBounds;
            List<ExplicitLhsPolynomialRelation> upperBounds = this.mUpperBounds;
            boolean bl = bvSingleDirectionBounds = SmtSortUtils.isBitvecSort(this.mSort) && this.mAntiDerBounds.isEmpty() && lowerBounds.isEmpty() != upperBounds.isEmpty();
            if (bvSingleDirectionBounds) {
                return this.checkforSingleDirectionBounds(script, lowerBounds, upperBounds, quantifier);
            }
            return this.buildCorrespondingFiniteJunctionForAntiDer(services, quantifier, script, bannedForDivCapture);
        }

        private static Term constructConstraintForSingleDirectionBounds(Term term, Script script, Sort sort, RelationSymbol.BvSignedness bvSignedness, Direction direction, int quantifier) {
            BigInteger boundAsBigInt = ExplicitLhsPolynomialRelations.getMaximalBound(sort, bvSignedness, direction);
            Term boundAsTerm = SmtUtils.constructIntegerValue(script, sort, boundAsBigInt);
            return QuantifierUtils.applyAntiDerOperator(script, quantifier, boundAsTerm, term);
        }

        private static BigInteger getMaximalBound(Sort sort, RelationSymbol.BvSignedness bvSignedness, Direction direction) {
            BigInteger boundAsBigInt;
            int size = SmtSortUtils.getBitvectorLength(sort);
            BigInteger pow = BigInteger.TWO.pow(size);
            block0 : switch (bvSignedness) {
                case SIGNED: {
                    switch (direction) {
                        case LOWER: {
                            boundAsBigInt = pow.divide(BigInteger.TWO).multiply(BigInteger.ONE).negate();
                            break block0;
                        }
                        case UPPER: {
                            boundAsBigInt = pow.divide(BigInteger.TWO).subtract(BigInteger.ONE);
                            break block0;
                        }
                    }
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)direction)));
                }
                case UNSIGNED: {
                    switch (direction) {
                        case LOWER: {
                            boundAsBigInt = BigInteger.ZERO;
                            break block0;
                        }
                        case UPPER: {
                            boundAsBigInt = pow.subtract(BigInteger.ONE);
                            break block0;
                        }
                    }
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)direction)));
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)bvSignedness)));
                }
            }
            return boundAsBigInt;
        }

        private Term checkforSingleDirectionBounds(Script script, List<ExplicitLhsPolynomialRelation> lowerBounds, List<ExplicitLhsPolynomialRelation> upperBounds, int quantifier) {
            List<ExplicitLhsPolynomialRelation> bounds;
            Direction direction;
            if (upperBounds.isEmpty()) {
                if (quantifier == 0) {
                    direction = Direction.UPPER;
                } else if (quantifier == 1) {
                    direction = Direction.LOWER;
                } else {
                    throw new AssertionError((Object)("Unknown quantifier " + quantifier));
                }
                bounds = lowerBounds;
            } else if (lowerBounds.isEmpty()) {
                if (quantifier == 0) {
                    direction = Direction.LOWER;
                } else if (quantifier == 1) {
                    direction = Direction.UPPER;
                } else {
                    throw new AssertionError((Object)("Unknown quantifier " + quantifier));
                }
                bounds = upperBounds;
            } else {
                return null;
            }
            return this.constructConstraintForSingleDirectionBounds(script, quantifier, direction, bounds);
        }

        private Term constructConstraintForSingleDirectionBounds(Script script, int quantifier, Direction direction, List<ExplicitLhsPolynomialRelation> bounds) {
            ArrayList<Term> dualFiniteJunction = new ArrayList<Term>();
            for (ExplicitLhsPolynomialRelation bound : bounds) {
                if (quantifier == 0 && bound.getRelationSymbol().isStrictRelation()) {
                    dualFiniteJunction.add(ExplicitLhsPolynomialRelations.constructConstraintForSingleDirectionBounds(bound.getRhs().toTerm(script), script, bound.getRhs().getSort(), bound.getRelationSymbol().getSignedness(), direction, quantifier));
                    continue;
                }
                if (quantifier != 1 || bound.getRelationSymbol().isStrictRelation()) continue;
                dualFiniteJunction.add(ExplicitLhsPolynomialRelations.constructConstraintForSingleDirectionBounds(bound.getRhs().toTerm(script), script, bound.getRhs().getSort(), bound.getRelationSymbol().getSignedness(), direction, quantifier));
            }
            return QuantifierUtils.applyDualFiniteConnective(script, quantifier, dualFiniteJunction);
        }

        private Term buildCorrespondingFiniteJunctionForAntiDer(IUltimateServiceProvider services, int quantifier, Script script, Set<TermVariable> bannedForDivCapture) {
            int numberOfCorrespondingFiniteJuncts = (int)Math.pow(2.0, this.mAntiDerBounds.size());
            if (this.mAntiDerBounds.size() > 5) {
                ILogger logger = services.getLoggingService().getLogger(this.getClass());
                logger.warn((Object)("Constructing " + numberOfCorrespondingFiniteJuncts + "(two to the power of " + this.mAntiDerBounds.size() + " dual juncts."));
            }
            Term[] correspondingFiniteJuncts = new Term[numberOfCorrespondingFiniteJuncts];
            int i = 0;
            while (i < numberOfCorrespondingFiniteJuncts) {
                if (!services.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "build " + i + " of " + numberOfCorrespondingFiniteJuncts + " xjuncts");
                }
                ArrayList<ExplicitLhsPolynomialRelation> lowerBounds = new ArrayList<ExplicitLhsPolynomialRelation>(this.mLowerBounds);
                ArrayList<ExplicitLhsPolynomialRelation> upperBounds = new ArrayList<ExplicitLhsPolynomialRelation>(this.mUpperBounds);
                int k = 0;
                while (k < this.mAntiDerBounds.size()) {
                    if (BigInteger.valueOf(i).testBit(k)) {
                        upperBounds.add((ExplicitLhsPolynomialRelation)this.mAntiDerBounds.get(k).getSecond());
                    } else {
                        lowerBounds.add((ExplicitLhsPolynomialRelation)this.mAntiDerBounds.get(k).getFirst());
                    }
                    ++k;
                }
                correspondingFiniteJuncts[i] = this.buildDualFiniteJunction(script, quantifier, bannedForDivCapture, lowerBounds, upperBounds);
                if (correspondingFiniteJuncts[i] == null) {
                    return null;
                }
                ++i;
            }
            return QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, correspondingFiniteJuncts);
        }

        private Term buildDualFiniteJunction(Script script, int quantifier, Set<TermVariable> bannedForDivCapture, List<ExplicitLhsPolynomialRelation> lowerBounds, List<ExplicitLhsPolynomialRelation> upperBounds) {
            if (lowerBounds.isEmpty() || upperBounds.isEmpty()) {
                boolean bvSingleDirectionBounds;
                boolean bl = bvSingleDirectionBounds = SmtSortUtils.isBitvecSort(this.mSort) && lowerBounds.isEmpty() != upperBounds.isEmpty();
                if (bvSingleDirectionBounds) {
                    return this.checkforSingleDirectionBounds(script, lowerBounds, upperBounds, quantifier);
                }
                return QuantifierUtils.applyDualFiniteConnective(script, quantifier, new Term[0]);
            }
            Pair<List<ExplicitLhsPolynomialRelation>, List<ExplicitLhsPolynomialRelation>> bounds = this.preprocessBounds(script, bannedForDivCapture, lowerBounds, upperBounds);
            if (bounds == null) {
                return null;
            }
            List preprocessedLowerBounds = (List)bounds.getFirst();
            List preprocessedUpperBounds = (List)bounds.getSecond();
            if ((long)preprocessedLowerBounds.size() * (long)preprocessedUpperBounds.size() >= Integer.MAX_VALUE) {
                throw new UnsupportedOperationException(String.format("Size of result too large: %s xjuncts", (long)preprocessedLowerBounds.size() * (long)preprocessedUpperBounds.size()));
            }
            Term[] allCombinations = new Term[preprocessedLowerBounds.size() * preprocessedUpperBounds.size()];
            int i = 0;
            for (ExplicitLhsPolynomialRelation lower : preprocessedLowerBounds) {
                for (ExplicitLhsPolynomialRelation upper : preprocessedUpperBounds) {
                    allCombinations[i] = this.combine(script, quantifier, lower, upper);
                    if (allCombinations[i] == null) {
                        return null;
                    }
                    ++i;
                }
            }
            return QuantifierUtils.applyDualFiniteConnective(script, quantifier, allCombinations);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Pair<List<ExplicitLhsPolynomialRelation>, List<ExplicitLhsPolynomialRelation>> preprocessBounds(Script script, Set<TermVariable> bannedForDivCapture, List<ExplicitLhsPolynomialRelation> inputLowerBounds, List<ExplicitLhsPolynomialRelation> inputUpperBounds) {
            List<ExplicitLhsPolynomialRelation> outputUpperBounds;
            List<ExplicitLhsPolynomialRelation> ouputLowerBounds;
            boolean trylowerBoundsFirst;
            int nonOneLowerCoefficients = ExplicitLhsPolynomialRelations.countNonOneCoefficients(inputLowerBounds);
            int nonOneUpperCoefficients = ExplicitLhsPolynomialRelations.countNonOneCoefficients(inputUpperBounds);
            if (nonOneLowerCoefficients == 0 || nonOneUpperCoefficients == 0) {
                return new Pair(inputLowerBounds, inputUpperBounds);
            }
            boolean bl = trylowerBoundsFirst = nonOneLowerCoefficients < nonOneUpperCoefficients || nonOneLowerCoefficients == nonOneUpperCoefficients && inputLowerBounds.size() >= inputUpperBounds.size();
            if (trylowerBoundsFirst) {
                List<ExplicitLhsPolynomialRelation> solvedLower = this.solve(script, bannedForDivCapture, inputLowerBounds);
                if (solvedLower != null) {
                    ouputLowerBounds = solvedLower;
                    outputUpperBounds = inputUpperBounds;
                    return new Pair(ouputLowerBounds, outputUpperBounds);
                } else {
                    List<ExplicitLhsPolynomialRelation> solvedUpper = this.solve(script, bannedForDivCapture, inputUpperBounds);
                    if (solvedUpper == null) return null;
                    ouputLowerBounds = inputLowerBounds;
                    outputUpperBounds = solvedUpper;
                }
                return new Pair(ouputLowerBounds, outputUpperBounds);
            } else {
                List<ExplicitLhsPolynomialRelation> solvedUpper = this.solve(script, bannedForDivCapture, inputUpperBounds);
                if (solvedUpper != null) {
                    ouputLowerBounds = inputLowerBounds;
                    outputUpperBounds = solvedUpper;
                    return new Pair(ouputLowerBounds, outputUpperBounds);
                } else {
                    List<ExplicitLhsPolynomialRelation> solvedLower = this.solve(script, bannedForDivCapture, inputLowerBounds);
                    if (solvedLower == null) return null;
                    ouputLowerBounds = solvedLower;
                    outputUpperBounds = inputUpperBounds;
                }
            }
            return new Pair(ouputLowerBounds, outputUpperBounds);
        }

        private List<ExplicitLhsPolynomialRelation> solve(Script script, Set<TermVariable> bannedForDivCapture, List<ExplicitLhsPolynomialRelation> bounds) {
            ArrayList<ExplicitLhsPolynomialRelation> result = new ArrayList<ExplicitLhsPolynomialRelation>(bounds.size());
            for (ExplicitLhsPolynomialRelation bound : bounds) {
                if (bound.getLhsCoefficient().equals((Object)Rational.ONE)) {
                    result.add(bound);
                    continue;
                }
                Pair<ExplicitLhsPolynomialRelation, Term> solvedBound = bound.divideByIntegerCoefficient(script, bannedForDivCapture);
                if (solvedBound == null) {
                    return null;
                }
                if (solvedBound.getSecond() != null) {
                    throw new AssertionError();
                }
                result.add((ExplicitLhsPolynomialRelation)solvedBound.getFirst());
            }
            return result;
        }

        @Deprecated
        private static boolean allCoefficientsOne(List<ExplicitLhsPolynomialRelation> bounds) {
            for (ExplicitLhsPolynomialRelation bound : bounds) {
                if (!bound.getLhsMonomial().isLinear()) {
                    throw new AssertionError((Object)"cannot handle proper monomial");
                }
                if (bound.getLhsCoefficient().isNegative()) {
                    throw new AssertionError((Object)"cannot handle negative coefficients");
                }
                if (bound.getLhsCoefficient().equals((Object)Rational.ONE)) continue;
                return false;
            }
            return true;
        }

        private static int countNonOneCoefficients(List<ExplicitLhsPolynomialRelation> bounds) {
            int number = 0;
            for (ExplicitLhsPolynomialRelation bound : bounds) {
                if (!bound.getLhsMonomial().isLinear()) {
                    throw new AssertionError((Object)"cannot handle proper monomial");
                }
                if (bound.getLhsCoefficient().isNegative()) {
                    throw new AssertionError((Object)"cannot handle negative coefficients");
                }
                if (bound.getLhsCoefficient().equals((Object)Rational.ONE)) continue;
                ++number;
            }
            return number;
        }

        private Term combine(Script script, int quantifier, ExplicitLhsPolynomialRelation lower, ExplicitLhsPolynomialRelation upper) {
            Term result;
            Pair<RelationSymbol, Rational> relSymbAndOffset = DualJunctionTir.computeRelationSymbolAndOffset(quantifier, lower.getRelationSymbol(), upper.getRelationSymbol(), lower.getRhs().getSort());
            assert (((Rational)relSymbAndOffset.getSecond()).equals((Object)Rational.ZERO) || ((Rational)relSymbAndOffset.getSecond()).equals((Object)Rational.ONE) || ((Rational)relSymbAndOffset.getSecond()).equals((Object)Rational.MONE));
            IPolynomialTerm lhs = lower.getRhs();
            IPolynomialTerm rhs = upper.getRhs();
            if (SmtSortUtils.isBitvecSort(lower.getRhs().getSort())) {
                assert (lower.getLhsCoefficient().equals((Object)Rational.ONE) && upper.getLhsCoefficient().equals((Object)Rational.ONE)) : "Both coefficients must be one";
                result = !((Rational)relSymbAndOffset.getSecond()).equals((Object)Rational.ZERO) ? null : ((RelationSymbol)((Object)relSymbAndOffset.getFirst())).constructTerm(script, lhs.toTerm(script), rhs.toTerm(script));
            } else {
                assert (lower.getLhsCoefficient().equals((Object)Rational.ONE) || upper.getLhsCoefficient().equals((Object)Rational.ONE)) : "At least one coefficient must be one";
                if (!((Rational)relSymbAndOffset.getSecond()).equals((Object)Rational.ZERO)) {
                    throw new AssertionError((Object)"Offset must be zero for non-bitvectors");
                }
                IPolynomialTerm resultLhs = !upper.getLhsCoefficient().equals((Object)Rational.ONE) ? lhs.mul(upper.getLhsCoefficient()) : lhs;
                IPolynomialTerm resultRhs = !lower.getLhsCoefficient().equals((Object)Rational.ONE) ? rhs.mul(lower.getLhsCoefficient()) : rhs;
                result = new PolynomialRelation(PolynomialRelation.TransformInequality.NO_TRANFORMATION, (RelationSymbol)((Object)relSymbAndOffset.getFirst()), (AbstractGeneralizedAffineTerm)resultLhs, (AbstractGeneralizedAffineTerm)resultRhs).positiveNormalForm(script);
            }
            return result;
        }

        private static enum Direction {
            UPPER,
            LOWER;

        }
    }
}

