/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTaskSimple;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class EliminationTask
extends EliminationTaskSimple {
    private final Context mContext;

    public EliminationTask(int quantifier, Set<TermVariable> eliminatees, Term term, Context context) {
        super(quantifier, eliminatees, term, context.getBoundByAncestors());
        this.mContext = context;
    }

    public EliminationTask(QuantifiedFormula quantifiedFormula, Context context) {
        super(quantifiedFormula, context.getBoundByAncestors());
        this.mContext = context;
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public EliminationTask integrateNewEliminatees(Collection<TermVariable> additionalEliminatees) {
        LinkedHashSet<TermVariable> additionalOccuringEliminatees = QuantifierUtils.projectToFreeVars(additionalEliminatees, this.getTerm());
        HashSet<TermVariable> resultEliminatees = new HashSet<TermVariable>(this.getEliminatees());
        boolean modified = resultEliminatees.addAll(additionalOccuringEliminatees);
        if (modified) {
            return new EliminationTask(this.getQuantifier(), resultEliminatees, this.getTerm(), this.mContext);
        }
        return this;
    }

    @Override
    public EliminationTask update(Set<TermVariable> newEliminatees, Term term) {
        return new EliminationTask(this.getQuantifier(), newEliminatees, term, this.mContext);
    }

    @Override
    public EliminationTask update(Term term) {
        return new EliminationTask(this.getQuantifier(), this.getEliminatees(), term, this.mContext);
    }

    public Pair<Term, EliminationTask> makeTight(IUltimateServiceProvider services, ManagedScript mgdScript) {
        Term[] dualJuncts = QuantifierUtils.getDualFiniteJunction(this.getQuantifier(), this.getTerm());
        ArrayList<Term> dualJunctsWithEliminatee = new ArrayList<Term>();
        ArrayList<Term> dualJunctsWithoutEliminatee = new ArrayList<Term>();
        Term[] termArray = dualJuncts;
        int n = dualJuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term dualJunct = termArray[n2];
            if (DataStructureUtils.haveEmptyIntersection(this.getEliminatees(), new HashSet<TermVariable>(Arrays.asList(dualJunct.getFreeVars())))) {
                dualJunctsWithoutEliminatee.add(dualJunct);
            } else {
                dualJunctsWithEliminatee.add(dualJunct);
            }
            ++n2;
        }
        if (dualJunctsWithoutEliminatee.isEmpty()) {
            return null;
        }
        Term dualJunctionWithoutEliminatee = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), this.getQuantifier(), dualJunctsWithoutEliminatee);
        Term dualJunctionWithEliminatee = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), this.getQuantifier(), dualJunctsWithEliminatee);
        Context newContext = this.getContext().constructChildContextForConDis(services, mgdScript, ((ApplicationTerm)this.getTerm()).getFunction(), dualJunctsWithoutEliminatee);
        return new Pair((Object)dualJunctionWithoutEliminatee, (Object)new EliminationTask(this.getQuantifier(), this.getEliminatees(), dualJunctionWithEliminatee, newContext));
    }
}

