/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class EliminationTaskSimple {
    private static final boolean DEBUG_USE_TO_STRING_DIRECT = false;
    private final int mQuantifier;
    private final LinkedHashSet<TermVariable> mEliminatees;
    private final Term mTerm;
    private final Set<TermVariable> mBoundByAncestors;

    @Deprecated
    public EliminationTaskSimple(int quantifier, Set<TermVariable> eliminatees, Term term, Set<TermVariable> boundByAncestors) {
        assert (quantifier == 0 || quantifier == 1);
        this.mQuantifier = quantifier;
        this.mEliminatees = QuantifierUtils.projectToFreeVars(eliminatees, term);
        this.mTerm = term;
        this.mBoundByAncestors = boundByAncestors;
    }

    @Deprecated
    public EliminationTaskSimple(int quantifier, Set<TermVariable> eliminatees, Term term) {
        assert (quantifier == 0 || quantifier == 1);
        this.mQuantifier = quantifier;
        this.mEliminatees = QuantifierUtils.projectToFreeVars(eliminatees, term);
        this.mTerm = term;
        this.mBoundByAncestors = Collections.emptySet();
    }

    @Deprecated
    public EliminationTaskSimple(QuantifiedFormula quantifiedFormula) {
        this.mQuantifier = quantifiedFormula.getQuantifier();
        this.mEliminatees = QuantifierUtils.projectToFreeVars(Arrays.asList(quantifiedFormula.getVariables()), quantifiedFormula.getSubformula());
        this.mTerm = quantifiedFormula.getSubformula();
        this.mBoundByAncestors = Collections.emptySet();
    }

    @Deprecated
    public EliminationTaskSimple(QuantifiedFormula quantifiedFormula, Set<TermVariable> boundByAncestors) {
        this.mQuantifier = quantifiedFormula.getQuantifier();
        this.mEliminatees = QuantifierUtils.projectToFreeVars(Arrays.asList(quantifiedFormula.getVariables()), quantifiedFormula.getSubformula());
        this.mTerm = quantifiedFormula.getSubformula();
        this.mBoundByAncestors = boundByAncestors;
    }

    public int getQuantifier() {
        return this.mQuantifier;
    }

    public Set<TermVariable> getEliminatees() {
        return Collections.unmodifiableSet(this.mEliminatees);
    }

    @Deprecated
    public Set<TermVariable> getBoundByAncestors() {
        return Collections.unmodifiableSet(this.mBoundByAncestors);
    }

    public Term getTerm() {
        return this.mTerm;
    }

    public Term toTerm(Script script) {
        if (this.mEliminatees.isEmpty()) {
            return this.mTerm;
        }
        return script.quantifier(this.mQuantifier, this.mEliminatees.toArray(new TermVariable[this.mEliminatees.size()]), this.mTerm, (Term[][])new Term[0][]);
    }

    public EliminationTaskSimple integrateNewEliminatees(Collection<TermVariable> additionalEliminatees) {
        HashSet<TermVariable> resultEliminatees = new HashSet<TermVariable>(this.mEliminatees);
        LinkedHashSet<TermVariable> additionalOccuringEliminatees = QuantifierUtils.projectToFreeVars(additionalEliminatees, this.mTerm);
        boolean modified = resultEliminatees.addAll(additionalOccuringEliminatees);
        if (modified) {
            return new EliminationTaskSimple(this.mQuantifier, resultEliminatees, this.mTerm, this.mBoundByAncestors);
        }
        return this;
    }

    public EliminationTaskSimple update(Set<TermVariable> newEliminatees, Term term) {
        return new EliminationTaskSimple(this.mQuantifier, newEliminatees, term, this.mBoundByAncestors);
    }

    public EliminationTaskSimple update(Term term) {
        return new EliminationTaskSimple(this.mQuantifier, this.mEliminatees, term, this.mBoundByAncestors);
    }

    public String toString() {
        String quantifier = this.getQuantifier() == 0 ? "\u2203" : "\u2200";
        String vars = this.getEliminatees().toString();
        String term = this.getTerm().toString();
        return String.valueOf(quantifier) + " " + vars + ". " + term;
    }

    public static Script.LBool areDistinct(Script script, EliminationTaskSimple et1, EliminationTaskSimple et2) {
        Term espTerm = et1.toTerm(script);
        Term sosTerm = et2.toTerm(script);
        Script.LBool sat = Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{espTerm, sosTerm}));
        return sat;
    }
}

