/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashSet;
import java.util.Set;

public class EqualityInformation {
    private final int mIndex;
    private final Term mGivenTerm;
    private final Term mEqualTerm;
    private final RelationSymbol mRelationSymbol;

    public EqualityInformation(int index, Term givenTerm, Term equalTerm, RelationSymbol relationSymbol) {
        this.mIndex = index;
        this.mGivenTerm = givenTerm;
        this.mEqualTerm = equalTerm;
        this.mRelationSymbol = relationSymbol;
    }

    @Deprecated
    public int getIndex() {
        return this.mIndex;
    }

    public Term getGivenTerm() {
        return this.mGivenTerm;
    }

    public Term getRelatedTerm() {
        return this.mEqualTerm;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public static EqualityInformation getEqinfo(Script script, Term givenTerm, Term[] context, Term forbiddenTerm, int quantifier) {
        EqualityInformation eqInfo;
        BinaryEqualityRelation[] binaryRelations = new BinaryEqualityRelation[context.length];
        int i = 0;
        while (i < context.length) {
            if (EqualityInformation.isSubterm(givenTerm, context[i])) {
                binaryRelations[i] = BinaryEqualityRelation.convert(context[i]);
                if (binaryRelations[i] != null) {
                    if (binaryRelations[i].getRelationSymbol().equals((Object)RelationSymbol.EQ) && quantifier == 1) {
                        binaryRelations[i] = null;
                    } else if (binaryRelations[i].getRelationSymbol().equals((Object)RelationSymbol.DISTINCT) && quantifier == 0) {
                        binaryRelations[i] = null;
                    } else {
                        BinaryEqualityRelation ber = binaryRelations[i];
                        eqInfo = EqualityInformation.getEqinfo(givenTerm, ber, forbiddenTerm, i);
                        SolvedBinaryRelation sbr = ber.solveForSubject(script, givenTerm);
                        if (sbr != null && SmtUtils.isSubterm(sbr.getRightHandSide(), forbiddenTerm)) {
                            sbr = null;
                        }
                        assert (sbr == null == (eqInfo == null)) : "sbr: " + sbr + " eqInfo: " + eqInfo;
                        if (eqInfo != null) {
                            return eqInfo;
                        }
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < context.length) {
            PolynomialRelation polyRel;
            if (binaryRelations[i] != null && (polyRel = PolynomialRelation.convert(script, context[i])) != null && (eqInfo = EqualityInformation.getEqinfo(script, givenTerm, polyRel, forbiddenTerm, i)) != null) {
                return eqInfo;
            }
            ++i;
        }
        return null;
    }

    public static EqualityInformation getEqinfo(Script script, Term givenTerm, PolynomialRelation polyRel, Term forbiddenTerm, int i) {
        if (polyRel.isVariable(givenTerm)) {
            SolvedBinaryRelation sbr = polyRel.solveForSubject(script, givenTerm);
            if (sbr == null) {
                return null;
            }
            Term equalTerm = sbr.getRightHandSide();
            if (forbiddenTerm != null && EqualityInformation.isSubterm(forbiddenTerm, equalTerm)) {
                return null;
            }
            return new EqualityInformation(i, givenTerm, equalTerm, polyRel.getRelationSymbol());
        }
        return null;
    }

    public static EqualityInformation getEqinfo(Term givenTerm, BinaryEqualityRelation ber, Term forbiddenTerm, int i) {
        Term lhs = ber.getLhs();
        Term rhs = ber.getRhs();
        if (!(!lhs.equals(givenTerm) || EqualityInformation.isSubterm(givenTerm, rhs) || forbiddenTerm != null && EqualityInformation.isSubterm(forbiddenTerm, rhs))) {
            return new EqualityInformation(i, givenTerm, rhs, ber.getRelationSymbol());
        }
        if (!(!rhs.equals(givenTerm) || EqualityInformation.isSubterm(givenTerm, lhs) || forbiddenTerm != null && EqualityInformation.isSubterm(forbiddenTerm, lhs))) {
            return new EqualityInformation(i, givenTerm, lhs, ber.getRelationSymbol());
        }
        return null;
    }

    public static Pair<Set<Term>, Set<Term>> getEqTerms(Script script, Term givenTerm, Term[] context, Term forbiddenTerm) {
        HashSet<Term> equivalentTerms = new HashSet<Term>();
        HashSet<Term> disjointTerms = new HashSet<Term>();
        int i = 0;
        while (i < context.length) {
            EqualityInformation eqInfo;
            PolynomialRelation polyRel = PolynomialRelation.convert(script, context[i]);
            if (polyRel != null && (eqInfo = EqualityInformation.getEqinfo(script, givenTerm, polyRel, forbiddenTerm, i)) != null) {
                switch (eqInfo.getRelationSymbol()) {
                    case DISTINCT: {
                        disjointTerms.add(eqInfo.getRelatedTerm());
                        break;
                    }
                    case EQ: {
                        equivalentTerms.add(eqInfo.getRelatedTerm());
                        break;
                    }
                    case LEQ: 
                    case GEQ: 
                    case LESS: 
                    case GREATER: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            ++i;
        }
        return new Pair(equivalentTerms, disjointTerms);
    }

    private static boolean isSubterm(Term subterm, Term term) {
        return SmtUtils.isSubterm(term, subterm);
    }
}

