/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.LinkedHashRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ParameterPartition {
    private final boolean mIsPartitionTrivial;
    private Term mTermWithPushedQuantifier;

    public ParameterPartition(Script script, EliminationTask et) {
        Term[] params = QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm());
        if (params.length == 1) {
            throw new IllegalArgumentException("Expected dual finite junction");
        }
        LinkedHashRelation quantifiedVars2param = new LinkedHashRelation();
        LinkedHashRelation param2quantifiedVars = new LinkedHashRelation();
        UnionFind uf = new UnionFind();
        Term[] termArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Term xjunct = termArray[n2];
            TermVariable[] termVariableArray = xjunct.getFreeVars();
            int n3 = termVariableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TermVariable tv = termVariableArray[n4];
                if (et.getEliminatees().contains(tv)) {
                    quantifiedVars2param.addPair((Object)tv, (Object)xjunct);
                    param2quantifiedVars.addPair((Object)xjunct, (Object)tv);
                }
                ++n4;
            }
            uf.makeEquivalenceClass((Object)xjunct);
            ++n2;
        }
        for (TermVariable tv : quantifiedVars2param.getDomain()) {
            uf.union((Collection)quantifiedVars2param.getImage((Object)tv));
        }
        Collection equivalenceClasses = uf.getAllEquivalenceClasses();
        boolean bl = this.mIsPartitionTrivial = equivalenceClasses.size() == 1;
        if (!this.mIsPartitionTrivial) {
            ArrayList<Term> resultParams = new ArrayList<Term>(equivalenceClasses.size());
            for (Set equivalenceClass : equivalenceClasses) {
                HashSet<TermVariable> quantifiedVarsInClass = new HashSet<TermVariable>();
                for (Term term : equivalenceClass) {
                    quantifiedVarsInClass.addAll(param2quantifiedVars.getImage((Object)term));
                }
                Term connectedEquivalenceClass = QuantifierUtils.applyDualFiniteConnective(script, et.getQuantifier(), equivalenceClass);
                Term quantified = SmtUtils.quantifier(script, et.getQuantifier(), quantifiedVarsInClass, connectedEquivalenceClass);
                resultParams.add(quantified);
            }
            this.mTermWithPushedQuantifier = QuantifierUtils.applyDualFiniteConnective(script, et.getQuantifier(), resultParams);
        }
    }

    public boolean isIsPartitionTrivial() {
        return this.mIsPartitionTrivial;
    }

    public Term getTermWithPushedQuantifier() {
        return this.mTermWithPushedQuantifier;
    }
}

