/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IteRemover;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTaskSimple;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfIrd;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfTir;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfUpd;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfUsr;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ElimStore3;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ElimStorePlain;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PartialQuantifierElimination {
    private static final boolean USE_UPD = true;
    private static final boolean USE_IRD = true;
    private static final boolean USE_TIR = true;
    private static final boolean USE_SSD = true;
    private static final boolean USE_AQE = false;
    private static final boolean USE_SOS = false;
    private static final boolean USE_USR = false;
    private static final boolean USE_PUSH_PULL = true;
    private static final boolean DEBUG_EXTENDED_RESULT_CHECK = false;
    private static final boolean DEBUG_APPLY_ARRAY_PQE_ALSO_TO_NEGATION = false;
    private static final boolean THROW_ERROR_IF_NOT_ALL_QUANTIFIERS_REMOVED = false;
    private static final boolean CORONA_QUANTIFIER_ELIMINATION = true;

    public static Term eliminate(IUltimateServiceProvider services, ManagedScript mgdScript, Term term, SmtUtils.SimplificationTechnique simplificationTechnique) {
        Term tmp = PartialQuantifierElimination.eliminateLight(services, mgdScript, term);
        return QuantifierPushTermWalker.eliminate(services, mgdScript, true, QuantifierPusher.PqeTechniques.ALL, simplificationTechnique, tmp);
    }

    public static Term eliminateLight(IUltimateServiceProvider services, ManagedScript mgdScript, Term term) {
        Term withoutIte = new IteRemover(mgdScript).transform(term);
        Term nnf = new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.KEEP).transform(withoutIte);
        Term chnf = new CommuhashNormalForm(services, mgdScript.getScript()).transform(nnf);
        Term result = QuantifierPushTermWalker.eliminate(services, mgdScript, false, QuantifierPusher.PqeTechniques.LIGHT, SmtUtils.SimplificationTechnique.NONE, chnf);
        assert (CommuhashUtils.isInCommuhashNormalForm(result, CommuhashUtils.COMMUTATIVE_OPERATORS)) : "Output not in commuhash form";
        return result;
    }

    public static Term eliminateCompat(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, QuantifierPusher.PqeTechniques quantifierEliminationTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Term term) {
        Term tmp = PartialQuantifierElimination.eliminateLight(services, mgdScript, term);
        return QuantifierPushTermWalker.eliminate(services, mgdScript, applyDistributivity, quantifierEliminationTechniques, simplificationTechnique, tmp);
    }

    public static Term eliminateCompat(IUltimateServiceProvider services, ManagedScript mgdScript, SmtUtils.SimplificationTechnique simplificationTechnique, Term term) {
        return PartialQuantifierElimination.eliminateCompat(services, mgdScript, true, QuantifierPusher.PqeTechniques.ALL, simplificationTechnique, term);
    }

    @Deprecated
    public static Term tryToEliminate(IUltimateServiceProvider services, ILogger logger, ManagedScript mgdScript, Term term, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        Term pushed = QuantifierPusher.eliminate(services, mgdScript, true, QuantifierPusher.PqeTechniques.ALL_LOCAL, simplificationTechnique, term);
        Term pnf = new PrenexNormalForm(mgdScript).transform(pushed);
        QuantifierSequence qs = new QuantifierSequence(mgdScript, pnf);
        Term matrix = qs.getInnerTerm();
        List<QuantifierSequence.QuantifiedVariables> qvs = qs.getQuantifierBlocks();
        Term result = matrix;
        int i = qvs.size() - 1;
        while (i >= 0) {
            QuantifierSequence.QuantifiedVariables qv = qvs.get(i);
            HashSet<TermVariable> eliminatees = new HashSet<TermVariable>(qv.getVariables());
            try {
                result = PartialQuantifierElimination.elim(mgdScript, qv.getQuantifier(), eliminatees, result, services, logger, simplificationTechnique, xnfConversionTechnique);
            }
            catch (ToolchainCanceledException tce) {
                RunningTaskInfo rti = new RunningTaskInfo(PartialQuantifierElimination.class, "eliminating quantifiers from formula with " + (qvs.size() - 1) + " quantifier alternations");
                tce.addRunningTaskInfo(rti);
                throw tce;
            }
            result = SmtUtils.quantifier(mgdScript.getScript(), qv.getQuantifier(), eliminatees, result);
            result = QuantifierPusher.eliminate(services, mgdScript, true, QuantifierPusher.PqeTechniques.ONLY_DER, simplificationTechnique, result);
            --i;
        }
        return result;
    }

    @Deprecated
    public static Term quantifier(IUltimateServiceProvider services, ILogger logger, ManagedScript mgdScript, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique, int quantifier, Collection<TermVariable> vars, Term body, Term[] ... patterns) {
        Set<TermVariable> varSet = PartialQuantifierElimination.constructIntersectionWithFreeVars(vars, body);
        if (varSet.isEmpty()) {
            return body;
        }
        Term elim = body;
        if (!((elim = PartialQuantifierElimination.elimPushPull(mgdScript, quantifier, varSet, elim, services, logger)) instanceof QuantifiedFormula)) {
            return elim;
        }
        QuantifiedFormula qf = (QuantifiedFormula)elim;
        varSet = new HashSet<TermVariable>(Arrays.asList(qf.getVariables()));
        elim = qf.getSubformula();
        try {
            elim = PartialQuantifierElimination.elim(mgdScript, quantifier, varSet, elim, services, logger, simplificationTechnique, xnfConversionTechnique);
        }
        catch (ToolchainCanceledException tce) {
            tce.addRunningTaskInfo(new RunningTaskInfo(PartialQuantifierElimination.class, "eliminating quantifiers"));
            throw tce;
        }
        if (varSet.isEmpty()) {
            return elim;
        }
        return mgdScript.getScript().quantifier(quantifier, varSet.toArray(new TermVariable[varSet.size()]), elim, patterns);
    }

    @Deprecated
    public static Term quantifierCustom(IUltimateServiceProvider services, ILogger logger, ManagedScript mgdScript, QuantifierPusher.PqeTechniques techniques, int quantifier, Collection<TermVariable> vars, Term body, Term[] ... patterns) {
        Set<TermVariable> varSet = PartialQuantifierElimination.constructIntersectionWithFreeVars(vars, body);
        if (varSet.isEmpty()) {
            return body;
        }
        Term elim = PartialQuantifierElimination.elimPushPull(mgdScript, quantifier, varSet, body, services, logger, techniques);
        if (elim instanceof QuantifiedFormula) {
            QuantifiedFormula qf = (QuantifiedFormula)elim;
            return mgdScript.getScript().quantifier(quantifier, qf.getVariables(), qf.getSubformula(), patterns);
        }
        return elim;
    }

    private static Set<TermVariable> constructIntersectionWithFreeVars(Collection<TermVariable> vars, Term term) {
        HashSet<TermVariable> freeVars = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        HashSet<TermVariable> occurringVars = new HashSet<TermVariable>();
        for (TermVariable tv : vars) {
            if (!freeVars.contains(tv)) continue;
            occurringVars.add(tv);
        }
        return occurringVars;
    }

    @Deprecated
    public static Term elimPushPull(ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, Term term, IUltimateServiceProvider services, ILogger logger) {
        return PartialQuantifierElimination.elimPushPull(mgdScript, quantifier, eliminatees, term, services, logger, QuantifierPusher.PqeTechniques.ALL_LOCAL);
    }

    private static Term elimPushPull(ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, Term term, IUltimateServiceProvider services, ILogger logger, QuantifierPusher.PqeTechniques techniques) {
        Term withoutIte = new IteRemover(mgdScript).transform(term);
        Term nnf = new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.KEEP).transform(withoutIte);
        Term quantified = mgdScript.getScript().quantifier(quantifier, eliminatees.toArray(new TermVariable[eliminatees.size()]), nnf, (Term[][])new Term[0][]);
        Term pushed = QuantifierPusher.eliminate(services, mgdScript, true, techniques, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, quantified);
        Term pnf = new PrenexNormalForm(mgdScript).transform(pushed);
        return pnf;
    }

    @Deprecated
    public static Term elim(ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, Term term, IUltimateServiceProvider services, ILogger logger, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        Term termAfterDER;
        Script script = mgdScript.getScript();
        HashSet<TermVariable> occuringVars = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        Iterator<TermVariable> it = eliminatees.iterator();
        while (it.hasNext()) {
            TermVariable tv = it.next();
            if (occuringVars.contains(tv)) continue;
            it.remove();
        }
        if (eliminatees.isEmpty()) {
            return term;
        }
        Term result = new IteRemover(mgdScript).transform(term);
        result = QuantifierUtils.transformToXnf(services, script, quantifier, mgdScript, result, xnfConversionTechnique);
        XnfDer xnfDer = new XnfDer(mgdScript, services);
        Term[] oldParams = QuantifierUtils.getXjunctsOuter(quantifier, result);
        Term[] newParams = new Term[oldParams.length];
        int i = 0;
        while (i < oldParams.length) {
            HashSet<TermVariable> eliminateesDER = new HashSet<TermVariable>(eliminatees);
            Term[] oldAtoms = QuantifierUtils.getXjunctsInner(quantifier, oldParams[i]);
            newParams[i] = QuantifierUtils.applyDualFiniteConnective(script, quantifier, Arrays.asList(xnfDer.tryToEliminate(quantifier, oldAtoms, eliminateesDER)));
            ++i;
        }
        result = termAfterDER = QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, newParams);
        HashSet<TermVariable> remainingAfterDER = new HashSet<TermVariable>(eliminatees);
        remainingAfterDER.retainAll(Arrays.asList(result.getFreeVars()));
        eliminatees.retainAll(remainingAfterDER);
        if (eliminatees.isEmpty()) {
            return result;
        }
        result = PartialQuantifierElimination.applyInfinityRestrictorDrop(mgdScript, quantifier, eliminatees, services, script, result);
        if (eliminatees.isEmpty()) {
            return result;
        }
        result = PartialQuantifierElimination.applyTir(mgdScript, quantifier, eliminatees, services, xnfConversionTechnique, script, result);
        if (eliminatees.isEmpty()) {
            return result;
        }
        result = PartialQuantifierElimination.applyUnconnectedParameterDeletion(mgdScript, quantifier, eliminatees, services, xnfConversionTechnique, script, result);
        long startTime = System.currentTimeMillis();
        EliminationTaskSimple inputEliminationTask = new EliminationTaskSimple(quantifier, eliminatees, result);
        EliminationTaskSimple esp = new ElimStorePlain(mgdScript, services, simplificationTechnique).startRecursiveElimination(new EliminationTaskSimple(quantifier, eliminatees, result));
        assert (!mgdScript.isLocked()) : "Solver still locked";
        long duration = System.currentTimeMillis() - startTime;
        assert (PartialQuantifierElimination.validateEquivalence(script, inputEliminationTask, esp, logger, "SDD")) : "Array QEs incorrect. Esp: " + esp + " Input:" + inputEliminationTask;
        result = esp.getTerm();
        eliminatees.clear();
        eliminatees.addAll(esp.getEliminatees());
        if (eliminatees.isEmpty()) {
            return result;
        }
        boolean sosChangedTerm = false;
        if (eliminatees.isEmpty()) {
            return result;
        }
        eliminatees.retainAll(Arrays.asList(result.getFreeVars()));
        if (sosChangedTerm) {
            result = PartialQuantifierElimination.elim(mgdScript, quantifier, eliminatees, result, services, logger, simplificationTechnique, xnfConversionTechnique);
        }
        if (eliminatees.isEmpty()) {
            return result;
        }
        assert (Arrays.asList(result.getFreeVars()).containsAll(eliminatees)) : "superficial variables";
        return result;
    }

    private static boolean validateEquivalence(Script script, EliminationTaskSimple inputEliminationTask, EliminationTaskSimple esp, ILogger logger, String name) {
        Script.LBool sat = EliminationTaskSimple.areDistinct(script, esp, inputEliminationTask);
        if (sat == Script.LBool.UNKNOWN) {
            logger.warn((Object)("Trying to double check " + name + " result, but SMT solver's response was UNKNOWN."));
            logger.warn((Object)("Input elimination task: " + inputEliminationTask));
            logger.warn((Object)("ElimStorePlain result: " + esp));
        }
        return sat != Script.LBool.SAT;
    }

    private static Term applyInfinityRestrictorDrop(ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, IUltimateServiceProvider services, Script script, Term resultOld) {
        XnfIrd xnfIRD = new XnfIrd(mgdScript, services);
        Term[] oldParams = QuantifierUtils.getXjunctsOuter(quantifier, resultOld);
        Term[] newParams = new Term[oldParams.length];
        int i = 0;
        while (i < oldParams.length) {
            HashSet<TermVariable> eliminateesIRD = new HashSet<TermVariable>(eliminatees);
            Term[] oldAtoms = QuantifierUtils.getXjunctsInner(quantifier, oldParams[i]);
            newParams[i] = QuantifierUtils.applyDualFiniteConnective(script, quantifier, Arrays.asList(xnfIRD.tryToEliminate(quantifier, oldAtoms, eliminateesIRD)));
            ++i;
        }
        Term termAfterIRD = QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, newParams);
        HashSet<TermVariable> remainingAfterIRD = new HashSet<TermVariable>(eliminatees);
        remainingAfterIRD.retainAll(Arrays.asList(termAfterIRD.getFreeVars()));
        eliminatees.retainAll(remainingAfterIRD);
        return termAfterIRD;
    }

    private static Term applyTir(ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, IUltimateServiceProvider services, SmtUtils.XnfConversionTechnique xnfConversionTechnique, Script script, Term resultOld) {
        XnfTir xnfTir = new XnfTir(mgdScript, services, xnfConversionTechnique);
        Term termAfterTIR = PartialQuantifierElimination.applyEliminationOuter(script, quantifier, eliminatees, resultOld, xnfTir, services, mgdScript, xnfConversionTechnique);
        return termAfterTIR;
    }

    private static Term applyUnconnectedParameterDeletion(ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, IUltimateServiceProvider services, SmtUtils.XnfConversionTechnique xnfConversionTechnique, Script script, Term resultOld) {
        XnfUpd xnfUpd = new XnfUpd(mgdScript, services);
        Term termAfterUPD = PartialQuantifierElimination.applyEliminationOuter(script, quantifier, eliminatees, resultOld, xnfUpd, services, mgdScript, xnfConversionTechnique);
        return termAfterUPD;
    }

    private static EliminationTaskSimple applyStoreOverSelect(ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, IUltimateServiceProvider services, ILogger logger, SmtUtils.SimplificationTechnique simplificationTechnique, Script script, Term resultOld) {
        HashSet<TermVariable> remainingAndNewAfterSOS = new HashSet<TermVariable>();
        Term[] oldParams = QuantifierUtils.getXjunctsOuter(quantifier, resultOld);
        Term[] newParams = new Term[oldParams.length];
        int i = 0;
        while (i < oldParams.length) {
            HashSet<TermVariable> eliminateesSOS = new HashSet<TermVariable>(eliminatees);
            newParams[i] = PartialQuantifierElimination.sos(script, quantifier, oldParams[i], eliminateesSOS, logger, services, mgdScript, simplificationTechnique);
            remainingAndNewAfterSOS.addAll(eliminateesSOS);
            ++i;
        }
        Term termAfterSOS = QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, newParams);
        return new EliminationTaskSimple(quantifier, remainingAndNewAfterSOS, termAfterSOS);
    }

    private static Term applyUsr(ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, IUltimateServiceProvider services, ILogger logger, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique, Script script, Term resultOld) {
        XnfUsr xnfUsr = new XnfUsr(mgdScript, services);
        Term[] oldParams = QuantifierUtils.getXjunctsOuter(quantifier, resultOld);
        Term[] newParams = new Term[oldParams.length];
        int i = 0;
        while (i < oldParams.length) {
            HashSet<TermVariable> eliminateesUsr = new HashSet<TermVariable>(eliminatees);
            Term[] oldAtoms = QuantifierUtils.getXjunctsInner(quantifier, oldParams[i]);
            newParams[i] = QuantifierUtils.applyDualFiniteConnective(script, quantifier, Arrays.asList(xnfUsr.tryToEliminate(quantifier, oldAtoms, eliminateesUsr)));
            ++i;
        }
        Term termAfterUsr = QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, newParams);
        if (!xnfUsr.getAffectedEliminatees().isEmpty()) {
            termAfterUsr = PartialQuantifierElimination.elim(mgdScript, quantifier, eliminatees, termAfterUsr, services, logger, simplificationTechnique, xnfConversionTechnique);
        }
        return termAfterUsr;
    }

    private static Term applyEliminationOuter(Script script, int quantifier, Set<TermVariable> eliminatees, Term term, XjunctPartialQuantifierElimination elimination, IUltimateServiceProvider services, ManagedScript freshTermVariableConstructor, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        Term[] oldXjunctsOuter = QuantifierUtils.getXjunctsOuter(quantifier, term);
        Term[] newXjunctsOuter = new Term[oldXjunctsOuter.length];
        int i = 0;
        while (i < oldXjunctsOuter.length) {
            HashSet<TermVariable> localEliminatees = PartialQuantifierElimination.constructIntersectionWithFreeVars(eliminatees, oldXjunctsOuter[i]);
            if (localEliminatees.isEmpty()) {
                newXjunctsOuter[i] = oldXjunctsOuter[i];
            } else {
                newXjunctsOuter[i] = PartialQuantifierElimination.applyEliminationInner(script, quantifier, localEliminatees, oldXjunctsOuter[i], elimination);
                if (quantifier == 0) {
                    if (SmtUtils.isTrueLiteral(newXjunctsOuter[i])) {
                        eliminatees.clear();
                        return script.term("true", new Term[0]);
                    }
                } else if (quantifier == 1) {
                    if (SmtUtils.isFalseLiteral(newXjunctsOuter[i])) {
                        eliminatees.clear();
                        return script.term("false", new Term[0]);
                    }
                } else {
                    throw new AssertionError((Object)"unknown quantifier");
                }
            }
            ++i;
        }
        Term result = QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, newXjunctsOuter);
        HashSet<TermVariable> remainingEliminatees = new HashSet<TermVariable>(eliminatees);
        remainingEliminatees.retainAll(Arrays.asList(result.getFreeVars()));
        eliminatees.retainAll(remainingEliminatees);
        if (!elimination.resultIsXjunction()) {
            result = QuantifierUtils.transformToXnf(services, script, quantifier, freshTermVariableConstructor, result, xnfConversionTechnique);
        }
        return result;
    }

    private static Term applyEliminationInner(Script script, int quantifier, Set<TermVariable> eliminatees, Term term, XjunctPartialQuantifierElimination elimination) {
        HashSet<TermVariable> eliminateesCopy = new HashSet<TermVariable>(eliminatees);
        Term[] oldXjunctsInner = QuantifierUtils.getXjunctsInner(quantifier, term);
        Term[] newXjunctsInner = elimination.tryToEliminate(quantifier, oldXjunctsInner, eliminateesCopy);
        Term result = QuantifierUtils.applyDualFiniteConnective(script, quantifier, Arrays.asList(newXjunctsInner));
        return result;
    }

    private static HashSet<TermVariable> constructIntersectionWithFreeVars(Set<TermVariable> vars, Term term) {
        HashSet<TermVariable> result = new HashSet<TermVariable>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            if (vars.contains(tv)) {
                result.add(tv);
            }
            ++n2;
        }
        return result;
    }

    public static Term sos(Script script, int quantifier, Term term, Set<TermVariable> eliminatees, ILogger logger, IUltimateServiceProvider services, ManagedScript freshTermVariableConstructor, SmtUtils.SimplificationTechnique simplicationTechnique) {
        Term result = term;
        HashSet<TermVariable> overallAuxVars = new HashSet<TermVariable>();
        for (TermVariable tv : eliminatees) {
            if (!tv.getSort().isArraySort()) continue;
            HashSet<TermVariable> thisIterationAuxVars = new HashSet<TermVariable>();
            Term elim = new ElimStore3(script, freshTermVariableConstructor, services, simplicationTechnique).elim(quantifier, tv, result, thisIterationAuxVars);
            logger.debug((Object)new DebugMessage("eliminated quantifier via SOS for {0}, additionally introduced {1}", new Object[]{tv, thisIterationAuxVars}));
            overallAuxVars.addAll(thisIterationAuxVars);
            assert (!Arrays.asList(elim.getFreeVars()).contains(tv)) : "var is still there";
            result = elim;
        }
        eliminatees.addAll(overallAuxVars);
        return result;
    }

    public static Term isSuperfluousConjunction(Script script, Set<Term> terms, Set<TermVariable> connectedVars, Set<TermVariable> quantifiedVars) {
        if (quantifiedVars.containsAll(connectedVars)) {
            Term conjunction = SmtUtils.and(script, terms.toArray(new Term[terms.size()]));
            Script.LBool isSat = Util.checkSat((Script)script, (Term)conjunction);
            if (isSat == Script.LBool.SAT) {
                return script.term("true", new Term[0]);
            }
            if (isSat == Script.LBool.UNSAT) {
                return script.term("false", new Term[0]);
            }
        }
        return null;
    }

    public static Term isSuperfluousDisjunction(Script script, Set<Term> terms, Set<TermVariable> connectedVars, Set<TermVariable> quantifiedVars) {
        if (quantifiedVars.containsAll(connectedVars)) {
            Term disjunction = SmtUtils.or(script, terms.toArray(new Term[terms.size()]));
            Script.LBool isSat = Util.checkSat((Script)script, (Term)SmtUtils.not(script, disjunction));
            if (isSat == Script.LBool.SAT) {
                return script.term("false", new Term[0]);
            }
            if (isSat == Script.LBool.UNSAT) {
                return script.term("true", new Term[0]);
            }
        }
        return null;
    }

    private static Term findEqualTermExists(TermVariable tv, Term term, ILogger logger) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            FunctionSymbol sym = appTerm.getFunction();
            Term[] params = appTerm.getParameters();
            if (sym.getName().equals("=")) {
                int tvOnOneSideOfEquality = PartialQuantifierElimination.tvOnOneSideOfEquality(tv, params, logger);
                if (tvOnOneSideOfEquality == -1) {
                    return null;
                }
                assert (tvOnOneSideOfEquality == 0 || tvOnOneSideOfEquality == 1);
                return params[tvOnOneSideOfEquality];
            }
            if (sym.getName().equals("and")) {
                Term[] termArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Term param = termArray[n2];
                    Term equalTerm = PartialQuantifierElimination.findEqualTermExists(tv, param, logger);
                    if (equalTerm != null) {
                        return equalTerm;
                    }
                    ++n2;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static Term findEqualTermForall(TermVariable tv, Term term, ILogger logger) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            FunctionSymbol sym = appTerm.getFunction();
            Term[] params = appTerm.getParameters();
            if (sym.getName().equals("not")) {
                assert (params.length == 1);
                if (params[0] instanceof ApplicationTerm) {
                    appTerm = (ApplicationTerm)params[0];
                    sym = appTerm.getFunction();
                    params = appTerm.getParameters();
                    if (sym.getName().equals("=")) {
                        int tvOnOneSideOfEquality = PartialQuantifierElimination.tvOnOneSideOfEquality(tv, params, logger);
                        if (tvOnOneSideOfEquality == -1) {
                            return null;
                        }
                        assert (tvOnOneSideOfEquality == 0 || tvOnOneSideOfEquality == 1);
                        return params[tvOnOneSideOfEquality];
                    }
                    return null;
                }
                return null;
            }
            if (sym.getName().equals("or")) {
                Term[] termArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Term param = termArray[n2];
                    Term equalTerm = PartialQuantifierElimination.findEqualTermForall(tv, param, logger);
                    if (equalTerm != null) {
                        return equalTerm;
                    }
                    ++n2;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static int tvOnOneSideOfEquality(TermVariable tv, Term[] params, ILogger logger) {
        if (params.length != 2) {
            logger.warn((Object)("Equality of length " + params.length));
        }
        if (params[0] == tv) {
            boolean rightHandSideContainsTv = Arrays.asList(params[1].getFreeVars()).contains(tv);
            if (rightHandSideContainsTv) {
                return -1;
            }
            return 1;
        }
        if (params[1] == tv) {
            boolean leftHandSideContainsTv = Arrays.asList(params[0].getFreeVars()).contains(tv);
            if (leftHandSideContainsTv) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public static Set<TermVariable> constructNewEliminatees(Term term, Set<TermVariable> eliminatees) {
        HashSet<TermVariable> result = new HashSet<TermVariable>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            if (eliminatees.contains(tv)) {
                result.add(tv);
            }
            ++n2;
        }
        return result;
    }
}

