/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonCoreBooleanSubTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ContainsQuantifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class PrenexNormalForm
extends TermTransformer {
    private final Script mScript;
    private final ManagedScript mMgdScript;

    public PrenexNormalForm(ManagedScript mgdScript) {
        this.mScript = mgdScript.getScript();
        this.mMgdScript = mgdScript;
    }

    protected void convert(Term term) {
        ApplicationTerm appTerm;
        String fun;
        if (term instanceof ApplicationTerm && (fun = (appTerm = (ApplicationTerm)term).getFunction().getName()).equals("ite")) {
            if (new ContainsQuantifier().containsQuantifier((Term)appTerm)) {
                throw new UnsupportedOperationException("ite Term with quantifier, use IteRemover first");
            }
            this.setResult((Term)appTerm);
            return;
        }
        super.convert(term);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        if (!NonCoreBooleanSubTermTransformer.isCoreBooleanNonAtom(appTerm)) {
            super.convertApplicationTerm(appTerm, newArgs);
            return;
        }
        String fun = appTerm.getFunction().getName();
        if (fun.equals("=")) {
            throw new UnsupportedOperationException("not yet implemented, we need term in nnf");
        }
        if (fun.equals("not")) {
            Term result = this.pullQuantifiersNot(newArgs);
            this.setResult(result);
            return;
        }
        if (fun.equals("and")) {
            Term result = this.pullQuantifiers(appTerm, newArgs);
            this.setResult(result);
            return;
        }
        if (fun.equals("or")) {
            Term result = this.pullQuantifiers(appTerm, newArgs);
            this.setResult(result);
            return;
        }
        if (fun.equals("=>")) {
            throw new UnsupportedOperationException("not yet implemented, we need term in nnf");
        }
        if (fun.equals("xor")) {
            throw new UnsupportedOperationException("not yet implemented, we need term in nnf");
        }
        if (fun.equals("distinct")) {
            throw new UnsupportedOperationException("not yet implemented, we need term in nnf");
        }
        if (!fun.equals("ite")) throw new AssertionError((Object)"unknown core boolean term");
        throw new UnsupportedOperationException("not yet implemented, we need term in nnf");
    }

    private Term pullQuantifiersNot(Term[] newArgs) {
        assert (newArgs.length == 1) : "no not";
        Term notArg = newArgs[0];
        QuantifierSequence quantifierSequence = new QuantifierSequence(this.mMgdScript, notArg);
        Term inner = quantifierSequence.getInnerTerm();
        List<QuantifierSequence.QuantifiedVariables> qVarSeq = quantifierSequence.getQuantifierBlocks();
        Term result = SmtUtils.not(this.mScript, inner);
        int i = qVarSeq.size() - 1;
        while (i >= 0) {
            QuantifierSequence.QuantifiedVariables quantifiedVars = qVarSeq.get(i);
            int resultQuantifier = (quantifiedVars.getQuantifier() + 1) % 2;
            result = SmtUtils.quantifier(this.mScript, resultQuantifier, quantifiedVars.getVariables(), result);
            --i;
        }
        return result;
    }

    private Term pullQuantifiers(ApplicationTerm appTerm, Term[] newArgs) {
        QuantifierSequence[] quantifierSequences = new QuantifierSequence[newArgs.length];
        HashSet<TermVariable> freeVariables = new HashSet<TermVariable>();
        int i = 0;
        while (i < newArgs.length) {
            freeVariables.addAll(Arrays.asList(newArgs[i].getFreeVars()));
            quantifierSequences[i] = new QuantifierSequence(this.mMgdScript, newArgs[i]);
            ++i;
        }
        Term result = QuantifierSequence.mergeQuantifierSequences(this.mMgdScript, appTerm.getFunction().getName(), quantifierSequences, freeVariables);
        return result;
    }

    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        throw new UnsupportedOperationException("not yet implemented, we need term without let");
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        if (SmtUtils.isQuantifiedFormulaWithSameQuantifier(old.getQuantifier(), newBody) != null) {
            Term result = SmtUtils.quantifier(this.mScript, old.getQuantifier(), new HashSet<TermVariable>(Arrays.asList(old.getVariables())), newBody);
            this.setResult(result);
        } else {
            super.postConvertQuantifier(old, newBody);
        }
    }

    public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
        this.setResult(newBody);
    }
}

