/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;

public class QuantifierOverapproximator
extends TermTransformer {
    private final Script mScript;

    private QuantifierOverapproximator(Script script) {
        this.mScript = script;
    }

    protected void convert(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            Term notTerm = SmtUtils.unzipNot((Term)appTerm);
            if (notTerm != null) {
                if (!SmtUtils.isAtomicFormula(notTerm)) {
                    throw new AssertionError((Object)"NNF required for sound overapproximation.");
                }
                this.setResult(term);
                return;
            }
            super.convert(term);
            return;
        }
        if (term instanceof QuantifiedFormula) {
            this.setResult(this.mScript.term("true", new Term[0]));
            return;
        }
        if (term instanceof TermVariable) {
            this.setResult(term);
            return;
        }
        if (term instanceof ConstantTerm) {
            this.setResult(term);
            return;
        }
        throw new UnsupportedOperationException("Unsupported kind of Term: " + term.getClass().getSimpleName());
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        this.setResult(SmtUtils.convertApplicationTerm(appTerm, newArgs, this.mScript));
    }

    public static Term apply(Script script, Term term) {
        return new QuantifierOverapproximator(script).transform(term);
    }
}

