/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PolyPacSimplificationTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermContextTransformationEngine;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.List;

public class QuantifierPushTermWalker
extends TermContextTransformationEngine.TermWalker<Context> {
    private static final boolean OPTION_APPLY_REPEATEDLY_UNTIL_NOCHANGE = false;
    private static final boolean OPTION_SIMPLIFY_CONSTRUCTED_APPLICATION_TERMS = true;
    private static final boolean DEBUG_CHECK_RESULT = false;
    private static final boolean DEBUG_CHECK_SIMPLIFICATION_POTENTIAL_OF_INPUT_AND_OUTPUT = false;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final QuantifierPusher.PqeTechniques mPqeTechniques;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final boolean mApplyDistributivity;

    private QuantifierPushTermWalker(IUltimateServiceProvider services, boolean applyDistributivity, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, ManagedScript mgdScript) {
        this.mServices = services;
        this.mApplyDistributivity = applyDistributivity;
        this.mPqeTechniques = pqeTechniques;
        this.mMgdScript = mgdScript;
        this.mSimplificationTechnique = simplificationTechnique;
    }

    @Override
    protected Context constructContextForApplicationTerm(Context context, FunctionSymbol symb, List<Term> allParams, int selectedParam) {
        return context.constructChildContextForConDis(this.mServices, this.mMgdScript, symb, allParams, selectedParam);
    }

    @Override
    protected Context constructContextForQuantifiedFormula(Context context, int quant, List<TermVariable> vars) {
        return context.constructChildContextForQuantifiedFormula(this.mMgdScript.getScript(), vars);
    }

    @Override
    protected TermContextTransformationEngine.DescendResult convert(Context context, Term term) {
        QuantifierPusher.FormulaClassification classification = null;
        Term currentTerm = PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, context.getCriticalConstraint(), term);
        int iterations = 0;
        do {
            classification = QuantifierPusher.classify(currentTerm);
            switch (classification) {
                case NOT_QUANTIFIED: {
                    if (SmtUtils.isAtomicFormula(currentTerm)) {
                        if (!SmtUtils.isTrueLiteral(currentTerm) && !SmtUtils.isFalseLiteral(currentTerm)) {
                            currentTerm = QuantifierPusher.simplify(this.mServices, this.mMgdScript, QuantifierPusher.SimplificationOccasion.ATOM, this.mSimplificationTechnique, context, currentTerm);
                        }
                        return new TermContextTransformationEngine.FinalResultForAscend(currentTerm);
                    }
                    Term negated = SmtUtils.unzipNot(currentTerm);
                    if (negated != null && SmtUtils.isAtomicFormula(negated)) {
                        currentTerm = QuantifierPusher.simplify(this.mServices, this.mMgdScript, QuantifierPusher.SimplificationOccasion.ATOM, this.mSimplificationTechnique, context, currentTerm);
                        return new TermContextTransformationEngine.FinalResultForAscend(currentTerm);
                    }
                    return new TermContextTransformationEngine.IntermediateResultForDescend(currentTerm);
                }
                case SAME_QUANTIFIER: {
                    currentTerm = QuantifierUtils.flattenQuantifiers(this.mMgdScript.getScript(), (QuantifiedFormula)currentTerm);
                    break;
                }
                case DUAL_QUANTIFIER: {
                    Context childContext = context.constructChildContextForQuantifiedFormula(this.mMgdScript.getScript(), Arrays.asList(((QuantifiedFormula)currentTerm).getVariables()));
                    EliminationTask et = new EliminationTask((QuantifiedFormula)currentTerm, childContext);
                    Term tmp = QuantifierPusher.processDualQuantifier(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, et, QuantifierPushTermWalker::eliminate);
                    QuantifierPusher.FormulaClassification tmpClassification = QuantifierPusher.classify(tmp);
                    if (tmpClassification == QuantifierPusher.FormulaClassification.DUAL_QUANTIFIER) {
                        return new TermContextTransformationEngine.FinalResultForAscend(tmp);
                    }
                    currentTerm = tmp;
                    break;
                }
                case CORRESPONDING_FINITE_CONNECTIVE: {
                    currentTerm = QuantifierPusher.pushOverCorrespondingFiniteConnective(this.mMgdScript.getScript(), (QuantifiedFormula)currentTerm);
                    assert (currentTerm != null) : "corresponding connective case must never fail";
                    break;
                }
                case ATOM: {
                    Term tmp = QuantifierPusher.applyEliminationToAtom(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, context, (QuantifiedFormula)currentTerm);
                    if (tmp == null) {
                        Term res = QuantifierPusher.pushInner(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, context.getBoundByAncestors(), (QuantifiedFormula)currentTerm, context.getCriticalConstraint(), QuantifierPushTermWalker::eliminate);
                        return new TermContextTransformationEngine.FinalResultForAscend(res);
                    }
                    currentTerm = tmp;
                    break;
                }
                case DUAL_FINITE_CONNECTIVE: {
                    EliminationTask et = new EliminationTask((QuantifiedFormula)currentTerm, context);
                    Term tmp = QuantifierPusher.tryToPushOverDualFiniteConnective(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, et, QuantifierPushTermWalker::eliminate);
                    if (tmp == null) {
                        Term res = QuantifierPusher.pushInner(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, context.getBoundByAncestors(), (QuantifiedFormula)currentTerm, context.getCriticalConstraint(), QuantifierPushTermWalker::eliminate);
                        return new TermContextTransformationEngine.FinalResultForAscend(res);
                    }
                    currentTerm = tmp;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)classification)));
                }
            }
            if (++iterations % 10 != 0) continue;
            ILogger logger = this.mServices.getLoggingService().getLogger(QuantifierPusher.class);
            logger.info((Object)String.format("Run %s iterations without descend maybe there is a nontermination bug.", iterations));
        } while (this.mServices.getProgressMonitorService().continueProcessing());
        throw new ToolchainCanceledException(QuantifierPusher.class, String.format("running %s iterations on subformula", iterations));
    }

    @Override
    protected Term constructResultForApplicationTerm(Context context, ApplicationTerm originalApplicationTerm, Term[] resultParams) {
        if (originalApplicationTerm.getFunction().getName().equals("and")) {
            Term tmp = SmtUtils.and(this.mMgdScript.getScript(), resultParams);
            Term result = PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, context.getCriticalConstraint(), tmp);
            return result;
        }
        if (originalApplicationTerm.getFunction().getName().equals("or")) {
            Term tmp = SmtUtils.or(this.mMgdScript.getScript(), resultParams);
            Term result = PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, context.getCriticalConstraint(), tmp);
            return result;
        }
        if (originalApplicationTerm.getFunction().getName().equals("=")) {
            Term eq = SmtUtils.equality(this.mMgdScript.getScript(), resultParams);
            return PolyPacSimplificationTermWalker.simplify(this.mServices, this.mMgdScript, context.getCriticalConstraint(), eq);
        }
        assert (Arrays.equals(originalApplicationTerm.getParameters(), resultParams));
        return originalApplicationTerm;
    }

    @Override
    protected Term constructResultForQuantifiedFormula(Context context, QuantifiedFormula originalQuantifiedFormula, Term resultSubformula) {
        return SmtUtils.quantifier(this.mMgdScript.getScript(), originalQuantifiedFormula.getQuantifier(), Arrays.asList(originalQuantifiedFormula.getVariables()), resultSubformula);
    }

    @Override
    protected boolean applyRepeatedlyUntilNoChange() {
        return false;
    }

    public static Term eliminate(IUltimateServiceProvider services, ManagedScript script, boolean applyDistributivity, QuantifierPusher.PqeTechniques quantifierEliminationTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Term inputTerm) {
        return QuantifierPushTermWalker.eliminate(services, script, applyDistributivity, quantifierEliminationTechniques, simplificationTechnique, new Context(script.getScript()), inputTerm);
    }

    public static Term eliminate(IUltimateServiceProvider services, ManagedScript script, boolean applyDistributivity, QuantifierPusher.PqeTechniques quantifierEliminationTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Context context, Term inputTerm) {
        QuantifierPushTermWalker.checkSimplificationPotential(services, script, "Quantifier elimination called on non-simplified input", inputTerm);
        Term result = TermContextTransformationEngine.transform(new QuantifierPushTermWalker(services, applyDistributivity, quantifierEliminationTechniques, simplificationTechnique, script), context, inputTerm);
        QuantifierPushTermWalker.checkSimplificationPotential(services, script, "Quantifier elimination failed to simlify output", result);
        return result;
    }

    private static void checkSimplificationPotential(IUltimateServiceProvider services, ManagedScript script, String msg, Term inputTerm) {
    }

    @Override
    protected void checkIntermediateResult(Context context, Term input, Term output) {
        Script.LBool lBool = SmtUtils.checkEquivalenceUnderAssumption(input, output, context.getCriticalConstraint(), this.mMgdScript.getScript());
        switch (lBool) {
            case SAT: {
                throw new AssertionError((Object)String.format("Intermediate result not equivalent. Input: %s Output: %s Assumption: %s", input, output, context.getCriticalConstraint()));
            }
            case UNKNOWN: {
                ILogger logger = this.mServices.getLoggingService().getLogger(this.getClass());
                logger.warn((Object)String.format("Insufficient ressources to check equivalence of intermediate result. Input: %s Output: %s Assumption: %s", input, output, context.getCriticalConstraint()));
                break;
            }
            case UNSAT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + lBool));
            }
        }
    }
}

