/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ParameterPartition;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushUtilsForLocalEliminatees;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class QuantifierPushUtils {
    public static final boolean OPTION_EVALUATE_SUCCESS_OF_DISTRIBUTIVITY_APPLICATION = false;
    public static final boolean OPTION_ELIMINATEE_SEQUENTIALIZATION = true;
    public static final boolean OPTION_SCOUT_BASED_DISTRIBUTIVITY_RECOMMENDATION = true;
    public static final String NOT_DUAL_FINITE_CONNECTIVE = "not dual finite connective";

    public static boolean isQuantifiedDualFiniteJunction(int quantifier, Term term) {
        QuantifiedFormula qf;
        boolean result = term instanceof QuantifiedFormula ? ((qf = (QuantifiedFormula)term).getQuantifier() == quantifier ? QuantifierPusher.classify(qf.getSubformula()) == QuantifierPusher.FormulaClassification.DUAL_FINITE_CONNECTIVE : false) : false;
        return result;
    }

    public static Pair<Boolean, Term> preprocessDualFiniteJunction(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask et, QuantifierUtils.IQuantifierEliminator qe, boolean pushLocalEliminatees, boolean pushDualQuantifiersInParams) {
        EliminationTask currentEt;
        block14: {
            Term tmp;
            currentEt = et;
            int i = 0;
            while (true) {
                Term localsEliminated;
                QuantifiedFormula qf;
                if (++i >= 20) {
                    throw new AssertionError((Object)"Probably an infinite loop!");
                }
                if (currentEt.getEliminatees().isEmpty()) {
                    return new Pair((Object)false, (Object)currentEt.getTerm());
                }
                List<Term> currentDualFiniteJuncts = Arrays.asList(QuantifierUtils.getDualFiniteJunction(currentEt.getQuantifier(), currentEt.getTerm()));
                if (currentDualFiniteJuncts.size() <= 1) {
                    return new Pair((Object)false, (Object)SmtUtils.quantifier(mgdScript.getScript(), currentEt.getQuantifier(), currentEt.getEliminatees(), currentDualFiniteJuncts.get(0)));
                }
                if (!QuantifierPushUtils.isFlattened(et.getQuantifier(), currentDualFiniteJuncts)) {
                    Term flattened = QuantifierPushUtils.flattenQuantifiedFormulas(mgdScript, et.getQuantifier(), currentEt.toTerm(mgdScript.getScript()));
                    if (flattened instanceof QuantifiedFormula) {
                        qf = (QuantifiedFormula)flattened;
                        if (qf.getQuantifier() != currentEt.getQuantifier()) {
                            return new Pair((Object)false, (Object)flattened);
                        }
                        currentEt = new EliminationTask(qf, currentEt.getContext());
                        continue;
                    }
                    return new Pair((Object)false, (Object)flattened);
                }
                ParameterPartition pp = new ParameterPartition(mgdScript.getScript(), currentEt);
                if (!pp.isIsPartitionTrivial()) {
                    Term tmp2 = pp.getTermWithPushedQuantifier();
                    if (tmp2 instanceof QuantifiedFormula) {
                        QuantifiedFormula qf2 = (QuantifiedFormula)tmp2;
                        if (qf2.getQuantifier() != currentEt.getQuantifier()) {
                            return new Pair((Object)false, (Object)tmp2);
                        }
                        currentEt = new EliminationTask(qf2, currentEt.getContext());
                        continue;
                    }
                    return new Pair((Object)false, (Object)tmp2);
                }
                if (pushLocalEliminatees && (localsEliminated = QuantifierPushUtilsForLocalEliminatees.pushLocalEliminateesOverCorrespondingFiniteJunction(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, currentEt, qe)) != null) {
                    if (localsEliminated instanceof QuantifiedFormula) {
                        qf = (QuantifiedFormula)localsEliminated;
                        if (qf.getQuantifier() != currentEt.getQuantifier()) {
                            return new Pair((Object)false, (Object)localsEliminated);
                        }
                        currentEt = new EliminationTask(qf, currentEt.getContext());
                        continue;
                    }
                    return new Pair((Object)false, (Object)localsEliminated);
                }
                if (!pushDualQuantifiersInParams || (tmp = QuantifierPushUtils.pushDualQuantifiersInParams(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, currentEt, qe)) == null) break block14;
                if (!(tmp instanceof QuantifiedFormula)) break;
                qf = (QuantifiedFormula)tmp;
                if (qf.getQuantifier() != currentEt.getQuantifier()) {
                    return new Pair((Object)false, (Object)tmp);
                }
                currentEt = new EliminationTask(qf, currentEt.getContext());
            }
            return new Pair((Object)false, (Object)tmp);
        }
        return new Pair((Object)true, (Object)currentEt.toTerm(mgdScript.getScript()));
    }

    static boolean isFlattened(int quantifier, List<Term> dualFiniteJuncts) {
        Predicate<Term> notSameQuantifier = x -> QuantifierPusher.classify(quantifier, x) != QuantifierPusher.FormulaClassification.SAME_QUANTIFIER;
        return dualFiniteJuncts.stream().allMatch(notSameQuantifier);
    }

    public static Term flattenQuantifiedFormulas(ManagedScript mgdScript, int quantifier, Term term) {
        Term inputDualJunction;
        Set freeVarNames = Arrays.stream(term.getFreeVars()).map(x -> x.getName()).collect(Collectors.toSet());
        LinkedHashMap<String, TermVariable> quantifiedVariables = new LinkedHashMap<String, TermVariable>();
        if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
            if (quantifiedFormula.getQuantifier() != quantifier) {
                return null;
            }
            inputDualJunction = quantifiedFormula.getSubformula();
            Arrays.stream(quantifiedFormula.getVariables()).forEach(x -> {
                TermVariable termVariable = quantifiedVariables.put(x.getName(), (TermVariable)x);
            });
        } else {
            inputDualJunction = term;
        }
        Term[] dualJuncts = QuantifierUtils.getDualFiniteJunction(quantifier, inputDualJunction);
        ArrayList<Term> resultDualJuncts = new ArrayList<Term>();
        Term[] termArray = dualJuncts;
        int n = dualJuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term dualJunct = termArray[n2];
            if (dualJunct instanceof QuantifiedFormula) {
                QuantifiedFormula innerQuantifiedFormula = (QuantifiedFormula)dualJunct;
                if (innerQuantifiedFormula.getQuantifier() != quantifier) {
                    resultDualJuncts.add(dualJunct);
                } else {
                    HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
                    TermVariable[] termVariableArray = innerQuantifiedFormula.getVariables();
                    int n3 = termVariableArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TermVariable resultVar;
                        TermVariable innerVar = termVariableArray[n4];
                        if (quantifiedVariables.containsKey(innerVar.getName()) || freeVarNames.contains(innerVar.getName())) {
                            resultVar = mgdScript.constructFreshCopy(innerVar);
                            substitutionMapping.put(innerVar, resultVar);
                        } else {
                            resultVar = innerVar;
                        }
                        quantifiedVariables.put(resultVar.getName(), resultVar);
                        ++n4;
                    }
                    Term resultSubformula = substitutionMapping.isEmpty() ? innerQuantifiedFormula.getSubformula() : Substitution.apply(mgdScript, substitutionMapping, innerQuantifiedFormula.getSubformula());
                    resultDualJuncts.add(resultSubformula);
                }
            } else {
                resultDualJuncts.add(dualJunct);
            }
            ++n2;
        }
        Term resultDualJunction = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), quantifier, resultDualJuncts);
        Term result = SmtUtils.quantifier(mgdScript.getScript(), quantifier, quantifiedVariables.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet()), resultDualJunction);
        return result;
    }

    public static Term pushDualQuantifiersInParams(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask et, QuantifierUtils.IQuantifierEliminator qe) {
        Term result;
        Term[] dualFiniteParams = QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm());
        assert (dualFiniteParams.length > 1) : "not dual finite connective";
        ArrayList<Term> resultDualFiniteParams = new ArrayList<Term>();
        boolean atLeastOneParameterModified = false;
        int i = 0;
        while (i < dualFiniteParams.length) {
            if (dualFiniteParams[i] instanceof QuantifiedFormula) {
                Context childContext = et.getContext().constructChildContextForConDis(services, mgdScript, ((ApplicationTerm)et.getTerm()).getFunction(), Arrays.asList(dualFiniteParams), i);
                Term resultDualFiniteParamI = qe.eliminate(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, childContext, dualFiniteParams[i]);
                if (resultDualFiniteParamI != dualFiniteParams[i]) {
                    atLeastOneParameterModified = true;
                }
                resultDualFiniteParams.add(resultDualFiniteParamI);
            } else {
                resultDualFiniteParams.add(dualFiniteParams[i]);
            }
            ++i;
        }
        if (atLeastOneParameterModified) {
            Term dualFiniteJunction = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), et.getQuantifier(), resultDualFiniteParams);
            result = SmtUtils.quantifier(mgdScript.getScript(), et.getQuantifier(), et.getEliminatees(), dualFiniteJunction);
        } else {
            result = null;
        }
        return result;
    }
}

