/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class QuantifierPushUtilsForLocalEliminatees {
    public static Term pushLocalEliminateesOverCorrespondingFiniteJunction(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask et, QuantifierUtils.IQuantifierEliminator qe) {
        Term[] currentDualFiniteJuncts = QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm());
        if (currentDualFiniteJuncts.length <= 1) {
            throw new AssertionError((Object)"not dual finite connective");
        }
        Pair<Term, Set<TermVariable>> qualifiedDualJunct2LocalEliminatees = QuantifierPushUtilsForLocalEliminatees.findSomePushableLocalEliminateeSet(et);
        EliminationTask currentEt = et;
        int iterations = 0;
        while (qualifiedDualJunct2LocalEliminatees != null) {
            Set localEliminatees = (Set)qualifiedDualJunct2LocalEliminatees.getSecond();
            LinkedHashSet<TermVariable> otherEliminatess = new LinkedHashSet<TermVariable>(currentEt.getEliminatees());
            otherEliminatess.removeAll(localEliminatees);
            Context context = currentEt.getContext().constructChildContextForQuantifiedFormula(mgdScript.getScript(), new ArrayList<TermVariable>(otherEliminatess));
            Term tmp = QuantifierPushUtilsForLocalEliminatees.pushLocalEliminateeSetToDualJunct(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, currentEt.getQuantifier(), currentEt.getTerm(), qualifiedDualJunct2LocalEliminatees, context, qe);
            otherEliminatess.retainAll(Arrays.asList(tmp.getFreeVars()));
            if (otherEliminatess.isEmpty()) {
                return tmp;
            }
            currentDualFiniteJuncts = QuantifierUtils.getDualFiniteJunction((currentEt = new EliminationTask(currentEt.getQuantifier(), otherEliminatess, tmp, currentEt.getContext())).getQuantifier(), tmp);
            if (currentDualFiniteJuncts.length <= 1) {
                return currentEt.toTerm(mgdScript.getScript());
            }
            qualifiedDualJunct2LocalEliminatees = QuantifierPushUtilsForLocalEliminatees.findSomePushableLocalEliminateeSet(currentEt);
            ++iterations;
        }
        if (iterations == 0) {
            return null;
        }
        return currentEt.toTerm(mgdScript.getScript());
    }

    private static Term pushLocalEliminateeSetToDualJunct(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, int quantifier, Term dualFiniteJunction, Pair<Term, Set<TermVariable>> dualJunctEliminateesPair, Context context, QuantifierUtils.IQuantifierEliminator qe) {
        Term[] dualFiniteJuncts = QuantifierUtils.getDualFiniteJunction(quantifier, dualFiniteJunction);
        if (dualFiniteJuncts.length <= 1) {
            throw new AssertionError((Object)"not dual finite connective");
        }
        int i = Arrays.asList(dualFiniteJuncts).indexOf(dualJunctEliminateesPair.getFirst());
        Term ithTermQuantified = SmtUtils.quantifier(mgdScript.getScript(), quantifier, (Collection)dualJunctEliminateesPair.getSecond(), (Term)dualJunctEliminateesPair.getFirst());
        Context childContextForIthTerm = context.constructChildContextForConDis(services, mgdScript, ((ApplicationTerm)dualFiniteJunction).getFunction(), Arrays.asList(dualFiniteJuncts), i);
        Term ithTermPushed = qe.eliminate(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, childContextForIthTerm, ithTermQuantified);
        ArrayList<Term> resultDualJuncts = new ArrayList<Term>(Arrays.asList(dualFiniteJuncts));
        resultDualJuncts.set(i, ithTermPushed);
        return QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), quantifier, resultDualJuncts);
    }

    static Pair<Term, Set<TermVariable>> findSomePushableLocalEliminateeSet(EliminationTask et) {
        Term[] dualFiniteJuncts = QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm());
        assert (dualFiniteJuncts.length > 1) : "not dual finite connective";
        HashRelation eliminatee2DualJuncts = new HashRelation();
        Term[] termArray = dualFiniteJuncts;
        int n = dualFiniteJuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term dualJunct = termArray[n2];
            HashSet<TermVariable> freeVars = new HashSet<TermVariable>(Arrays.asList(dualJunct.getFreeVars()));
            for (TermVariable eliminatee : et.getEliminatees()) {
                if (!freeVars.contains(eliminatee)) continue;
                eliminatee2DualJuncts.addPair((Object)eliminatee, (Object)dualJunct);
            }
            ++n2;
        }
        HashRelation dualJunct2LocalEliminatees = new HashRelation();
        for (TermVariable eliminatee : et.getEliminatees()) {
            Set dualJunctsOfEliminatee = eliminatee2DualJuncts.getImage((Object)eliminatee);
            assert (!dualJunctsOfEliminatee.isEmpty());
            if (dualJunctsOfEliminatee.size() != 1) continue;
            Term dualJunct = (Term)dualJunctsOfEliminatee.iterator().next();
            QuantifierPusher.FormulaClassification classification = QuantifierPusher.classify(et.getQuantifier(), dualJunct);
            switch (classification) {
                case ATOM: {
                    break;
                }
                case CORRESPONDING_FINITE_CONNECTIVE: {
                    dualJunct2LocalEliminatees.addPair((Object)dualJunct, (Object)eliminatee);
                    break;
                }
                case DUAL_FINITE_CONNECTIVE: {
                    throw new AssertionError((Object)"Dual finite connective not flattened");
                }
                case DUAL_QUANTIFIER: {
                    break;
                }
                case NOT_QUANTIFIED: {
                    throw new AssertionError((Object)"Illegal for the call above");
                }
                case SAME_QUANTIFIER: {
                    throw new AssertionError((Object)"Quantifier not flattened");
                }
                default: {
                    throw new AssertionError((Object)("Unknown value: " + (Object)((Object)classification)));
                }
            }
        }
        if (dualJunct2LocalEliminatees.isEmpty()) {
            return null;
        }
        Term[] termArray2 = dualFiniteJuncts;
        int n3 = dualFiniteJuncts.length;
        int n4 = 0;
        while (n4 < n3) {
            Term dualFiniteJunct = termArray2[n4];
            Set eliminatees = dualJunct2LocalEliminatees.getImage((Object)dualFiniteJunct);
            if (!eliminatees.isEmpty()) {
                return new Pair((Object)dualFiniteJunct, (Object)eliminatees);
            }
            ++n4;
        }
        throw new AssertionError((Object)"HashRelation must contain at least one element.");
    }
}

