/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ParameterPartition;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfScout;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class QuantifierPushUtilsForSubsetPush {
    public static Term sequentialSubsetPush(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask et, QuantifierUtils.IQuantifierEliminator qe) {
        List<Term> currentDualFiniteJuncts = Arrays.asList(QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm()));
        if (currentDualFiniteJuncts.size() <= 1) {
            throw new AssertionError((Object)"No dual finite junction");
        }
        if (!QuantifierPushUtils.isFlattened(et.getQuantifier(), currentDualFiniteJuncts)) {
            throw new AssertionError((Object)"Not flattened");
        }
        ParameterPartition pp = new ParameterPartition(mgdScript.getScript(), et);
        if (!pp.isIsPartitionTrivial()) {
            throw new AssertionError((Object)"Is partitionable!");
        }
        ArrayList<TermVariable> currentEliminatees = new ArrayList<TermVariable>(et.getEliminatees());
        ArrayList<TermVariable> failedEliminatees = new ArrayList<TermVariable>();
        List<TermVariable> currentSuitableEliminatees = QuantifierPushUtilsForSubsetPush.findSuitableEliminatees(currentEliminatees, failedEliminatees, currentDualFiniteJuncts, et.getQuantifier());
        int iterations = 0;
        int iterationsWithProgress = 0;
        while (!currentSuitableEliminatees.isEmpty()) {
            Term pushSubformula;
            HashSet<TermVariable> eliminatedMinions;
            QuantifiedFormula qf;
            if (iterations > 20) {
                throw new AssertionError((Object)"Maybe an infinite loop");
            }
            TermVariable eliminatee = XnfScout.selectBestEliminatee(mgdScript.getScript(), et.getQuantifier(), currentSuitableEliminatees, currentDualFiniteJuncts);
            PartitionByEliminateeOccurrence parti = new PartitionByEliminateeOccurrence(currentDualFiniteJuncts, eliminatee);
            List<TermVariable> minionEliminatees = QuantifierPusher.determineMinionEliminatees(currentEliminatees, parti.getFiniteDualJunctsWithoutEliminatee());
            if (!minionEliminatees.contains(eliminatee)) {
                throw new AssertionError((Object)("Missing minion " + eliminatee));
            }
            Term pushed = QuantifierPushUtilsForSubsetPush.pushMinionEliminatees(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, et, qe, minionEliminatees, parti, currentEliminatees);
            ++iterations;
            if (pushed == null) {
                failedEliminatees.add(eliminatee);
                currentSuitableEliminatees = QuantifierPushUtilsForSubsetPush.findSuitableEliminatees(currentEliminatees, failedEliminatees, currentDualFiniteJuncts, et.getQuantifier());
                continue;
            }
            LinkedList<TermVariable> newEliminatees = new LinkedList<TermVariable>();
            if (pushed instanceof QuantifiedFormula) {
                qf = (QuantifiedFormula)pushed;
                eliminatedMinions = new HashSet<TermVariable>(minionEliminatees);
                for (TermVariable tv : Arrays.asList(qf.getVariables())) {
                    if (minionEliminatees.contains(tv)) {
                        eliminatedMinions.remove(tv);
                        if (tv != eliminatee) continue;
                        failedEliminatees.add(eliminatee);
                        continue;
                    }
                    newEliminatees.add(tv);
                }
                pushSubformula = qf.getSubformula();
            } else {
                eliminatedMinions = new HashSet<TermVariable>(minionEliminatees);
                pushSubformula = pushed;
            }
            if (!eliminatedMinions.isEmpty()) {
                ++iterationsWithProgress;
            }
            currentEliminatees.removeAll(eliminatedMinions);
            currentEliminatees.addAll(newEliminatees);
            currentDualFiniteJuncts = new ArrayList<Term>(parti.getFiniteDualJunctsWithoutEliminatee());
            currentDualFiniteJuncts.add(pushSubformula);
            Term currentDualFiniteJunction = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), et.getQuantifier(), currentDualFiniteJuncts);
            EliminationTask etForPreprocessing = new EliminationTask(et.getQuantifier(), new HashSet<TermVariable>(currentEliminatees), currentDualFiniteJunction, et.getContext());
            Pair<Boolean, Term> pair = QuantifierPushUtils.preprocessDualFiniteJunction(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, etForPreprocessing, qe, false, true);
            if (!((Boolean)pair.getFirst()).booleanValue()) {
                return (Term)pair.getSecond();
            }
            qf = (QuantifiedFormula)pair.getSecond();
            currentEliminatees = new ArrayList<TermVariable>(Arrays.asList(qf.getVariables()));
            failedEliminatees.retainAll(currentEliminatees);
            currentDualFiniteJuncts = Arrays.asList(QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), qf.getSubformula()));
            currentSuitableEliminatees = QuantifierPushUtilsForSubsetPush.findSuitableEliminatees(currentEliminatees, failedEliminatees, currentDualFiniteJuncts, et.getQuantifier());
        }
        if (iterationsWithProgress == 0) {
            return null;
        }
        return SmtUtils.quantifier(mgdScript.getScript(), et.getQuantifier(), currentEliminatees, QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), et.getQuantifier(), currentDualFiniteJuncts));
    }

    private static Term pushMinionEliminatees(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask et, QuantifierUtils.IQuantifierEliminator qe, List<TermVariable> minionEliminatees, PartitionByEliminateeOccurrence parti, List<TermVariable> currentEliminatees) {
        Term flattened;
        Term dualFiniteJunction = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), et.getQuantifier(), parti.getFiniteDualJunctsWithEliminatee());
        Term quantified = SmtUtils.quantifier(mgdScript.getScript(), et.getQuantifier(), new HashSet<TermVariable>(minionEliminatees), dualFiniteJunction);
        ArrayList<TermVariable> nonMinionEliminatees = new ArrayList<TermVariable>(currentEliminatees);
        nonMinionEliminatees.removeAll(new HashSet<TermVariable>(minionEliminatees));
        Context parentContext = et.getContext();
        Context context = parentContext.constructChildContextForQuantifiedFormula(mgdScript.getScript(), nonMinionEliminatees);
        context = context.constructChildContextForConDis(services, mgdScript, ((ApplicationTerm)et.getTerm()).getFunction(), parti.getFiniteDualJunctsWithoutEliminatee());
        Term pushed = qe.eliminate(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, context, quantified);
        Object result = pushed == quantified ? null : ((flattened = QuantifierPushUtils.flattenQuantifiedFormulas(mgdScript, et.getQuantifier(), pushed)) == null ? pushed : (flattened == quantified ? null : flattened));
        return result;
    }

    private static List<TermVariable> findSuitableEliminatees(List<TermVariable> currentEliminatees, List<TermVariable> bannedEliminatees, List<Term> currentDualFiniteParams, int quantifier) {
        return currentEliminatees.stream().filter(eliminatee -> !bannedEliminatees.contains(eliminatee) && currentDualFiniteParams.stream().anyMatch(param -> !Arrays.asList(param.getFreeVars()).contains(eliminatee)) && currentDualFiniteParams.stream().anyMatch(param -> Arrays.asList(param.getFreeVars()).contains(eliminatee) && QuantifierPusher.classify(quantifier, param) == QuantifierPusher.FormulaClassification.CORRESPONDING_FINITE_CONNECTIVE)).collect(Collectors.toList());
    }

    private static class PartitionByEliminateeOccurrence {
        private final List<Term> mFiniteDualJunctsWithEliminatee;
        private final List<Term> mFiniteDualJunctsWithoutEliminatee;

        public PartitionByEliminateeOccurrence(List<Term> finiteDualJuncts, TermVariable eliminatee) {
            ArrayList<Term> finiteDualJunctsWithEliminatee = new ArrayList<Term>();
            ArrayList<Term> finiteDualJunctsWithoutEliminatee = new ArrayList<Term>();
            for (Term dualFiniteJunct : finiteDualJuncts) {
                if (Arrays.asList(dualFiniteJunct.getFreeVars()).contains(eliminatee)) {
                    finiteDualJunctsWithEliminatee.add(dualFiniteJunct);
                    continue;
                }
                finiteDualJunctsWithoutEliminatee.add(dualFiniteJunct);
            }
            if (finiteDualJunctsWithEliminatee.isEmpty()) {
                throw new AssertionError((Object)"Eliminatee must occur in at least one dualfiniteJunct");
            }
            if (finiteDualJunctsWithoutEliminatee.isEmpty()) {
                throw new AssertionError((Object)"Eliminatee must not occur all dualfiniteJuncts");
            }
            this.mFiniteDualJunctsWithEliminatee = finiteDualJunctsWithEliminatee;
            this.mFiniteDualJunctsWithoutEliminatee = finiteDualJunctsWithoutEliminatee;
        }

        public List<Term> getFiniteDualJunctsWithEliminatee() {
            return this.mFiniteDualJunctsWithEliminatee;
        }

        public List<Term> getFiniteDualJunctsWithoutEliminatee() {
            return this.mFiniteDualJunctsWithoutEliminatee;
        }
    }
}

