/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisDepthCodeGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQeAdapter2014;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionSaa;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionTir;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushUtilsForSubsetPush;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfIrd;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfPlr;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfScout;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfTir;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfUpd;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QuantifierPusher
extends TermTransformer {
    private static final boolean DEBUG_CHECK_RESULT = false;
    private final Script mScript;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final PqeTechniques mPqeTechniques;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final Set<TermVariable> mBannedForDivCapture;
    private final boolean mApplyDistributivity;

    private QuantifierPusher(ManagedScript script, IUltimateServiceProvider services, boolean applyDistributivity, PqeTechniques quantifierEliminationTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Set<TermVariable> bannedForDivCapture) {
        this.mServices = services;
        this.mMgdScript = script;
        this.mScript = script.getScript();
        this.mApplyDistributivity = applyDistributivity;
        this.mPqeTechniques = quantifierEliminationTechniques;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mBannedForDivCapture = bannedForDivCapture;
    }

    @Deprecated
    public static Term eliminate(IUltimateServiceProvider services, ManagedScript script, boolean applyDistributivity, PqeTechniques quantifierEliminationTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Set<TermVariable> bannedForDivCapture, Term inputTerm) {
        ILogger logger = services.getLoggingService().getLogger(QuantifierPusher.class);
        SmtUtils.ExtendedSimplificationResult esr1 = SmtUtils.simplifyWithStatistics(script, inputTerm, services, SmtUtils.SimplificationTechnique.POLY_PAC);
        logger.info((Object)esr1.buildSizeReductionMessage());
        Term result = new QuantifierPusher(script, services, applyDistributivity, quantifierEliminationTechniques, simplificationTechnique, bannedForDivCapture).transform(esr1.getSimplifiedTerm());
        SmtUtils.ExtendedSimplificationResult esr2 = SmtUtils.simplifyWithStatistics(script, result, services, SmtUtils.SimplificationTechnique.POLY_PAC);
        logger.info((Object)(String.valueOf(esr2.buildSizeReductionMessage()) + " " + new DAGSize().treesize(esr2.getSimplifiedTerm())));
        return result;
    }

    public static Term eliminate(IUltimateServiceProvider services, ManagedScript script, boolean applyDistributivity, PqeTechniques quantifierEliminationTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Context context, Term inputTerm) {
        services.getLoggingService().getLogger(QuantifierPusher.class).warn((Object)"Ignoring assumption.");
        return QuantifierPusher.eliminate(services, script, applyDistributivity, quantifierEliminationTechniques, simplificationTechnique, inputTerm);
    }

    public static Term eliminate(IUltimateServiceProvider services, ManagedScript script, boolean applyDistributivity, PqeTechniques quantifierEliminationTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Term inputTerm) {
        return QuantifierPusher.eliminate(services, script, applyDistributivity, quantifierEliminationTechniques, simplificationTechnique, Collections.emptySet(), inputTerm);
    }

    protected void convert(Term term) {
        FormulaClassification classification = null;
        Term currentTerm = term;
        block8: while (true) {
            classification = QuantifierPusher.classify(currentTerm);
            switch (classification) {
                case NOT_QUANTIFIED: {
                    super.convert(currentTerm);
                    return;
                }
                case SAME_QUANTIFIER: {
                    currentTerm = QuantifierUtils.flattenQuantifiers(this.mScript, (QuantifiedFormula)currentTerm);
                    continue block8;
                }
                case DUAL_QUANTIFIER: {
                    EliminationTask et = new EliminationTask((QuantifiedFormula)currentTerm, new Context(this.mMgdScript.term(null, "true", new Term[0]), this.mBannedForDivCapture));
                    Term tmp = QuantifierPusher.processDualQuantifier(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, et, QuantifierPusher::eliminate);
                    FormulaClassification tmpClassification = QuantifierPusher.classify(tmp);
                    if (tmpClassification == FormulaClassification.DUAL_QUANTIFIER) {
                        this.setResult(tmp);
                        return;
                    }
                    currentTerm = tmp;
                    continue block8;
                }
                case CORRESPONDING_FINITE_CONNECTIVE: {
                    currentTerm = QuantifierPusher.pushOverCorrespondingFiniteConnective(this.mScript, (QuantifiedFormula)currentTerm);
                    assert (currentTerm != null) : "corresponding connective case must never fail";
                    continue block8;
                }
                case ATOM: {
                    Term tmp = QuantifierPusher.applyEliminationToAtom(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, new Context(this.mMgdScript.term(null, "true", new Term[0]), this.mBannedForDivCapture), (QuantifiedFormula)currentTerm);
                    if (tmp == null) {
                        Term res = QuantifierPusher.pushInner(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, this.mBannedForDivCapture, (QuantifiedFormula)currentTerm, this.mMgdScript.term(null, "true", new Term[0]), QuantifierPusher::eliminate);
                        this.setResult(res);
                        return;
                    }
                    currentTerm = tmp;
                    continue block8;
                }
                case DUAL_FINITE_CONNECTIVE: {
                    EliminationTask et = new EliminationTask((QuantifiedFormula)currentTerm, new Context(this.mMgdScript.term(null, "true", new Term[0]), this.mBannedForDivCapture));
                    Term tmp = QuantifierPusher.tryToPushOverDualFiniteConnective(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, et, QuantifierPusher::eliminate);
                    if (tmp == null) {
                        Term res = QuantifierPusher.pushInner(this.mServices, this.mMgdScript, this.mApplyDistributivity, this.mPqeTechniques, this.mSimplificationTechnique, this.mBannedForDivCapture, (QuantifiedFormula)currentTerm, this.mMgdScript.term(null, "true", new Term[0]), QuantifierPusher::eliminate);
                        this.setResult(res);
                        return;
                    }
                    currentTerm = tmp;
                    continue block8;
                }
            }
            break;
        }
        throw new AssertionError((Object)("unknown value " + (Object)((Object)classification)));
    }

    public static Term pushInner(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Set<TermVariable> bannedForDivCapture, QuantifiedFormula quantifiedFormula, Term criticalConstraint, QuantifierUtils.IQuantifierEliminator qe) {
        Context context = new Context(criticalConstraint, bannedForDivCapture);
        Context childContext = context.constructChildContextForQuantifiedFormula(mgdScript.getScript(), Arrays.asList(quantifiedFormula.getVariables()));
        Term subFormulaPushed = qe.eliminate(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, childContext, quantifiedFormula.getSubformula());
        Term res = SmtUtils.quantifier(mgdScript.getScript(), quantifiedFormula.getQuantifier(), new HashSet<TermVariable>(Arrays.asList(quantifiedFormula.getVariables())), subFormulaPushed);
        return res;
    }

    public static Term applyEliminationToAtom(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, PqeTechniques pqeTechniques, Context context, QuantifiedFormula quantifiedFormula) {
        EliminationTask et = new EliminationTask(quantifiedFormula, context);
        Term elimResult = et.getEliminatees().size() < quantifiedFormula.getVariables().length ? et.toTerm(mgdScript.getScript()) : QuantifierPusher.applyDualJunctionEliminationTechniques(et, mgdScript, services, pqeTechniques);
        return elimResult;
    }

    public static Term pushOverCorrespondingFiniteConnective(Script script, QuantifiedFormula quantifiedFormula) {
        assert (quantifiedFormula.getSubformula() instanceof ApplicationTerm);
        ApplicationTerm appTerm = (ApplicationTerm)quantifiedFormula.getSubformula();
        assert (appTerm.getFunction().getApplicationString().equals(SmtUtils.getCorrespondingFiniteConnective(quantifiedFormula.getQuantifier())));
        Term[] oldParams = appTerm.getParameters();
        Term[] newParams = new Term[oldParams.length];
        int i = 0;
        while (i < oldParams.length) {
            newParams[i] = SmtUtils.quantifier(script, quantifiedFormula.getQuantifier(), new HashSet<TermVariable>(Arrays.asList(quantifiedFormula.getVariables())), oldParams[i]);
            ++i;
        }
        return script.term(appTerm.getFunction().getName(), newParams);
    }

    public static Term tryToPushOverDualFiniteConnective(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask et, QuantifierUtils.IQuantifierEliminator qe) {
        Pair<Boolean, Term> pair = QuantifierPushUtils.preprocessDualFiniteJunction(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, et, qe, false, true);
        if (!((Boolean)pair.getFirst()).booleanValue()) {
            return (Term)pair.getSecond();
        }
        EliminationTask preprocessedEt = new EliminationTask((QuantifiedFormula)pair.getSecond(), et.getContext());
        Term eliminationResult = QuantifierPusher.applyDualJunctionEliminationTechniques(preprocessedEt, mgdScript, services, pqeTechniques);
        if (eliminationResult != null) {
            return eliminationResult;
        }
        if (!applyDistributivity) {
            return null;
        }
        Term seq = QuantifierPushUtilsForSubsetPush.sequentialSubsetPush(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, preprocessedEt, qe);
        if (seq != null) {
            return seq;
        }
        return QuantifierPusher.applyDistributivityAndPush(services, mgdScript, pqeTechniques, simplificationTechnique, preprocessedEt, qe, true, false);
    }

    private static boolean isDualFiniteConnective(EliminationTask et) {
        if (et.getTerm() instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)et.getTerm();
            return appTerm.getFunction().getApplicationString().equals(SmtUtils.getCorrespondingFiniteConnective(SmtUtils.getOtherQuantifier(et.getQuantifier())));
        }
        return false;
    }

    public static Term applyDistributivityAndPush(IUltimateServiceProvider services, ManagedScript mgdScript, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask et, QuantifierUtils.IQuantifierEliminator qe, boolean derBasedDistributivityParameterPreselection, boolean evaluateSuccessOfDistributivityApplication) {
        int rec;
        Term[] dualFiniteParams = QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm());
        if (dualFiniteParams.length == 1) {
            throw new AssertionError((Object)"No dual finite junction");
        }
        if (derBasedDistributivityParameterPreselection && (rec = XnfScout.computeRecommendation(mgdScript.getScript(), et.getEliminatees(), dualFiniteParams, et.getQuantifier())) != -1) {
            Term correspondingFinite = QuantifierPusher.applyDistributivityAndPushOneStep(services, mgdScript, et.getQuantifier(), et.getEliminatees(), et.getContext(), dualFiniteParams, rec);
            return correspondingFinite;
        }
        int i = 0;
        while (i < dualFiniteParams.length) {
            if (QuantifierPusher.isCorrespondingFinite(dualFiniteParams[i], et.getQuantifier())) {
                List<TermVariable> freeVars = Arrays.asList(dualFiniteParams[i].getFreeVars());
                if (DataStructureUtils.intersection(new HashSet<TermVariable>(freeVars), et.getEliminatees()).isEmpty()) {
                    throw new AssertionError((Object)"Useless application of distibutivity, no eliminatee involved.");
                }
                Term correspondingFinite = QuantifierPusher.applyDistributivityAndPushOneStep(services, mgdScript, et.getQuantifier(), et.getEliminatees(), et.getContext(), dualFiniteParams, i);
                if (!evaluateSuccessOfDistributivityApplication) {
                    return correspondingFinite;
                }
                Term pushed = qe.eliminate(services, mgdScript, true, pqeTechniques, simplificationTechnique, et.getContext(), correspondingFinite);
                if (QuantifierPusher.allStillQuantified(et.getEliminatees(), pushed)) {
                    return null;
                }
                return pushed;
            }
            ++i;
        }
        return null;
    }

    private Map<TermVariable, Long> computeTreesizeOfInhabitedParams(List<TermVariable> eliminatees, List<Term> currentDualFiniteParams) {
        List treeSize = currentDualFiniteParams.stream().map(x -> new DAGSize().treesize(x)).collect(Collectors.toList());
        HashMap<TermVariable, Long> result = new HashMap<TermVariable, Long>();
        for (TermVariable eliminatee : eliminatees) {
            long s = 0L;
            int i = 0;
            while (i < currentDualFiniteParams.size()) {
                if (Arrays.asList(currentDualFiniteParams.get(i).getFreeVars()).contains(eliminatee)) {
                    s += ((Long)treeSize.get(i)).longValue();
                }
                ++i;
            }
            result.put(eliminatee, s);
        }
        return result;
    }

    private static List<TermVariable> remaningEliminateeThatDoNotOccurInAllParams(List<TermVariable> remainingEliminatees, List<Term> currentDualFiniteParams) {
        return remainingEliminatees.stream().filter(eliminatee -> currentDualFiniteParams.stream().anyMatch(param -> !Arrays.asList(param.getFreeVars()).contains(eliminatee))).collect(Collectors.toList());
    }

    public static List<TermVariable> determineMinionEliminatees(Collection<TermVariable> eliminatees, List<Term> termsWithoutMasterEliminatee) {
        return eliminatees.stream().filter(eliminatee -> termsWithoutMasterEliminatee.stream().allMatch(param -> !Arrays.asList(param.getFreeVars()).contains(eliminatee))).collect(Collectors.toList());
    }

    private static boolean allStillQuantified(Set<TermVariable> eliminatees, Term pushed) {
        Set<Term> quantifiedFormulas = SubTermFinder.find(pushed, x -> x instanceof QuantifiedFormula, false);
        Set allQuantifiedVars = quantifiedFormulas.stream().map(x -> ((QuantifiedFormula)x).getVariables()).flatMap(termVariableArray -> Stream.of(termVariableArray)).collect(Collectors.toSet());
        return allQuantifiedVars.containsAll(eliminatees);
    }

    private static Term applyDistributivityAndPushOneStep(IUltimateServiceProvider services, ManagedScript mgdScript, int quantifier, Set<TermVariable> eliminatees, Context context, Term[] dualFiniteParams, int i) {
        Term[] correspondingFiniteParams = QuantifierUtils.getCorrespondingFiniteJunction(quantifier, dualFiniteParams[i]);
        ArrayList<Term> otherDualFiniteParams = new ArrayList<Term>(dualFiniteParams.length - 1);
        int j = 0;
        while (j < dualFiniteParams.length) {
            if (j != i) {
                otherDualFiniteParams.add(dualFiniteParams[j]);
            }
            ++j;
        }
        Term[] resultOuterParams = new Term[correspondingFiniteParams.length];
        int offset = 0;
        Term[] termArray = correspondingFiniteParams;
        int n = correspondingFiniteParams.length;
        int n2 = 0;
        while (n2 < n) {
            Term cfp = termArray[n2];
            ArrayList<Term> resultInnerParams = new ArrayList<Term>();
            resultInnerParams.add(cfp);
            resultInnerParams.addAll(otherDualFiniteParams);
            resultOuterParams[offset] = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), quantifier, resultInnerParams);
            resultOuterParams[offset] = SmtUtils.quantifier(mgdScript.getScript(), quantifier, eliminatees, resultOuterParams[offset]);
            ++offset;
            ++n2;
        }
        ILogger logger = services.getLoggingService().getLogger(QuantifierPusher.class);
        if (logger.isDebugEnabled()) {
            CondisDepthCodeGenerator.CondisDepthCode cdc = CondisDepthCodeGenerator.CondisDepthCode.of(QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), quantifier, dualFiniteParams));
            String message = "Distributing " + resultOuterParams.length + " " + QuantifierUtils.getNameOfCorrespondingJuncts(quantifier) + " over " + dualFiniteParams.length + " " + QuantifierUtils.getNameOfDualJuncts(quantifier) + ". " + "Applying distributivity to a " + cdc + " term";
            logger.info((Object)message);
        }
        Term result = QuantifierUtils.applyCorrespondingFiniteConnective(mgdScript.getScript(), quantifier, resultOuterParams);
        Term simplifiedResult = QuantifierPusher.simplify(services, mgdScript, SimplificationOccasion.AFTER_DISTRIBTIVITY, SmtUtils.SimplificationTechnique.POLY_PAC, context, result);
        return simplifiedResult;
    }

    private static boolean isCorrespondingFinite(Term term, int quantifier) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getApplicationString().equals(SmtUtils.getCorrespondingFiniteConnective(quantifier));
        }
        return false;
    }

    private static Term applyDualJunctionEliminationTechniques(EliminationTask et, ManagedScript mgdScript, IUltimateServiceProvider services, PqeTechniques pqeTechniques) {
        return QuantifierPusher.applyNewEliminationTechniquesExhaustively(services, mgdScript, pqeTechniques, et);
    }

    @Deprecated
    private Term applyOldEliminationTechniquesSequentially(EliminationTask et, ManagedScript mgdScript, IUltimateServiceProvider services, PqeTechniques pqeTechniques) {
        int numberOfEliminateesBefore = et.getEliminatees().size();
        List<XjunctPartialQuantifierElimination> elimtechniques = QuantifierPusher.generateOldEliminationTechniques(pqeTechniques, mgdScript, services);
        Term[] dualFiniteParams = QuantifierUtils.getDualFiniteJunction(et.getQuantifier(), et.getTerm());
        for (XjunctPartialQuantifierElimination technique : elimtechniques) {
            Term[] elimResulDualFiniteParams = technique.tryToEliminate(et.getQuantifier(), dualFiniteParams, new HashSet<TermVariable>(et.getEliminatees()));
            Term result = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), et.getQuantifier(), Arrays.asList(elimResulDualFiniteParams));
            Set<TermVariable> eliminateesAfterwards = PartialQuantifierElimination.constructNewEliminatees(result, et.getEliminatees());
            if (eliminateesAfterwards.isEmpty()) {
                return result;
            }
            if (numberOfEliminateesBefore <= eliminateesAfterwards.size()) continue;
            Term quantified = SmtUtils.quantifier(mgdScript.getScript(), et.getQuantifier(), eliminateesAfterwards, result);
            return quantified;
        }
        return null;
    }

    private Term applyNewEliminationTechniquesSequentially(EliminationTask et, ManagedScript mgdScript, IUltimateServiceProvider services, PqeTechniques pqeTechniques) {
        List<DualJunctionQuantifierElimination> elimtechniques = QuantifierPusher.generateNewEliminationTechniques(pqeTechniques, mgdScript, services);
        EliminationTask currentEt = et;
        for (DualJunctionQuantifierElimination djqe : elimtechniques) {
            DualJunctionQuantifierElimination.EliminationResult er = djqe.tryToEliminate(currentEt);
            if (er == null) continue;
            if (!er.getNewEliminatees().isEmpty()) {
                throw new AssertionError((Object)"to be implemented");
            }
            currentEt = er.getEliminationTask();
            Term iRes = currentEt.toTerm(mgdScript.getScript());
            return iRes;
        }
        return null;
    }

    private static Term applyNewEliminationTechniquesExhaustively(IUltimateServiceProvider services, ManagedScript mgdScript, PqeTechniques pqeTechniques, EliminationTask inputEt) {
        List<DualJunctionQuantifierElimination> elimtechniques = QuantifierPusher.generateNewEliminationTechniques(pqeTechniques, mgdScript, services);
        DualJunctionQuantifierElimination.EliminationResult er = QuantifierPusher.tryToEliminateOne(services, inputEt, elimtechniques);
        if (er == null) {
            return null;
        }
        EliminationTask resultEt = er.integrateNewEliminatees();
        assert (resultEt.getContext() == inputEt.getContext()) : "Illegal modification of context";
        Term simplifiedTerm = QuantifierPusher.simplify(services, mgdScript, SimplificationOccasion.AFTER_ELIMINATION_TECHNIQUES, SmtUtils.SimplificationTechnique.POLY_PAC, resultEt.getContext(), resultEt.getTerm());
        resultEt = resultEt.update(simplifiedTerm);
        return resultEt.toTerm(mgdScript.getScript());
    }

    private static DualJunctionQuantifierElimination.EliminationResult tryToEliminateOne(IUltimateServiceProvider services, EliminationTask currentEt, List<DualJunctionQuantifierElimination> elimtechniques) {
        ILogger logger = services.getLoggingService().getLogger(QuantifierPusher.class);
        for (DualJunctionQuantifierElimination djqe : elimtechniques) {
            DualJunctionQuantifierElimination.EliminationResult er = djqe.tryToEliminate(currentEt);
            if (logger.isDebugEnabled()) {
                if (er != null) {
                    logger.debug((Object)String.format("At least one variable eliminated via %s: %s", djqe.getAcronym(), currentEt.getEliminatees()));
                } else {
                    logger.debug((Object)String.format("No variable eliminated via %s: %s", djqe.getAcronym(), currentEt.getEliminatees()));
                }
            }
            if (er == null) continue;
            if (er.getEliminationTask().getEliminatees().equals(currentEt.getEliminatees())) {
                logger.warn((Object)"no eliminatee completely removed, nonetheless the elimination was considered successful");
            }
            return er;
        }
        return null;
    }

    @Deprecated
    private List<DualJunctionQuantifierElimination> generateOldEliminationTechniquesWithAdapter(PqeTechniques pqeTechniques, ManagedScript mgdScript, IUltimateServiceProvider services) {
        ArrayList<DualJunctionQuantifierElimination> elimtechniques = new ArrayList<DualJunctionQuantifierElimination>();
        switch (pqeTechniques) {
            case ALL_LOCAL: {
                new DualJunctionQeAdapter2014(mgdScript, services, null);
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfPlr(mgdScript, services)));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfDer(mgdScript, services)));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfIrd(mgdScript, services)));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfTir(mgdScript, services, SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION)));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfUpd(mgdScript, services)));
                break;
            }
            case NO_UPD: {
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfPlr(mgdScript, services)));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfDer(mgdScript, services)));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfIrd(mgdScript, services)));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfTir(mgdScript, services, SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION)));
                break;
            }
            case ONLY_DER: {
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfDer(mgdScript, services)));
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + (Object)((Object)pqeTechniques)));
            }
        }
        return elimtechniques;
    }

    private static List<DualJunctionQuantifierElimination> generateNewEliminationTechniques(PqeTechniques pqeTechniques, ManagedScript mgdScript, IUltimateServiceProvider services) {
        ArrayList<DualJunctionQuantifierElimination> elimtechniques = new ArrayList<DualJunctionQuantifierElimination>();
        switch (pqeTechniques) {
            case ALL: {
                elimtechniques.add(new DualJunctionDer(mgdScript, services, false));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfIrd(mgdScript, services)));
                elimtechniques.add(new DualJunctionTir(mgdScript, services, true));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfUpd(mgdScript, services)));
                elimtechniques.add(new DualJunctionDer(mgdScript, services, true));
                elimtechniques.add(new DualJunctionSaa(mgdScript, services, true));
                break;
            }
            case ALL_LOCAL: {
                elimtechniques.add(new DualJunctionDer(mgdScript, services, false));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfIrd(mgdScript, services)));
                elimtechniques.add(new DualJunctionTir(mgdScript, services, false));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfUpd(mgdScript, services)));
                elimtechniques.add(new DualJunctionDer(mgdScript, services, true));
                break;
            }
            case NO_UPD: {
                elimtechniques.add(new DualJunctionDer(mgdScript, services, false));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfIrd(mgdScript, services)));
                elimtechniques.add(new DualJunctionTir(mgdScript, services, false));
                elimtechniques.add(new DualJunctionDer(mgdScript, services, true));
                break;
            }
            case ONLY_DER: {
                elimtechniques.add(new DualJunctionDer(mgdScript, services, false));
                elimtechniques.add(new DualJunctionDer(mgdScript, services, true));
                break;
            }
            case LIGHT: {
                elimtechniques.add(new DualJunctionDer(mgdScript, services, false));
                elimtechniques.add(new DualJunctionQeAdapter2014(mgdScript, services, new XnfIrd(mgdScript, services)));
                elimtechniques.add(new DualJunctionTir(mgdScript, services, false));
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + (Object)((Object)pqeTechniques)));
            }
        }
        return elimtechniques;
    }

    @Deprecated
    private static List<XjunctPartialQuantifierElimination> generateOldEliminationTechniques(PqeTechniques pqeTechniques, ManagedScript mgdScript, IUltimateServiceProvider services) {
        ArrayList<XjunctPartialQuantifierElimination> elimtechniques = new ArrayList<XjunctPartialQuantifierElimination>();
        switch (pqeTechniques) {
            case ALL_LOCAL: {
                elimtechniques.add(new XnfPlr(mgdScript, services));
                elimtechniques.add(new XnfDer(mgdScript, services));
                elimtechniques.add(new XnfIrd(mgdScript, services));
                elimtechniques.add(new XnfTir(mgdScript, services, SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION));
                elimtechniques.add(new XnfUpd(mgdScript, services));
                break;
            }
            case NO_UPD: {
                elimtechniques.add(new XnfPlr(mgdScript, services));
                elimtechniques.add(new XnfDer(mgdScript, services));
                elimtechniques.add(new XnfIrd(mgdScript, services));
                elimtechniques.add(new XnfTir(mgdScript, services, SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION));
                break;
            }
            case ONLY_DER: {
                elimtechniques.add(new XnfDer(mgdScript, services));
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + (Object)((Object)pqeTechniques)));
            }
        }
        return elimtechniques;
    }

    public static FormulaClassification classify(Term term) {
        if (term instanceof QuantifiedFormula) {
            QuantifiedFormula qf = (QuantifiedFormula)term;
            return QuantifierPusher.classify(qf.getQuantifier(), qf.getSubformula());
        }
        return FormulaClassification.NOT_QUANTIFIED;
    }

    public static FormulaClassification classify(int quantifier, Term subformula) {
        ApplicationTerm appTerm;
        QuantifiedFormula quantifiedSubFormula;
        FormulaClassification result = subformula instanceof QuantifiedFormula ? ((quantifiedSubFormula = (QuantifiedFormula)subformula).getQuantifier() == quantifier ? FormulaClassification.SAME_QUANTIFIER : FormulaClassification.DUAL_QUANTIFIER) : (subformula instanceof ApplicationTerm ? (QuantifierUtils.isDualFiniteJunction(quantifier, (Term)(appTerm = (ApplicationTerm)subformula)) ? FormulaClassification.DUAL_FINITE_CONNECTIVE : (QuantifierUtils.isCorrespondingFiniteJunction(quantifier, (Term)appTerm) ? FormulaClassification.CORRESPONDING_FINITE_CONNECTIVE : FormulaClassification.ATOM)) : FormulaClassification.ATOM);
        return result;
    }

    public static Term processDualQuantifier(IUltimateServiceProvider services, ManagedScript mgdScript, boolean applyDistributivity, PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask et, QuantifierUtils.IQuantifierEliminator qe) {
        assert (et.getTerm() instanceof QuantifiedFormula);
        QuantifiedFormula quantifiedSubFormula = (QuantifiedFormula)et.getTerm();
        assert (quantifiedSubFormula.getQuantifier() == SmtUtils.getOtherQuantifier(et.getQuantifier()));
        Context childContext = et.getContext().constructChildContextForQuantifiedFormula(mgdScript.getScript(), Arrays.asList(quantifiedSubFormula.getVariables()));
        Term quantifiedSubFormulaPushed = qe.eliminate(services, mgdScript, applyDistributivity, pqeTechniques, simplificationTechnique, childContext, et.getTerm());
        Term result = SmtUtils.quantifier(mgdScript.getScript(), et.getQuantifier(), new HashSet<TermVariable>(et.getEliminatees()), quantifiedSubFormulaPushed);
        return result;
    }

    public static Term simplify(IUltimateServiceProvider services, ManagedScript mgdScript, SimplificationOccasion occasion, SmtUtils.SimplificationTechnique simplificationTechnique, Context context, Term term) {
        SmtUtils.ExtendedSimplificationResult esr = SmtUtils.simplifyWithStatistics(mgdScript, term, context.getCriticalConstraint(), services, simplificationTechnique);
        ILogger logger = services.getLoggingService().getLogger(QuantifierPusher.class);
        if (logger.isDebugEnabled()) {
            CondisDepthCodeGenerator.CondisDepthCode termCdc = CondisDepthCodeGenerator.CondisDepthCode.of(term);
            logger.info((Object)("Simplification " + occasion.getLogString() + " via " + String.valueOf((Object)simplificationTechnique) + ": " + esr.buildSizeReductionMessage() + " CDC code " + termCdc));
        }
        return esr.getSimplifiedTerm();
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        if (appTerm.getFunction().getApplicationString().equals("and")) {
            this.setResult(SmtUtils.and(this.mScript, newArgs));
        } else if (appTerm.getFunction().getApplicationString().equals("or")) {
            this.setResult(SmtUtils.or(this.mScript, newArgs));
        } else {
            super.convertApplicationTerm(appTerm, newArgs);
        }
    }

    public static enum FormulaClassification {
        NOT_QUANTIFIED,
        CORRESPONDING_FINITE_CONNECTIVE,
        DUAL_FINITE_CONNECTIVE,
        SAME_QUANTIFIER,
        DUAL_QUANTIFIER,
        ATOM;

    }

    public static enum PqeTechniques {
        ONLY_DER,
        ALL_LOCAL,
        NO_UPD,
        ALL,
        LIGHT;

    }

    public static enum SimplificationOccasion {
        ATOM,
        AFTER_ELIMINATION_TECHNIQUES,
        AFTER_DISTRIBTIVITY;


        public String getLogString() {
            String result;
            switch (this) {
                case AFTER_ELIMINATION_TECHNIQUES: {
                    result = "after elimination techniques";
                    break;
                }
                case AFTER_DISTRIBTIVITY: {
                    result = "after distributivity";
                    break;
                }
                case ATOM: {
                    result = "of atom";
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + (Object)((Object)this)));
                }
            }
            return result;
        }
    }
}

