/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class QuantifierSequence {
    private final ManagedScript mMgdScript;
    private final List<QuantifiedVariables> mQuantifierBlocks;
    private Term mInnerTerm;

    public QuantifierSequence(ManagedScript mgdScript, Term innerTerm, List<QuantifiedVariables> quantifierBlocks) {
        this.mMgdScript = mgdScript;
        this.mInnerTerm = innerTerm;
        this.mQuantifierBlocks = quantifierBlocks;
    }

    public QuantifierSequence(ManagedScript mgdScript, Term input) {
        this.mMgdScript = mgdScript;
        this.mQuantifierBlocks = new ArrayList<QuantifiedVariables>();
        Term innerTerm = input;
        while (innerTerm instanceof QuantifiedFormula) {
            QuantifiedFormula qf = (QuantifiedFormula)innerTerm;
            Set<TermVariable> variables = SmtUtils.projectToFreeVars(new HashSet<TermVariable>(Arrays.asList(qf.getVariables())), qf.getSubformula());
            if (!variables.isEmpty()) {
                int quantifier = qf.getQuantifier();
                if (this.mQuantifierBlocks.isEmpty() || this.mQuantifierBlocks.get(this.mQuantifierBlocks.size() - 1).getQuantifier() != quantifier) {
                    QuantifiedVariables qv = new QuantifiedVariables(qf.getQuantifier(), variables);
                    this.mQuantifierBlocks.add(qv);
                } else {
                    QuantifiedVariables last = this.mQuantifierBlocks.remove(this.mQuantifierBlocks.size() - 1);
                    HashSet<TermVariable> newQuantifiedVariables = new HashSet<TermVariable>(last.getVariables());
                    newQuantifiedVariables.addAll(variables);
                    this.mQuantifierBlocks.add(new QuantifiedVariables(quantifier, newQuantifiedVariables));
                }
            }
            innerTerm = qf.getSubformula();
        }
        for (QuantifiedVariables qb : this.mQuantifierBlocks) {
            if (!qb.getVariables().isEmpty()) continue;
            throw new IllegalArgumentException("empty set not allowed");
        }
        this.mInnerTerm = innerTerm;
    }

    public static Term prependQuantifierSequence(Script script, List<QuantifiedVariables> quantifierSequence, Term term) {
        Term result = term;
        int i = quantifierSequence.size() - 1;
        while (i >= 0) {
            QuantifiedVariables quantifiedVars = quantifierSequence.get(i);
            result = script.quantifier(quantifiedVars.getQuantifier(), quantifiedVars.getVariables().toArray(new TermVariable[quantifiedVars.getVariables().size()]), result, (Term[][])new Term[0][]);
            --i;
        }
        return result;
    }

    public Term getInnerTerm() {
        return this.mInnerTerm;
    }

    public Term toTerm() {
        return QuantifierSequence.prependQuantifierSequence(this.mMgdScript.getScript(), this.mQuantifierBlocks, this.mInnerTerm);
    }

    public void replace(Set<TermVariable> forbiddenVariables, ManagedScript freshVarConstructor, String replacementPrefix) {
        Set forbiddenNames = forbiddenVariables.stream().map(TermVariable::getName).collect(Collectors.toSet());
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        for (QuantifiedVariables qv : this.mQuantifierBlocks) {
            for (TermVariable tv : new ArrayList<TermVariable>(qv.getVariables())) {
                if (!forbiddenNames.contains(tv.getName())) continue;
                TermVariable fresh = freshVarConstructor.constructFreshTermVariable(replacementPrefix, tv.getSort());
                substitutionMapping.put(tv, fresh);
                qv.mVariables.remove(tv);
                qv.mVariables.add(fresh);
            }
        }
        this.mInnerTerm = Substitution.apply(this.mMgdScript, substitutionMapping, this.mInnerTerm);
    }

    public static Term mergeQuantifierSequences(ManagedScript mgdScript, String functionSymbolName, QuantifierSequence[] quantifierSequences, HashSet<TermVariable> freeVariables) {
        Term resultInnerTerm;
        Arrays.sort(quantifierSequences, Collections.reverseOrder(Comparator.comparing(QuantifierSequence::getNumberOfQuantifierBlocks)));
        QuantifierSequence largestSequence = quantifierSequences[0];
        ArrayList<QuantifiedVariables> resultQuantifierBlocks = new ArrayList<QuantifiedVariables>(largestSequence.getNumberOfQuantifierBlocks());
        Term[] innerTerms = new Term[quantifierSequences.length];
        int i = 0;
        while (i < largestSequence.getNumberOfQuantifierBlocks()) {
            int quantifierOfLargestSequence = largestSequence.getQuantifierBlocks().get(i).getQuantifier();
            resultQuantifierBlocks.add(new QuantifiedVariables(quantifierOfLargestSequence, new HashSet<TermVariable>()));
            ++i;
        }
        assert (resultQuantifierBlocks.size() == largestSequence.getNumberOfQuantifierBlocks());
        HashSet<TermVariable> occurredVariables = new HashSet<TermVariable>(freeVariables);
        int i2 = 0;
        while (i2 < quantifierSequences.length) {
            quantifierSequences[i2].replace(occurredVariables, mgdScript, "prenex");
            for (QuantifiedVariables quantifiedVariables : quantifierSequences[i2].getQuantifierBlocks()) {
                occurredVariables.addAll(quantifiedVariables.getVariables());
            }
            innerTerms[i2] = quantifierSequences[i2].getInnerTerm();
            if (quantifierSequences[i2].getNumberOfQuantifierBlocks() > 0) {
                QuantifierSequence.integrateQuantifierBlocks(resultQuantifierBlocks, quantifierSequences[i2].getQuantifierBlocks());
            }
            ++i2;
        }
        for (QuantifiedVariables qb : resultQuantifierBlocks) {
            if (!qb.getVariables().isEmpty()) continue;
            throw new IllegalArgumentException("empty set not allowed");
        }
        if (functionSymbolName.equals("and")) {
            resultInnerTerm = SmtUtils.and(mgdScript.getScript(), innerTerms);
        } else if (functionSymbolName.equals("or")) {
            resultInnerTerm = SmtUtils.or(mgdScript.getScript(), innerTerms);
        } else {
            throw new IllegalArgumentException("unsupported " + functionSymbolName);
        }
        Term term = QuantifierSequence.prependQuantifierSequence(mgdScript.getScript(), resultQuantifierBlocks, resultInnerTerm);
        return term;
    }

    private static void integrateQuantifierBlocks(List<QuantifiedVariables> resultQuantifierBlocks, List<QuantifiedVariables> quantifierBlocks) {
        int offset;
        int lastQuantifierCurrent;
        int lastQuantifierResult = resultQuantifierBlocks.get(resultQuantifierBlocks.size() - 1).getQuantifier();
        if (lastQuantifierResult == (lastQuantifierCurrent = quantifierBlocks.get(quantifierBlocks.size() - 1).getQuantifier())) {
            offset = resultQuantifierBlocks.size() - quantifierBlocks.size();
        } else if (resultQuantifierBlocks.size() == quantifierBlocks.size()) {
            resultQuantifierBlocks.add(new QuantifiedVariables(lastQuantifierCurrent, new HashSet<TermVariable>()));
            offset = resultQuantifierBlocks.size() - quantifierBlocks.size();
        } else {
            offset = resultQuantifierBlocks.size() - quantifierBlocks.size() - 1;
        }
        assert (offset >= 0);
        int i = 0;
        while (i < quantifierBlocks.size()) {
            assert (resultQuantifierBlocks.get(i + offset).getQuantifier() == quantifierBlocks.get(i).getQuantifier()) : "wrong offset";
            QuantifiedVariables oldQuantifierBlock = resultQuantifierBlocks.get(i + offset);
            resultQuantifierBlocks.set(i + offset, oldQuantifierBlock.addVariables(quantifierBlocks.get(i).getVariables()));
            ++i;
        }
    }

    public List<QuantifiedVariables> getQuantifierBlocks() {
        return Collections.unmodifiableList(this.mQuantifierBlocks);
    }

    public int getNumberOfQuantifierBlocks() {
        return this.mQuantifierBlocks.size();
    }

    public String toString() {
        return this.mQuantifierBlocks + " " + this.mInnerTerm;
    }

    public String buildQuantifierSequenceStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        for (QuantifiedVariables qb : this.mQuantifierBlocks) {
            sb.append(QuantifierUtils.getAsciiAbbreviation(qb.getQuantifier()));
        }
        return sb.toString();
    }

    public static class QuantifiedVariables {
        private final int mQuantifier;
        private final Set<TermVariable> mVariables;

        public QuantifiedVariables(int quantifier, Set<TermVariable> variables) {
            this.mQuantifier = quantifier;
            this.mVariables = variables;
        }

        public int getQuantifier() {
            return this.mQuantifier;
        }

        public Set<TermVariable> getVariables() {
            return Collections.unmodifiableSet(this.mVariables);
        }

        public String toString() {
            return String.valueOf(this.mQuantifier == 0 ? "exists" : "forall") + this.mVariables + ". ";
        }

        public QuantifiedVariables addVariables(Collection<TermVariable> newVariables) {
            LinkedHashSet<TermVariable> resVariables = new LinkedHashSet<TermVariable>(this.mVariables);
            resVariables.addAll(newVariables);
            return new QuantifiedVariables(this.mQuantifier, resVariables);
        }
    }
}

