/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;

public class QuantifierUtils {
    private QuantifierUtils() {
    }

    public static Term applyCorrespondingFiniteConnective(Script script, int quantifier, Collection<Term> xjunctsOuter) {
        Term result;
        if (quantifier == 0) {
            result = SmtUtils.or(script, xjunctsOuter);
        } else if (quantifier == 1) {
            result = SmtUtils.and(script, xjunctsOuter);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static Term applyCorrespondingFiniteConnective(Script script, int quantifier, Term ... xjunctsOuter) {
        return QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, Arrays.asList(xjunctsOuter));
    }

    public static Term applyDualFiniteConnective(Script script, int quantifier, Collection<Term> xjunctsInner) {
        Term result;
        if (quantifier == 0) {
            result = SmtUtils.and(script, xjunctsInner);
        } else if (quantifier == 1) {
            result = SmtUtils.or(script, xjunctsInner);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static Term applyDualFiniteConnective(Script script, int quantifier, Term ... xjunctsInner) {
        return QuantifierUtils.applyDualFiniteConnective(script, quantifier, Arrays.asList(xjunctsInner));
    }

    public static Term applyDerOperator(Script script, int quantifier, Term lhs, Term rhs) {
        Term result;
        if (quantifier == 0) {
            result = SmtUtils.binaryEquality(script, lhs, rhs);
        } else if (quantifier == 1) {
            result = SmtUtils.distinct(script, lhs, rhs);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static Term applyAntiDerOperator(Script script, int quantifier, Term lhs, Term rhs) {
        Term result;
        if (quantifier == 0) {
            result = SmtUtils.distinct(script, lhs, rhs);
        } else if (quantifier == 1) {
            result = SmtUtils.binaryEquality(script, lhs, rhs);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static Term[] getCorrespondingFiniteJunction(int quantifier, Term term) {
        return QuantifierUtils.getXjunctsOuter(quantifier, term);
    }

    @Deprecated
    public static Term[] getXjunctsOuter(int quantifier, Term xnf) {
        Term[] xjunctsOuter;
        if (quantifier == 0) {
            xjunctsOuter = SmtUtils.getDisjuncts(xnf);
        } else if (quantifier == 1) {
            xjunctsOuter = SmtUtils.getConjuncts(xnf);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return xjunctsOuter;
    }

    public static boolean isDualFiniteJunction(int quantifier, Term term) {
        return QuantifierUtils.getDualFiniteJunction(quantifier, term).length > 1;
    }

    public static boolean isCorrespondingFiniteJunction(int quantifier, Term term) {
        return QuantifierUtils.getCorrespondingFiniteJunction(quantifier, term).length > 1;
    }

    public static Term[] getDualFiniteJunction(int quantifier, Term term) {
        return QuantifierUtils.getXjunctsInner(quantifier, term);
    }

    @Deprecated
    public static Term[] getXjunctsInner(int quantifier, Term xnf) {
        Term[] xjunctsOuter;
        if (quantifier == 0) {
            xjunctsOuter = SmtUtils.getConjuncts(xnf);
        } else if (quantifier == 1) {
            xjunctsOuter = SmtUtils.getDisjuncts(xnf);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return xjunctsOuter;
    }

    public static Term getNeutralElement(Script script, int quantifier) {
        if (quantifier == 0) {
            return script.term("false", new Term[0]);
        }
        if (quantifier == 1) {
            return script.term("true", new Term[0]);
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public static Term getAbsorbingElement(Script script, int quantifier) {
        if (quantifier == 0) {
            return script.term("true", new Term[0]);
        }
        if (quantifier == 1) {
            return script.term("false", new Term[0]);
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public static Term transformToXnf(IUltimateServiceProvider services, Script script, int quantifier, ManagedScript freshTermVariableConstructor, Term term, SmtUtils.XnfConversionTechnique xnfConversionTechnique) throws AssertionError {
        if (quantifier == 0) {
            term = SmtUtils.toDnf(services, freshTermVariableConstructor, term, xnfConversionTechnique);
        } else if (quantifier == 1) {
            term = SmtUtils.toCnf(services, freshTermVariableConstructor, term, xnfConversionTechnique);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return term;
    }

    public static int getCorrespondingQuantifier(String booleanConnective) {
        if (booleanConnective.equals("and")) {
            return 1;
        }
        if (booleanConnective.equals("or")) {
            return 0;
        }
        throw new AssertionError((Object)("unsupported connective " + booleanConnective));
    }

    public static String getDualBooleanConnective(String booleanConnective) {
        if (booleanConnective.equals("and")) {
            return "or";
        }
        if (booleanConnective.equals("or")) {
            return "and";
        }
        throw new AssertionError((Object)("unsupported connective " + booleanConnective));
    }

    public static Term negateIfUniversal(IUltimateServiceProvider services, ManagedScript mgdScript, int quantifier, Term inputTerm) {
        Term result;
        if (quantifier == 0) {
            result = inputTerm;
        } else if (quantifier == 1) {
            result = new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.IS_ATOM).transform(SmtUtils.not(mgdScript.getScript(), inputTerm));
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static Term negateIfUniversal(Script script, int quantifier, Term inputTerm) {
        Term result;
        if (quantifier == 0) {
            result = inputTerm;
        } else if (quantifier == 1) {
            result = SmtUtils.not(script, inputTerm);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static Term negateIfExistential(IUltimateServiceProvider services, ManagedScript mgdScript, int quantifier, Term inputTerm) {
        Term result;
        if (quantifier == 0) {
            result = new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.IS_ATOM).transform(SmtUtils.not(mgdScript.getScript(), inputTerm));
        } else if (quantifier == 1) {
            result = inputTerm;
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static Term negateIfExistential(Script script, int quantifier, Term inputTerm) {
        Term result;
        if (quantifier == 0) {
            result = SmtUtils.not(script, inputTerm);
        } else if (quantifier == 1) {
            result = inputTerm;
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static int getDualQuantifier(int quantifier) {
        if (quantifier == 0) {
            return 1;
        }
        if (quantifier == 1) {
            return 0;
        }
        throw new UnsupportedOperationException("unknown quantifier " + quantifier);
    }

    public static boolean isQuantifierFree(Term term) {
        return !new SubtermPropertyChecker(x -> x instanceof QuantifiedFormula).isSatisfiedBySomeSubterm(term);
    }

    public static String getNameOfCorrespondingJuncts(int quantifier) {
        String result;
        if (quantifier == 0) {
            result = "conjuncts";
        } else if (quantifier == 1) {
            result = "disjuncts";
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static String getNameOfDualJuncts(int quantifier) {
        String result;
        if (quantifier == 0) {
            result = "disjuncts";
        } else if (quantifier == 1) {
            result = "conjuncts";
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    public static String getAsciiAbbreviation(int quantifier) {
        if (quantifier == 0) {
            return "E";
        }
        if (quantifier == 1) {
            return "A";
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public static RelationSymbol getDerOperator(int quantifier) {
        if (quantifier == 0) {
            return RelationSymbol.EQ;
        }
        if (quantifier == 1) {
            return RelationSymbol.DISTINCT;
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public static boolean isDerRelationSymbol(int quantifier, RelationSymbol relSymb) {
        return relSymb.equals((Object)QuantifierUtils.getDerOperator(quantifier));
    }

    public static LinkedHashSet<TermVariable> projectToFreeVars(Collection<TermVariable> vars, Term term) {
        LinkedHashSet<TermVariable> result = new LinkedHashSet<TermVariable>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable freeVar = termVariableArray[n2];
            if (vars.contains(freeVar)) {
                result.add(freeVar);
            }
            ++n2;
        }
        return result;
    }

    public static Term flattenQuantifiers(Script script, QuantifiedFormula qf) {
        return SmtUtils.quantifier(script, qf.getQuantifier(), Arrays.asList(qf.getVariables()), qf.getSubformula());
    }

    @FunctionalInterface
    public static interface IQuantifierEliminator {
        public Term eliminate(IUltimateServiceProvider var1, ManagedScript var2, boolean var3, QuantifierPusher.PqeTechniques var4, SmtUtils.SimplificationTechnique var5, Context var6, Term var7);
    }
}

