/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class SkolemNormalForm {
    private Term mResult;
    private final ManagedScript mMgdScript;
    private final HashRelation3<String, Sort[], Sort> mSkolemFunctions;

    public SkolemNormalForm(ManagedScript mgdScript, Term inputFormula) {
        this.mMgdScript = mgdScript;
        this.mSkolemFunctions = new HashRelation3();
        assert (new PrenexNormalForm(mgdScript).transform(inputFormula) == inputFormula) : "input formula must be in prenex normal form";
        if (!(inputFormula instanceof QuantifiedFormula)) {
            this.mResult = inputFormula;
        } else {
            this.skolemize((QuantifiedFormula)inputFormula);
        }
    }

    private void skolemize(QuantifiedFormula inputFormula) {
        this.mMgdScript.lock(this);
        QuantifierSequence qs = new QuantifierSequence(this.mMgdScript, (Term)inputFormula);
        HashMap<TermVariable, Term> substitutionMapping = new HashMap<TermVariable, Term>();
        QuantifierSequence.QuantifiedVariables universalQuantifiersInScope = new QuantifierSequence.QuantifiedVariables(1, Collections.emptySet());
        for (QuantifierSequence.QuantifiedVariables qb : qs.getQuantifierBlocks()) {
            if (qb.getQuantifier() == 1) {
                universalQuantifiersInScope = new QuantifierSequence.QuantifiedVariables(1, DataStructureUtils.union(qb.getVariables(), universalQuantifiersInScope.getVariables()));
                continue;
            }
            ArrayList<TermVariable> universalVars = new ArrayList<TermVariable>(universalQuantifiersInScope.getVariables());
            Term[] universalVarsArray = universalVars.toArray(new Term[universalVars.size()]);
            List<Sort> paramSortList = universalVars.stream().map(tv -> tv.getSort()).collect(Collectors.toList());
            Sort[] paramSorts = paramSortList.toArray(new Sort[paramSortList.size()]);
            for (TermVariable existVar : qb.getVariables()) {
                Sort resultSort = existVar.getSort();
                String skolemFunctionName = this.getFreshFunctionSymbol(paramSorts, resultSort);
                this.mMgdScript.declareFun(this, skolemFunctionName, paramSorts, resultSort);
                Term ufAppTerm = this.mMgdScript.term((Object)this, skolemFunctionName, universalVarsArray);
                substitutionMapping.put(existVar, ufAppTerm);
            }
        }
        Term newInnerTerm = Substitution.apply(this.mMgdScript, substitutionMapping, qs.getInnerTerm());
        if (universalQuantifiersInScope.getVariables().isEmpty()) {
            this.mResult = newInnerTerm;
        } else {
            try {
                this.mResult = QuantifierSequence.prependQuantifierSequence(this.mMgdScript.getScript(), Collections.singletonList(universalQuantifiersInScope), newInnerTerm);
            }
            catch (Exception exception) {
                throw new AssertionError();
            }
        }
        this.mMgdScript.unlock(this);
    }

    String getFreshFunctionSymbol(Sort[] parameterSorts, Sort resultSort) {
        String name = this.mMgdScript.constructFreshSkolemFunctionName(parameterSorts, resultSort);
        this.mSkolemFunctions.addTriple((Object)name, (Object)parameterSorts, (Object)resultSort);
        return name;
    }

    public Term getSkolemizedFormula() {
        return this.mResult;
    }

    public HashRelation3<String, Sort[], Sort> getSkolemFunctions() {
        return this.mSkolemFunctions;
    }
}

