/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class TermTransducer<E> {
    private Map<Term, E> mSubtermResult;

    public E transduce(Term term) {
        this.mSubtermResult = new HashMap<Term, E>();
        TermTransducerHelper tth = new TermTransducerHelper();
        tth.transform(term);
        E result = this.mSubtermResult.get(term);
        this.mSubtermResult = null;
        return result;
    }

    protected abstract E transduceImmediately(Term var1);

    protected abstract E transduce(ApplicationTerm var1, List<E> var2);

    private class TermTransducerHelper
    extends TermTransformer {
        private TermTransducerHelper() {
        }

        protected void convert(Term term) {
            Object result = TermTransducer.this.transduceImmediately(term);
            if (result == null) {
                super.convert(term);
            } else {
                this.setResult(term);
                TermTransducer.this.mSubtermResult.put(term, result);
            }
        }

        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            List transducedArguments = Arrays.stream(appTerm.getParameters()).map(TermTransducer.this.mSubtermResult::get).collect(Collectors.toList());
            Object result = TermTransducer.this.transduce(appTerm, transducedArguments);
            TermTransducer.this.mSubtermResult.put((Term)appTerm, result);
            super.convertApplicationTerm(appTerm, newArgs);
        }

        public void preConvertLet(LetTerm oldLet, Term[] newValues) {
            super.preConvertLet(oldLet, newValues);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
            super.postConvertLet(oldLet, newValues, newBody);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
            super.postConvertQuantifier(old, newBody);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
            super.postConvertAnnotation(old, newAnnots, newBody);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void preConvertMatchCase(MatchTerm oldMatch, int caseNr) {
            super.preConvertMatchCase(oldMatch, caseNr);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void postConvertMatch(MatchTerm oldMatch, Term newDataTerm, Term[] newCases) {
            super.postConvertMatch(oldMatch, newDataTerm, newCases);
            throw new UnsupportedOperationException("not yet implemented");
        }
    }
}

