/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EqualityInformation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class XnfDer
extends XjunctPartialQuantifierElimination {
    private static final boolean EXTENDED_DEBUG_OUTPUT = false;

    public XnfDer(ManagedScript script, IUltimateServiceProvider services) {
        super(script, services);
    }

    @Override
    public String getName() {
        return "destructive equality resolution";
    }

    @Override
    public String getAcronym() {
        return "DER";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    @Override
    public Term[] tryToEliminate(int quantifier, Term[] dualJuncts, Set<TermVariable> eliminatees) {
        ArrayList<TermVariable> eliminateesBefore = new ArrayList<TermVariable>(eliminatees);
        HashSet<TermVariable> copyOfeliminatees = new HashSet<TermVariable>(eliminatees);
        this.tryToEliminate_EqInfoBased(quantifier, dualJuncts, copyOfeliminatees);
        Term[] resultAtomsSbr_Based = this.tryToEliminate_SbrBased(quantifier, dualJuncts, eliminatees);
        return resultAtomsSbr_Based;
    }

    private Term[] tryToEliminate_EqInfoBased(int quantifier, Term[] dualJuncts, Set<TermVariable> eliminatees) {
        boolean someVariableWasEliminated;
        Term[] resultAtoms = dualJuncts;
        Set<TermVariable> freeVarsInResultAtoms = SmtUtils.getFreeVars(Arrays.asList(resultAtoms));
        do {
            someVariableWasEliminated = false;
            Iterator<TermVariable> it = eliminatees.iterator();
            while (it.hasNext()) {
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "eliminating " + eliminatees.size() + " quantified variables from " + dualJuncts.length + " xjuncts");
                }
                TermVariable tv = it.next();
                if (!freeVarsInResultAtoms.contains(tv)) {
                    it.remove();
                    continue;
                }
                Term[] withoutTv = this.derSimple(this.mScript, quantifier, resultAtoms, tv, this.mLogger);
                if (withoutTv == null) continue;
                resultAtoms = withoutTv;
                freeVarsInResultAtoms = SmtUtils.getFreeVars(Arrays.asList(resultAtoms));
                it.remove();
                someVariableWasEliminated = true;
            }
        } while (someVariableWasEliminated);
        return resultAtoms;
    }

    private Term[] tryToEliminate_SbrBased(int quantifier, Term[] dualJuncts, Set<TermVariable> eliminatees) {
        LinkedHashMap<Term, PolynomialRelation> term2relation = new LinkedHashMap<Term, PolynomialRelation>();
        Term[] termArray = dualJuncts;
        int n = dualJuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term dualJunct = termArray[n2];
            term2relation.put(dualJunct, null);
            ++n2;
        }
        boolean someVariableWasEliminated = true;
        Set<TermVariable> freeVarsInResultAtoms = SmtUtils.getFreeVars(term2relation.keySet());
        do {
            someVariableWasEliminated = false;
            Iterator<TermVariable> it = eliminatees.iterator();
            while (it.hasNext()) {
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "eliminating " + eliminatees.size() + " quantified variables from " + dualJuncts.length + " xjuncts");
                }
                TermVariable tv = it.next();
                if (!freeVarsInResultAtoms.contains(tv)) {
                    it.remove();
                    continue;
                }
                LinkedHashMap<Term, PolynomialRelation> withoutTv = this.tryToEliminateOneVar(this.mScript, quantifier, term2relation, tv);
                if (withoutTv == null) continue;
                term2relation = withoutTv;
                freeVarsInResultAtoms = SmtUtils.getFreeVars(term2relation.keySet());
                it.remove();
                someVariableWasEliminated = true;
            }
        } while (someVariableWasEliminated);
        return term2relation.keySet().toArray(new Term[term2relation.keySet().size()]);
    }

    private LinkedHashMap<Term, PolynomialRelation> tryToEliminateOneVar(Script script, int quantifier, LinkedHashMap<Term, PolynomialRelation> term2relation, TermVariable tv) {
        Pair<Term, SolvedBinaryRelation> solution = this.tryToSolveWithoutAssumptionsAndUpdateEntries(script, quantifier, term2relation, tv);
        if (solution == null) {
            return null;
        }
        return this.replace(script, term2relation, (SolvedBinaryRelation)solution.getSecond(), (Term)solution.getFirst());
    }

    private Pair<Term, SolvedBinaryRelation> tryToSolveWithoutAssumptionsAndUpdateEntries(Script script, int quantifier, LinkedHashMap<Term, PolynomialRelation> term2relation, TermVariable tv) {
        for (Map.Entry<Term, PolynomialRelation> entry : term2relation.entrySet()) {
            SolvedBinaryRelation sbr;
            if (!Arrays.asList(entry.getKey().getFreeVars()).contains(tv) || (sbr = this.tryToSolveAndUpdateEntry(script, quantifier, tv, entry)) == null) continue;
            return new Pair((Object)entry.getKey(), (Object)sbr);
        }
        return null;
    }

    private LinkedHashMap<Term, PolynomialRelation> replace(Script script, LinkedHashMap<Term, PolynomialRelation> term2relation, SolvedBinaryRelation sbr, Term termOfSbr) {
        Map<Term, Term> substitutionMapping = Collections.singletonMap(sbr.getLeftHandSide(), sbr.getRightHandSide());
        LinkedHashMap<Term, PolynomialRelation> result = new LinkedHashMap<Term, PolynomialRelation>();
        for (Map.Entry<Term, PolynomialRelation> entry : term2relation.entrySet()) {
            if (entry.getKey() == termOfSbr) continue;
            if (Arrays.asList(entry.getKey().getFreeVars()).contains(sbr.getLeftHandSide())) {
                Term replaced = this.substituteAndNormalize(substitutionMapping, entry.getKey());
                assert (UltimateNormalFormUtils.respectsUltimateNormalForm(replaced)) : "Term not in UltimateNormalForm";
                result.put(replaced, null);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private SolvedBinaryRelation tryToSolveAndUpdateEntry(Script script, int quantifier, TermVariable tv, Map.Entry<Term, PolynomialRelation> entry) {
        SolvedBinaryRelation sbr;
        if (entry.getValue() != null) {
            sbr = !XnfDer.isDerRelation(quantifier, entry.getValue().getRelationSymbol()) ? null : entry.getValue().solveForSubject(script, (Term)tv);
        } else {
            BinaryEqualityRelation ber = BinaryEqualityRelation.convert(entry.getKey());
            if (ber == null) {
                return null;
            }
            if (!XnfDer.isDerRelation(quantifier, ber.getRelationSymbol())) {
                sbr = null;
            } else {
                SolvedBinaryRelation sber = ber.solveForSubject(script, (Term)tv);
                if (sber != null) {
                    sbr = sber;
                } else {
                    PolynomialRelation polyRel = PolynomialRelation.convert(script, entry.getKey());
                    if (polyRel == null) {
                        sbr = null;
                    } else {
                        entry.setValue(polyRel);
                        sbr = polyRel.solveForSubject(script, (Term)tv);
                    }
                }
            }
        }
        return sbr;
    }

    private static boolean isDerRelation(int quantifier, RelationSymbol relationSymbol) {
        if (quantifier == 0) {
            return relationSymbol == RelationSymbol.EQ;
        }
        if (quantifier == 1) {
            return relationSymbol == RelationSymbol.DISTINCT;
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    private SolvedBinaryRelation solveForTvBer(Script script, Term key, TermVariable tv) {
        BinaryEqualityRelation ber = BinaryEqualityRelation.convert(key);
        SolvedBinaryRelation res = ber == null ? null : ber.solveForSubject(script, (Term)tv);
        return res;
    }

    private Term[] derSimple(Script script, int quantifier, Term[] inputAtoms, TermVariable tv, ILogger logger) {
        Term[] resultAtoms;
        EqualityInformation eqInfo = EqualityInformation.getEqinfo(script, (Term)tv, inputAtoms, null, quantifier);
        if (eqInfo == null) {
            logger.debug((Object)new DebugMessage("not eliminated quantifier via DER for {0}", new Object[]{tv}));
            resultAtoms = null;
        } else {
            logger.debug((Object)new DebugMessage("eliminated quantifier via DER for {0}", new Object[]{tv}));
            resultAtoms = new Term[inputAtoms.length - 1];
            Map<Term, Term> substitutionMapping = Collections.singletonMap(eqInfo.getGivenTerm(), eqInfo.getRelatedTerm());
            int i = 0;
            while (i < eqInfo.getIndex()) {
                resultAtoms[i] = this.substituteAndNormalize(substitutionMapping, inputAtoms[i]);
                assert (UltimateNormalFormUtils.respectsUltimateNormalForm(resultAtoms[i])) : "Term not in UltimateNormalForm";
                ++i;
            }
            i = eqInfo.getIndex() + 1;
            while (i < inputAtoms.length) {
                resultAtoms[i - 1] = this.substituteAndNormalize(substitutionMapping, inputAtoms[i]);
                assert (UltimateNormalFormUtils.respectsUltimateNormalForm(resultAtoms[i - 1])) : "Term not in UltimateNormalForm";
                ++i;
            }
        }
        return resultAtoms;
    }

    private Term substituteAndNormalize(Map<Term, Term> substitutionMapping, Term term) {
        PolynomialRelation polyRel;
        Term result = Substitution.apply(this.mMgdScript, substitutionMapping, term);
        if (term != result && (polyRel = PolynomialRelation.convert(this.mScript, result)) != null) {
            result = polyRel.positiveNormalForm(this.mScript);
        }
        return result;
    }
}

