/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XnfIrd
extends XjunctPartialQuantifierElimination {
    public XnfIrd(ManagedScript script, IUltimateServiceProvider services) {
        super(script, services);
    }

    @Override
    public String getName() {
        return "infinity restrictor drop";
    }

    @Override
    public String getAcronym() {
        return "IRD";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    @Override
    public Term[] tryToEliminate(int quantifier, Term[] dualJuncts, Set<TermVariable> eliminatees) {
        Iterator<TermVariable> it = eliminatees.iterator();
        Term[] result = dualJuncts;
        while (it.hasNext()) {
            TermVariable tv = it.next();
            if (!SmtUtils.getFreeVars(Arrays.asList(result)).contains(tv)) {
                it.remove();
                continue;
            }
            Term[] withoutTv = XnfIrd.irdSimple(this.mMgdScript, quantifier, result, tv);
            if (withoutTv == null) continue;
            result = withoutTv;
            it.remove();
        }
        return result;
    }

    public static Term[] irdSimple(ManagedScript mgdScript, int quantifier, Term[] oldParams, TermVariable tv) {
        ArrayList<Term> paramsWithoutTv = new ArrayList<Term>();
        int numberOfAntiDer = 0;
        int numberOfUpperBounds = 0;
        int numberOfLowerBounds = 0;
        Term[] termArray = oldParams;
        int n = oldParams.length;
        int n2 = 0;
        while (n2 < n) {
            Term oldParam = termArray[n2];
            if (!Arrays.asList(oldParam.getFreeVars()).contains(tv)) {
                paramsWithoutTv.add(oldParam);
            } else {
                if (!SmtSortUtils.isNumericSort(tv.getSort()) && !SmtSortUtils.isBitvecSort(tv.getSort())) {
                    return null;
                }
                SolvedBinaryRelation sbr = XnfIrd.solve(mgdScript, tv, quantifier, oldParam);
                if (sbr == null) {
                    return null;
                }
                switch (sbr.getRelationSymbol()) {
                    case EQ: {
                        if (quantifier == 0) {
                            return null;
                        }
                        if (quantifier == 1) {
                            ++numberOfAntiDer;
                            break;
                        }
                        throw new AssertionError((Object)"unknown quantifier");
                    }
                    case DISTINCT: {
                        if (quantifier == 0) {
                            ++numberOfAntiDer;
                            break;
                        }
                        if (quantifier == 1) {
                            return null;
                        }
                        throw new AssertionError((Object)"unknown quantifier");
                    }
                    case GEQ: 
                    case GREATER: {
                        if (numberOfUpperBounds > 0) {
                            return null;
                        }
                        ++numberOfLowerBounds;
                        break;
                    }
                    case LEQ: 
                    case LESS: {
                        if (numberOfLowerBounds > 0) {
                            return null;
                        }
                        ++numberOfUpperBounds;
                        break;
                    }
                    case BVULE: 
                    case BVULT: 
                    case BVUGE: 
                    case BVUGT: 
                    case BVSLE: 
                    case BVSLT: 
                    case BVSGE: 
                    case BVSGT: {
                        throw new AssertionError((Object)"cannot have been transformed to PolynomialRelation");
                    }
                    default: {
                        throw new AssertionError((Object)"unknown functionSymbol");
                    }
                }
            }
            ++n2;
        }
        float numberOfDomainElements = XnfIrd.underapproximateNumberOfDomainElements(tv.getSort());
        if ((float)numberOfAntiDer >= numberOfDomainElements) {
            return null;
        }
        return paramsWithoutTv.toArray(new Term[paramsWithoutTv.size()]);
    }

    private static SolvedBinaryRelation solve(ManagedScript mgdScript, TermVariable tv, int quantifier, Term term) {
        PolynomialRelation polyRel = PolynomialRelation.convert(mgdScript.getScript(), term);
        if (polyRel == null) {
            return null;
        }
        MultiCaseSolvedBinaryRelation mcsbr = polyRel.solveForSubject(mgdScript, (Term)tv, MultiCaseSolvedBinaryRelation.Xnf.fromQuantifier(quantifier), Collections.emptySet());
        if (mcsbr == null) {
            return null;
        }
        List<Case> cases = mcsbr.getCases();
        if (cases.size() > 1) {
            return null;
        }
        Case oneCase = cases.iterator().next();
        if (!oneCase.getSupportingTerms().isEmpty()) {
            return null;
        }
        return oneCase.getSolvedBinaryRelation();
    }

    private static float underapproximateNumberOfDomainElements(Sort sort) {
        if (SmtSortUtils.isBoolSort(sort)) {
            return 2.0f;
        }
        if (SmtSortUtils.isNumericSort(sort)) {
            return Float.POSITIVE_INFINITY;
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            BigInteger bitsize = new BigInteger(sort.getRealSort().getIndices()[0]);
            return (float)Math.pow(2.0, bitsize.doubleValue());
        }
        if (SmtSortUtils.isFloatingpointSort(sort)) {
            BigInteger[] indices = SmtUtils.toBigIntegerArray(sort.getRealSort().getIndices());
            BigInteger bitsize = indices[0].add(indices[1]);
            return (float)Math.pow(2.0, bitsize.doubleValue());
        }
        if (SmtSortUtils.isArraySort(sort)) {
            Sort[] arg = sort.getRealSort().getArguments();
            assert (arg.length == 2);
            Sort indexSort = arg[0];
            Sort valueSort = arg[1];
            return (float)Math.pow(XnfIrd.underapproximateNumberOfDomainElements(indexSort), XnfIrd.underapproximateNumberOfDomainElements(valueSort));
        }
        return 1.0f;
    }
}

