/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class XnfPlr
extends XjunctPartialQuantifierElimination {
    public XnfPlr(ManagedScript script, IUltimateServiceProvider services) {
        super(script, services);
    }

    @Override
    public String getName() {
        return "positive literal removal";
    }

    @Override
    public String getAcronym() {
        return "PLR";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    @Override
    public Term[] tryToEliminate(int quantifier, Term[] dualJuncts, Set<TermVariable> eliminatees) {
        int i;
        if (quantifier == 1) {
            return dualJuncts;
        }
        ArrayList<TermVariable> booleanQuantVars = new ArrayList<TermVariable>(eliminatees.size());
        for (TermVariable eliminatee : eliminatees) {
            if (!SmtSortUtils.isBoolSort(eliminatee.getSort())) continue;
            booleanQuantVars.add(eliminatee);
        }
        Iterator iter = booleanQuantVars.iterator();
        HashMap<TermVariable, Term> substitutionMapping = new HashMap<TermVariable, Term>();
        Term trueTerm = this.mScript.term("true", new Term[0]);
        Term falseTerm = this.mScript.term("false", new Term[0]);
        block1: while (iter.hasNext()) {
            TermVariable var = (TermVariable)iter.next();
            i = 0;
            while (i < dualJuncts.length) {
                Term atom = dualJuncts[i];
                if (atom instanceof ApplicationTerm) {
                    ApplicationTerm aatom = (ApplicationTerm)atom;
                    if (aatom.getFunction().getName().equals("not") && aatom.getParameters()[0].equals(var)) {
                        if (this.mLogger.isDebugEnabled()) {
                            this.mLogger.debug((Object)String.format("eliminated quantifier via %s for %s", this.getAcronym(), var));
                        }
                        substitutionMapping.put(var, falseTerm);
                        continue block1;
                    }
                } else if (atom.equals(var)) {
                    substitutionMapping.put(var, trueTerm);
                    if (!this.mLogger.isDebugEnabled()) continue block1;
                    this.mLogger.debug((Object)String.format("eliminated quantifier via %s for %s", this.getAcronym(), var));
                    continue block1;
                }
                ++i;
            }
        }
        if (substitutionMapping.isEmpty()) {
            return dualJuncts;
        }
        Term[] rtr = (Term[])dualJuncts.clone();
        i = 0;
        while (i < dualJuncts.length) {
            rtr[i] = Substitution.apply(this.mMgdScript, substitutionMapping, dualJuncts[i]);
            ++i;
        }
        return rtr;
    }
}

