/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisTermTransducer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeHashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class XnfScout
extends CondisTermTransducer<Result> {
    private static final boolean OPTION_OMIT_DESCED_FOR_DER = false;
    private final Script mScript;
    private final int mQuantifier;
    private final TermVariable mEliminatee;
    private final Set<TermVariable> mQuantifiedInAncestors;

    public XnfScout(Script script, int quantifier, TermVariable eliminatee, Set<TermVariable> quantifiedInAncestors) {
        this.mScript = script;
        this.mQuantifier = quantifier;
        this.mEliminatee = eliminatee;
        this.mQuantifiedInAncestors = quantifiedInAncestors;
    }

    private Occurrence classify(Script script, int quantifier, Term term, TermVariable eliminatee, Set<TermVariable> quantifiedInAncestors) {
        if (!Arrays.asList(term.getFreeVars()).contains(eliminatee)) {
            return Occurrence.ABSENT;
        }
        if (SmtSortUtils.isBoolSort(eliminatee.getSort())) {
            if (term.equals(eliminatee) || eliminatee.equals(SmtUtils.unzipNot(term))) {
                return Occurrence.DER;
            }
            return Occurrence.OTHER_OCCURRENCE;
        }
        if (SmtSortUtils.isArraySort(eliminatee.getSort())) {
            if (this.isDerRelationForArray(quantifier, term, eliminatee)) {
                return Occurrence.DER;
            }
            return Occurrence.ELIMINABLE;
        }
        PolynomialRelation polyRel = PolynomialRelation.convert(script, term);
        if (polyRel == null) {
            return Occurrence.OTHER_OCCURRENCE;
        }
        SolvedBinaryRelation sbr = polyRel.solveForSubject(script, (Term)eliminatee);
        if (sbr == null) {
            return Occurrence.OTHER_OCCURRENCE;
        }
        if (polyRel.getRelationSymbol() == QuantifierUtils.getDerOperator(quantifier)) {
            return Occurrence.DER;
        }
        return Occurrence.ELIMINABLE;
    }

    private boolean isDerRelationForArray(int quantifier, Term term, TermVariable eliminatee) {
        BinaryEqualityRelation ber = BinaryEqualityRelation.convert(term);
        if (ber == null) {
            return false;
        }
        SolvedBinaryRelation sbr = ber.solveForSubject(null, (Term)eliminatee);
        if (sbr == null) {
            return false;
        }
        return ber.getRelationSymbol() == QuantifierUtils.getDerOperator(quantifier);
    }

    @Override
    protected Result transduceAtom(Term term) {
        boolean atLeastOneNonInvolvedCorrespondingJunct;
        long occurringCorrespondingJuncts;
        long eliminableCorrespondingJuncts;
        long derCorrespondingJuncts;
        Occurrence classification = this.classify(this.mScript, this.mQuantifier, term, this.mEliminatee, this.mQuantifiedInAncestors);
        switch (classification) {
            case ABSENT: {
                derCorrespondingJuncts = 0L;
                eliminableCorrespondingJuncts = 0L;
                occurringCorrespondingJuncts = 0L;
                atLeastOneNonInvolvedCorrespondingJunct = true;
                break;
            }
            case DER: {
                derCorrespondingJuncts = 1L;
                eliminableCorrespondingJuncts = 0L;
                occurringCorrespondingJuncts = 0L;
                atLeastOneNonInvolvedCorrespondingJunct = false;
                break;
            }
            case ELIMINABLE: {
                derCorrespondingJuncts = 0L;
                eliminableCorrespondingJuncts = 1L;
                occurringCorrespondingJuncts = 0L;
                atLeastOneNonInvolvedCorrespondingJunct = false;
                break;
            }
            case OTHER_OCCURRENCE: {
                derCorrespondingJuncts = 0L;
                eliminableCorrespondingJuncts = 0L;
                occurringCorrespondingJuncts = 1L;
                atLeastOneNonInvolvedCorrespondingJunct = false;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + (Object)((Object)classification)));
            }
        }
        return new Result(Adk.ATOM, derCorrespondingJuncts, eliminableCorrespondingJuncts, occurringCorrespondingJuncts, atLeastOneNonInvolvedCorrespondingJunct);
    }

    @Override
    protected Result transduceConjunction(ApplicationTerm originalTerm, List<Result> transducedArguments) {
        Result result;
        if (this.mQuantifier == 0) {
            result = this.transduceDual(originalTerm, Adk.CONJUNCTION, transducedArguments);
        } else if (this.mQuantifier == 1) {
            result = this.transduceCorresponding(originalTerm, Adk.CONJUNCTION, transducedArguments);
        } else {
            throw new AssertionError((Object)("Unknown quantifier " + this.mQuantifier));
        }
        return result;
    }

    private Result transduceCorresponding(ApplicationTerm originalTerm, Adk adk, List<Result> transducedArguments) {
        double derCorrespondingJuncts = 0.0;
        double eliminableCorrespondingJuncts = 0.0;
        double occurringCorrespondingJuncts = 0.0;
        boolean atLeastOneNonInvolvedCorrespondingJunct = false;
        for (Result arg : transducedArguments) {
            if (arg.getAdk() == adk) {
                throw new AssertionError((Object)"Expected alternation between conjunction and disjunction");
            }
            derCorrespondingJuncts += arg.getDerCorrespondingJuncts();
            eliminableCorrespondingJuncts += arg.getEliminableCorrespondingJuncts();
            occurringCorrespondingJuncts += arg.getOccurringCorrespondingJuncts();
            atLeastOneNonInvolvedCorrespondingJunct |= arg.isAtLeastOneNonInvolvedCorrespondingJunct();
        }
        return new Result(adk, derCorrespondingJuncts, eliminableCorrespondingJuncts, occurringCorrespondingJuncts, atLeastOneNonInvolvedCorrespondingJunct);
    }

    private Result transduceDual(ApplicationTerm originalTerm, Adk adk, List<Result> transducedArguments) {
        double originalCorrespondingJuncts = QuantifierUtils.getCorrespondingFiniteJunction(this.mQuantifier, originalTerm.getParameters()[0]).length;
        double derCorrespondingJuncts = transducedArguments.get(0).getDerCorrespondingJuncts();
        double eliminableCorrespondingJuncts = transducedArguments.get(0).getEliminableCorrespondingJuncts();
        double occurringCorrespondingJuncts = transducedArguments.get(0).getOccurringCorrespondingJuncts();
        boolean atLeastOneNonInvolvedCorrespondingJunct = transducedArguments.get(0).isAtLeastOneNonInvolvedCorrespondingJunct();
        int i = 1;
        while (i < transducedArguments.size()) {
            if (transducedArguments.get(i).getAdk() == adk) {
                throw new AssertionError((Object)"Expected alternation between conjunction and disjunction");
            }
            double oldOriginalCorrespondingJuncts = originalCorrespondingJuncts;
            double oldDerCorrespondingJuncts = derCorrespondingJuncts;
            double oldEliminableCorrespondingJuncts = eliminableCorrespondingJuncts;
            double oldEccurringCorrespondingJuncts = occurringCorrespondingJuncts;
            double oldNonInvolved = atLeastOneNonInvolvedCorrespondingJunct ? 1 : 0;
            double operandOriginalCorrespondingJuncts = QuantifierUtils.getCorrespondingFiniteJunction(this.mQuantifier, originalTerm.getParameters()[i]).length;
            double operandDerCorrespondingJuncts = transducedArguments.get(i).getDerCorrespondingJuncts();
            double operandEliminableCorrespondingJuncts = transducedArguments.get(i).getEliminableCorrespondingJuncts();
            double operandOccurringCorrespondingJuncts = transducedArguments.get(i).getOccurringCorrespondingJuncts();
            double operandNonInvolved = transducedArguments.get(i).isAtLeastOneNonInvolvedCorrespondingJunct() ? 1 : 0;
            originalCorrespondingJuncts = oldOriginalCorrespondingJuncts * operandOriginalCorrespondingJuncts;
            derCorrespondingJuncts = oldDerCorrespondingJuncts * operandDerCorrespondingJuncts + oldDerCorrespondingJuncts * operandEliminableCorrespondingJuncts + oldDerCorrespondingJuncts * operandOccurringCorrespondingJuncts + oldDerCorrespondingJuncts * operandNonInvolved + oldEliminableCorrespondingJuncts * operandDerCorrespondingJuncts + oldEccurringCorrespondingJuncts * operandDerCorrespondingJuncts + oldNonInvolved * operandDerCorrespondingJuncts;
            occurringCorrespondingJuncts = oldEccurringCorrespondingJuncts * operandEliminableCorrespondingJuncts + oldEccurringCorrespondingJuncts * operandOccurringCorrespondingJuncts + oldEccurringCorrespondingJuncts * operandNonInvolved + oldEliminableCorrespondingJuncts * operandOccurringCorrespondingJuncts + oldNonInvolved * operandOccurringCorrespondingJuncts;
            eliminableCorrespondingJuncts = oldEliminableCorrespondingJuncts * operandEliminableCorrespondingJuncts + oldEliminableCorrespondingJuncts * operandNonInvolved + oldNonInvolved * operandEliminableCorrespondingJuncts;
            atLeastOneNonInvolvedCorrespondingJunct &= transducedArguments.get(i).isAtLeastOneNonInvolvedCorrespondingJunct();
            ++i;
        }
        return new Result(adk, derCorrespondingJuncts, eliminableCorrespondingJuncts, occurringCorrespondingJuncts, atLeastOneNonInvolvedCorrespondingJunct);
    }

    @Override
    protected Result transduceDisjunction(ApplicationTerm originalTerm, List<Result> transducedArguments) {
        Result result;
        if (this.mQuantifier == 0) {
            result = this.transduceCorresponding(originalTerm, Adk.DISJUNCTION, transducedArguments);
        } else if (this.mQuantifier == 1) {
            result = this.transduceDual(originalTerm, Adk.DISJUNCTION, transducedArguments);
        } else {
            throw new AssertionError((Object)("Unknown quantifier " + this.mQuantifier));
        }
        return result;
    }

    public static TermVariable selectBestEliminatee(Script script, int quantifier, List<TermVariable> eliminatees, List<Term> dualFiniteParams) {
        if (eliminatees.size() == 1) {
            return eliminatees.iterator().next();
        }
        Map<TermVariable, Result> score = XnfScout.computeApplicabilityScore(script, quantifier, eliminatees, dualFiniteParams);
        TreeHashRelation tr = new TreeHashRelation();
        tr.reverseAddAll(score);
        Map.Entry best = (Map.Entry)tr.entrySet().iterator().next();
        return (TermVariable)((HashSet)best.getValue()).iterator().next();
    }

    private static Map<TermVariable, Result> computeApplicabilityScore(Script script, int quantifier, List<TermVariable> eliminatees, List<Term> currentDualFiniteParams) {
        Term correspondingFiniteJunction = QuantifierUtils.applyDualFiniteConnective(script, quantifier, currentDualFiniteParams);
        HashMap<TermVariable, Result> result = new HashMap<TermVariable, Result>();
        for (TermVariable eliminatee : eliminatees) {
            Result score = (Result)new XnfScout(script, quantifier, eliminatee, null).transduce(correspondingFiniteJunction);
            result.put(eliminatee, score);
        }
        return result;
    }

    public static int computeRecommendation(Script script, Set<TermVariable> eliminatees, Term[] dualFiniteParams, int quantifier) {
        int res = XnfScout.computeRecommendationDer(script, eliminatees, dualFiniteParams, quantifier);
        if (res == -1) {
            res = XnfScout.computeRecommendationEliminable(script, eliminatees, dualFiniteParams, quantifier);
        }
        return res;
    }

    public static int computeRecommendation(Script script, Set<TermVariable> eliminatees, Term[] dualFiniteParams, int quantifier, Function<Result, Double> ratioProvider) {
        ArrayList<Double> scores = new ArrayList<Double>(dualFiniteParams.length);
        int i = 0;
        while (i < dualFiniteParams.length) {
            scores.add(null);
            Term param = dualFiniteParams[i];
            if (QuantifierUtils.isCorrespondingFiniteJunction(quantifier, param)) {
                scores.set(i, 0.0);
                for (TermVariable eliminatee : eliminatees) {
                    Result res = (Result)new XnfScout(script, quantifier, eliminatee, null).transduce(param);
                    double ratio = ratioProvider.apply(res);
                    scores.set(i, (Double)scores.get(i) + ratio);
                }
            }
            ++i;
        }
        int argMax = -1;
        int i2 = 0;
        while (i2 < scores.size()) {
            if (scores.get(i2) != null && (Double)scores.get(i2) > 0.0) {
                argMax = i2;
            }
            ++i2;
        }
        return argMax;
    }

    public static int computeRecommendationDer(Script script, Set<TermVariable> eliminatees, Term[] dualFiniteParams, int quantifier) {
        return XnfScout.computeRecommendation(script, eliminatees, dualFiniteParams, quantifier, x -> x.computeDerRatio());
    }

    public static int computeRecommendationEliminable(Script script, Set<TermVariable> eliminatees, Term[] dualFiniteParams, int quantifier) {
        return XnfScout.computeRecommendation(script, eliminatees, dualFiniteParams, quantifier, x -> x.computeEliminableRatio());
    }

    public static int computeRecommendation2(Script script, Set<TermVariable> eliminatees, Term[] dualFiniteParams, int quantifier) {
        int alt;
        TermVariable bestEliminatee = XnfScout.selectBestEliminatee(script, quantifier, new ArrayList<TermVariable>(eliminatees), Arrays.asList(dualFiniteParams));
        int res = XnfScout.computeRecommendationDer(script, Collections.singleton(bestEliminatee), dualFiniteParams, quantifier);
        if (res == -1) {
            res = XnfScout.computeRecommendationEliminable(script, Collections.singleton(bestEliminatee), dualFiniteParams, quantifier);
        }
        if (res != (alt = XnfScout.computeRecommendation(script, eliminatees, dualFiniteParams, quantifier))) {
            bestEliminatee.toString();
        }
        return res;
    }

    public static enum Adk {
        ATOM,
        DISJUNCTION,
        CONJUNCTION;

    }

    public static enum Occurrence {
        DER,
        ELIMINABLE,
        OTHER_OCCURRENCE,
        ABSENT;

    }

    public static class Result
    implements Comparable<Result> {
        private final Adk mAdk;
        private final boolean mAtLeastOneNonInvolvedCorrespondingJunct;
        private final double mDerCorrespondingJuncts;
        private final double mEliminableCorrespondingJuncts;
        private final double mOccurringCorrespondingJuncts;

        public Result(Adk adk, double derCorrespondingJuncts, double eliminableCorrespondingJuncts, double occurringCorrespondingJuncts, boolean atLeastOneNonInvolvedCorrespondingJunct) {
            this.mAdk = adk;
            this.mAtLeastOneNonInvolvedCorrespondingJunct = atLeastOneNonInvolvedCorrespondingJunct;
            this.mDerCorrespondingJuncts = derCorrespondingJuncts;
            this.mEliminableCorrespondingJuncts = eliminableCorrespondingJuncts;
            this.mOccurringCorrespondingJuncts = occurringCorrespondingJuncts;
        }

        public Adk getAdk() {
            return this.mAdk;
        }

        public boolean isAtLeastOneNonInvolvedCorrespondingJunct() {
            return this.mAtLeastOneNonInvolvedCorrespondingJunct;
        }

        public double getDerCorrespondingJuncts() {
            return this.mDerCorrespondingJuncts;
        }

        public double getEliminableCorrespondingJuncts() {
            return this.mEliminableCorrespondingJuncts;
        }

        public double getOccurringCorrespondingJuncts() {
            return this.mOccurringCorrespondingJuncts;
        }

        public String toString() {
            return String.format("%s: %s DER, %s eliminable, %s other occurring, %s non-involved", new Object[]{this.mAdk, this.mDerCorrespondingJuncts, this.mEliminableCorrespondingJuncts, this.mOccurringCorrespondingJuncts, this.mAtLeastOneNonInvolvedCorrespondingJunct});
        }

        @Override
        public int compareTo(Result other) {
            int step1 = Double.valueOf(this.getOccurringCorrespondingJuncts()).compareTo(other.getOccurringCorrespondingJuncts());
            if (step1 != 0) {
                return step1;
            }
            int step2 = Double.valueOf(this.getEliminableCorrespondingJuncts()).compareTo(other.getEliminableCorrespondingJuncts());
            if (step2 != 0) {
                return step2;
            }
            int step3 = Double.valueOf(this.getDerCorrespondingJuncts()).compareTo(other.getDerCorrespondingJuncts());
            if (step3 != 0) {
                return step3;
            }
            int step4 = Boolean.valueOf(this.isAtLeastOneNonInvolvedCorrespondingJunct()).compareTo(other.isAtLeastOneNonInvolvedCorrespondingJunct());
            if (step4 != 0) {
                return step4;
            }
            return 0;
        }

        public Double computeDerRatio() {
            Double all = this.getDerCorrespondingJuncts() + this.getEliminableCorrespondingJuncts() + this.getOccurringCorrespondingJuncts() + (double)(this.isAtLeastOneNonInvolvedCorrespondingJunct() ? 1 : 0);
            Double derRatio = this.getDerCorrespondingJuncts() / all;
            return derRatio;
        }

        public Double computeEliminableRatio() {
            Double all = this.getDerCorrespondingJuncts() + this.getEliminableCorrespondingJuncts() + this.getOccurringCorrespondingJuncts() + (double)(this.isAtLeastOneNonInvolvedCorrespondingJunct() ? 1 : 0);
            Double eliminableRatio = this.getEliminableCorrespondingJuncts() / all;
            return eliminableRatio;
        }
    }
}

