/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.ExplicitLhsPolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XnfTir
extends XjunctPartialQuantifierElimination {
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;

    public XnfTir(ManagedScript script, IUltimateServiceProvider services, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        super(script, services);
        this.mXnfConversionTechnique = xnfConversionTechnique;
    }

    @Override
    public String getName() {
        return "transitive inequality resolution";
    }

    @Override
    public String getAcronym() {
        return "TIR";
    }

    @Override
    public boolean resultIsXjunction() {
        return false;
    }

    @Override
    public Term[] tryToEliminate(int quantifier, Term[] inputConjuncts, Set<TermVariable> eliminatees) {
        Term inputConjunction = QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, Arrays.asList(inputConjuncts));
        ArrayList<Object> currentDisjuncts = new ArrayList<Term>(Arrays.asList(inputConjunction));
        Iterator<TermVariable> it = eliminatees.iterator();
        while (it.hasNext()) {
            ArrayList<Object> nextDisjuncts = new ArrayList();
            TermVariable eliminatee = it.next();
            if (!eliminatee.getSort().isNumericSort()) {
                nextDisjuncts = currentDisjuncts;
                continue;
            }
            boolean unableToRemoveEliminatee = false;
            for (Term oldDisjunct : currentDisjuncts) {
                List<Term> elimResultDisjuncts = this.tryToEliminateSingleDisjuct(quantifier, oldDisjunct, eliminatee, eliminatees);
                if (elimResultDisjuncts == null) {
                    unableToRemoveEliminatee = true;
                    nextDisjuncts.add(oldDisjunct);
                    continue;
                }
                nextDisjuncts.addAll(elimResultDisjuncts);
            }
            if (!unableToRemoveEliminatee) {
                it.remove();
            }
            currentDisjuncts = nextDisjuncts;
        }
        Term[] resultDisjuncts = currentDisjuncts.toArray(new Term[currentDisjuncts.size()]);
        Term resultDisjunction = QuantifierUtils.applyCorrespondingFiniteConnective(this.mScript, quantifier, resultDisjuncts);
        return new Term[]{resultDisjunction};
    }

    private List<Term> tryToEliminateSingleDisjuct(int quantifier, Term disjunct, TermVariable eliminatee, Set<TermVariable> bannedForDivCapture) {
        Term disjunction;
        Term conjunction = XnfTir.tryToEliminateConjuncts(this.mServices, this.mScript, quantifier, disjunct, eliminatee, bannedForDivCapture);
        if (conjunction == null) {
            return null;
        }
        if (quantifier == 0) {
            disjunction = SmtUtils.toDnf(this.mServices, this.mMgdScript, conjunction, this.mXnfConversionTechnique);
        } else if (quantifier == 1) {
            disjunction = SmtUtils.toCnf(this.mServices, this.mMgdScript, conjunction, this.mXnfConversionTechnique);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        assert (!Arrays.asList(disjunction.getFreeVars()).contains(eliminatee)) : "not eliminated";
        SmtUtils.ExtendedSimplificationResult simp = SmtUtils.simplifyWithStatistics(this.mMgdScript, conjunction, this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        disjunction = simp.getSimplifiedTerm();
        List<Term> resultDisjunctions = Arrays.asList(QuantifierUtils.getCorrespondingFiniteJunction(quantifier, disjunction));
        return resultDisjunctions;
    }

    public static Term tryToEliminateConjuncts(IUltimateServiceProvider services, Script script, int quantifier, Term disjunct, TermVariable eliminatee, Set<TermVariable> bannedForDivCapture) {
        Term[] inputAtoms = QuantifierUtils.getDualFiniteJunction(quantifier, disjunct);
        ArrayList<Term> termsWithoutEliminatee = new ArrayList<Term>();
        ArrayList<Bound> upperBounds = new ArrayList<Bound>();
        ArrayList<Bound> lowerBounds = new ArrayList<Bound>();
        ArrayList<Pair<Term, Term>> antiDer = new ArrayList<Pair<Term, Term>>();
        Term[] termArray = inputAtoms;
        int n = inputAtoms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (!Arrays.asList(term.getFreeVars()).contains(eliminatee)) {
                termsWithoutEliminatee.add(term);
            } else {
                boolean divByIntegerConstant;
                PolynomialRelation.TransformInequality transform;
                if (quantifier == 0) {
                    transform = PolynomialRelation.TransformInequality.STRICT2NONSTRICT;
                } else if (quantifier == 1) {
                    transform = PolynomialRelation.TransformInequality.NONSTRICT2STRICT;
                } else {
                    throw new AssertionError((Object)"unknown quantifier");
                }
                PolynomialRelation polyRel = PolynomialRelation.convert(script, term, transform);
                if (polyRel == null) {
                    return null;
                }
                if (!polyRel.isVariable((Term)eliminatee)) {
                    return null;
                }
                SolvedBinaryRelation sbr = polyRel.solveForSubject(script, (Term)eliminatee);
                if (sbr == null) {
                    ExplicitLhsPolynomialRelation elpr = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, (Term)eliminatee, polyRel);
                    if (elpr == null) {
                        return null;
                    }
                    if (!SmtSortUtils.isIntSort(eliminatee.getSort())) {
                        return null;
                    }
                    Pair<ExplicitLhsPolynomialRelation, Term> pair = elpr.divideByIntegerCoefficient(script, bannedForDivCapture);
                    if (pair == null) {
                        return null;
                    }
                    ExplicitLhsPolynomialRelation tmp = (ExplicitLhsPolynomialRelation)pair.getFirst();
                    if (!tmp.getLhsMonomial().isLinear()) {
                        return null;
                    }
                    sbr = new SolvedBinaryRelation(tmp.getLhsMonomial().getSingleVariable(), tmp.getRhs().toTerm(script), tmp.getRelationSymbol(), MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT);
                    divByIntegerConstant = true;
                } else {
                    divByIntegerConstant = false;
                }
                if (SolveForSubjectUtils.isVariableDivCaptured(sbr, bannedForDivCapture)) {
                    throw new AssertionError((Object)"should not be possible to divCapture here");
                }
                Term eliminateeOnLhs = sbr.asTerm(script);
                BinaryNumericRelation bnr = BinaryNumericRelation.convert(eliminateeOnLhs);
                switch (bnr.getRelationSymbol()) {
                    case DISTINCT: {
                        if (quantifier == 0) {
                            if (divByIntegerConstant) {
                                antiDer.add(XnfTir.antiDerWithAssumption(script, 0, term, (Term)eliminatee));
                                break;
                            }
                            antiDer.add((Pair<Term, Term>)new Pair((Object)bnr.getRhs(), (Object)bnr.getRhs()));
                            break;
                        }
                        assert (XnfTir.occursInsideSelectTerm(term, eliminatee)) : "should have been removed by DER";
                        throw new AssertionError((Object)"should have been removed by DER");
                    }
                    case EQ: {
                        if (quantifier == 1) {
                            if (divByIntegerConstant) {
                                antiDer.add(XnfTir.antiDerWithAssumption(script, 1, term, (Term)eliminatee));
                                break;
                            }
                            antiDer.add((Pair<Term, Term>)new Pair((Object)bnr.getRhs(), (Object)bnr.getRhs()));
                            break;
                        }
                        assert (XnfTir.occursInsideSelectTerm(term, eliminatee)) : "should have been removed by DER";
                        throw new AssertionError((Object)"should have been removed by DER");
                    }
                    case GEQ: {
                        lowerBounds.add(new Bound(false, bnr.getRhs()));
                        break;
                    }
                    case GREATER: {
                        lowerBounds.add(new Bound(true, bnr.getRhs()));
                        break;
                    }
                    case LEQ: {
                        upperBounds.add(new Bound(false, bnr.getRhs()));
                        break;
                    }
                    case LESS: {
                        upperBounds.add(new Bound(true, bnr.getRhs()));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            ++n2;
        }
        AntiDerBuildingInstructions bi = new AntiDerBuildingInstructions(services, script, quantifier, upperBounds, lowerBounds, antiDer);
        ArrayList<Term> resultAtoms = new ArrayList<Term>();
        for (Bound lowerBound : lowerBounds) {
            for (Bound upperBound : upperBounds) {
                resultAtoms.add(XnfTir.buildInequality(script, quantifier, lowerBound, upperBound));
                if (services.getProgressMonitorService().continueProcessing()) continue;
                throw new ToolchainCanceledException(XnfTir.class, "building " + lowerBounds.size() * upperBounds.size() + " inequalities");
            }
        }
        resultAtoms.addAll(termsWithoutEliminatee);
        if (!antiDer.isEmpty()) {
            resultAtoms.add(bi.buildCorrespondingFiniteJuntion());
        }
        Term result = QuantifierUtils.applyDualFiniteConnective(script, quantifier, resultAtoms);
        assert (!Arrays.asList(result.getFreeVars()).contains(eliminatee)) : "not eliminated";
        return result;
    }

    private static Pair<Term, Term> antiDerWithAssumption(Script script, int quantifier, Term originalTerm, Term eliminatee) {
        RelationSymbol upperRelationSymbol;
        RelationSymbol lowerRelationSymbol;
        PolynomialRelation origPolyRel = PolynomialRelation.convert(script, originalTerm);
        ExplicitLhsPolynomialRelation elpr = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, eliminatee, origPolyRel);
        Rational coeff = elpr.getLhsCoefficient();
        PolynomialRelation.TransformInequality transform = PolynomialRelation.TransformInequality.NO_TRANFORMATION;
        if (quantifier == 0) {
            if (coeff.isNegative()) {
                lowerRelationSymbol = RelationSymbol.LESS;
                upperRelationSymbol = RelationSymbol.GREATER;
            } else {
                lowerRelationSymbol = RelationSymbol.GREATER;
                upperRelationSymbol = RelationSymbol.LESS;
            }
        } else if (coeff.isNegative()) {
            lowerRelationSymbol = RelationSymbol.LEQ;
            upperRelationSymbol = RelationSymbol.GEQ;
        } else {
            lowerRelationSymbol = RelationSymbol.GEQ;
            upperRelationSymbol = RelationSymbol.LEQ;
        }
        BinaryNumericRelation bnr = BinaryNumericRelation.convert(originalTerm);
        BinaryNumericRelation lowerBoundBnr = bnr.changeRelationSymbol(lowerRelationSymbol);
        PolynomialRelation relLower = PolynomialRelation.convert(script, lowerBoundBnr.toTerm(script), transform);
        ExplicitLhsPolynomialRelation elprLower = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, eliminatee, relLower);
        assert (coeff.equals((Object)elprLower.getLhsCoefficient()));
        SolvedBinaryRelation sbrLower = elprLower.divideByIntegerCoefficientForInequalities(script, Collections.emptySet());
        BinaryNumericRelation upperBoundBnr = bnr.changeRelationSymbol(upperRelationSymbol);
        PolynomialRelation relUpper = PolynomialRelation.convert(script, upperBoundBnr.toTerm(script), transform);
        ExplicitLhsPolynomialRelation elprUpper = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, eliminatee, relUpper);
        assert (coeff.equals((Object)elprUpper.getLhsCoefficient()));
        SolvedBinaryRelation sbrUpper = elprUpper.divideByIntegerCoefficientForInequalities(script, Collections.emptySet());
        if (sbrLower == null || sbrUpper == null) {
            throw new AssertionError((Object)"suddenly unsolvable");
        }
        Term lowerBound = sbrLower.getRightHandSide();
        Term upperBound = sbrUpper.getRightHandSide();
        return new Pair((Object)lowerBound, (Object)upperBound);
    }

    private static boolean occursInsideSelectTerm(Term term, TermVariable tv) {
        List<MultiDimensionalSelect> selectTerms = MultiDimensionalSelect.extractSelectShallow(term, true);
        for (MultiDimensionalSelect mds : selectTerms) {
            for (Term index : mds.getIndex()) {
                if (!Arrays.asList(index.getFreeVars()).contains(tv)) continue;
                return true;
            }
            if (Arrays.asList(mds.getSelectTerm().getFreeVars()).contains(tv)) {
                return true;
            }
            if (!Arrays.asList(mds.getArray().getFreeVars()).contains(tv)) continue;
            return true;
        }
        return false;
    }

    private static Term buildInequality(Script script, int quantifier, Bound lowerBound, Bound upperBound) {
        String symbol;
        Term term;
        PolynomialRelation polyRel;
        boolean isStrict;
        boolean lbIsInt = SmtSortUtils.isIntSort(lowerBound.getTerm().getSort());
        if (quantifier == 0) {
            boolean bl = isStrict = lowerBound.isIsStrict() || upperBound.isIsStrict();
            assert (!(lowerBound.isIsStrict() && upperBound.isIsStrict() && lbIsInt)) : "unsound if int and both are strict";
        } else if (quantifier == 1) {
            boolean bl = isStrict = lowerBound.isIsStrict() && upperBound.isIsStrict();
            assert (lowerBound.isIsStrict() || upperBound.isIsStrict() || !lbIsInt) : "unsound if int and both are non-strict";
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        if ((polyRel = PolynomialRelation.convert(script, term = script.term(symbol = isStrict ? "<" : "<=", new Term[]{lowerBound.getTerm(), upperBound.getTerm()}))) == null) {
            throw new AssertionError((Object)"should be affine");
        }
        return polyRel.positiveNormalForm(script);
    }

    private static class AntiDerBuildingInstructions {
        private final IUltimateServiceProvider mServices;
        private final Script mScript;
        private final int mQuantifier;
        private final List<Bound> mUpperBounds;
        private final List<Bound> mLowerBounds;
        private final List<Pair<Term, Term>> mAntiDer;

        public AntiDerBuildingInstructions(IUltimateServiceProvider services, Script script, int quantifier, List<Bound> upperBounds, List<Bound> lowerBounds, List<Pair<Term, Term>> antiDer) {
            this.mServices = services;
            this.mScript = script;
            this.mQuantifier = quantifier;
            this.mUpperBounds = upperBounds;
            this.mLowerBounds = lowerBounds;
            this.mAntiDer = antiDer;
        }

        Term buildCorrespondingFiniteJuntion() {
            ArrayList<Term> resultCorrespondingFiniteJuncts = new ArrayList<Term>();
            int i = 0;
            while ((double)i < Math.pow(2.0, this.mAntiDer.size())) {
                ArrayList<Term> resultAtoms = new ArrayList<Term>();
                ArrayList<Bound> adLowerBounds = new ArrayList<Bound>();
                ArrayList<Bound> adUpperBounds = new ArrayList<Bound>();
                int k = 0;
                while (k < this.mAntiDer.size()) {
                    if (BigInteger.valueOf(i).testBit(k)) {
                        Bound upperBound = this.computeBound((Term)this.mAntiDer.get(k).getSecond(), this.mQuantifier, BoundType.UPPER);
                        adUpperBounds.add(upperBound);
                    } else {
                        Bound lowerBound = this.computeBound((Term)this.mAntiDer.get(k).getFirst(), this.mQuantifier, BoundType.LOWER);
                        adLowerBounds.add(lowerBound);
                    }
                    ++k;
                }
                for (Bound adLower : adLowerBounds) {
                    for (Bound adUpper : adUpperBounds) {
                        resultAtoms.add(XnfTir.buildInequality(this.mScript, this.mQuantifier, adLower, adUpper));
                    }
                    for (Bound upperBound : this.mUpperBounds) {
                        resultAtoms.add(XnfTir.buildInequality(this.mScript, this.mQuantifier, adLower, upperBound));
                    }
                }
                for (Bound adUpper : adUpperBounds) {
                    for (Bound lowerBound : this.mLowerBounds) {
                        resultAtoms.add(XnfTir.buildInequality(this.mScript, this.mQuantifier, lowerBound, adUpper));
                    }
                }
                resultCorrespondingFiniteJuncts.add(QuantifierUtils.applyDualFiniteConnective(this.mScript, this.mQuantifier, resultAtoms));
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "building " + Math.pow(2.0, this.mAntiDer.size()) + " xjuncts");
                }
                ++i;
            }
            return QuantifierUtils.applyCorrespondingFiniteConnective(this.mScript, this.mQuantifier, resultCorrespondingFiniteJuncts);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Bound computeBound(Term term, int quantifier, BoundType boundType) {
            if (SmtSortUtils.isRealSort(term.getSort())) {
                if (quantifier == 0) {
                    return new Bound(true, term);
                }
                if (quantifier != 1) throw new AssertionError((Object)"unknown quantifier");
                return new Bound(false, term);
            }
            if (!SmtSortUtils.isIntSort(term.getSort())) throw new AssertionError((Object)("unknown sort " + term.getSort()));
            Term one = SmtUtils.constructIntValue(this.mScript, BigInteger.ONE);
            if (quantifier == 0) {
                if (boundType == BoundType.LOWER) {
                    return new Bound(false, this.mScript.term("+", new Term[]{term, one}));
                }
                if (boundType != BoundType.UPPER) throw new AssertionError((Object)("unknown BoundType" + (Object)((Object)boundType)));
                return new Bound(false, this.mScript.term("-", new Term[]{term, one}));
            }
            if (quantifier != 1) throw new AssertionError((Object)"unknown quantifier");
            if (boundType == BoundType.LOWER) {
                return new Bound(true, this.mScript.term("-", new Term[]{term, one}));
            }
            if (boundType != BoundType.UPPER) throw new AssertionError((Object)("unknown BoundType" + (Object)((Object)boundType)));
            return new Bound(true, this.mScript.term("+", new Term[]{term, one}));
        }
    }

    private static class Bound {
        private final boolean mIsStrict;
        private final Term mTerm;

        public Bound(boolean isStrict, Term term) {
            this.mIsStrict = isStrict;
            this.mTerm = term;
        }

        public boolean isIsStrict() {
            return this.mIsStrict;
        }

        public Term getTerm() {
            return this.mTerm;
        }

        public String toString() {
            return "Bound [mIsStrict=" + this.mIsStrict + ", mTerm=" + this.mTerm + "]";
        }
    }

    public static enum BoundType {
        UPPER,
        LOWER;

    }
}

